;CD ROM DRIVE DRIVER
;---------------------------------------------------------------
;Rev	Date	   Name	Description
;---------------------------------------------------------------
;	02-08-2001 DNS	Initial this module
;---------------------------------------------------------------
;========================================================
R170	EQU	#0050	;Data
R171	EQU	#0051	;Error
R172	EQU	#0052	;Direct
R173	EQU	#0053	;Reserve
R174	EQU	#0054	;Lenght	block low
R175	EQU	#0055	;Lenght	block high
R176	EQU	#4052	;Drive device
R177	EQU	#4053	;Status

W170	EQU	#0150	;Data
W171	EQU	#0151	;????
W172	EQU	#0152	;????
W173	EQU	#0153	;Reserve
W174	EQU	#0154	;Lenght	block low
W175	EQU	#0155	;Lenght	block high
W176	EQU	#4152	;Drive device
W177	EQU	#4153	;Command

RAM_ATAPI_PK 	EQU	#FEE0
RAM_ATAPI_READ	EQU	#FEF0

;BSY	EQU	7
;DRQ	EQU	3
;ERR	EQU	0

RESETC
RESETCD	LD	B,50
RESECD	PUSH	BC
	LD	A,1
	CALL	CD_TEST
	POP	BC
	RET	NC
	EI 
	HALT 
	DJNZ	RESECD
	RET 

LREADC

READC	LD	A,1
	JP	CD_READ

OPENC	LD	A,1
	JP	CD_OPEN

CLOSC	LD	A,1
	JP	CD_CLOS

SIZESEC	EQU	#0800
PKTSIZE	EQU	12

CD_TEST	LD	HL,CMDNOPP
	LD	DE,0
	CALL	AP_COM
	RET 

DETECTC

CD_OPEN	LD	HL,CMDOPEN
	LD	DE,0
	CALL	AP_COM
	RET 

CD_CLOS	LD	HL,CMDCLOS
	LD	DE,0
	CALL	AP_COM
	RET 

; HL:IX	- SECTOR
;    DE	- ADDRESS
;     B	- SECTOR COUNT
;     A	- DRIVE

CD_READ	LD	C,A
	EXX
	LD	C,PAGE3
	IN	A,(C)
	PUSH	AF
	LD	A,SYSPAGE
	OUT	(C),A
	LD	HL,CMDREAD
	LD	DE,RAM_ATAPI_READ
	LD	BC,PKTSIZE
	LDIR
	EXX
	LD	A,H
	LD	(RAM_ATAPI_READ+SECREAD+0),A	;R01
	LD	A,L
	LD	(RAM_ATAPI_READ+SECREAD+1),A	;R01
	LD	A,XH
	LD	(RAM_ATAPI_READ+SECREAD+2),A	;R01
	LD	A,XL
	LD	(RAM_ATAPI_READ+SECREAD+3),A	;R01
	LD	A,B
	LD	(RAM_ATAPI_READ+COUNT+1),A	;R01
	POP	AF
	OUT	(PAGE3),A
;R01	LD	HL,CMDREAD
	LD	HL,RAM_ATAPI_READ
	LD	A,C
	CALL	AP_COM
	RET 

; INPUT:  HL - AP paket	(12bytes)
; RETURN: CF - ERROR
;	 01h - RECOVERED ERROR
;	 02h - NOT READY
;	 03h - MEDIUM ERROR
;	 04h - HARDWARE	ERROR
;	 05h - ILLEGAL REQUEST
;	 06h - UNIT ATTETION
;	 07h - DATA PROTECT
;	 0Bh - ABORTED COMMAND
;	 80h - TIME OUT

AP_COM	AND	#01
	LD	A,#A0
	JR	Z,APCOM1
	LD	A,#B0
APCOM1	LD	BC,W176
	OUT	(C),A		;SELECT	DRIVE
	EXX 
	LD	DE,#8000
	LD	BC,R177
	CALL	CWAITPRT
	EXX 
	JR	NC,CDREADY
	LD	BC,W177
	LD	A,#08
	OUT	(C),A
	LD	B,#00
	DJNZ	$
	EXX 
	LD	DE,#8000
	LD	BC,R177
	CALL	CWAITPRT
	EXX 
	RET	C
CDREADY
	LD	C,PAGE3
	IN	B,(C)

	PUSH	DE
	PUSH	BC

	LD	A,SYSPAGE
	OUT	(C),A
	LD	A,B
	LD	DE,RAM_ATAPI_PK
	LD	BC,PKTSIZE
	LDIR

	POP	BC
	POP	DE
	OUT	(C),B

	XOR	A
	EXX
	OUT	(C),A
	XOR	A
	LD	BC,W171
	OUT	(C),A
	LD	DE,SIZESEC	;SIZE BLOCK
	LD	BC,W174
	OUT	(C),E
	LD	BC,W175
	OUT	(C),D
	LD	BC,W177
	LD	A,#A0
	OUT	(C),A
	LD	DE,#8000
	LD	BC,R177
	CALL	CWAITPRT
	EXX 
	RET	C
	EXX 
	LD	DE,#0908
	LD	BC,R177
	CALL	CWAITPRT
	EXX 
	BIT	ERR,A
	JR	NZ,CDERROR
	JR	NC,YEP_DRQ
	LD	A,#80
	RET 

YEP_DRQ	LD	C,PAGE3
	IN	B,(C)
	PUSH	BC
	LD	A,SYSPAGE
	OUT	(PAGE3),A
	LD	HL,RAM_ATAPI_PK
	LD	BC,W170
	LD	A,PKTSIZE
	SRL	A
OUTPKT	OUTI 
	OUTI 
	DEC	A
	JR	NZ,OUTPKT
	POP	BC
	OUT	(C),B
	LD	B,#80
	DJNZ	$
AP_LOOP	EXX 
	LD	DE,#8000
	LD	BC,R177
	CALL	CWAITPRT
	EXX 
	RET	C
	LD	BC,R177
	IN	A,(C)
	BIT	ERR,A
	JR	Z,NO_ERR
CDERROR	LD	BC,R171	;ERROR
	IN	A,(C)
	RRCA 
	RRCA 
	RRCA 
	RRCA 
	AND	#0F
	SCF 
	RET 

NO_ERR	BIT	DRQ,A
	LD	A,0
	RET	Z	;NO DATA REQUEST
	EX	DE,HL
	LD	BC,R174
	IN	E,(C)
	LD	BC,R175
	IN	D,(C)	;TRANSFER BLOCK	SIZE
	LD	A,D
	OR	E
	RET	Z	;BLOCK = 0
	LD	BC,R172
	IN	A,(C)
	AND	#02
	CP	#02
	JP	Z,FROM_CD
TO_CD	LD	BC,R170
WR_T_CD	OUTI 
	OUTI 
	DEC	DE
	DEC	DE
	LD	A,D
	OR	E
	JR	NZ,WR_T_CD
	EX	DE,HL
	JR	AP_LOOP

FROM_CD	LD	A,H
	OR	L
	JR	Z,NULL
	LD	BC,R170
RD_F_CD	INI 
	INI 
	DEC	DE
	DEC	DE
	LD	A,D
	OR	E
	JR	NZ,RD_F_CD
	EX	DE,HL
	JR	AP_LOOP

NULL	LD	BC,R170
RD_N_CD	IN	A,(C)
	DEC	B
	IN	A,(C)
	DEC	B
	DEC	DE
	DEC	DE
	LD	A,D
	OR	E
	JR	NZ,RD_N_CD
; DE = 0 !!!
	JR	AP_LOOP

; E - Second * 10

PAUSE	LD	HL,#0000
PAUSE1	DEC	L
	JR	NZ,PAUSE1
	DEC	H
	JR	NZ,PAUSE1
	DEC	E
	JR	NZ,PAUSE1
	RET 

; D - MASK
; E - PATTERN
; BC - PORT

CWAITPRT
	LD	A,100
	LD	HL,#0000
CWAITPX	EX	AF,AF'
CWAITP0	IN	A,(C)
	CP	#FF
	JR	Z,CWAITP1
	AND	D
	CP	E
	JR	NZ,CWAITP2
	AND	A
	RET 

CWAITP2	DEC	L
	JR	NZ,CWAITP0
	DEC	H
	JR	NZ,CWAITP0
	EX	AF,AF'
	DEC	A
	JR	NZ,CWAITPX
	EX	AF,AF'
CWAITP1	SCF 
	RET 

CMDNOPP	DEFB	#00
	DEFB	00,00,00
	DEFB	#00
	DEFB	00,00,00
	DEFB	00,00,00
	DEFB	#00

CMDOPEN	DEFB	#1B
	DEFB	#00,#00,#00
	DEFB	#02
	DEFB	#00,#00,#00,#00,#00,#00,#00

CMDCLOS	DEFB	#1B
	DEFB	#00,#00,#00
	DEFB	#03
	DEFB	#00,#00,#00,#00,#00,#00,#00

CMDREAD	DEFB	#28,#00
SECREAD	EQU	$-CMDREAD
	DEFB	#00,#00,#00,#00
	DEFB	#00
COUNT	EQU	$-CMDREAD
	DEFB	#00,#01
	DEFB	#00,#00,#00

;========================================================


