//  
#include <avr\io.h>
#include <avr\interrupt.h>
#include <avr\eeprom.h>
#include <stdint.h>

//      "perepherial.h":
#include "abstract_defs.h"											//    
#include "perepherial.h"											//  -    
#include "IND-driver-full\indicator_2f.h"							//    7- 

#define TCNT0_DIV 						220							//        

volatile uint8_t		ROMBankNumber;								//  64-   ( 27801)
uint8_t EEMEM 			EEPROM_ROMBankNumber = 0;					//    EEPROM

//        (0..15)
#define ROM_ADDR_PORT ROM_ADDR_DATA, R, _VIRT
//    
#define ROM_ADDR_DATA_0  B, 1, _HI									// ROM_A16
#define ROM_ADDR_DATA_1  B, 4, _HI									// ROM_A17
#define ROM_ADDR_DATA_2  B, 3, _HI									// ROM_A18
#define ROM_ADDR_DATA_3  B, 2, _HI									// ROM_A19
#define ROM_ADDR_DATA_4  B, 7, _NONE								//  
#define ROM_ADDR_DATA_5  B, 7, _NONE								//  
#define ROM_ADDR_DATA_6  B, 7, _NONE								//  
#define ROM_ADDR_DATA_7  B, 7, _NONE								//  

// 
volatile uint8_t Flag_Int_Need_Scan_Keys;							//     ( )?
volatile uint8_t Flag_Int_Need_Save_Settings;						//    ? (  )

//  
int  main(void);													// MAIN,   
void Pereferial_Init(void);											//  
void Btn_Process_All(void);											//   
void Settings_Save(void);											//    EEPROM
void Settings_Load(void);											//    EEPROM
void DisplayBankNumber(uint8_t AROMBankNumber);						//     7-   HEX
