/*
 *   64-   ROM-  "-86"
 *
 * Chip type           : ATtiny2313A
 * lock frequency     : 8,000000 MHz (Internal osc)
 * Fuse Bits		   : Default, no changes
 *
 * Date                : 27.01.2020
 * Author              : Alex Shamilich
 *
 * Version: 		   : 1.0.0
 */
#include "main.h"
#include "IND-driver-full\port_macros.h"
// ====================================================================
void Pereferial_Init(void)											//  
{
	// Crystal Oscillator division factor: 1
	CLKPR=0x80;
	CLKPR=0x00;

//	CLKPR =  (1 << CLKPCE);																		// enable to set CLKPSx bits (p.30 attiny2313 manual)
//	CLKPR = ((0 << CLKPS3) | (0 << CLKPS2) | (0 << CLKPS1) | (0 << CLKPS0)); // ClkDiv = 0
//	CLKPR = ((0 << CLKPS3) | (1 << CLKPS2) | (0 << CLKPS1) | (1 << CLKPS0)); // ClkDiv = 32		// ignore CKDIV8 default fuse and set syslem clock to 8Mhz (without div8)

	// 
	//
	// Port B initialization
	// Clear all bits in Port B
	// State 0 = Tri-State
	//       1 = Pull-UP (Vcc on input)
	PORTB=0b00000001;
	DDRB=0b11111110;  	//bit=0 - input direction, bit=1 - output
	//            |-  AIN0    CPUPin-12  	PB0  		BTN_DWN
	//           |--  AIN1    CPUPin-13  	PB1  		ROM_A16
	//          |---  OC0A    CPUPin-14  	PB2  		ROM_A19
	//         |----  OC1A    CPUPin-15  	PB3  		ROM_A18
	//        |-----  OC1B    CPUPin-16  	PB4  		ROM_A17
	//       |------  MOSI    CPUPin-17  	PB5  	
	//      |-------  MISO    CPUPin-18  	PB6  	
	//     |--------  SCK     CPUPin-19  	PB7  	

	// Port D initialization
	// Clear all bits in Port D
	// State 0 = Tri-State
	//       1 = Pull-UP (Vcc on input)
	//PORTD=0b00011111;
	PORTD=0b11000000;
	DDRD=0b00111111;  //bit=0 - input direction, bit=1 - output
	//            |-  RXD     CPUPin-2   	PD0  		7SegLED_C
	//           |--  TXD     CPUPin-3   	PD1  		7SegLED_D
	//          |---  INT0    CPUPin-6   	PD2  		7SegLED_A
	//         |----  INT1    CPUPin-7   	PD3  		7SegLED_F
	//        |-----  T0      CPUPin-8   	PD4			7SegLED_E
	//       |------  T1      CPUPin-9   	PD5			7SegLED_DP
	//      |-------  ICP     CPUPin-11  	PD6 		BTN_UP

	// Port A initialization
	PORTA=0b00000011;	//port state: bit=0 - Tri-State, bit=1 - Pull-UP (Vcc on input)
	DDRA=0b11111111;	//input direction: bit=0 - input, bit=1 - output
	//            |-  XTAL1		CPUPin-5  	PA0     	7SegLED_B
	//           |--  XTAL2		CPUPin-4  	PA1      	7SegLED_G
	//          |---  RESET		CPUPin-1 	PA2    		RESET----


	//   0
	TIMSK |= (1 << TOIE0);								 // Timer0 Overflow Interrupt Enable
	TCNT0 = TCNT0_DIV;

//	TCCR0B |= ((0 << CS02) | (0 << CS01) | (0 << CS00)); // TimerStopped
//	TCCR0B |= ((0 << CS02) | (0 << CS01) | (1 << CS00)); // Clk/1
//	TCCR0B |= ((0 << CS02) | (1 << CS01) | (0 << CS00)); // Clk/8
//	TCCR0B |= ((0 << CS02) | (1 << CS01) | (1 << CS00)); // Clk/64
	TCCR0B |= ((1 << CS02) | (0 << CS01) | (0 << CS00)); // Clk/256
//	TCCR0B |= ((1 << CS02) | (0 << CS01) | (1 << CS00)); // Clk/1024
//	TCNT0 = 0x00;

	//  
	ROMBankNumber							= 0;					//  64-   ( 27801)
	Flag_Int_Need_Scan_Keys					= NO;
	Flag_Int_Need_Save_Settings 			= NO;
}
//===================================================================

//===================================================================
// 	
//===================================================================
int main(void)														// MAIN,   
{
	Pereferial_Init();                       						//  
 	IND_Init();														//  LED 7- 

	sei();					 										//     

//	for (uint8_t n= 0; n < 16; n++)									//       
//	{
//		DisplayBankNumber(n);										//     7-   HEX
//		PM_WritePort(ROM_ADDR_PORT, n);								//      
//		_delay_ms( 100 );
//	}

	Settings_Load();												//    EEPROM


	while (1) {														//   
		//LED_RED_INV;

		if (Flag_Int_Need_Scan_Keys == YES)							//    61 (16,384 ms)
		{
			Flag_Int_Need_Scan_Keys = NO;							//          
			Btn_Process_All();										//  

			DisplayBankNumber(ROMBankNumber);						//     7-   HEX
			PM_WritePort(ROM_ADDR_PORT, ROMBankNumber);				//      
		}

//		if (Flag_Int_Need_Save_Settings == YES)						//  -   
//		{
//			Flag_Int_Need_Save_Settings = NO;						//  
//			Settings_Save();										//     
//		}

	}
	return 0;
}
//===================================================================
void DisplayBankNumber(uint8_t AROMBankNumber)						//     7-   HEX
{
	if (AROMBankNumber<10)
	{
		IND_OutInt(AROMBankNumber,0);
	}
	else
	{
		switch (AROMBankNumber)
		{
			case 10: IND_OutSym("A",1);break;
			case 11: IND_OutSym("b",1);break;
			case 12: IND_OutSym("C",1);break;
			case 13: IND_OutSym("d",1);break;
			case 14: IND_OutSym("E",1);break;
			case 15: IND_OutSym("F",1);break;
		}
	}

}
//===================================================================
ISR(TIMER0_OVF_vect)												//    0    
{
	TCNT0 = TCNT0_DIV;												//    (   ) +   TCCR0B |= ((0 << CS02) | (1 << CS01) | (0 << CS00)); // Clk/8
	IND_Update();													//     (  )
	Flag_Int_Need_Scan_Keys     = YES;								//      
}
//===================================================================
void Btn_Process_All(void)											//   
{
	if (BTN_PRESSED_BTN_UP)	  										//  +
	{
		if (ROMBankNumber <=14)
		{
			ROMBankNumber++;
			Settings_Save();										//     
			///Flag_Int_Need_Save_Settings = YES;
		}
		_delay_ms( 200 );
	}
	if (BTN_PRESSED_BTN_DWN)	  										//  -
	{
		if (ROMBankNumber >= 1)
		{
			ROMBankNumber--;
			Settings_Save();										//     
			//Flag_Int_Need_Save_Settings = YES;
		}
		_delay_ms( 200 );
	}
}
//===================================================================

void Settings_Load(void)											//    EEPROM
{
  ROMBankNumber = eeprom_read_byte(&EEPROM_ROMBankNumber);
  if (ROMBankNumber > 15)											//   EEPROM       
	  ROMBankNumber = 0;
}
//===================================================================
void Settings_Save(void)											//    EEPROM
{
	eeprom_write_byte(&EEPROM_ROMBankNumber, ROMBankNumber);
}
//===================================================================
// http://chipenable.ru/index.php/programming-avr/item/105-uchebnyy-kurs-ispolzovanie-vneshnih-preryvaniy-v-avr.html
// http://chipenable.ru/index.php/programming-avr/item/58-uchebnyy-kurs-semisegmentnyy-indikator-dinamicheskaya-indikatsiya.html
// http://chipenable.ru/index.php/programming-avr/item/206-biblioteka-dlya-semisegmentnogo-indikatora-s-proizvolnym-podklyucheniem-vyvodov.html
// http://easyelectronics.ru/avr-uchebnyj-kurs-ispolzovanie-eeprom.html
