; BOOT for Computer "MIKRO-80"
; 2014-12-03 adapted by vlad6502.livejournal.com
;
; Original Idea:
; BOOT for Computer "Radio 86RK" / "Apogee BK01"
; (c) 10-05-2014 vinxru (aleksey.f.morozov@gmail.com)

     .org 0h     ;   00000h


DOS        			.EQU 0BFFDH		; Exit ORDOS

SEND_MODE  			.EQU  10000000b ; 80h   (1 0 0 A H 0 B CL)
RECV_MODE  			.EQU  10010000b ; 90h   (1 0 0 A H 0 B CL)

BB55_ControlWord	.EQU 23h 
BB55_PortA			.EQU 20h 
BB55_PortB			.EQU 21h 
BB55_PortC			.EQU 22h 

;   

ERR_START           .EQU 040h ;      
ERR_WAIT            .EQU 041h ;   
ERR_OK_DISK    		.EQU 042h ;  ,     
ERR_OK          	.EQU 043h ;  
ERR_OK_READ     	.EQU 044h ;      
ERR_OK_ADDR    	 	.EQU 047h ;     
ERR_OK_BLOCK   		.EQU 04Fh 


;----------------------------------------------------------------------------
;  

Entry:
     ;      
     ; 256 .     C  0
     LD C,0

Boot:
     ;   ( )   HL
     CALL  RecvMode

     JP   Boot2

;----------------------------------------------------------------------------
;     ( HL   USER_PORT)

Rst1:						;      $0008
     ;      
     LD	A,20h			; INX   H
	 OUT (BB55_PortB),A		; MVI   M, 20h
     XOR	A				; MVI   M, 0
	 JP ContRst1		; ..    8 
	 
;----------------------------------------------------------------------------
;   

Rst2:						;      $0010
WaitForReady:
RST80 .DB 0CFH ;     Rst 8 - Rst   1
       CP   ERR_WAIT
       JP Z,WaitForReady
       RET


;----------------------------------------------------------------------------
ContRst1:
	 OUT (BB55_PortB),A		; DCX   H

     ;  
     IN	A,(BB55_PortA)		; MOV   A, M
     RET
;----------------------------------------------------------------------------

     ;    (  )
Boot2:
	 LD A,0				; INR   L
	 OUT (BB55_PortB),A		; MVI   M, 0
     LD A,44h			; MVI   M, 44h
	 OUT (BB55_PortB),A
     LD A,40h			; MVI   M, 40h
	 OUT (BB55_PortB),A
     LD A,0h			; MVI   M, 0h
	 OUT (BB55_PortB),A
							; DCR   L

     ;   ,    ERR_START   
RST81 .DB 0CFH ;     Rst 8 - Rst   1
       CP   ERR_START
       JP NZ,RetrySync

     ;  
RST102 .DB 0D7H ; RST 10 - Rst   2
        CP   ERR_OK_DISK
        JP NZ,RetrySync

     ;       
RST82 .DB 0CFH ;     Rst 8 - Rst   1    
       LD  A,SEND_MODE
       CALL  SetMode

     ;   BOOT
     LD  A,0				; MVI   M, 0
	 OUT (BB55_PortA),A
RST83 .DB 0CFH ;     Rst 8 - Rst   1 1

     ;  
     CALL  RecvMode

     ;    BOOT
RST101 .DB 0D7H ; RST 10 - Rst   2
        CP   ERR_OK_ADDR
        JP NZ,RetrySync
     
     ;    BC
RST84 .DB 0CFH ;     Rst 8 - Rst   1
       LD C,A
RST85 .DB 0CFH ;     Rst 8 - Rst   1
       LD B,A

     ;     
     PUSH BC

     ;       
RecvLoop:
     ;   ,   .
RST100 .DB 0D7H ; RST 10 - Rst   2
        CP   ERR_OK_READ
        JP Z,Rst1

     ;      ,   ERR_OK_BLOCK
     CP   ERR_OK_BLOCK
     JP NZ,PrintError

     ;   
RST86 .DB 0CFH ;     Rst 8 - Rst   1
       LD E,A
RST87 .DB 0CFH ;     Rst 8 - Rst   1
       LD D,A

     ;   
RecvBlock:
     LD A,E
     OR D
     JP Z,RecvLoop
RST88 .DB 0CFH ;     Rst 8 - Rst   1
       LD (BC),A
       INC   BC
       DEC   DE
       JP   RecvBlock

;----------------------------------------------------------------------------
;  

RetrySync:
     ; 
     DEC   C
     JP NZ,Boot

;----------------------------------------------------------------------------
;   

PrintError:
     CALL  0F815h				; PrintHEXbyte
     JP   DOS

;----------------------------------------------------------------------------
;     

RecvMode:
;		di
;		IN A,(0Ah)
;		SET 5,A
;		OUT (0Ah),A		  ; 2,5 

     LD  A,RECV_MODE

SetMode:
     OUT (BB55_ControlWord),A	
								
								
     RET



.End

