; SD BIOS for Computer "MIKRO-80"
; 2014-12-20 adapted by vlad6502.livejournal.com
;
; Original Idea:
; SD BIOS for Computer "Radio 86RK" / "Apogee BK01"
; (c) 10-05-2014 vinxru (aleksey.f.morozov@gmail.com)

;    .org 0E000h-683 ;      0E0FFh
;    .org 0d000h ;      SHELL
;    .org 0d980h
;    .org 0dc00h    

     .org 0B400h         ;0B400h      
;----------------------------------------------------------------------------

; INIT_VIDEO      = 0FACEh
USER_PORT       = 0EE00h    ;  58055  RK86

BB55_ControlWord	.EQU 23h 
BB55_PortA			.EQU 20h 
BB55_PortB			.EQU 21h 
BB55_PortC			.EQU 22h 

Stack_End			.EQU 0F3C0h
;Stack_End			= 0F7FFh

CalculateCRC		.EQU 0F82Ah
PrintString			.EQU 0F818h
PrintCharFromC		.EQU 0F809h
PrintHEXbyte		.EQU 0F815h			 
PrintHexWord		.EQU 0FC5Ah
WarmReset			.EQU 0BFFDH
GetChar				.EQU 0F803h

SEND_MODE  			.EQU  10000000b ; 80h   (1 0 0 A H 0 B CL)
RECV_MODE  			.EQU  10010000b ; 90h   (1 0 0 A H 0 B CL)



ERR_START           .EQU 040h ;      
ERR_WAIT            .EQU 041h ;   
ERR_OK_NEXT    		.EQU 042h ;  ,     
ERR_OK          	.EQU 043h ;  
ERR_OK_READ     	.EQU 044h ;      
ERR_OK_ENTRY        .EQU 045h
ERR_OK_WRITE	    .EQU 046h
ERR_OK_ADDR    	 	.EQU 047h ;     
ERR_OK_BLOCK   		.EQU 04Fh 


VER_BUF             .EQU 0

;----------------------------------------------------------------------------
;  RK 

     .db ($+2)>>8, ($+2)&0FFh
     
;----------------------------------------------------------------------------
	      
Entry:
     ;    
;    LD	HL, SELF_NAME
     LD C,1Fh ;CALL	0F833h				; SetFreeMemAddr
	 CALL 0F809H
     ;     
     LD	HL,aHello
     CALL PrintString

     ;   
     CALL	PrintVer

     ;  
     LD	HL,aCrLf
     CALL	PrintString

     ;   SHELL.RK   
     LD	HL,aShellRk
     LD	DE,aEmpty
     CALL	CmdExec
 	 
     PUSH	AF

     ;  -   
     CP	04h
     JP NZ,Error2

     ;   "   BOOT/SHELL.RK"
     LD	HL,aErrorShellRk
     CALL	PrintString		
	 jp WarmReset
     ;JMP	$					; lock computer

;----------------------------------------------------------------------------

PrintVer:
     ;   
     LD	A, 1
     CALL	StartCommand	;      
     CALL	SwitchRecv
     
     ;      
     LD	BC,VER_BUF
     LD	DE,18          ; 1   ,   -  
     CALL	RecvBlock
          
     ;   
     XOR A
     LD	(VER_BUF+17),A
     LD	HL,VER_BUF+1
     JP	PrintString

;----------------------------------------------------------------------------

aHello:         .db 13,10,"SD BIOS V1.0",13,10
aSdController:  .db "SD CONTROLLER ",0
;aCrLf:         .db 13,10,0
aErrorShellRk:  .db "fajl ne najden "
aShellRk:       .db "BOOT/SHELL.RK",0
                .db "(c) 04-05-2014 vinxru"

aDbgMsgA:	.db " DEBUG POINT A ",0
aDbgMsgB:	.db " DEBUG POINT B ",0
aTrcMsg:	.db " -TRACE POINT- ",0

aLoadAddress:	.db "PROGRAM LOADING START_ADR END_ADR CRC: ",0

;         

SELF_NAME    = $-512 ;  ( 256 )
CMD_LINE     = $-256 ;   256 

;----------------------------------------------------------------------------
;   SD BIOS
;----------------------------------------------------------------------------

aError:    .db "o{ibka SD "
aEmpty:    .db 0
aCRCerror: .db "CRC ERROR", 0
aCrLf:     .db 13,10,0

LoadedCnt: .dw 0
LoadStart: .dw 0
LoadEnd:   .dw 0
PathPtr:   .dw 0
aString:   .db "STRING->ATMEGA[",0
aEndStr:   .db "]",13,10,0
aBiosEntry: .db ">> BIOS CALL[", 0

;----------------------------------------------------------------------------
;   ,      

Error:     
     ;  
     LD SP,Stack_End		; LXI	SP, 0E1CFh

     ;   
     PUSH AF

     ;  
     ;         ,    
     ; MVI	C, 1Fh
     ; CALL	0F809h			; PrintChar, ClearScreen  
     ;    
     ; CALL       INIT_VIDEO			

Error2:
     ;   " SD "
     LD	HL,aError
     CALL	PrintString

     ;   
     POP AF
     CALL	PrintHEXbyte

     ; 
     JP	$

;----------------------------------------------------------------------------

BiosEntry:
     PUSH HL
     LD (PathPtr),HL

	 push DE	 
	 LD l,a
	 LD  h,0
	 ADD HL,HL ;dad  h			;     2
	 EX DE,HL ;xchg
	 LD	HL,JmpTbl
	 ADD HL,DE ;dad  d

	 LD E,(HL) ;mov  e,M
	 INC HL ;inx  H
	 LD D,(HL) ;mov  d,M
	 EX DE,HL ;xchg
	 pop DE

;     LXI	H, JmpTbl
;     ADD	L				
;     MOV	L, A
;     MOV	L, M

 
 ;call PrintHexWord		;   
 ;jmp $
     EX (SP),HL ;XTHL
     LD HL,(PathPtr) ;lhld PathPtr

	jp LSkipD1
 ; Debug: Infom BIOS call
	 push HL
	 push DE
	 push BC
	 push AF
	 LD HL,aBiosEntry
	 call PrintString 
	 LD HL,(PathPtr)
	 call PrintString 
	 LD HL,aEndStr
	 call PrintString 
	 pop AF
	 pop BC
	 pop DE
	 pop HL
 ;------------------------

LSkipD1:
			LD HL,(PathPtr)
			RET		; Goto Subroutine

;----------------------------------------------------------------------------
;  8D00.   JmpTbl    

JmpTbl:
     .dw CmdExec           ; 0 HL- , DE-   / A- 
     .dw CmdFind           ; 1 HL- , DE-   , BC- / HL- , A- 
     .dw CmdOpenDelete     ; 2 D-, HL-  / A- 
     .dw CmdSeekGetSize    ; 3 B-, DE:HL- / A- , DE:HL-
     .dw CmdRead           ; 4 HL-, DE- / HL- , A- 
     .dw CmdWrite          ; 5 HL-, DE- / A- 
     .dw CmdMove           ; 6 HL-, DE- / A- 
;----------------------------------------------------------------------------
; HL-, DE-   , BC- / HL- , A- 

CmdFind:
		;  
		;    MVI	A, 3
		;    CALL	StartCommand

 ;push H		
 ; lxi h,aLoadAddress		;   -      !!!
 ;call PrintString
     ;  
     LD	A, 3
     CALL	StartCommand
 ;pop H	;     !

	; 
     CALL	SendString

     ;  
     EX DE,HL
     CALL	SendWord

     ;    
     CALL	SwitchRecv

     ; 
     LD	HL, 0

CmdFindLoop:
     ;    
     CALL	WaitForReady
     CP	ERR_OK
     JP Z,Ret0
     CP	ERR_OK_ENTRY
     JP NZ,EndCommand

     ;   
     LD	DE,20	;  
     CALL	RecvBlock

     ;   
     INC HL

     ; 
     JP	CmdFindLoop

;----------------------------------------------------------------------------
; D-, HL-  / A- 

CmdOpenDelete:
 ;push H		
 ;lxi h,aLoadAddress		;   -      !!! 
     ;  
     LD A, 4
     CALL	StartCommand
 ;pop h

     ; 
     LD	A, D
     CALL	Send

     ;  
     CALL	SendString

     ;    
     CALL	SwitchRecvAndWait
     CP	ERR_OK
     JP Z,Ret0
     JP	EndCommand
     
;----------------------------------------------------------------------------
; B-, DE:HL- / A- , DE:HL-

CmdSeekGetSize:
 ;push H		
 ;lxi h,aLoadAddress		;   -      !!!
     ;  
     LD	A, 5
     CALL	StartCommand
 ;pop h 

     ;      
     LD	A, B
     CALL	Send

     ;      
     CALL	SendWord
     EX DE,HL
     CALL	SendWord

     ;    .     ERR_OK
     CALL	SwitchRecvAndWait
     CP	ERR_OK
     JP NZ,EndCommand

     ;  
     CALL	RecvWord
     EX DE,HL
     CALL	RecvWord

     ; 
     JP	Ret0
     
;----------------------------------------------------------------------------
; HL-, DE- / HL- , A- 

CmdRead:
 ;push H		
 ;lxi h,aLoadAddress		;   -      !!!
     ;  
     LD	A, 6
     CALL	StartCommand
 ;pop h

     ;   BC
     LD	B,D
     LD C,E

     ;  
     CALL	SendWord        ; HL-

     ;    
     CALL	SwitchRecv

     ;  .    BC,    HL
     JP	RecvBuf

;----------------------------------------------------------------------------
; HL-, DE- / A- 

CmdWrite:
 ;push H		
 ;lxi h,aLoadAddress		;   -      !!!
     ;  
     LD A,7
     CALL	StartCommand
 ;pop h
      
     ;  
     CALL	SendWord        ; HL-

     ;    HL
     EX DE,HL

CmdWriteFile2:
     ;   
     CALL	SwitchRecvAndWait
     CP  	ERR_OK
     JP Z,Ret0
     CP  	ERR_OK_WRITE
     JP NZ,EndCommand

     ;  ,      DE
     CALL	RecvWord

     ;        
     CALL	SwitchSend

     ;  .  BC  DE. (  )
CmdWriteFile1:
     LD	A,(HL)
     INC HL
     CALL	Send
     DEC	DE
     LD A,D
     OR	E
     JP NZ,CmdWriteFile1

     JP	CmdWriteFile2

;----------------------------------------------------------------------------
; HL-, DE- / A- 

CmdMove:     
 ;push H		
 ;lxi h,aLoadAddress		;   -      !!!
     ;  
     LD A,8
     CALL	StartCommand
 ;pop h

     ;  
     CALL	SendString

     ;    
     CALL	SwitchRecvAndWait
     CP	ERR_OK_WRITE
     JP NZ,EndCommand

     ;    
     CALL	SwitchSend

     ;  
     EX DE,HL 
     CALL	SendString

WaitEnd:
     ;    
     CALL	SwitchRecvAndWait
     CP	ERR_OK
     JP Z,Ret0
     JP	EndCommand

;----------------------------------------------------------------------------
; HL- , DE-  / A- 

CmdExec:
 push HL 		

 ; Print Load Address information
;	 LD HL,aLoadAddress 
;	 push DE
;	 push BC
;	 call PrintString
;	 pop BC
;	 pop DE

     ;  
     LD A,2
     CALL	StartCommand

	 pop HL	;       !

     ;  
     PUSH	HL
     CALL	SendString
     POP	HL

     ;     
     ;     ERR_OK_ADDR
     CALL	SwitchRecvAndWait
     CP	ERR_OK_ADDR
     JP NZ,EndCommand

     ;    (HL-)
     PUSH	DE
     EX DE,HL 
     LD HL,SELF_NAME	; $DBCE
     CALL	strcpy255
     POP	DE
 
     ;    (DE-)
     LD HL,CMD_LINE		; $DCCE
     CALL	strcpy255

     ; ***   .     . ***
     ;   (  )
	 LD SP,Stack_End			; LXI	SP, 0E1CFh

      ;     DE     
     CALL	RecvWord
	 EX DE,HL  
	 LD (LoadStart),HL
	 EX DE,HL 
     PUSH	DE


     LD B,D
     LD C,E
      ;  
     CALL	RecvBuf
	 LD (LoadedCnt),HL
     JP NZ,Error

     ;  
     ;         ,    
     ; MVI	C, 1Fh
     ; CALL	0F809h     
     ;    
     ; CALL       INIT_VIDEO


  ;   
	LD HL,(LoadStart)
  ;call	PrintHexWord	; print word HL

 
  ;  CRC - !!!!           +6        !!!
  LD HL,(LoadStart)
  EX DE,HL 
  LD HL,(LoadedCnt)
  ADD HL,DE ;dad	d				; Calculate end address
  LD (LoadEnd),HL

  ;call	PrintHexWord	;    

CheckCRC:
  ;  CRC  
  LD HL,(LoadEnd)
  LD BC,-7
  ADD HL,BC ;dad  b
  EX DE,HL 
  LD HL,(LoadStart)
  call	CalculateCRC
  push BC 
  pop HL ; bc-> hl
  
  push BC 
  ;call	PrintHexWord	;  CRC
  pop BC
 
  ; CompareCRC
  LD HL,(LoadEnd)
  DEC HL ;dcx h
  LD A,(HL) ;mov	a,m
  cp c
;  jnz	CrcError
  DEC HL ;dcx	h
  LD A,(HL) ;mov	a,m
  cp	b
;  jnz	CrcError

  LD HL,aCrLf
  call	PrintString

		 ;   
		 LD A, 1		;  
		 LD BC,BiosEntry  ;   SD BIOS
		 LD DE,SELF_NAME  ;  
		 LD HL, CMD_LINE   ;  
	 
		;-------------------------------------------------------
		;   
		;-------------------------------------------------------
		 RET
		

	
CrcError:
  LD HL,aCRCerror
  call	PrintString	
  jp	$	

;----------------------------------------------------------------------------
;    .   8E00.
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
;   . 
; A -  

StartCommand:
     ;      
     ;  256 ,      256+ 
     ;     - ,    
     PUSH	BC
     PUSH	HL
     PUSH	AF
     LD C,0

StartCommand1:
     ;   ( )   HL
     CALL       SwitchRecv

     ;    (  )
     LD A,0					; LXI	H, USER_PORT+1
     LD HL,USER_PORT+1 ;     !!!!
     OUT (BB55_PortB),A			; MVI        M, 0
     LD A,44h				; MVI        M, 44h
	 OUT (BB55_PortB),A
     LD A,40h				; MVI        M, 40h
	 OUT (BB55_PortB),A
     LD (HL),0h				; MVI        M, 0h
	 OUT (BB55_PortB),A

     ;   ,    ERR_START
     CALL	Recv
     CP	ERR_START
     JP Z,StartCommand2

     ; .     256  (   
     ;  64  ,   )
     PUSH	BC
     LD C,0
StartCommand3:
     CALL	Recv
     DEC	C
     JP NZ,StartCommand3
     POP	BC
        
     ; 
     DEC C
     JP NZ,StartCommand1    

     ;  
     LD A,ERR_START
StartCommandErr2:
     POP	BC ;   AF
     POP	HL ;   H
     POP	BC ;   B     
     POP	BC ;   .
     RET

;----------------------------------------------------------------------------
;    .    ERR_OK_NEXT

StartCommand2:
     ;          	
     CALL	WaitForReady
     CP	ERR_OK_NEXT
     JP NZ,StartCommandErr2

     ;    
     CALL       SwitchSend

     POP        AF
     POP        HL
     POP        BC

     ;   
     JP        Send

;----------------------------------------------------------------------------
;    

SwitchSend:
     CALL	Recv
SwitchSend0:
     LD A,SEND_MODE
     OUT (BB55_ControlWord),A		; STA	USER_PORT+3
     RET

;----------------------------------------------------------------------------
;    
;   ,     

Ret0:
     XOR	A

;----------------------------------------------------------------------------
;      A 
;   ,     

EndCommand:
     PUSH	AF
     CALL	Recv
     POP	AF
     RET

;----------------------------------------------------------------------------
;    DE 
;  A.

RecvWord:
    CALL Recv
    LD E,A
    CALL Recv
    LD D,A
    RET
    
;----------------------------------------------------------------------------
;    HL 
;  A.

SendWord:
    LD A,L
    CALL	Send
    LD A,H
    JP		Send
    
;----------------------------------------------------------------------------
;  
; HL - 
;  A.

SendString:
 jp   LoopSendString
 
 ; Debug Message ----   
 push HL 
 push DE 
 push BC 
 push AF
 push HL 
 LD HL,aString
 call PrintString
 pop HL
 call PrintString
 LD HL,aEndStr
 call PrintString
; call GetChar
 pop AF
 pop BC
 pop DE
 pop HL
 ;------------------

LoopSendString:
     XOR	A
     OR	(HL)
     JP Z,Send
     CALL	Send
     INC	HL
     JP	LoopSendString
     
;----------------------------------------------------------------------------
;    

SwitchRecv:
     LD A,RECV_MODE
     OUT (BB55_ControlWord),A		; STA	USER_PORT+3   BB55_PortB  ?????????????????????  
     RET

;----------------------------------------------------------------------------
;        .

SwitchRecvAndWait:
     CALL SwitchRecv

;----------------------------------------------------------------------------
;   .

WaitForReady:
     CALL	Recv
     CP	ERR_WAIT
     JP Z,WaitForReady
     RET

;----------------------------------------------------------------------------
;  DE    BC
;  A

RecvBlock:
     PUSH	HL
							; LXI 	H, USER_PORT+1
     INC 	D
     XOR 	A
     OR 	E
     JP Z,RecvBlock2
RecvBlock1:
     LD A,20h			; MVI        M, 20h			; 7
	 OUT (BB55_PortB),A
     LD A,0			; MVI        M, 0			; 7
	 OUT (BB55_PortB),A
     IN	A,(BB55_PortA)		; LDA	USER_PORT		; 13
     LD (BC),A 		        ; 7
     INC	BC		        ; 5
     DEC	E		        ; 5
     JP NZ,RecvBlock1		; 10 = 54
RecvBlock2:
     DEC	D
     JP NZ,RecvBlock1
     POP	HL
     RET

;----------------------------------------------------------------------------
;     BC. 
;   HL  
;  A
;    ,   Z=1

RecvBuf:
     LD	HL, 0
RecvBuf0:   
     ; 
     CALL	WaitForReady
     CP	ERR_OK_READ
     JP Z,Ret0		;   Z ( )
     SUB    ERR_OK_BLOCK
     JP NZ,EndCommand	;   NZ ()

     ;     DE
     CALL	RecvWord

     ;  HL  
     ADD HL,DE ;DAD D

     ;  DE    BC
     CALL	RecvBlock

     JP	RecvBuf0

;----------------------------------------------------------------------------
;     256  ( )

strcpy255:
     LD B,255
strcpy255_1:
     LD A,(DE) ;LDAX D
     INC  DE
     LD (HL),A
     INC  HL
     OR A
     RET Z
     DEC  B
     JP NZ,strcpy255_1
     LD (HL),0 ; 
     RET

;----------------------------------------------------------------------------
;    A.

Send:
	OUT	(BB55_PortA),A		; STA	USER_PORT

;----------------------------------------------------------------------------
;    

Recv:
     LD	A,20h
     OUT (BB55_PortB),A	; STA	USER_PORT+1
     XOR A
     OUT (BB55_PortB),A	; STA	USER_PORT+1
     IN	A,(BB55_PortA)	; LDA	USER_PORT
     RET

;----------------------------------------------------------------------------


DebugA:
 LD	HL,aDbgMsgA
 CALL	PrintString
 JP    $


DebugB:
 LD	HL,aDbgMsgB
 CALL	PrintString
 JP    $

Trace: 
 PUSH AF
 PUSH HL
 PUSH BC
 PUSH DE
 LD HL,aTrcMsg
 CALL	PrintString
 POP  DE
 POP  BC
 POP  HL
 POP  AF
 RET


.End