(*$GPCP*)(*$E+*)(*$T-*)

VAR LastX, LastY: INTEGER;

/*$C
INIT$:
    .BYTE   ^O33, ^O246, ^O62      ; 40x24 mode
    .BYTE   ^O33, ^O45, ^O41, ^O61 ; Term mode
    .BYTE   ^O33, ^O133, ^O60, ^O73, ^O60, ^O162
    .BYTE   ^O33, ^O45, ^O41, ^O60 ; Graph
    .BYTE   0
*/
PROCEDURE InitGraph;
BEGIN /*$C
    BIS     #^O10000, @#^O44 ; Disable Ctrl-C
    MOV     #INIT$, R0
$TTYOUT:
    TSTB    @#^O177564
    BPL     $TTYOUT
    MOVB    (R0)+, @#^O177566
    BNE     $TTYOUT
*/
END {InitGraph};

/*$C
CLOSE$:
    .BYTE   ^O33, ^O45, ^O41, ^O63
    .BYTE   ^O33, ^O246, ^O61 ; 80x24 mode
    .BYTE   ^O14
    .BYTE   0, 0
*/
PROCEDURE CloseGraph;
BEGIN /*$C
    MOV     #CLOSE$, R0
    JMP     $TTYOUT
*/
END {CloseGraph};

PROCEDURE ClearDevice;
BEGIN /*$C
    MOV     R2, -(SP)
    MOV     #^O-1140, R0
    MOV     #^O-1136, R1
    MOV     #^O-100000, R2
    MOV     R2, @R0
1$: CLR     @R1
    INC     @R0
    SOB     R2, 1$
    MOV     (SP)+, R2
*/
END {ClearDevice};

/*$C
PALET$:
    .BYTE   ^O33, ^O45, ^O41, ^O63
    .BYTE ^O33, ^O240, 1
    .BYTE ^O33, ^O241, 2
    .BYTE ^O33, ^O240, 3
    .BYTE   ^O33, ^O45, ^O41, ^O60 ; Graph
    .BYTE 0
*/
PROCEDURE Palette (n: INTEGER);
BEGIN /*$C
    MOV     #PALET$, R0
    CALL    $TTYOUT
*/
END {Palette};

PROCEDURE PutPixel (x, y, color: INTEGER);
BEGIN /*$C
    MOV     6(SP), LastX
    MOV     4(SP), LastY
    MOV     6(SP), R1
    BIC     #^O-10, R1
    MOV     #1, R0
    ASH     R1, R0
    MOV     4(SP), R1
    MUL     #^O120, R1
    BIS     #^O-100000, R1
    MOV     R1, @#^O176640
    MOV     6(SP), R1
    ASH     #-3, R1
    ADD     R1, @#^O176640
    BICB    R0, @#^O176642
    BICB    R0, @#^O176643
    BIT     #1, 2(SP)
    BEQ     1$
    BISB    R0, @#^O176642
1$: BIT     #2, 2(SP)
    BEQ     2$
    BISB    R0, @#^O176643
2$: */
END {PutPixel};
