﻿                ; тест клавиатуры
                emt     14              ; инициализируем всё
                mov     #100000, @#4    ; СТОП - будет выход в монитор
                mov     #100, @#177660  ; запретим прерывания от клавиатуры
                mov     #V60, @#60      ; установим свои векторы клавиатуры
                mov     #200, @#62
                mov     #V274, @#274
                mov     #200, @#276
                mov     #42010, R1
                jsr     R2, IOuts
                .asciz  "Scancode:"
                .even
                mtps    #0
                tstb    @#177662        ; сбросим флаг нового кода, на всякий случай
                clr     @#177660        ; разрешаем прерывания от клавиатуры
                ; работаем
1$:             bit     #100, @#177716  ; ждём нажатия клавиши
                bne     1$
                call    DrawPress
                call    BeepPress
4$:             bit     #100, @#177716  ; ждём отжатия клавиши
                beq     4$
                call    ClearScCode
                call    DrawUnPress
                call    BeepUnPress
                br      1$

DrawPress:      mov     #42000, R1
                mov     #100, R2
                mov     #5, R0
2$:             clr     (R1)
                add     R2, R1
                sob     R0, 2$
                mov     #5, R0
3$:             mov     #177777, (R1)
                add     R2, R1
                sob     R0, 3$
                return

BeepPress:      mov     #30, R2
                mov     #30, R3
                jmp     Beep

DrawUnPress:    mov     #42000, R1
                mov     #100, R2
                mov     #5, R0
6$:             mov     #177777, (R1)
                add     R2, R1
                sob     R0, 6$
                mov     #5, R0
5$:             clr     (R1)
                add     R2, R1
                sob     R0, 5$
                return

BeepUnPress:    mov     #30, R2
                mov     #40, R3
                jmp     Beep

V60:            push    R5
                push    R4
                push    R3
                push    R2
                push    R1
                push    R0
                call    vCode
                br      0ExTr$

V274:           push    R5
                push    R4
                push    R3
                push    R2
                push    R1
                push    R0
                call    vCode
                tst     (R1)+
                jsr     R2, IOuts
                .asciz  "АР2"
                .even
0ExTr$:         pop     R0
                pop     R1
                pop     R2
                pop     R3
                pop     R4
                pop     R5
                rti

ClearScCode:    mov     #42034, R1
                mov     #10., R3
8$:             mov     #8., R2
7$:             clr     (R1)+
                sob     R2, 7$
                add     #100-16., R1
                sob     R3, 8$
                return

vCode:          mov     #4, R2
                mov     #33, R3
                call    Beep
                mov     #42034, R1
                mov     @#177662, R2
                call    OctOutB
                mov     #255, R0
                jmp     PutchX


;вход:  R2 - длительность звука БИП
;       R3 - частота звука
Beep:           push    R2
                push    R0
1$:             mov     #320, @#177716  ; импульс на динамик 
                mov     R3, R0
                sob     R0,.            ; длительность положительной половины импульса 
                mov     #220, @#177716  ; сбросить 
                mov     R3, R0
                sob     R0,.            ; пауза (длительность отрицательной половины импульса) 
                sob     R2, 1$          ; цикл звука при нажатии клавиши (102062-102110) 
                pop     R0
                pop     R2
                return

; Вывод инлайн-строки символов, заканчивающейся нулём
; вход: R1 - адрес вывода
; строка за командой
IOuts:          call    Puts
                inc     R2
                bic     #1, R2
                rts     R2

; Вывод восьмеричного числа (байта)
; вход: R1 - адрес вывода
;       R2 - число в мл. байте
OctOutB:        push    R3
                push    R2
                push    R0
                mov     #3, R3
                swab    R2
                clr     R0
                br      300$

; Вывод восьмеричного числа
; вход: R1 - адрес вывода
;       R2 - число
OctOut:         push    R3
                push    R2
                push    R0
                mov     #6, R3
                clr     R0
                br      1$
2$:             clr     R0
                asl     R2
                rol     R0
300$:           asl     R2
                rol     R0
1$:             asl     R2
                rol     R0
                add     #'0, R0
                call    Putch
                sob     R3, 2$
                pop     R0
                pop     R2
                pop     R3
                return

; Вывод строки символов, заканчивающейся нулём
; вход: R1 - адрес вывода
;       R2 - адрес строки
Puts:           push    R0
2$:             movb    (R2)+, R0
                beq     1$
                call    Putch
                br      2$
1$:             pop     R0
                return

; Вывод символа xorом
; вход: R1 - адрес вывода
;       R0 - кoд
PutchX:         mov     #74511, morph$
                call    Putch
                mov     #10511, morph$
                return
; Вывод символа
; вход: R1 - адрес вывода
;       R0 - кoд
Putch:          push    R5
                push    R4
                push    R3
                push    R2
                push    R0
                bic     #177400, R0
                tstb    R0
                bpl     02$
                sub     #40, R0
02$:            asl     R0
                mov     R0, R2
                asl     R0
                asl     R0
                add     R2, R0
                add     #112276-500, R0
                mov     #10., R2
p01$:           movb    (R0)+, R3
                mov     #8., R4
03$:            asr     R3
                ror     R5
                asr     R5
                sob     R4, 03$
morph$:         mov     R5, (R1)
                add     #100, R1
                sob     R2, p01$
                sub     #1200-2, R1
                pop     R0
                pop     R2
                pop     R3
                pop     R4
                pop     R5
                return

                .end
