PROGRAM TSTSPR; (*$GPCP*)(*$T-*)

PROCEDURE InitGraph; EXTERNAL;
PROCEDURE CloseGraph; EXTERNAL;
PROCEDURE ClearDevice; EXTERNAL;
PROCEDURE Palette (n: INTEGER); EXTERNAL;
PROCEDURE SetPalette (c0, c1, c2, c3: INTEGER); EXTERNAL;
PROCEDURE PutPixel (x, y, color: INTEGER); EXTERNAL;
PROCEDURE PutSpr (x, y: INTEGER; PROCEDURE spr); EXTERNAL;

PROCEDURE Spr; BEGIN
/*$C
	.radix 8
	.WORD	5., 62.
	.WORD	177777, 177777, 177777, 177777, 177777, 401, 0, 0
	.WORD	0, 100200, 172765, 177777, 177777, 177777, 127657, 170761
	.WORD	177777, 177777, 177777, 107617, 176775, 177777, 177777, 177777
	.WORD	137677, 176775, 177777, 177777, 177777, 137677, 176775, 177777
	.WORD	177777, 177777, 137677, 176775, 177777, 177777, 177777, 137677
	.WORD	152725, 162377, 177777, 177777, 137677, 52725, 140377, 177777
	.WORD	177777, 137677, 62745, 140377, 177777, 177777, 137677, 152725
	.WORD	160377, 177777, 177777, 137677, 152725, 170777, 177777, 177777
	.WORD	137677, 176775, 175777, 177777, 177777, 137677, 176775, 177777
	.WORD	177777, 177777, 137677, 177777, 177777, 777, 177377, 137677
	.WORD	165777, 177777, 377, 176377, 137677, 140777, 77777, 377
	.WORD	170377, 137677, 140777, 37777, 3777, 163777, 137677, 161777
	.WORD	167777, 176777, 136777, 137677, 173777, 147777, 14377, 114377
	.WORD	137677, 176775, 17777, 377, 140377, 137677, 176775, 17777
	.WORD	377, 140377, 137677, 176775, 17437, 0, 140300, 137677
	.WORD	176775, 47517, 105613, 105212, 137677, 176775, 17437, 0
	.WORD	140300, 137677, 176775, 17437, 0, 140300, 137677, 176775
	.WORD	167757, 3407, 140300, 137677, 176775, 157737, 174771, 100200
	.WORD	137677, 176775, 57537, 177376, 100601, 137677, 176775, 157737
	.WORD	176374, 100601, 137677, 176775, 167757, 177777, 3407, 137677
	.WORD	176775, 167757, 177777, 3407, 137677, 176775, 173767, 177777
	.WORD	1002, 137677, 176775, 43507, 177777, 0, 137677, 176775
	.WORD	27457, 177777, 40100, 137276, 176775, 167757, 177777, 144310
	.WORD	137276, 176775, 27457, 17036, 174370, 137276, 176775, 161743
	.WORD	7417, 174370, 137276, 176775, 122645, 3407, 66154, 137677
	.WORD	176775, 101202, 401, 40100, 137276, 76575, 1002, 0
	.WORD	133266, 167777, 176775, 1403, 0, 135272, 143777, 76575
	.WORD	2405, 0, 155733, 101376, 176775, 7016, 0, 157737
	.WORD	101777, 76575, 37477, 100200, 127657, 153777, 76575, 140300
	.WORD	3407, 170360, 177376, 176775, 177777, 177777, 177777, 137677
	.WORD	176775, 177777, 177777, 157777, 137677, 176775, 177777, 177777
	.WORD	107777, 125653, 176775, 177777, 177777, 3777, 125653, 176775
	.WORD	177777, 177777, 1777, 123247, 176775, 177777, 177777, 1777
	.WORD	125253, 176775, 177777, 177777, 23777, 125653, 176775, 177777
	.WORD	177777, 177777, 137677, 176775, 177777, 177777, 177777, 137677
	.WORD	176775, 177777, 177777, 177777, 137677, 176775, 177777, 177777
	.WORD	177777, 137677, 170761, 177777, 177777, 177777, 107617, 172765
	.WORD	177777, 177777, 177777, 127657, 401, 0, 0, 0
	.WORD	100200, 177777, 177777, 177777, 177777, 177777 
	.radix 10
*/
END {Spr};

VAR i: INTEGER;
BEGIN
  InitGraph; ClearDevice;
  SetPalette(0, 13, 15, 11);
  for i:=0 to 8 do PutSpr(16+i*6, 19+i*6, Spr);
  for i:=0 to 8 do PutSpr(54-i*6, 73+i*6, Spr);
  repeat until false;
END {TSTSPR}.
