#define ORG .org
#define EQU .equ
#define DB  .db
#define DW  .dw
;ca a == cat a  - DIR list for disk a
;lo "File name" == load "File name"  - load filename from disk
;lo "File name" code
;mo "File name" - save SNA to disk with filename
;mo "File name" code

;               74ls138
;         A5  a       0     dat_wr
;         A3  b       1     
;        /wr  c       2
;                     3
;                     4    dat_rd
;         M1  e1      5    conf_wr
;         A7 /e2      6
;      /IORQ /e3      7
;
;a7=0,a6=1,a5=0/1,a4=1,a3=0,a2=1,a1=1,a0=1
;01010111  57h  data
;01110111  77h  conf
 
SD_DATA_PORT EQU 057h
SD_CONF_PORT EQU 077h

; command response R1
; 0x00 ok
; or bitfield
; 0x01 idle state
; 0x02 erase reset
; 0x04 illegal command
; 0x08 command crc error
; 0x10 erase sequence error
; 0x20 address error
; 0x40 parameter error
; 0x80 timeout (other bits meaningless)
;
; packet token
; 0xFF none yet
; 0xFE ok
; or bitfield
; 0x01 error
; 0x02 controller error
; 0x04 media ecc failed
; 0x08 out of range
; 0x10 card is locked

CMD0   EQU 040h |  0 ; resets the card
CMD8   EQU 040h |  8 ; read IF_COND
CMD9   EQU 040h |  9 ; read CSD
CMD10  EQU 040h | 10 ; read CID
CMD16  EQU 040h | 16 ; set R/W block
CMD17  EQU 040h | 17 ; read block
CMD24  EQU 040h | 24 ; write block
CMD55  EQU 040h | 55 ; next command is ACMDxx
ACMD41 EQU 040h | 41 ; send host capacity support, init card

    .ORG 04b3h
SD_FIN: ld A,0FFh
SD_PUT:
   out (SD_DATA_PORT),a
  RET
SD_RWR:
      ld    A,E
      add   hl,hl
      adc   A,A
      ld    D,A
      ld    E,H
      ld    H,L
      ld    L,0
      ret
POPHRET:POP hl
;Verify - NOT USED
VERBL:  ;call from 0738h
   RET  ; Adr 04C2h RET!

;Enter param: HL adress,BC start sector,A count, DE cyl. offset
;Out param:Z set=OK,NZ=error
REABE:  ; call from 0731h, 088ch, 098dh, 0ee4h, 38b4h
;STACK OVERLAP CHECK
  PUSH  BC
  PUSH  DE
  PUSH  HL
  LD  E,A
  LD  B,9
MU512: SLA E
  RL  D
  DJNZ  MU512
  LD  BC,05CB2h
  SCF
  SBC HL,BC
  JR  NC,OK
  POP HL
  PUSH  HL
  ADD HL,DE
  JR  C,SO
  LD  BC,12
  ADD HL,BC
  JR  C,SO
  SBC HL,SP
  JR  C,OK
SO:
  RST  08h
  DB  01Dh ;stack overlap
OK:  POP HL
  POP DE
  POP BC

REABL:    ; call from 0720h
      push hl
      call CALC
      jr    c,POPHRET
sdr2:
      pop bc  ; (HL)
      push  hl
      push  de
      push bc ; (HL)
SD_READ:  ;    EHL, D  ,        (HL)
      call SD_RWR
      ld    C,CMD17
      call  SD_CMDD
;      jr    c,POPHRET
      ld    de,0FF01h
      call  SD_WAIT
      pop   hl  
      cp    0FEh
      ret   nz  
      ld    B,0
SDR_L1:   call  SD_GET
      ld    (hl),A
      inc   hl  
      call  SD_GET
      ld    (hl),A
      inc   hl  
      djnz SDR_L1
      call SD_FIN
      out (SD_DATA_PORT),a ;
;      call  SD_GET 
;      call  SD_GET 
      pop DE
      pop bc  ; (HL)
      dec d
      jr z,ERRT
      push HL
      ld    hl,01h
      add   hl,bc
      jr nc,sdr2
      inc e
      jr sdr2

WRIBL:   ; call from 3a41h
      push hl
      call CALC
      jr    c,POPHRET
sdw2:
      pop bc  ; (HL)
      push  hl
      push  de
      push bc ; (HL)
      jr SD_WRITE

WRIBE:   ; call from 0984h
      CALL  WRIBL
      jr  ERRT

CALC:
  OR A ;avoids zero sector count - it transfers 256 sectors!
  JP Z,08C3h ; Parameter error
  di
  ld l,a
  ld a,d
  ld h,e
  ld d,l
  ld l,0h
  add hl,bc
  jr nc,sdr1
  inc a
sdr1:
  ld e,a
      push  hl
      push  de
      ld    de,0FFh
      call  SD_WAIT
      pop   de
      pop   hl  
  ret

    .ORG 0555h
ERRT:
;error test & RST 8
      EI
;  RET Z ;If no error
    .ORG 0556h
      ret ;Adr #556 -skip cassette load

SD_GET:
;   CALL SD_FIN
   ld a,0ffh
   out (SD_DATA_PORT),a
   in a,( SD_DATA_PORT)
  RET

SD_WRITE:  ;    EHL, D  ,      (HL)
      call SD_RWR
      ld    C,CMD24 ;   512 
      call  SD_CMDD
;      jp    c,POPHRET
      ld a,0feh ;  
      out (SD_DATA_PORT),a ;      call SD_PUT
      ld B,0h
      pop  hl
SDR_WL1:
      ld A,(hl)
      inc hl
      out (SD_DATA_PORT),a ;      call SD_PUT
      ld A,(hl)
      inc hl
      out (SD_DATA_PORT),a ;      call SD_PUT
      djnz SDR_WL1
      call SD_FIN
      out (SD_DATA_PORT),a ;
;      call SD_FIN
      pop DE
      pop bc  ; (HL)
      dec d
      jr z,ERRT
      push HL
      ld    hl,01h
      add   hl,bc
      jr nc,sdw2
      inc e
      jr sdw2

SD_CMD:   ld    hl,0
SD_CMDW:  ld    de,0
SD_CMDD:  call  SD_FIN
      ld    A,C
      push af
      out (SD_DATA_PORT),a ;      call  SD_PUT
      ld    A,D
      out (SD_DATA_PORT),a ;      call  SD_PUT
      ld    A,E
      out (SD_DATA_PORT),a ;      call  SD_PUT
      ld    A,H
      out (SD_DATA_PORT),a ;      call  SD_PUT
      ld    A,L
      out (SD_DATA_PORT),a ;      call  SD_PUT
      pop af
      cp CMD8
      ld    A,87h
      jr  z,putCRC
      ld    A,95h
putCRC:
      out (SD_DATA_PORT),a ;      call  SD_PUT
      ld    de,8080h
SD_WAIT:  ld    bc,20000
SDW_L1:   call  SD_GET
      ld    h,A
      sub   D 
      cp    E 
      ld    A,h
      ret   nc  
      dec   bc  
      ld    A,b
      or    c
      jr    nz,SDW_L1
      sub   1 
      ret 

    .ORG 038bfh
SD_INIT:
      ld SP,061a5h
      xor A
      out (SD_CONF_PORT),a  ;  call  SD_OFF
      dec a
      ld b,a  ; ld    B,10h
sdi_loop:
      out (SD_DATA_PORT),a ;  call  SD_FIN
      djnz sdi_loop
      out (SD_CONF_PORT),a ;  call  SD_ON
      ld    C,CMD0
      call  SD_CMD
      cp    1
      jr nz,init_exit ;      ret   nz  
SDI_L1: ld C,041h;CMD55
      CALL SD_CMD
      and 0FEh
      jr nz,init_exit ;      ret nz
      ld C,041h;ACMD41
      CALL SD_CMD
      cp 1
      jr z,SDI_L1
init_exit:
      ld H,0FFh
      jp 011cbh
    .ORG 038f2h
    nop
  .end
