;Size-optimized LZSA1 PDP-11 decoder version by Ivan Gorodetsky
;
;usage:
; mov #src_adr,r1
; mov #dst_adr,r2
; jsr pc,unlzsa1
;
;v 1.0 - 2019-10-20
;v 1.1 - 2019-10-22 (-4 bytes)
;v 1.2 - 2019-10-24 (-2 bytes)
;v 1.3 - 2020-04-24 (+4 bytes)
;
;compress with <-f1 -r> options
;156 bytes
;
;  LZSA compression algorithms are (c) 2019 Emmanuel Marty,
;  see https://github.com/emmanuel-marty/lzsa for more information
;
;  This software is provided 'as-is', without any express or implied
;  warranty.  In no event will the authors be held liable for any damages
;  arising from the use of this software.
;
;  Permission is granted to anyone to use this software for any purpose,
;  including commercial applications, and to alter it and redistribute it
;  freely, subject to the following restrictions:
;
;  1. The origin of this software must not be misrepresented; you must not
;     claim that you wrote the original software. If you use this software
;     in a product, an acknowledgment in the product documentation would be
;     appreciated but is not required.
;  2. Altered source versions must be plainly marked as such, and must not be
;     misrepresented as being the original software.
;  3. This notice may not be removed or altered from any source distribution.
		
	
unlzsa1:
ReadToken:
		clrb Counter+1
		movb (r1)+,r0
		mov r0,r5
		bic #177617,r0
		beq NoLiterals
		asr r0
		asr r0
		asr r0
		asr r0
		cmp #7,r0
		bne m1
		jsr pc,ReadLong
m1:
		movb r0,Counter+0
		mov Counter,r3
bc1:
		movb (r1)+,(r2)+
		sob r3,bc1
NoLiterals:
		movb (r1)+,Offset+0
		movb #377,Offset+1
		movb r5,r0
		bpl ShortOffset
LongOffset:
		movb (r1)+,Offset+1
ShortOffset:
		clrb Counter+1
		bic #177760,r0
		add #3,r0
		cmp #18.,r0
		bne m2
		jsr pc,ReadLong
m2:
		movb r0,Counter+0
		mov r1,r4
		mov Offset,r1
		add r2,r1
		mov Counter,r3
bc2:
		movb (r1)+,(r2)+
		sob r3,bc2
		mov r4,r1
		br ReadToken
ReadLong:
		movb (r1)+,r4
		bis #177400,r4	;FF00h
		add r4,r0
		bcc m3
		movb r0,Counter+1
		movb (r1)+,r0
		tstb Counter+1
		beq m4
m3:
		rts pc
m4:
		movb r0,Counter+0
		movb (r1)+,Counter+1
		tst Counter
		beq m5
		rts pc
m5:
		mov (sp)+,r4
		rts pc
				
Counter:	dw 0
Offset:		dw 0
