; reassembly of "pal.hex"
; created by ReAVR V3.4.0
; at 2020/04/24 - 00:46:09
; for Atmel AVR assembler
;---------------------------------------
; AVR_TYPE=Atmega8
; FLASH_SIZE=8KB
; SRAM_START=0x60
; Crystal: 17.734475MHz, 1 clock is 56ns
;---------------------------------------
;Line period 64 us (Micro-seconds)
;Line blanking 12.05 +- 0.25 us
;Line sync 4.7 +- 0.1 us
;Front porch: 1.65 +- 0.1 us
;Burst start 5.6 +- 0.1 us after sync start. (0.9us after sunc end).
;Burst 10 +- 1 cycles
.DEVICE ATmega8
.include "m8def.inc"

	.cseg
	.org	0x0000
;---------------------------------------
; bit numbers:
;
.equ	b0	= 0x00
.equ	b1	= 0x01
.equ	b2	= 0x02
.equ	b3	= 0x03
.equ	b4	= 0x04
.equ	b5	= 0x05
.equ	b6	= 0x06
.equ	b7	= 0x07

.macro out_values_to_Port_C
	out	PORTC,r21
	out	PORTC,r22
	out	PORTC,r23
	out	PORTC,r24
.endm

.macro out_values_to_Port_D
	out	PORTD,r11
	out	PORTD,r25
	out	PORTD,r12
	out	PORTD,r25
.endm

.macro color_Burst
	out_values_to_Port_C ;224ns
	out_values_to_Port_C
	out_values_to_Port_C
	out_values_to_Port_C
	out_values_to_Port_C
	out_values_to_Port_C
	out_values_to_Port_C
	out_values_to_Port_C
	out_values_to_Port_C
	out_values_to_Port_C
.endm

;---------------------------------------
; Interrupt Vector table
;---------------------------------------
	rjmp	_RESET		;RESET
	rjmp	_INT0_Handler	;INT0
	reti			;INT1
	reti			;TIMER2 COMP
	reti			;TIMER2 OVF
	reti			;TIMER1 CAPT
	reti			;TIMER1 COMPA
	reti			;TIMER1 COMPB
	reti			;TIMER1 OVF
	reti			;TIMER0 OVF
	reti			;SPI, STC
	reti			;USART, RXC
	reti			;USART, UDRE
	reti			;USART, TXC
	reti			;ADC
	reti			;EE_RDY
	reti			;ANA_COMP
	reti			;TWI
	reti			;SPM_RDY

;=======================================================================================
_RESET:
	; init stack pointer 0x45F
	ldi	r16,low(RAMEND)
	out	SPL,r16
	ldi	r16,high(RAMEND)
	out	SPH,r16

	; init ports
	ldi	r16,0xFF
	out	DDRC,r16
	ldi	r16,0xE0
	out	DDRD,r16
	ldi	r16,0x04
	out	PORTD,r16

	clr	r19
	ldi	r25,0xC4

	; external interrupts initialization ---------------

	; INT0 enable
	in	r16,GICR
	ori	r16,0x40	
	out	GICR,r16

	; Set ISC00, ISC01. The rising edge of INT0 generates an interrupt request
	ldi	r16,0x03
	out	MCUCR,r16

	; clear interrupt flag
	ldi	r16,0x40
	out	GIFR,r16
	; --------------------------------------------------

	sei			; enable global interrupts

MAINLOOP:
	rjmp	MAINLOOP

; 1000ns = 1us, 1000us = 1ms
;========================================================================================
_INT0_Handler:			; interrupt at SYN rising edge ; 4 clocks to enter interrupt 4*56ns = 224ns (OK)

;;;; back porch start
	out	PORTD,r25		; 56ns

; delay 616ns -------------------------------
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
; --------------------------------------------

;--- 896ns passed at this line

;;;; burst ================== should start 900ns (0.9us) after rising edge of SYNC
	; 10 pulses, 40 clocks 40*56ns = 2240ns (2.24us)
	out_values_to_Port_D ; 224ns
	out_values_to_Port_D ; 224ns
	out_values_to_Port_D ; 224ns
	out_values_to_Port_D ; 224ns
	out_values_to_Port_D ; 224ns
	out_values_to_Port_D ; 224ns
	out_values_to_Port_D ; 224ns
	out_values_to_Port_D ; 224ns
	out_values_to_Port_D ; 224ns
	out_values_to_Port_D ; 224ns
	out_values_to_Port_D ; 224ns
;;;; ========================

;--- 3136ns (3.136us) passed at this line

	ldi	r21,0xA4	;56ns
	ldi	r23,0xA4	;56ns

	;112ns
	sbrc	r18,b0
	ldi	r21,0xE4

	;112ns
	sbrs	r18,b0
	ldi	r23,0xE4

	mov	r11,r21		; 56ns
	mov	r12,r23		; 56ns

	ldi	r21,0x19	; 56ns
	ldi	r22,0x15	; 56ns
	ldi	r23,0x34	; 56ns
	ldi	r24,0x07	; 56ns

	;112ns
	sbrs	r18,b0
	ldi	r21,0x07

	;112ns
	sbrs	r18,b0
	ldi	r22,0x34

	;112ns
	sbrs	r18,b0
	ldi	r23,0x15

	;112ns
	sbrs	r18,b0
	ldi	r24,0x19

	dec	r18			; 56ns

	; +1176ns

;--- 4312ns (4.3126us) passed at this line


; 4*6*56ns+56ns = 1400ns
; loop -------------------
	ldi	r17,6
L0082:
	dec	r17	; 1 cycle
	nop		; 1 cycle
	brne	L0082	; 2 cycle
; ------------------------
	nop

;--- 5768ns (5.768us) passed at this line


;Color burst for 16 colors 35840ns = 35.840us
	; Color Burst ( for color 1) 
	color_Burst ; 224*10 = 2240ns = 2.24us
	; Color Burst ( for color 2) 
	color_Burst ; 224*10 = 2240ns = 2.24us
	; Color Burst ( for color 3) 
	color_Burst ; 224*10 = 2240ns = 2.24us
	; Color Burst ( for color 4) 
	color_Burst ; 224*10 = 2240ns = 2.24us
	; Color Burst ( for color 5) 
	color_Burst ; 224*10 = 2240ns = 2.24us
	; Color Burst ( for color 6) 
	color_Burst ; 224*10 = 2240ns = 2.24us
	; Color Burst ( for color 7) 
	color_Burst ; 224*10 = 2240ns = 2.24us
	; Color Burst ( for color 8) 
	color_Burst ; 224*10 = 2240ns = 2.24us
	; Color Burst ( for color 9) 
	color_Burst ; 224*10 = 2240ns = 2.24us
	; Color Burst ( for color 10) 
	color_Burst ; 224*10 = 2240ns = 2.24us
	; Color Burst ( for color 11) 
	color_Burst ; 224*10 = 2240ns = 2.24us
	; Color Burst ( for color 12) 
	color_Burst ; 224*10 = 2240ns = 2.24us
	; Color Burst ( for color 13) 
	color_Burst ; 224*10 = 2240ns = 2.24us
	; Color Burst ( for color 14) 
	color_Burst ; 224*10 = 2240ns = 2.24us
	; Color Burst ( for color 15) 
	color_Burst ; 224*10 = 2240ns = 2.24us
	; Color Burst ( for color 16) 
	color_Burst ; 224*10 = 2240ns = 2.24us

;--- 41608ns (41.608us) passed at this line

	out	PORTD,r25	; 0xC4
	out	PORTC,r19	; zero value

	reti

;---------------------------------------
; Code not seems to use any RAM.
;---------------------------------------
;<eof>
