; reassembly of "pal.hex"
; created by ReAVR V3.4.0
; at 2020/04/24 - 00:46:09
; for Atmel AVR assembler
;---------------------------------------
; AVR_TYPE=Atmega8
; FLASH_SIZE=8KB
; SRAM_START=0x60
; Crystal: 17.734475MHz, 1 clock is 56ns
;---------------------------------------
.DEVICE ATmega8
.include "m8def.inc"

	.cseg
	.org	0x0000
;---------------------------------------
; bit numbers:
;
.equ	b0	= 0x00
.equ	b1	= 0x01
.equ	b2	= 0x02
.equ	b3	= 0x03
.equ	b4	= 0x04
.equ	b5	= 0x05
.equ	b6	= 0x06
.equ	b7	= 0x07


;---------------------------------------
; redefine registers
;
.def	CNT	= r17
.def	ODD_EVEN	= r18
.def	ZERO	= r19
.def	BLANK	= r25
.def	CB1	= r0
.def	CB2	= r1

;---------------------------------------
; MACRO definitions
;
.macro out_values_to_Port_D
	out	PORTD,r11
	out	PORTD,BLANK
	out	PORTD,r12
	out	PORTD,BLANK
.endm

.macro out_values_to_Port_C
	out	PORTC,r21
	out	PORTC,r22
	out	PORTC,r23
	out	PORTC,r24
.endm

.macro color_burst
	out_values_to_Port_D
	out_values_to_Port_D
	out_values_to_Port_D
	out_values_to_Port_D
	out_values_to_Port_D
	out_values_to_Port_D
	out_values_to_Port_D
	out_values_to_Port_D
	out_values_to_Port_D
	out_values_to_Port_D
	out_values_to_Port_D
.endm

.macro color_carrier_10_periods
	out_values_to_Port_C	
	out_values_to_Port_C
	out_values_to_Port_C
	out_values_to_Port_C
	out_values_to_Port_C
	out_values_to_Port_C
	out_values_to_Port_C
	out_values_to_Port_C
	out_values_to_Port_C
	out_values_to_Port_C
.endm



;---------------------------------------
; Interrupt Vector table
;---------------------------------------
	rjmp	_RESET		;RESET
	rjmp	_INT0_Handler	;INT0
	reti			;INT1
	reti			;TIMER2 COMP
	reti			;TIMER2 OVF
	reti			;TIMER1 CAPT
	reti			;TIMER1 COMPA
	reti			;TIMER1 COMPB
	reti			;TIMER1 OVF
	reti			;TIMER0 OVF
	reti			;SPI, STC
	reti			;USART, RXC
	reti			;USART, UDRE
	reti			;USART, TXC
	reti			;ADC
	reti			;EE_RDY
	reti			;ANA_COMP
	reti			;TWI
	reti			;SPM_RDY

;=======================================================================================
_RESET:
	; init stack pointer 0x45F
	ldi	r16,low(RAMEND)
	out	SPL,r16
	ldi	r16,high(RAMEND)
	out	SPH,r16

	; init ports
	ldi	r16,0xFF
	out	DDRC,r16
	ldi	r16,0xE0
	out	DDRD,r16

	ldi	r16,0xC0
	out	PORTD,r16


	clr ODD_EVEN
	clr	ZERO
	ldi	BLANK,0x40

	ldi r16,0x20
	mov CB1,r16
	ldi r16,0x60
	mov CB2,r16

	; external interrupts initialization ---------------

	; INT0 enable
	in	r16,GICR
	ori	r16,0x40	
	out	GICR,r16

	; Set ISC00, ISC01. The falling edge of INT0 generates an interrupt request
	ldi	r16,0x02
	out	MCUCR,r16

	; clear interrupt flag
	ldi	r16,0x40
	out	GIFR,r16
	; --------------------------------------------------


	sei			; enable global interrupts

MAINLOOP:
	rjmp	MAINLOOP

;========================================================================================
_INT0_Handler:			; SYN falling edge (4 cycle to enter interrupt 4*56=224ns)
	out	PORTD,BLANK		; 56ns
	; ---- 280ns passed here
	; wait for HSYNC end 20*4*56 = 4480ns, 4.48us
	ldi	CNT,22
L002C2:
	dec	CNT
	nop
	brne	L002C2

	; if HSYNC is still LOW it is a VSYNC, skip it
	sbis	PIND,b2
	rjmp	Delay26us

	out	PORTD,BLANK
	
	nop
	nop
	nop
	
	; ---- 5600ns (5.6us) passed here
BURST:
	; 40 cycles = 40*56=2240ns = 2.24us
	color_burst		; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

	; ---- 7840ns (7.84us) passed here

	;next burst init
	mov	r11,CB1
	mov	r12,CB2
	sbrc ODD_EVEN,b0
	mov	 r11,CB2
	sbrc ODD_EVEN,b0
	mov	 r12,CB1

	;					   0 123456 7
	sbrc ODD_EVEN,b0
	ldi  r21,0x19	; 56ns 0|011001|1
	sbrc ODD_EVEN,b0
	ldi  r22,0x15	; 56ns 0|010101|1
	sbrc ODD_EVEN,b0
	ldi  r23,0x34	; 56ns 0|110100|1
	sbrc ODD_EVEN,b0
	ldi  r24,0x07	; 56ns 0|000111|1

	sbrs	ODD_EVEN,b0
	ldi	r21,0x07	;      0|000111|1
	sbrs	ODD_EVEN,b0
	ldi	r22,0x34	;	   0|110100|1
	sbrs	ODD_EVEN,b0
	ldi	r23,0x15	;	   0|010101|1
	sbrs	ODD_EVEN,b0
	ldi	r24,0x19	;	   0|011001|1

	inc	ODD_EVEN

	;+21*56 = 1176ns
	; ---- 9016ns (9.016us) passed here

; loop ----------- 6 * 4* 56ns = 1344ns = 1.344us
	ldi	CNT,6-2
L0082:
	dec	CNT
	nop
	brne	L0082
; ------------------------
	; ---- 10360ns (10.36us) passed here
	nop
	nop
	; ---- 10472ns (10.472us) passed here

;10500ns should be here
COLOR_CARRIER:
	color_carrier_10_periods	;1
	color_carrier_10_periods	;2
	color_carrier_10_periods	;3
	color_carrier_10_periods	;4
	color_carrier_10_periods	;5
	color_carrier_10_periods	;6
	color_carrier_10_periods	;7
	color_carrier_10_periods	;8
	color_carrier_10_periods	;9
	color_carrier_10_periods	;10
	color_carrier_10_periods	;11
	color_carrier_10_periods	;12
	color_carrier_10_periods	;13
	color_carrier_10_periods	;14
	color_carrier_10_periods	;15
	color_carrier_10_periods	;16
	color_carrier_10_periods	;1
	color_carrier_10_periods	;2
	color_carrier_10_periods	;3
	color_carrier_10_periods	;4
	color_carrier_10_periods	;5
	color_carrier_10_periods	;6
	color_carrier_10_periods	;7
	out	PORTD,BLANK
	out	PORTC,ZERO
	reti


Delay26us:
; loop ----------- 4 * 56ns * 120 = 26880ns = 26.88us
	ldi	CNT,112
L0312:
	dec	CNT
	nop
	brne	L0312
; ----------------
	reti

;---------------------------------------
; Code not seems to use any RAM.
;---------------------------------------
;<eof>
