{

Z game

ZX Like Pascal code source

graphic: Bugsy
code: Andrew771 
'2016-2017

Compilate flags for ZX Like Pascal:
off - attributes (all)
on - checking a sprite edges
on - virtual screen (all)

}


Program z_game;

const
	key_code_space=32;
	key_code_left=79;
	key_code_right=80;
	key_code_up=81;
	key_code_down=65;

	id_our=1;
	id_enemy=2;

	i_obj_id=1;
	i_obj_x=2;
	i_obj_y=3;
	i_obj_w=4;
	i_obj_h=5;
	i_obj_val1=6;
	i_obj_val2=7;

	i_v_bel=1;
	i_v_id=2;
	i_v_x=3;
	i_v_y=4;
	i_v_dx=5;
	i_v_dy=6;
	i_v_dirtrack=7;
	i_v_dirgun=8;
	i_v_i_root=9;
	i_v_j_root=10;

	id_fort_our=1;
	id_fort_enemy=2;
	id_work_our=3;
	id_work_enemy=4;
	id_bridge_left_right=5;
	id_bridge_up_down=6;
	id_flag_enemy=11;

	id_cran=1;
	id_light=2;
	id_medium=3;
	id_heavy=4;

	id_stop=0;
	id_left=1;
	id_up_left=2;
	id_up=3;
	id_up_right=4;
	id_right=5;
	id_down_right=6;
	id_down=7;
	id_down_left=8;

	flag_phase_01=1;
	flag_phase_02=2;
	flag_phase_03=3;
	flag_phase_04=4;

	land_code_river_01_left_right=5;
	land_code_river_01_up_down=6;
	land_code_river_01_up_left=8;
	land_code_river_01_up_right=7;
	land_code_river_01_down_left=9;
	land_code_river_01_down_right=10;

	land_code_river_02_left_right=11;
	land_code_river_02_up_down=12;
	land_code_river_02_up_left=14;
	land_code_river_02_up_right=13;
	land_code_river_02_down_left=15;
	land_code_river_02_down_right=16;

	rivrev=65;

	x_max=64;
	y_max=64;
	map_scr_width=8;
	map_scr_height=6;
	x_map_scr_max=57;
	y_map_scr_max=59;

	x_max_obj=5;
	y_max_obj=5;

	root_id_move=1;
	root_id_take=2;
	root_id_bridge=3;
	root_id_sum=4;
	root_id_fort=5;

var
	m: array[1..64,1..64] of byte
	= [

        20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 23,
        22, 4, 1, 0, 4, 0, 1, 0,
        1, 0, 4, 0, 1, 0, 4, 3,
        1, 0, 3, 4, 1, 0, 1, 0,
        1, 0, 1, 4, 1, 255, 255, 255,
        255, 255, 1, 0, 2, 0, 1, 0,
        1, 3, 1, 0, 1, 3, 1, 0,
        1, 0, 1, 0, 1, 0, 1, 2,
        1, 0, 1, 2, 1, 4, 1, 23,
        22, 3, 2, 1, 0, 1, 0, 1,
        0, 2, 0, 1, 3, 1, 0, 1,
        0, 1, 0, 1, 4, 1, 0, 3,
        0, 1, 0, 2, 0, 255, 255, 255,
        255, 255, 0, 1, 2, 1, 0, 1,
        0, 2, 0, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 0, 2, 0, 1,
        0, 1, 0, 1, 0, 4, 0, 23,
        22, 0, 1, 0, 2, 0, 1, 0,
        3, 0, 1, 0, 1, 4, 1, 0,
        1, 0, 1, 0, 4, 0, 1, 0,
        1, 0, 1, 0, 4, 255, 255, 255,
        255, 255, 1, 4, 1, 0, 1, 0,
        1, 0, 1, 3, 4, 0, 1, 0,
        1, 0, 1, 0, 1, 0, 4, 0,
        1, 0, 3, 0, 1, 0, 3, 23,
        22, 1, 255, 255, 0, 2, 0, 1,
        0, 1, 0, 4, 0, 2, 0, 1,
        0, 4, 0, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 0, 255, 255, 255,
        255, 255, 0, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 255, 255, 4, 23,
        22, 0, 255, 255, 0, 0, 1, 4,
        4, 0, 1, 0, 1, 2, 1, 0,
        4, 0, 2, 0, 1, 0, 1, 0,
        1, 0, 1, 0, 1, 255, 255, 255,
        255, 255, 1, 0, 1, 2, 1, 4,
        3, 0, 1, 0, 1, 0, 1, 0,
        2, 0, 1, 0, 1, 0, 1, 4,
        1, 0, 1, 0, 255, 255, 1, 23,
        22, 1, 255, 255, 0, 1, 0, 1,
        0, 1, 0, 1, 0, 3, 4, 1,
        0, 1, 0, 1, 0, 1, 3, 1,
        0, 1, 0, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 0, 1, 0, 3,
        0, 4, 0, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 3, 1, 0, 1,
        0, 1, 0, 4, 255, 255, 0, 23,
        22, 0, 18, 18, 18, 19, 18, 18,
        18, 18, 18, 18, 18, 18, 18, 18,
        18, 18, 18, 18, 18, 18, 18, 18,
        18, 18, 18, 18, 18, 18, 18, 18,
        18, 18, 18, 19, 18, 18, 18, 18,
        18, 18, 18, 18, 18, 18, 18, 18,
        18, 18, 18, 18, 18, 18, 18, 18,
        18, 18, 19, 18, 18, 18, 1, 23,
        22, 1, 0, 1, 0, 17, 0, 1,
        0, 1, 2, 1, 0, 1, 0, 1,
        4, 1, 0, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 0, 1, 0, 1,
        0, 4, 3, 17, 0, 1, 0, 1,
        0, 1, 0, 1, 0, 1, 0, 2,
        0, 1, 0, 1, 0, 1, 3, 1,
        0, 1, 17, 1, 0, 1, 0, 23,
        22, 0, 1, 0, 1, 17, 1, 20,
        20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 21, 2,
        1, 3, 1, 0, 1, 0, 1, 0,
        10, 5, 5, 5, 5, 5, 5, 5,
        9, 0, 1, 0, 1, 0, 1, 0,
        1, 0, 1, 0, 1, 0, 1, 0,
        2, 0, 17, 0, 1, 0, 3, 23,
        22, 1, 0, 3, 3, 17, 22, 1,
        0, 1, 0, 1, 0, 1, 0, 4,
        0, 1, 0, 1, 3, 1, 0, 1,
        0, 1, 0, 1, 0, 1, 0, 1,
        6, 1, 0, 17, 0, 1, 0, 1,
        6, 1, 4, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 0, 1, 0, 1,
        0, 1, 17, 1, 0, 1, 0, 23,
        22, 0, 1, 0, 1, 17, 22, 0,
        1, 2, 4, 0, 1, 0, 1, 0,
        1, 0, 1, 0, 3, 0, 1, 0,
        1, 0, 1, 0, 1, 2, 1, 0,
        6, 0, 4, 17, 1, 2, 4, 0,
        6, 0, 2, 0, 1, 0, 1, 0,
        4, 0, 1, 0, 1, 0, 1, 0,
        1, 0, 17, 0, 1, 0, 1, 20,
        22, 1, 4, 4, 0, 17, 22, 1,
        0, 3, 2, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 21, 3,
        6, 1, 0, 17, 0, 1, 3, 1,
        6, 1, 20, 20, 20, 20, 20, 20,
        20, 20, 21, 1, 20, 20, 20, 20,
        20, 21, 17, 20, 20, 20, 21, 1,
        22, 0, 1, 0, 1, 17, 22, 0,
        1, 0, 1, 0, 1, 0, 1, 0,
        1, 0, 1, 22, 1, 0, 1, 0,
        1, 4, 1, 0, 1, 0, 1, 0,
        6, 0, 1, 17, 1, 10, 5, 5,
        8, 0, 1, 0, 1, 0, 1, 0,
        1, 3, 1, 0, 1, 0, 1, 0,
        1, 0, 17, 0, 1, 0, 2, 20,
        22, 1, 0, 1, 0, 17, 21, 1,
        3, 1, 0, 1, 2, 1, 3, 2,
        0, 2, 0, 22, 0, 1, 0, 4,
        0, 3, 0, 1, 0, 1, 0, 4,
        6, 1, 4, 17, 0, 6, 0, 1,
        0, 1, 0, 1, 0, 1, 0, 1,
        0, 1, 0, 4, 0, 10, 5, 5,
        5, 5, 5, 5, 5, 5, 5, 5,
        22, 3, 1, 0, 1, 17, 1, 0,
        1, 0, 1, 0, 1, 2, 1, 2,
        1, 0, 1, 21, 2, 0, 1, 0,
        4, 0, 1, 0, 2, 0, 1, 0,
        6, 0, 1, 17, 1, 6, 1, 0,
        1, 0, 1, 0, 1, 0, 1, 0,
        1, 0, 2, 0, 1, 6, 1, 0,
        1, 0, 17, 2, 1, 0, 3, 23,
        22, 20, 20, 20, 21, 17, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20,
        20, 21, 3, 1, 4, 1, 0, 1,
        0, 1, 0, 1, 0, 1, 0, 1,
        6, 1, 4, 17, 0, 7, 5, 5,
        5, 5, 5, 5, 5, 9, 0, 1,
        0, 1, 0, 3, 0, 6, 0, 1,
        0, 1, 17, 1, 0, 1, 3, 23,
        22, 0, 1, 0, 1, 17, 1, 0,
        1, 0, 1, 2, 1, 0, 1, 3,
        1, 0, 1, 0, 1, 0, 1, 0,
        1, 0, 1, 0, 1, 0, 1, 0,
        6, 2, 1, 17, 3, 0, 1, 3,
        1, 0, 1, 4, 1, 6, 1, 0,
        1, 10, 5, 5, 5, 8, 4, 3,
        1, 0, 17, 3, 1, 0, 1, 23,
        22, 1, 255, 255, 0, 17, 0, 1,
        0, 1, 0, 1, 0, 3, 0, 4,
        4, 1, 0, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 10, 5, 5, 5,
        8, 1, 0, 17, 0, 255, 255, 1,
        0, 1, 3, 1, 4, 6, 2, 1,
        0, 6, 0, 1, 0, 1, 0, 1,
        0, 1, 17, 1, 255, 255, 4, 23,
        22, 0, 255, 255, 0, 17, 1, 0,
        1, 0, 1, 0, 1, 0, 1, 0,
        1, 3, 1, 0, 1, 2, 1, 0,
        3, 0, 1, 0, 6, 0, 2, 0,
        4, 0, 1, 17, 0, 255, 255, 0,
        1, 0, 1, 0, 1, 7, 5, 5,
        5, 8, 1, 0, 1, 0, 1, 0,
        1, 4, 17, 0, 255, 255, 1, 23,
        22, 1, 255, 255, 0, 17, 0, 1,
        0, 1, 0, 1, 0, 3, 0, 3,
        0, 1, 0, 1, 0, 3, 0, 3,
        0, 1, 0, 2, 6, 1, 0, 1,
        3, 1, 3, 17, 2, 255, 255, 1,
        0, 1, 0, 1, 0, 1, 0, 1,
        0, 1, 0, 4, 4, 2, 0, 1,
        0, 1, 17, 1, 255, 255, 0, 23,
        22, 0, 18, 18, 18, 19, 18, 18,
        18, 18, 18, 18, 18, 18, 18, 18,
        18, 18, 18, 18, 18, 18, 18, 18,
        18, 18, 18, 18, 6, 18, 18, 18,
        18, 18, 18, 19, 18, 18, 18, 18,
        18, 18, 18, 18, 18, 18, 18, 18,
        18, 18, 18, 18, 18, 18, 18, 18,
        18, 18, 19, 18, 18, 18, 1, 23,
        22, 1, 0, 3, 0, 17, 0, 1,
        0, 4, 0, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 6, 1, 0, 1,
        0, 1, 0, 17, 0, 2, 0, 1,
        0, 1, 0, 2, 0, 3, 0, 4,
        3, 1, 0, 1, 0, 1, 2, 1,
        0, 3, 17, 1, 0, 1, 4, 23,
        22, 3, 1, 2, 1, 17, 1, 0,
        1, 0, 1, 0, 1, 0, 3, 0,
        1, 0, 1, 0, 1, 2, 1, 0,
        1, 0, 1, 0, 6, 4, 1, 0,
        1, 0, 1, 17, 1, 0, 1, 0,
        3, 4, 3, 3, 3, 0, 1, 0,
        22, 3, 1, 0, 1, 0, 1, 0,
        1, 0, 17, 4, 1, 0, 1, 23,
        22, 1, 0, 1, 0, 17, 0, 1,
        0, 1, 0, 3, 2, 1, 0, 3,
        0, 1, 0, 1, 0, 1, 0, 10,
        5, 5, 5, 5, 8, 1, 0, 1,
        0, 1, 0, 17, 0, 1, 0, 4,
        3, 1, 0, 2, 2, 1, 0, 1,
        22, 1, 0, 2, 0, 1, 0, 1,
        0, 1, 17, 1, 0, 2, 0, 23,
        22, 3, 1, 0, 1, 17, 2, 0,
        1, 0, 2, 0, 1, 0, 1, 2,
        3, 0, 1, 3, 1, 0, 4, 6,
        1, 0, 1, 2, 1, 0, 3, 0,
        1, 0, 1, 17, 1, 0, 1, 0,
        1, 4, 1, 0, 1, 0, 1, 0,
        22, 0, 2, 0, 1, 0, 1, 0,
        1, 4, 17, 0, 1, 4, 1, 23,
        22, 1, 0, 1, 0, 17, 0, 1,
        0, 1, 0, 1, 0, 10, 5, 5,
        9, 4, 0, 1, 4, 1, 0, 6,
        0, 1, 22, 1, 0, 1, 0, 1,
        0, 1, 0, 17, 0, 1, 0, 1,
        0, 2, 0, 1, 0, 1, 0, 1,
        22, 1, 10, 5, 5, 5, 5, 5,
        9, 1, 17, 1, 0, 3, 3, 23,
        22, 0, 4, 0, 1, 17, 4, 0,
        1, 0, 1, 0, 1, 6, 1, 0,
        6, 0, 1, 0, 1, 0, 1, 6,
        1, 0, 22, 2, 1, 0, 1, 0,
        1, 0, 4, 17, 1, 0, 2, 0,
        2, 0, 1, 2, 1, 0, 3, 0,
        22, 0, 6, 0, 1, 0, 1, 0,
        6, 0, 17, 3, 1, 0, 1, 23,
        22, 1, 0, 1, 2, 17, 0, 1,
        0, 1, 0, 1, 4, 6, 0, 1,
        6, 1, 0, 1, 4, 1, 0, 6,
        0, 1, 22, 3, 0, 1, 0, 1,
        0, 1, 0, 17, 0, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20,
        21, 1, 6, 1, 0, 1, 0, 1,
        6, 1, 17, 1, 2, 1, 0, 23,
        21, 0, 1, 0, 1, 17, 2, 0,
        1, 0, 1, 0, 1, 6, 1, 0,
        7, 5, 5, 5, 5, 5, 5, 8,
        1, 0, 22, 0, 1, 0, 1, 0,
        1, 0, 2, 17, 1, 2, 4, 2,
        1, 3, 1, 0, 1, 0, 1, 0,
        1, 0, 6, 0, 1, 3, 1, 0,
        6, 0, 17, 4, 1, 0, 1, 23,
        5, 5, 5, 5, 5, 5, 5, 9,
        0, 1, 0, 1, 0, 6, 0, 1,
        0, 1, 0, 4, 0, 1, 0, 1,
        3, 1, 22, 1, 2, 1, 0, 1,
        0, 1, 0, 17, 0, 1, 0, 1,
        0, 3, 0, 1, 0, 1, 0, 3,
        0, 1, 6, 1, 3, 1, 0, 1,
        6, 3, 17, 3, 0, 1, 0, 23,
        22, 4, 1, 3, 1, 17, 1, 6,
        4, 0, 1, 0, 1, 6, 1, 0,
        1, 0, 3, 0, 1, 0, 1, 0,
        3, 0, 22, 0, 19, 18, 18, 18,
        18, 18, 18, 19, 1, 0, 1, 0,
        1, 0, 2, 0, 1, 0, 1, 0,
        1, 0, 6, 0, 1, 0, 1, 0,
        6, 0, 17, 0, 1, 0, 1, 23,
        22, 1, 0, 1, 0, 17, 3, 6,
        0, 1, 2, 1, 0, 6, 0, 1,
        0, 1, 0, 1, 0, 1, 0, 1,
        0, 1, 22, 1, 17, 1, 0, 1,
        0, 1, 0, 1, 0, 1, 4, 2,
        0, 4, 0, 1, 2, 1, 2, 1,
        0, 1, 6, 1, 0, 1, 0, 1,
        6, 4, 17, 1, 0, 1, 0, 20,
        22, 0, 1, 0, 1, 17, 1, 6,
        3, 0, 2, 0, 1, 6, 1, 0,
        1, 2, 3, 0, 1, 0, 1, 0,
        1, 0, 22, 0, 17, 0, 1, 0,
        1, 0, 1, 0, 1, 0, 1, 2,
        1, 0, 1, 0, 1, 0, 1, 0,
        1, 0, 6, 0, 1, 4, 1, 0,
        7, 5, 5, 5, 5, 5, 5, 5,
        22, 1, 0, 1, 0, 17, 0, 6,
        3, 3, 0, 1, 0, 6, 2, 3,
        0, 1, 0, 1, 0, 1, 4, 1,
        0, 1, 22, 1, 17, 1, 0, 1,
        0, 1, 0, 1, 2, 1, 0, 3,
        10, 5, 5, 5, 5, 5, 5, 9,
        0, 1, 6, 1, 0, 1, 0, 1,
        0, 1, 17, 1, 0, 1, 0, 23,
        22, 0, 1, 0, 1, 17, 1, 6,
        3, 0, 1, 0, 1, 6, 3, 20,
        20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 21, 3, 17, 0, 1, 0,
        1, 0, 2, 0, 1, 3, 1, 3,
        6, 0, 1, 0, 3, 0, 1, 6,
        1, 0, 6, 0, 1, 0, 1, 0,
        1, 3, 17, 0, 1, 0, 1, 23,
        22, 2, 0, 3, 0, 17, 4, 6,
        0, 1, 2, 1, 0, 6, 0, 1,
        0, 1, 4, 1, 0, 3, 0, 1,
        0, 1, 0, 4, 17, 1, 0, 1,
        0, 1, 0, 2, 0, 1, 4, 1,
        6, 1, 0, 1, 3, 3, 0, 6,
        0, 3, 6, 1, 0, 1, 0, 1,
        0, 1, 17, 1, 0, 1, 0, 23,
        22, 0, 3, 0, 4, 17, 1, 7,
        5, 5, 5, 5, 5, 8, 1, 3,
        4, 0, 2, 0, 1, 0, 1, 0,
        1, 0, 1, 2, 17, 0, 4, 0,
        1, 0, 3, 3, 1, 0, 4, 3,
        6, 0, 1, 0, 1, 0, 1, 7,
        5, 5, 8, 0, 1, 3, 1, 0,
        1, 2, 17, 0, 1, 0, 1, 23,
        22, 1, 0, 1, 4, 17, 4, 1,
        0, 1, 0, 2, 0, 2, 0, 1,
        0, 1, 0, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 17, 1, 0, 2,
        4, 1, 0, 1, 0, 1, 0, 1,
        6, 1, 0, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 0, 1, 0, 1,
        0, 1, 17, 1, 2, 1, 0, 23,
        22, 0, 255, 255, 1, 17, 1, 0,
        1, 0, 1, 0, 1, 0, 1, 0,
        3, 2, 1, 0, 1, 4, 1, 0,
        1, 255, 255, 0, 17, 2, 1, 0,
        1, 0, 4, 10, 5, 5, 5, 5,
        8, 2, 1, 0, 1, 0, 1, 0,
        1, 0, 1, 0, 1, 0, 1, 2,
        1, 3, 17, 3, 255, 255, 1, 23,
        22, 2, 255, 255, 0, 17, 0, 1,
        0, 1, 0, 1, 0, 1, 0, 1,
        0, 1, 2, 1, 0, 1, 0, 1,
        0, 255, 255, 0, 17, 4, 0, 1,
        4, 1, 0, 6, 0, 1, 0, 1,
        0, 1, 2, 1, 3, 1, 0, 1,
        0, 1, 0, 1, 0, 1, 0, 1,
        0, 1, 17, 0, 255, 255, 3, 23,
        22, 0, 255, 255, 1, 17, 1, 0,
        1, 0, 1, 0, 2, 3, 1, 0,
        1, 0, 1, 0, 1, 0, 1, 0,
        2, 255, 255, 0, 17, 0, 1, 0,
        1, 4, 1, 6, 1, 0, 1, 0,
        1, 0, 4, 0, 1, 4, 2, 0,
        1, 0, 1, 2, 1, 0, 1, 0,
        1, 0, 17, 0, 255, 255, 1, 23,
        22, 1, 18, 18, 18, 19, 18, 18,
        18, 18, 18, 18, 18, 18, 18, 18,
        18, 18, 18, 18, 18, 18, 18, 18,
        18, 18, 18, 18, 19, 18, 18, 18,
        18, 18, 18, 6, 18, 18, 18, 18,
        18, 18, 18, 18, 18, 18, 18, 18,
        18, 18, 18, 18, 18, 18, 18, 18,
        18, 18, 19, 18, 18, 18, 0, 23,
        22, 0, 1, 0, 2, 17, 1, 2,
        4, 0, 3, 0, 1, 2, 1, 4,
        1, 4, 1, 0, 1, 0, 1, 0,
        1, 0, 1, 0, 17, 3, 1, 0,
        1, 0, 4, 6, 1, 0, 1, 0,
        1, 0, 1, 0, 1, 0, 1, 0,
        2, 0, 1, 0, 4, 0, 1, 0,
        1, 0, 17, 0, 2, 0, 1, 23,
        22, 1, 0, 1, 2, 17, 0, 1,
        0, 1, 0, 1, 0, 1, 10, 5,
        5, 5, 9, 1, 0, 1, 2, 1,
        0, 1, 0, 1, 17, 1, 0, 1,
        0, 1, 4, 6, 0, 3, 0, 1,
        0, 4, 0, 1, 0, 1, 0, 1,
        0, 3, 0, 1, 0, 1, 0, 1,
        0, 1, 17, 1, 0, 1, 0, 23,
        22, 0, 1, 0, 3, 17, 1, 0,
        4, 0, 1, 0, 1, 0, 6, 0,
        1, 0, 6, 0, 3, 0, 1, 0,
        1, 0, 1, 0, 17, 0, 1, 10,
        5, 5, 5, 8, 1, 0, 1, 0,
        1, 0, 1, 0, 1, 0, 1, 0,
        1, 0, 1, 0, 1, 0, 1, 0,
        1, 2, 17, 0, 1, 0, 1, 23,
        22, 1, 3, 3, 0, 17, 0, 1,
        0, 3, 10, 5, 5, 5, 8, 1,
        0, 1, 6, 1, 2, 3, 4, 2,
        0, 1, 0, 1, 17, 1, 0, 6,
        0, 1, 0, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 0, 1, 0, 1,
        0, 3, 0, 1, 0, 1, 0, 1,
        0, 4, 17, 4, 0, 1, 3, 23,
        22, 0, 1, 0, 1, 17, 1, 0,
        1, 0, 6, 0, 1, 4, 1, 3,
        3, 0, 7, 5, 5, 5, 5, 5,
        5, 5, 9, 0, 17, 0, 2, 6,
        1, 3, 1, 3, 1, 0, 1, 0,
        1, 0, 1, 0, 1, 0, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20,
        20, 21, 17, 20, 20, 20, 20, 23,
        21, 3, 0, 1, 0, 17, 2, 1,
        0, 1, 6, 2, 0, 1, 0, 1,
        0, 1, 0, 1, 0, 1, 0, 1,
        2, 1, 6, 1, 17, 3, 0, 6,
        0, 1, 0, 1, 0, 1, 0, 1,
        0, 1, 3, 1, 22, 1, 2, 2,
        0, 1, 0, 2, 0, 1, 3, 2,
        0, 1, 17, 1, 4, 3, 0, 23,
        5, 5, 5, 5, 5, 5, 5, 5,
        5, 5, 8, 0, 1, 2, 1, 4,
        4, 0, 1, 0, 1, 0, 1, 0,
        2, 0, 6, 0, 17, 0, 1, 6,
        1, 3, 1, 0, 1, 3, 3, 0,
        1, 0, 1, 0, 22, 0, 2, 0,
        1, 0, 1, 0, 4, 0, 1, 0,
        1, 22, 17, 0, 1, 0, 1, 23,
        21, 1, 4, 1, 0, 17, 3, 1,
        0, 1, 0, 1, 0, 2, 0, 1,
        0, 1, 3, 1, 0, 1, 0, 10,
        5, 5, 8, 1, 17, 1, 0, 6,
        0, 1, 0, 4, 4, 1, 0, 1,
        0, 1, 0, 1, 22, 1, 0, 1,
        0, 1, 0, 1, 2, 1, 4, 1,
        2, 22, 17, 1, 0, 4, 0, 23,
        1, 20, 20, 20, 21, 17, 20, 20,
        20, 20, 20, 21, 1, 20, 20, 20,
        20, 20, 20, 20, 20, 21, 1, 6,
        1, 2, 3, 2, 17, 0, 1, 6,
        1, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 21, 0, 1, 0,
        1, 0, 1, 0, 1, 0, 1, 0,
        1, 22, 17, 3, 1, 0, 1, 23,
        22, 1, 0, 1, 0, 17, 0, 1,
        0, 4, 0, 1, 0, 1, 2, 1,
        0, 1, 2, 1, 0, 3, 0, 6,
        0, 1, 0, 1, 17, 2, 0, 6,
        0, 1, 0, 1, 3, 1, 0, 1,
        0, 1, 0, 2, 0, 1, 0, 1,
        0, 1, 0, 1, 2, 1, 4, 1,
        0, 22, 17, 1, 3, 2, 2, 23,
        22, 0, 1, 0, 1, 17, 1, 0,
        1, 4, 1, 0, 1, 0, 1, 0,
        1, 0, 4, 0, 1, 0, 1, 6,
        3, 0, 3, 0, 17, 0, 1, 6,
        1, 0, 1, 0, 1, 0, 3, 0,
        4, 0, 1, 0, 1, 2, 1, 2,
        4, 0, 1, 0, 1, 0, 2, 0,
        23, 22, 17, 0, 1, 3, 1, 23,
        22, 1, 0, 1, 0, 17, 0, 1,
        0, 4, 0, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 4, 1, 0, 7,
        5, 5, 5, 5, 5, 5, 5, 8,
        0, 1, 0, 1, 0, 1, 0, 1,
        3, 1, 0, 1, 0, 1, 0, 1,
        4, 1, 0, 4, 0, 1, 0, 23,
        23, 22, 17, 1, 0, 3, 3, 23,
        22, 2, 2, 4, 1, 17, 1, 0,
        1, 0, 1, 0, 1, 3, 1, 0,
        1, 0, 1, 0, 1, 0, 1, 2,
        1, 0, 1, 2, 17, 0, 1, 0,
        1, 0, 1, 0, 1, 0, 1, 4,
        2, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20,
        20, 21, 17, 3, 1, 0, 1, 23,
        22, 1, 0, 1, 0, 17, 0, 4,
        0, 1, 0, 4, 0, 1, 4, 2,
        0, 2, 0, 1, 0, 1, 0, 1,
        0, 1, 3, 1, 17, 1, 0, 1,
        0, 1, 0, 1, 0, 1, 0, 1,
        3, 1, 0, 3, 0, 3, 0, 1,
        0, 4, 0, 4, 4, 1, 2, 1,
        0, 1, 17, 1, 0, 1, 0, 23,
        22, 0, 255, 255, 1, 19, 18, 18,
        18, 18, 18, 18, 18, 18, 18, 18,
        18, 18, 18, 18, 18, 18, 18, 18,
        18, 18, 18, 18, 19, 18, 18, 18,
        18, 18, 18, 18, 18, 18, 18, 18,
        18, 18, 18, 18, 18, 18, 18, 18,
        18, 18, 18, 18, 18, 18, 18, 18,
        18, 18, 19, 2, 255, 255, 1, 23,
        22, 1, 255, 255, 0, 17, 0, 1,
        0, 1, 3, 1, 0, 4, 0, 1,
        0, 1, 0, 4, 0, 1, 0, 1,
        0, 1, 4, 1, 0, 255, 255, 255,
        255, 255, 1, 1, 4, 1, 0, 1,
        0, 1, 2, 1, 0, 1, 4, 1,
        0, 1, 0, 2, 0, 3, 0, 1,
        3, 1, 17, 0, 255, 255, 0, 23,
        22, 4, 255, 255, 1, 17, 2, 4,
        1, 0, 4, 0, 1, 0, 3, 4,
        2, 0, 1, 3, 2, 0, 1, 0,
        1, 0, 2, 0, 4, 255, 255, 255,
        255, 255, 0, 0, 1, 0, 1, 0,
        1, 0, 1, 4, 1, 0, 1, 0,
        1, 0, 1, 0, 1, 0, 4, 0,
        1, 0, 17, 0, 255, 255, 1, 23,
        22, 1, 18, 18, 18, 19, 0, 1,
        0, 3, 4, 1, 0, 1, 0, 1,
        0, 1, 4, 1, 0, 1, 0, 1,
        0, 1, 4, 1, 4, 255, 255, 255,
        255, 255, 1, 1, 0, 1, 0, 1,
        0, 1, 2, 1, 0, 2, 0, 1,
        0, 1, 0, 1, 2, 1, 0, 1,
        0, 1, 19, 18, 18, 18, 0, 23,
        22, 3, 1, 0, 1, 0, 1, 0,
        1, 2, 1, 0, 1, 0, 1, 0,
        1, 3, 1, 2, 1, 0, 1, 0,
        3, 0, 2, 0, 2, 255, 255, 255,
        255, 255, 0, 0, 4, 0, 1, 3,
        1, 0, 3, 0, 1, 0, 1, 0,
        1, 0, 1, 0, 2, 0, 1, 0,
        1, 0, 1, 4, 1, 2, 4, 23,
        22, 1, 0, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 0, 1, 0, 1,
        0, 2, 2, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 0, 255, 255, 255,
        255, 255, 1, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 0, 2, 0, 1,
        0, 1, 4, 1, 4, 4, 4, 1,
        0, 1, 3, 1, 4, 1, 0, 23,
        20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20

	];

	obj: array[1..32,1..7] of byte {id,x,y,width,height,value1,value2}
	= [

	2, 30, 2, 18, 20, 0, 5,
	1, 30, 59, 18, 20, 0, 5,
	6, 6, 31, 4, 4, 0, 0,
	6, 6, 50, 4, 4, 0, 0,
	6, 59, 15, 4, 4, 0, 0,
	6, 59, 34, 4, 4, 0, 0,
	5, 29, 22, 4, 4, 0, 0,
	5, 36, 43, 4, 4, 0, 0,
	6, 29, 55, 4, 4, 0, 0,
	6, 36, 10, 4, 4, 0, 0,
	4, 3, 5, 8, 10, 0, 5,
	4, 61, 5, 8, 10, 0, 5,
	4, 3, 19, 8, 10, 0, 5,
	4, 61, 19, 8, 10, 0, 5,
	4, 3, 40, 8, 10, 0, 5,
	4, 61, 40, 8, 10, 0, 5,
	4, 3, 58, 8, 10, 0, 5,
	4, 61, 58, 8, 10, 0, 5,
	4, 26, 40, 8, 10, 0, 5,
	4, 38, 19, 8, 10, 0, 5,
	11, 5, 6, 8, 10, 11, 1,
	11, 60, 6, 8, 10, 12, 1,
	11, 5, 20, 8, 10, 13, 1,
	11, 60, 20, 8, 10, 14, 1,
	11, 5, 41, 8, 10, 15, 1,
	11, 60, 41, 8, 10, 16, 1,
	11, 5, 59, 8, 10, 17, 1,
	11, 60, 59, 8, 10, 18, 1,
	11, 28, 41, 8, 10, 19, 1,
	11, 37, 20, 8, 10, 20, 1,
	0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0

	];

	v: array[1..64,1..10] of byte; {belong,id,x,y,dx,dy,direction_track,direction_gun,i_root,j_root}

	r: array[1..3,1..64] of byte {commands for 3 roots of enemies}
	= [

	1,32,8,
	1,6,8,
	2,5,6,
	1,6,8,
	1,6,20,
	2,5,20,
	1,6,20,
	3,6,31,0,0,
	1,6,41,
	2,5,41,
	1,6,41,
	3,6,50,0,0,
	1,6,58,
	1,5,59,
	1,6,58,
	4,
	1,32,58,
	5,
	0,0,0,0,0,0,0,0,0,0,

	0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,

	0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,
	0,0,0,0

	];

	value_obj,value_v: byte;
	global_cycle: byte;
	i,j,i1,j1: byte;
	key1,key2: byte;
	x_map_scr,y_map_scr,x_put,y_put: byte;
	x_cur,y_cur: word;
	x_min_lim,y_min_lim: byte;
	x_random,y_random: byte;
	new_v_x,new_v_y: byte;

	root_i_cur,root_j_cur: byte;

	flag_timer,time_seconds,time_minuts: byte;
	flag_is_moving: byte;
	flag_is_bridge: byte;



{--------------- initialization ---------------}

procedure initial;
begin

x_map_scr:=28;
y_map_scr:=3;
MapSet(m,MAP_SPRITES,0,0,map_scr_width,map_scr_height);

value_obj:=32;
value_v:=1;

for i:=1 to value_v do
	begin
		v[i,i_v_bel]:=id_enemy;
		v[i,i_v_id]:=id_heavy;
		V[i,i_v_x]:=32;
		V[i,i_v_y]:=7;
		V[i,i_v_dx]:=0;
		V[i,i_v_dy]:=0;
		V[i,i_v_dirtrack]:=id_stop;
		V[i,i_v_dirgun]:=id_stop;
		v[i,i_v_i_root]:=1;
		v[i,i_v_j_root]:=1;
	end;

end;



{--------------- timer ---------------}

procedure timer_tik;

begin

flag_timer:=0;

if obj[i,i_obj_val1]=0 and obj[i,i_obj_val2]=0
	then
		flag_timer:=1
	else
		if obj[i,i_obj_val1]>0
			then
				obj[i,i_obj_val1]:=obj[i,i_obj_val1]-1
			else
				begin
					obj[i,i_obj_val1]:=59;
					obj[i,i_obj_val2]:=obj[i,i_obj_val2]-1;
				end;

if flag_timer=1 then obj[i,i_obj_val2]:=5;

end;



procedure timer_put;

begin

gotoxy(x_cur,y_cur);
if obj[i,i_obj_val1]>9
	then write(obj[i,i_obj_val2],':',obj[i,i_obj_val1])
	else write(obj[i,i_obj_val2],':0',obj[i,i_obj_val1]);

end;



{--------------- put objects ---------------}

procedure put_objects;
begin

for i:=1 to value_obj do
	begin
		x_put:=obj[i,i_obj_x];
		y_put:=obj[i,i_obj_y];
		if x_put>(x_map_scr-x_max_obj)
			then x_min_lim:=x_map_scr-x_max_obj
			else x_min_lim:=1;
		if y_put>(y_map_scr-y_max_obj)
			then y_min_lim:=y_map_scr-y_max_obj
			else y_min_lim:=1;
		if x_put>=x_min_lim and x_put<=(x_map_scr+map_scr_width)
		and y_put>=y_min_lim and y_put<=(y_map_scr+map_scr_height)
		then
			case obj[i,i_obj_id] of

				id_flag_enemy:
					case obj[i,i_obj_val2] of

						flag_phase_01:
							begin
								SpritePutClear(FLAG_ENEMY_01,0,(x_put-x_map_scr)*4+1,(y_put-y_map_scr)*4+1);
							end;
						flag_phase_02:
							begin
								SpritePutClear(FLAG_ENEMY_02,0,(x_put-x_map_scr)*4+1,(y_put-y_map_scr)*4+1);
							end;
						flag_phase_03:
							begin
								SpritePutClear(FLAG_ENEMY_03,0,(x_put-x_map_scr)*4+1,(y_put-y_map_scr)*4+1);
							end;
						flag_phase_04:
							begin
								SpritePutClear(FLAG_ENEMY_04,0,(x_put-x_map_scr)*4+1,(y_put-y_map_scr)*4+1);
							end;
					end;


				id_work_our,id_work_enemy:
					begin
						SpritePutClear(WORK,0,(x_put-x_map_scr)*4,(y_put-y_map_scr)*4);

						x_cur:=(x_put-x_map_scr)*8+8;
						y_cur:=(y_put-y_map_scr)*4+7;
						if x_cur<64 and y_cur<24 then timer_put;
					end;


				id_fort_our:
					begin
						SpritePutClear(FORT_01,0,(x_put-x_map_scr)*4,(y_put-y_map_scr)*4);
						SpritePutClear(FORT_02,0,(x_put-x_map_scr)*4,(y_put-y_map_scr)*4);
						SpritePutClear(FORT_OUR_ENTRY,0,(x_put-x_map_scr+2)*4,(y_put-y_map_scr)*4+2);

						x_cur:=(x_put-x_map_scr)*8+18;
						y_cur:=(y_put-y_map_scr)*4+11;
						if x_cur<64 and y_cur<24 then timer_put;
					end;

				id_fort_enemy:
					begin
						SpritePutClear(FORT_01,0,(x_put-x_map_scr)*4,(y_put-y_map_scr)*4);
						SpritePutClear(FORT_02,0,(x_put-x_map_scr)*4,(y_put-y_map_scr)*4);
						SpritePutClear(FORT_ENEMY_ENTRY,0,(x_put-x_map_scr+1)*4+2,(y_put-y_map_scr+3)*4+2);

						x_cur:=(x_put-x_map_scr)*8+18;
						y_cur:=(y_put-y_map_scr)*4+11;
						if x_cur<64 and y_cur<24 then timer_put;
					end;

				id_bridge_up_down:
					begin
						SpritePutClear(BRIDGE_UP_DOWN,0,(x_put-x_map_scr)*4,(y_put-y_map_scr)*4);
					end;

				id_bridge_left_right:
					begin
						SpritePutClear(BRIDGE_LEFT_RIGHT,0,(x_put-x_map_scr)*4,(y_put-y_map_scr)*4);
					end;
			end;
	end;


for i:=1 to value_v do
	begin
		x_put:=v[i,i_v_x];
		y_put:=v[i,i_v_y];
		if x_put>(x_map_scr-1)
			then x_min_lim:=x_map_scr-1
			else x_min_lim:=1;
		if y_put>(y_map_scr-1)
			then y_min_lim:=y_map_scr-1
			else y_min_lim:=1;
		if x_put>=x_min_lim and x_put<=(x_map_scr+map_scr_width)
		and y_put>=y_min_lim and y_put<=(y_map_scr+map_scr_height)
		then
			case v[i,i_v_id] of

				id_heavy:
				   begin
					case v[i,i_v_dirtrack] of

						id_left,id_stop:
							begin
							  SpritePutAnd(TRACK_LEFT_MASK,0,(x_put-x_map_scr)*4+v[i,i_v_dx],(y_put-y_map_scr)*4+v[i,i_v_dy]);
							  SpritePutOr(TRACK_LEFT,0,(x_put-x_map_scr)*4+v[i,i_v_dx],(y_put-y_map_scr)*4+v[i,i_v_dy]);
							end;

						id_right:
							begin
							  SpritePutAnd(TRACK_RIGHT_MASK,0,(x_put-x_map_scr)*4+v[i,i_v_dx],(y_put-y_map_scr)*4+v[i,i_v_dy]);
							  SpritePutOr(TRACK_RIGHT,0,(x_put-x_map_scr)*4+v[i,i_v_dx],(y_put-y_map_scr)*4+v[i,i_v_dy]);
							end;

						id_up:
							begin
							  SpritePutAnd(TRACK_UP_MASK,0,(x_put-x_map_scr)*4+v[i,i_v_dx],(y_put-y_map_scr)*4+v[i,i_v_dy]);
							  SpritePutOr(TRACK_UP,0,(x_put-x_map_scr)*4+v[i,i_v_dx],(y_put-y_map_scr)*4+v[i,i_v_dy]);
							end;

						id_down:
							begin
							  SpritePutAnd(TRACK_DOWN_MASK,0,(x_put-x_map_scr)*4+v[i,i_v_dx],(y_put-y_map_scr)*4+v[i,i_v_dy]);
							  SpritePutOr(TRACK_DOWN,0,(x_put-x_map_scr)*4+v[i,i_v_dx],(y_put-y_map_scr)*4+v[i,i_v_dy]);
							end;

					end;
					case v[i,i_v_dirgun] of

						id_left,id_stop:
							begin
							  SpritePutAnd(GUN_LEFT_MASK,0,(x_put-x_map_scr)*4+v[i,i_v_dx],(y_put-y_map_scr)*4+v[i,i_v_dy]);
							  SpritePutOr(GUN_LEFT,0,(x_put-x_map_scr)*4+v[i,i_v_dx],(y_put-y_map_scr)*4+v[i,i_v_dy]);
							end;

						id_up_left:
							begin
							  SpritePutAnd(GUN_UP_LEFT_MASK,0,(x_put-x_map_scr)*4+v[i,i_v_dx],(y_put-y_map_scr)*4+v[i,i_v_dy]);
							  SpritePutOr(GUN_UP_LEFT,0,(x_put-x_map_scr)*4+v[i,i_v_dx],(y_put-y_map_scr)*4+v[i,i_v_dy]);
							end;

						id_up:
							begin
							  SpritePutAnd(GUN_UP_MASK,0,(x_put-x_map_scr)*4+v[i,i_v_dx],(y_put-y_map_scr)*4+v[i,i_v_dy]);
							  SpritePutOr(GUN_UP,0,(x_put-x_map_scr)*4+v[i,i_v_dx],(y_put-y_map_scr)*4+v[i,i_v_dy]);
							end;

						id_up_right:
							begin
							  SpritePutAnd(GUN_UP_RIGHT_MASK,0,(x_put-x_map_scr)*4+v[i,i_v_dx],(y_put-y_map_scr)*4+v[i,i_v_dy]);
							  SpritePutOr(GUN_UP_RIGHT,0,(x_put-x_map_scr)*4+v[i,i_v_dx],(y_put-y_map_scr)*4+v[i,i_v_dy]);
							end;

						id_right:
							begin
							  SpritePutAnd(GUN_RIGHT_MASK,0,(x_put-x_map_scr)*4+v[i,i_v_dx],(y_put-y_map_scr)*4+v[i,i_v_dy]);
							  SpritePutOr(GUN_RIGHT,0,(x_put-x_map_scr)*4+v[i,i_v_dx],(y_put-y_map_scr)*4+v[i,i_v_dy]);
							end;

						id_down_right:
							begin
							  SpritePutAnd(GUN_DOWN_RIGHT_MASK,0,(x_put-x_map_scr)*4+v[i,i_v_dx],(y_put-y_map_scr)*4+v[i,i_v_dy]);
							  SpritePutOr(GUN_DOWN_RIGHT,0,(x_put-x_map_scr)*4+v[i,i_v_dx],(y_put-y_map_scr)*4+v[i,i_v_dy]);
							end;

						id_down:
							begin
							  SpritePutAnd(GUN_DOWN_MASK,0,(x_put-x_map_scr)*4+v[i,i_v_dx],(y_put-y_map_scr)*4+v[i,i_v_dy]);
							  SpritePutOr(GUN_DOWN,0,(x_put-x_map_scr)*4+v[i,i_v_dx],(y_put-y_map_scr)*4+v[i,i_v_dy]);
							end;

						id_down_left:
							begin
							  SpritePutAnd(GUN_DOWN_LEFT_MASK,0,(x_put-x_map_scr)*4+v[i,i_v_dx],(y_put-y_map_scr)*4+v[i,i_v_dy]);
							  SpritePutOr(GUN_DOWN_LEFT,0,(x_put-x_map_scr)*4+v[i,i_v_dx],(y_put-y_map_scr)*4+v[i,i_v_dy]);
							end;


					end;
				   end;

			end;
	end;


end;



{--------------- artifical intellect ---------------}


procedure is_bridge;
begin

flag_is_bridge:=0;

for i1:=1 to value_obj do
	case obj[i1,i_obj_id] of
		id_bridge_left_right,id_bridge_up_down:
			if obj[i1,i_obj_y]=y_cur and obj[i1,i_obj_x]=x_cur
				then flag_is_bridge:=1;
	end;

end;


procedure new_vehicle;
begin

if value_v<64
	then
		begin
			value_v:=value_v+1;

			v[value_v,i_v_bel]:=id_enemy;
			v[value_v,i_v_id]:=id_heavy;
			V[value_v,i_v_x]:=new_v_x;
			V[value_v,i_v_y]:=new_v_y;
			V[value_v,i_v_dx]:=0;
			V[value_v,i_v_dy]:=0;
			V[value_v,i_v_dirtrack]:=id_stop;
			V[value_v,i_v_dirgun]:=id_stop;
			v[value_v,i_v_i_root]:=1;
			v[value_v,i_v_j_root]:=1;
		end;

end;


procedure art_intel;

begin

{river change}

for i:=y_map_scr to y_map_scr+map_scr_height-1 do
	for j:=x_map_scr to x_map_scr+map_scr_width-1 do
		case m[i,j] of

			land_code_river_01_left_right: m[i,j]:=land_code_river_02_left_right;
			land_code_river_01_up_down: m[i,j]:=land_code_river_02_up_down;
			land_code_river_01_up_left: m[i,j]:=land_code_river_02_up_left;
			land_code_river_01_up_right: m[i,j]:=land_code_river_02_up_right;
			land_code_river_01_down_left: m[i,j]:=land_code_river_02_down_left;
			land_code_river_01_down_right: m[i,j]:=land_code_river_02_down_right;

			land_code_river_02_left_right: m[i,j]:=land_code_river_01_left_right;
			land_code_river_02_up_down: m[i,j]:=land_code_river_01_up_down;
			land_code_river_02_up_left: m[i,j]:=land_code_river_01_up_left;
			land_code_river_02_up_right: m[i,j]:=land_code_river_01_up_right;
			land_code_river_02_down_left: m[i,j]:=land_code_river_01_down_left;
			land_code_river_02_down_right: m[i,j]:=land_code_river_01_down_right;

		end;

{object change}

for i:=1 to value_obj do
	case obj[i,i_obj_id] of

		id_flag_enemy:
			case obj[i,i_obj_val2] of

				flag_phase_01: obj[i,i_obj_val2]:=flag_phase_02;
				flag_phase_02: obj[i,i_obj_val2]:=flag_phase_03;
				flag_phase_03: obj[i,i_obj_val2]:=flag_phase_04;
				flag_phase_04: obj[i,i_obj_val2]:=flag_phase_01;

			end;

		id_fort_enemy:
			if obj[i,i_obj_val1]=0 and obj[i,i_obj_val2]=0
				then
					begin
						new_v_x:=obj[i,i_obj_x]+2;
						new_v_y:=obj[i,i_obj_y]+5;
						new_vehicle;
					end;

		id_work_enemy:
			if obj[i,i_obj_val1]=0 and obj[i,i_obj_val2]=0
				then
					begin
						new_v_x:=obj[i,i_obj_x];
						new_v_y:=obj[i,i_obj_y]+3;
						new_vehicle;
					end;

	end;


{vehicle change}

for i:=1 to value_v do
   begin {------------------------------------------------------------------}

	case m[v[i,i_v_y],v[i,i_v_x]] of
		2,3,4: m[v[i,i_v_y],v[i,i_v_x]]:=0;
	end;

flag_is_moving:=0;
case global_cycle of
	1:
		case m[v[i,i_v_y],v[i,i_v_x]] of
			5,6,11,12,17,18,19: flag_is_moving:=1;
		end;
	0: flag_is_moving:=1;
end;

if flag_is_moving=1 then

   begin {++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

	if v[i,i_v_bel]=id_enemy
		then
			begin
				root_i_cur:=v[i,i_v_i_root];
				root_j_cur:=v[i,i_v_j_root];
				case r[root_i_cur,root_j_cur] of
					root_id_move,root_id_take:
						if r[root_i_cur,root_j_cur+1]=v[i,i_v_x] and r[root_i_cur,root_j_cur+2]=v[i,i_v_y]
						and v[i,i_v_dx]=0 and v[i,i_v_dy]=0
							then
								begin
									v[i,i_v_j_root]:=v[i,i_v_j_root]+3;
									v[i,i_v_dirtrack]:=id_stop;
								end
							else
								begin
									if r[root_i_cur,root_j_cur+1]>v[i,i_v_x] and v[i,i_v_dx]=0 and v[i,i_v_dy]=0
										then v[i,i_v_dirtrack]:=id_right;
									if r[root_i_cur,root_j_cur+1]<v[i,i_v_x] and v[i,i_v_dx]=0 and v[i,i_v_dy]=0
										then v[i,i_v_dirtrack]:=id_left;
									if r[root_i_cur,root_j_cur+2]>v[i,i_v_y] and v[i,i_v_dx]=0 and v[i,i_v_dy]=0
										then v[i,i_v_dirtrack]:=id_down;
									if r[root_i_cur,root_j_cur+2]<v[i,i_v_y] and v[i,i_v_dx]=0 and v[i,i_v_dy]=0
										then v[i,i_v_dirtrack]:=id_up;
								end;
					root_id_bridge:
						begin
							v[i,i_v_j_root]:=v[i,i_v_j_root]+5;
						end;
					root_id_sum:
						begin
							v[i,i_v_j_root]:=v[i,i_v_j_root]+1;
						end;
					root_id_fort:
						begin
							v[i,i_v_dirtrack]:=id_stop;
						end;
				end;
			end;


	case v[i,i_v_dirtrack] of
		id_left:
			if v[i,i_v_dx]>0
				then v[i,i_v_dx]:=v[i,i_v_dx]-1
				else
					case m[v[i,i_v_y],v[i,i_v_x]-1] of
						7,8,9,10,13,14,15,16,20,21,22,23,255: v[i,i_v_dirtrack]:=random(3)*2+1;
						5,6,11,12:
							begin
								x_cur:=v[i,i_v_x]-1;
								y_cur:=v[i,i_v_y];
								is_bridge;
								if flag_is_bridge=0
									then v[i,i_v_dirtrack]:=random(3)*2+1
									else
										begin
											v[i,i_v_x]:=v[i,i_v_x]-1;
											v[i,i_v_dx]:=3;
											flag_is_moving:=1;
										end;
							end;
						else
							begin
								v[i,i_v_x]:=v[i,i_v_x]-1;
								v[i,i_v_dx]:=3;
								flag_is_moving:=1;
							end;
			
					end;

		id_up:
			if v[i,i_v_dy]>0
				then v[i,i_v_dy]:=v[i,i_v_dy]-1
				else
					case m[v[i,i_v_y]-1,v[i,i_v_x]] of
						7,8,9,10,13,14,15,16,20,21,22,23,255: v[i,i_v_dirtrack]:=random(3)*2+1;
						5,6,11,12:
							begin
								x_cur:=v[i,i_v_x];
								y_cur:=v[i,i_v_y]-1;
								is_bridge;
								if flag_is_bridge=0
									then v[i,i_v_dirtrack]:=random(3)*2+1
									else
										begin
											v[i,i_v_y]:=v[i,i_v_y]-1;
											v[i,i_v_dy]:=3;
											flag_is_moving:=1;
										end;
							end;
						else
							begin
								v[i,i_v_y]:=v[i,i_v_y]-1;
								v[i,i_v_dy]:=3;
								flag_is_moving:=1;
							end;
					end;

		id_right:
			case v[i,i_v_dx] of
				0:
					case m[v[i,i_v_y],v[i,i_v_x]+1] of
						7,8,9,10,13,14,15,16,20,21,22,23,255: v[i,i_v_dirtrack]:=random(3)*2+1;
						5,6,11,12:
							begin
								x_cur:=v[i,i_v_x]+1;
								y_cur:=v[i,i_v_y];
								is_bridge;
								if flag_is_bridge=0
									then v[i,i_v_dirtrack]:=random(3)*2+1
									else
										begin
											v[i,i_v_dx]:=v[i,i_v_dx]+1;
											flag_is_moving:=1;
										end;
							end;
						else
							begin
								v[i,i_v_dx]:=v[i,i_v_dx]+1;
								flag_is_moving:=1;
							end;
					end;

				1,2:
					begin
						v[i,i_v_dx]:=v[i,i_v_dx]+1;
						flag_is_moving:=1;
					end;

				3:
					begin
						v[i,i_v_x]:=v[i,i_v_x]+1;
						v[i,i_v_dx]:=0;
						flag_is_moving:=1;
					end;
			end;

		id_down:
			case v[i,i_v_dy] of
				0:
					case m[v[i,i_v_y]+1,v[i,i_v_x]] of
						7,8,9,10,13,14,15,16,20,21,22,23,255: v[i,i_v_dirtrack]:=random(3)*2+1;
						5,6,11,12:
							begin
								x_cur:=v[i,i_v_x];
								y_cur:=v[i,i_v_y]+1;
								is_bridge;
								if flag_is_bridge=0
									then v[i,i_v_dirtrack]:=random(3)*2+1
									else
										begin
											v[i,i_v_dy]:=v[i,i_v_dy]+1;
											flag_is_moving:=1;
										end;
							end;
						else
							begin
								v[i,i_v_dy]:=v[i,i_v_dy]+1;
								flag_is_moving:=1;
							end;
					end;

				1,2:
					begin
						v[i,i_v_dy]:=v[i,i_v_dy]+1;
						flag_is_moving:=1;
					end;

				3:
					begin
						v[i,i_v_y]:=v[i,i_v_y]+1;
						v[i,i_v_dy]:=0;
						flag_is_moving:=1;
					end;
			end;

		id_stop: flag_is_moving:=1;

	end;

	v[i,i_v_dirgun]:=v[i,i_v_dirtrack];

   end; {++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

   end; {------------------------------------------------------------------}


end;


{--------------- main ---------------}

begin

border(0);
color(48);
VirtScreenClear;
randomize;

initial;

repeat

global_cycle:=global_cycle+1;
if global_cycle=2 then global_cycle:=0;

for i:=1 to 2 do
	timer_tik;

for i:=11 to 20 do
	timer_tik;

asm(MAP4X4_PUT);

color(6);
put_objects;

VirtScreenPut;
color(48);
VirtScreenClear;

art_intel;


ReadKey(key1,key2);

case key1 of
	key_code_left:
		begin
			x_map_scr:=x_map_scr-1;
			if x_map_scr<1 then x_map_scr:=1;
		end;
	key_code_right:
		begin
			x_map_scr:=x_map_scr+1;
			if x_map_scr>x_map_scr_max then x_map_scr:=x_map_scr_max;
		end;
	key_code_up:
		begin
			y_map_scr:=y_map_scr-1;
			if y_map_scr<1 then y_map_scr:=1;
		end;
	key_code_down:
		begin
			y_map_scr:=y_map_scr+1;
			if y_map_scr>y_map_scr_max then y_map_scr:=y_map_scr_max;
		end;
end;

until key1=key_code_space;


end.


;       44   
; :  
; : 

MAP4X4_PUT		ld	a,(_X_MAP_SCR)
			ld	(map_x),a
			ld	a,(_Y_MAP_SCR)
			ld	(map_y),a

			ld	a,(map_y)
			dec	a
			ld	l,a
			ld	h,0
			add	hl,hl
			add	hl,hl
			add	hl,hl
			add	hl,hl
			add	hl,hl
			add	hl,hl

			ld	a,(map_x)
			dec	a
			ld	e,a
			ld	d,0
			add	hl,de

			ld	de,(map_addr_array)
			add	hl,de

			ld	(map_addr_curr),hl

			ld	hl,(map_xscr)
			ld	(map_xscr_curr),hl

			ld	a,(map_height_scr)
			ld	b,a

map4x4_put_01		push	bc

			ld	a,(map_width_scr)
			ld	b,a

map4x4_put_02		push	bc

			ld	hl,(map_addr_curr)

			ld	a,(hl)
			cp	255
			jp	z,map4x4_put_05
			and	a
			ld	hl,(map_addr_sprites)
			jp	z,map4x4_put_04
			ld	b,a

			ld	de,128

map4x4_put_03		add	hl,de
			djnz	map4x4_put_03

map4x4_put_04		call	map4x4_put_10

map4x4_put_05		ld	hl,(map_addr_curr)
			inc	hl
			ld	(map_addr_curr),hl

			ld	hl,map_xscr_curr
			inc	(hl)
			inc	(hl)
			inc	(hl)
			inc	(hl)

			pop	bc
			djnz	map4x4_put_02

			ld	hl,(map_addr_curr)
			ld	a,(map_xmax_array)
			ld	e,a
			ld	d,0
			add	hl,de

			ld	a,(map_width_scr)
			ld	e,a
			and	a
			sbc	hl,de

			ld	(map_addr_curr),hl

			ld	hl,map_yscr_curr
			inc	(hl)
			inc	(hl)
			inc	(hl)
			inc	(hl)

			ld	a,(map_xscr)
			ld	(map_xscr_curr),a

			pop	bc
			djnz	map4x4_put_01

			ret


map4x4_put_10		ex	de,hl

			ld	bc,(map_xscr_curr)

			LD      A,B
			LD      H,A
			RRCA
			RRCA
			RRCA
			AND	A,224
			ADD	A,C
			LD	L,A
			LD	A,H
			AND	24
			OR	64
			LD	H,A

			ld	bc,addr_virt_screen-16384
			add	hl,bc

			; 1

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 2

			ld	bc,#6ff
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 3

			ld	bc,#6ff
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 4

			ld	bc,#6ff
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 5

			ld	bc,#6e3
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 6

			ld	bc,#6ff
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 7

			ld	bc,#6ff
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 8

			ld	bc,#6ff
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 9

			ld	bc,#6e3
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 10

			ld	bc,#6ff
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 11

			ld	bc,#6ff
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 12

			ld	bc,#6ff
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 13

			ld	bc,#6e3
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 14

			ld	bc,#6ff
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 15

			ld	bc,#6ff
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 16

			ld	bc,#6ff
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a

			ret



MAP_SPRITES

			DEFB 0,1,0,32,0,1,32,96						; 000  1
			DEFB 0,128,0,28,46,62,0,0
			DEFB 0,6,10,46,0,2,6,0
			DEFB 0,130,6,0,32,96,0,4
			DEFB 4,76,0,0,0,0,16,0
			DEFB 0,0,128,0,4,12,0,0
			DEFB 4,64,0,0,2,0,16,0
			DEFB 0,0,32,4,12,0,0,8
			DEFB 0,0,0,32,0,24,40,56
			DEFB 0,128,0,0,0,32,96,0
			DEFB 0,0,0,32,97,0,3,5
			DEFB 0,128,2,128,128,32,0,4
			DEFB 0,64,0,0,1,2,19,0
			DEFB 0,0,128,0,132,128,128,0
			DEFB 7,64,15,16,19,31,0,0
			DEFB 0,0,192,226,230,0,0,8

			DEFB 0,0,64,8,1,3,0,0						; 001  2
			DEFB 0,0,4,64,0,0,24,0
			DEFB 0,8,0,0,132,0,0,0
			DEFB 0,64,196,0,0,0,104,160
			DEFB 66,192,0,2,6,0,4,0
			DEFB 1,2,19,0,0,64,192,8
			DEFB 194,224,224,0,0,0,4,0
			DEFB 224,2,38,96,0,64,0,2
			DEFB 32,0,0,1,0,0,16,48
			DEFB 0,0,0,0,0,0,8,0
			DEFB 0,64,192,1,0,64,0,0
			DEFB 0,32,0,0,0,0,8,0
			DEFB 2,0,1,2,67,0,4,0
			DEFB 0,0,130,134,128,0,0,8
			DEFB 2,6,0,0,64,0,4,0
			DEFB 8,24,2,48,80,112,0,4

			DEFB 0,64,0,4,0,32,97,0						; 002  
			DEFB 0,0,3,68,4,4,4,4
			DEFB 0,4,128,64,192,78,209,83
			DEFB 0,4,32,96,8,0,0,0
			DEFB 0,0,0,0,16,48,0,4
			DEFB 116,136,152,136,152,136,152,136
			DEFB 209,83,209,97,2,4,14,31
			DEFB 8,0,0,0,32,2,6,0
			DEFB 0,0,0,0,64,0,8,0
			DEFB 152,136,128,64,48,8,4,4
			DEFB 63,127,127,255,126,248,112,224
			DEFB 0,8,0,0,0,0,64,0
			DEFB 0,0,0,2,64,8,24,0
			DEFB 4,20,4,3,0,32,0,1
			DEFB 96,192,65,131,0,0,1,0
			DEFB 2,0,16,0,0,2,6,0

			DEFB 0,0,32,0,2,32,96,0						; 003  
			DEFB 0,8,24,0,0,0,0,7
			DEFB 0,32,0,2,134,0,0,0
			DEFB 0,0,8,24,0,4,0,0
			DEFB 0,0,16,0,0,0,66,6
			DEFB 8,57,72,89,64,64,32,16
			DEFB 128,152,164,172,196,14,7,79
			DEFB 32,0,0,4,12,0,0,16
			DEFB 0,0,0,0,32,0,0,4
			DEFB 8,8,9,8,41,8,7,0
			DEFB 254,252,240,224,196,128,0,0
			DEFB 0,0,64,2,0,0,8,24
			DEFB 0,0,0,33,3,0,0,0
			DEFB 0,0,8,0,0,0,1,0
			DEFB 1,32,0,0,4,12,0,0
			DEFB 0,0,0,4,128,0,0,0

			DEFB 0,0,17,3,0,0,1,32						; 004 
			DEFB 0,0,16,0,0,3,6,12
			DEFB 0,0,1,16,0,224,114,56
			DEFB 0,0,8,0,0,32,96,0
			DEFB 0,0,0,64,192,4,0,0
			DEFB 24,48,32,96,65,66,133,138
			DEFB 88,40,88,172,52,172,54,175
			DEFB 0,4,0,0,0,0,64,4
			DEFB 0,0,32,0,0,0,4,0
			DEFB 149,170,145,166,149,166,149,166
			DEFB 55,175,55,175,55,175,54,172
			DEFB 0,0,0,16,0,0,0,64
			DEFB 32,0,0,2,0,32,96,0
			DEFB 245,62,7,0,16,48,0,0
			DEFB 52,188,224,2,0,0,32,0
			DEFB 2,6,0,0,32,96,0,0

			DEFB 128,16,3,31,62,245,170,85					; 005  -
			DEFB 0,2,128,240,250,92,174,87
			DEFB 0,0,0,32,0,31,255,245
			DEFB 0,128,2,0,254,255,171,85
			DEFB 171,85,170,85,170,85,170,85
			DEFB 171,85,170,81,170,85,170,85
			DEFB 170,84,170,85,170,85,170,85
			DEFB 170,85,170,85,170,85,170,85
			DEFB 170,85,170,85,170,85,174,5
			DEFB 170,85,170,85,162,85,170,84
			DEFB 170,85,170,85,160,79,152,48
			DEFB 170,93,170,85,10,193,60,3
			DEFB 226,24,7,64,0,0,16,0
			DEFB 168,81,6,248,0,128,0,8
			DEFB 224,0,0,0,128,0,16,0
			DEFB 0,0,128,0,4,0,64,0

			DEFB 65,1,0,34,0,0,8,0						; 006  -
			DEFB 170,213,238,117,58,53,58,245
			DEFB 170,84,170,85,170,82,170,81
			DEFB 64,66,128,16,2,0,32,0
			DEFB 1,67,3,3,3,3,19,3
			DEFB 232,213,170,85,186,85,170,85
			DEFB 168,84,186,85,170,85,170,85
			DEFB 128,72,64,64,36,32,160,40
			DEFB 3,3,3,33,0,0,0,7
			DEFB 170,85,170,213,234,213,234,213
			DEFB 170,85,42,85,170,85,171,85
			DEFB 160,16,146,80,136,72,168,73
			DEFB 15,93,26,24,14,1,16,0
			DEFB 170,85,170,85,174,213,234,213
			DEFB 170,85,170,85,162,85,170,84
			DEFB 136,80,144,16,36,64,64,72

			DEFB 0,65,5,1,1,35,131,3					; 007  -
			DEFB 234,149,174,213,170,85,170,85
			DEFB 170,85,170,85,174,85,170,85
			DEFB 64,64,162,80,190,95,171,85
			DEFB 3,19,6,7,134,7,6,3
			DEFB 170,85,170,81,170,85,170,85
			DEFB 170,84,170,85,170,85,170,85
			DEFB 170,85,170,85,170,85,170,85
			DEFB 35,3,9,1,1,64,0,0
			DEFB 170,85,170,85,170,213,202,101
			DEFB 170,81,170,85,170,85,234,85
			DEFB 170,93,170,85,170,85,168,3
			DEFB 0,8,0,64,0,0,16,0
			DEFB 50,25,14,3,0,128,0,8
			DEFB 170,80,3,222,224,0,16,0
			DEFB 124,192,128,0,4,0,64,0

			DEFB 1,3,67,15,126,245,234,85					; 008  -
			DEFB 170,85,170,85,170,69,170,85
			DEFB 170,84,170,92,170,84,170,85
			DEFB 64,130,160,128,128,68,65,64
			DEFB 170,85,170,85,174,85,170,85
			DEFB 170,85,170,85,170,85,170,85
			DEFB 170,85,170,69,170,85,170,85
			DEFB 64,72,32,32,161,32,32,64
			DEFB 170,69,170,85,170,85,10,193
			DEFB 170,85,171,85,170,85,170,85
			DEFB 170,84,170,84,168,85,169,82
			DEFB 68,64,144,128,128,2,0,0
			DEFB 62,3,1,0,32,0,2,0
			DEFB 42,21,194,120,7,0,8,0
			DEFB 164,8,48,192,0,1,0,16
			DEFB 0,16,0,2,0,0,8,0

			DEFB 2,64,4,0,0,128,231,127					; 009  -
			DEFB 8,0,0,64,0,62,255,209
			DEFB 0,4,128,0,32,0,192,248
			DEFB 0,16,0,2,64,0,0,0
			DEFB 250,85,170,85,170,117,170,85
			DEFB 170,85,170,85,138,85,170,85
			DEFB 174,85,170,85,170,85,170,85
			DEFB 4,0,128,64,161,32,144,80
			DEFB 170,85,170,85,170,85,42,149
			DEFB 170,84,170,85,234,85,170,85
			DEFB 170,85,174,85,170,85,170,85
			DEFB 168,72,136,82,144,80,176,32
			DEFB 106,21,14,71,6,3,35,1
			DEFB 170,85,170,69,170,85,170,213
			DEFB 170,84,170,84,170,116,170,85
			DEFB 96,194,128,128,128,136,64,64

			DEFB 0,2,0,0,0,32,0,1						; 010  -
			DEFB 0,4,0,3,31,117,234,213
			DEFB 16,0,124,255,171,85,170,85
			DEFB 64,0,4,224,254,95,169,85
			DEFB 3,135,14,13,26,29,26,29
			DEFB 170,85,170,85,170,85,234,85
			DEFB 170,85,162,85,170,85,170,85
			DEFB 170,85,174,85,170,85,170,85
			DEFB 78,13,14,13,6,7,67,1
			DEFB 170,85,168,85,170,85,170,213
			DEFB 170,85,170,85,168,85,170,85
			DEFB 170,85,186,85,170,85,170,80
			DEFB 1,17,1,0,4,0,32,1
			DEFB 170,215,170,213,234,213,234,213
			DEFB 170,85,170,85,162,85,170,85
			DEFB 167,72,144,16,160,36,64,64

			DEFB 128,16,3,31,62,245,170,85					; 011  - 2
			DEFB 0,2,128,240,250,92,174,87
			DEFB 0,0,0,32,0,31,255,245
			DEFB 0,128,2,0,254,255,171,85
			DEFB 170,85,170,85,170,85,170,85
			DEFB 43,85,170,87,170,85,170,85
			DEFB 170,85,170,85,170,85,170,85
			DEFB 170,213,170,85,170,85,170,85
			DEFB 170,85,170,85,170,85,168,5
			DEFB 170,85,170,85,174,85,170,84
			DEFB 170,85,170,85,160,79,152,48
			DEFB 170,81,170,85,10,193,60,3
			DEFB 226,24,7,64,0,0,16,0
			DEFB 168,81,6,248,0,128,0,8
			DEFB 224,0,0,0,128,0,16,0
			DEFB 0,0,128,0,4,0,64,0

			DEFB 65,1,0,34,0,0,8,0						; 012  - 2
			DEFB 170,213,232,117,58,53,58,245
			DEFB 170,84,170,85,170,82,170,81
			DEFB 64,66,128,16,2,0,32,0
			DEFB 1,67,3,3,3,3,19,3
			DEFB 235,213,170,85,162,85,170,85
			DEFB 168,84,162,85,170,85,170,85
			DEFB 128,72,64,64,36,32,160,40
			DEFB 3,3,3,33,0,0,0,7
			DEFB 170,85,170,213,234,213,234,213
			DEFB 170,85,234,85,170,85,170,85
			DEFB 160,16,146,80,136,72,40,73
			DEFB 15,93,26,25,14,1,16,0
			DEFB 170,85,170,213,168,213,234,213
			DEFB 170,85,170,85,174,85,170,84
			DEFB 136,80,144,16,36,64,64,72

			DEFB 0,65,5,1,1,35,131,3					; 013  - 2
			DEFB 234,149,168,213,170,85,170,85
			DEFB 170,85,170,85,168,85,170,85
			DEFB 64,64,162,80,190,95,171,85
			DEFB 3,19,6,7,134,7,6,3
			DEFB 170,85,170,87,170,85,170,85
			DEFB 170,85,170,85,170,85,170,85
			DEFB 170,213,170,85,170,85,170,85
			DEFB 35,3,9,1,1,64,0,0
			DEFB 170,85,170,85,170,213,202,101
			DEFB 170,87,170,85,170,85,138,85
			DEFB 170,81,170,85,170,85,168,3
			DEFB 0,8,0,64,0,0,16,0
			DEFB 50,25,14,3,0,128,0,8
			DEFB 170,80,3,222,224,0,16,0
			DEFB 124,192,128,0,4,0,64,0

			DEFB 1,3,67,15,126,245,234,85					; 014  - 2
			DEFB 170,85,170,85,170,93,170,85
			DEFB 170,84,170,80,170,84,170,85
			DEFB 64,130,160,128,128,68,65,64
			DEFB 170,85,170,85,168,85,170,85
			DEFB 170,85,170,85,170,85,170,85
			DEFB 170,85,170,93,170,85,170,85
			DEFB 64,72,32,32,161,32,32,64
			DEFB 170,93,170,85,170,85,10,193
			DEFB 170,85,170,85,170,85,170,85
			DEFB 170,84,42,84,168,85,169,82
			DEFB 68,64,144,128,128,2,0,0
			DEFB 62,3,1,0,32,0,2,0
			DEFB 42,21,194,120,7,0,8,0
			DEFB 164,8,48,192,0,1,0,16
			DEFB 0,16,0,2,0,0,8,0

			DEFB 2,64,4,0,0,128,231,127					; 015  - 2
			DEFB 8,0,0,64,0,62,255,209
			DEFB 0,4,128,0,32,0,192,248
			DEFB 0,16,0,2,64,0,0,0
			DEFB 250,85,170,85,170,69,170,85
			DEFB 170,85,170,85,186,85,170,85
			DEFB 174,85,170,85,170,85,170,85
			DEFB 4,0,128,64,161,32,144,80
			DEFB 170,85,170,85,170,85,42,149
			DEFB 170,85,170,85,138,85,170,85
			DEFB 170,213,168,85,170,85,170,85
			DEFB 168,72,136,82,144,80,176,32
			DEFB 106,21,14,71,6,3,35,1
			DEFB 170,85,170,93,170,85,170,213
			DEFB 170,84,170,84,170,68,170,85
			DEFB 96,194,128,128,128,136,64,64

			DEFB 0,2,0,0,0,32,0,1						; 016  - 2
			DEFB 0,4,0,3,31,117,234,213
			DEFB 16,0,124,255,171,85,170,85
			DEFB 64,0,4,224,254,95,169,85
			DEFB 3,135,14,13,26,29,26,29
			DEFB 170,85,170,85,170,85,138,85
			DEFB 170,85,174,85,170,85,170,85
			DEFB 170,85,168,85,170,85,170,85
			DEFB 78,13,14,13,6,7,67,1
			DEFB 170,85,171,85,170,85,170,213
			DEFB 170,85,170,85,171,85,170,85
			DEFB 170,85,162,85,170,85,170,80
			DEFB 1,17,1,0,4,0,32,1
			DEFB 170,212,170,213,234,213,234,213
			DEFB 170,85,170,85,174,85,170,85
			DEFB 167,72,144,16,160,36,64,64

			DEFB 191,95,191,95,191,127,191,95				; 017  -
			DEFB 255,255,127,255,255,254,254,254
			DEFB 239,255,255,255,255,127,127,111
			DEFB 250,252,122,253,254,253,254,189
			DEFB 63,95,63,91,47,31,47,31
			DEFB 222,254,254,255,255,255,255,247
			DEFB 127,127,127,251,255,255,255,255
			DEFB 254,253,250,244,248,244,248,244
			DEFB 47,31,47,31,47,95,191,127
			DEFB 255,255,127,255,255,254,254,254
			DEFB 255,223,255,255,255,127,119,127
			DEFB 248,244,120,244,250,252,250,252
			DEFB 191,127,191,123,191,95,63,95
			DEFB 222,254,254,255,255,255,255,247
			DEFB 127,127,127,251,255,255,255,255
			DEFB 250,253,254,253,250,253,186,253

			DEFB 170,85,174,255,255,255,191,255				; 018  -
			DEFB 0,80,170,245,255,255,255,251
			DEFB 2,5,171,87,255,255,255,255
			DEFB 168,85,250,255,255,255,127,251
			DEFB 255,255,247,255,255,255,255,248
			DEFB 255,255,255,191,255,253,255,31
			DEFB 255,255,247,255,255,255,255,248
			DEFB 255,255,255,255,126,255,255,31
			DEFB 248,255,255,127,255,254,255,255
			DEFB 31,255,255,255,255,255,255,251
			DEFB 248,255,255,127,255,254,255,255
			DEFB 31,255,255,255,255,255,255,251
			DEFB 255,255,247,255,255,95,170,21
			DEFB 255,255,255,255,234,213,160,64
			DEFB 255,255,247,255,175,85,10,0
			DEFB 255,255,255,255,255,117,170,85

			DEFB 191,95,191,255,255,255,191,255				; 019  
			DEFB 255,255,127,255,255,254,254,254
			DEFB 239,255,255,255,255,127,127,111
			DEFB 250,253,126,255,255,255,255,191
			DEFB 255,255,255,251,255,255,255,248
			DEFB 222,254,254,255,255,255,255,31
			DEFB 127,127,127,251,255,255,255,248
			DEFB 251,255,255,255,254,255,255,31
			DEFB 248,255,255,127,255,247,255,255
			DEFB 31,255,255,255,255,254,254,254
			DEFB 120,255,255,255,255,127,127,127
			DEFB 31,255,255,255,255,127,255,251
			DEFB 255,255,255,251,255,127,191,95
			DEFB 222,254,254,255,255,255,255,247
			DEFB 127,127,127,251,255,255,255,255
			DEFB 255,255,255,255,255,255,190,253

			DEFB 119,168,208,129,160,208,104,208				; 020   
			DEFB 253,0,144,97,0,0,8,0
			DEFB 253,0,64,0,0,33,0,0
			DEFB 123,133,0,1,161,66,5,10
			DEFB 174,208,160,208,160,128,128,128
			DEFB 215,1,5,2,10,6,10,20
			DEFB 222,0,0,0,0,0,0,0
			DEFB 241,69,42,81,42,5,42,65
			DEFB 128,128,128,128,128,192,160,192
			DEFB 12,20,12,20,4,10,2,5
			DEFB 0,0,0,0,0,0,0,0
			DEFB 42,85,42,1,170,69,170,81
			DEFB 160,192,160,192,192,224,96,63
			DEFB 3,1,2,5,2,5,10,255
			DEFB 0,0,128,128,128,64,192,255
			DEFB 42,5,42,65,42,87,47,252

			DEFB 119,168,208,129,160,208,104,208				; 021   
			DEFB 254,1,32,64,1,2,0,0
			DEFB 246,10,1,2,67,133,11,21
			DEFB 0,0,0,0,0,255,255,255
			DEFB 174,208,160,208,160,128,128,128
			DEFB 213,0,0,0,0,0,0,0
			DEFB 227,139,85,163,85,11,85,131
			DEFB 255,254,254,254,252,252,248,248
			DEFB 128,128,128,128,128,192,160,192
			DEFB 0,0,0,0,1,0,1,0
			DEFB 85,171,85,3,85,139,85,163
			DEFB 252,252,252,252,252,252,252,248
			DEFB 160,192,160,192,192,224,96,63
			DEFB 0,0,0,0,0,0,0,255
			DEFB 85,11,85,131,85,175,94,248
			DEFB 240,224,196,192,0,1,32,0

			DEFB 119,168,208,129,160,208,104,208				; 022   
			DEFB 254,1,32,64,1,0,0,0
			DEFB 246,10,1,2,67,5,3,5
			DEFB 0,0,0,0,0,255,255,255
			DEFB 160,216,162,208,160,128,128,128
			DEFB 0,0,155,0,10,4,0,0
			DEFB 15,55,87,11,5,3,5,3
			DEFB 255,254,254,254,252,252,248,248
			DEFB 16,128,128,129,192,253,160,64
			DEFB 0,0,0,0,0,215,0,0
			DEFB 5,3,71,15,23,171,7,11
			DEFB 252,252,252,252,248,248,248,252
			DEFB 160,192,160,129,128,128,128,64
			DEFB 1,2,0,64,0,0,0,0
			DEFB 69,3,5,3,5,35,131,5
			DEFB 252,252,252,252,248,240,224,192

			DEFB 119,168,208,129,160,208,104,208				; 023   
			DEFB 254,1,32,64,1,0,0,0
			DEFB 253,0,8,0,0,0,0,20
			DEFB 205,2,0,0,64,1,0,8
			DEFB 160,216,162,208,160,128,128,128
			DEFB 0,0,155,0,10,4,0,0
			DEFB 0,0,87,0,0,0,0,20
			DEFB 0,1,86,1,0,0,0,0
			DEFB 16,128,128,129,192,253,160,64
			DEFB 0,0,0,0,0,215,0,0
			DEFB 0,0,0,0,0,90,0,0
			DEFB 0,0,64,1,6,233,0,2
			DEFB 160,192,160,129,128,128,128,64
			DEFB 1,2,0,64,0,0,0,0
			DEFB 0,0,2,8,0,0,128,0
			DEFB 8,0,0,0,0,8,0,1




FLAG_ENEMY_01		DEFB 4
			DEFB 0,0, 64,0,190,255,255,255,227,128
			DEFB 0,1, 0,0,0,192,192,208,192,192
			DEFB 1,0, 128,130,135,143,144,160,192,128
			DEFB 1,1, 0,0,224,248,60,0,128,0

FLAG_ENEMY_02		DEFB 4
			DEFB 0,0, 64,0,158,255,255,255,243,128
			DEFB 0,1, 0,0,0,192,192,208,192,0
			DEFB 1,0, 128,130,135,143,150,160,192,128
			DEFB 1,1, 0,0,224,248,28,0,128,0

FLAG_ENEMY_03		DEFB 4
			DEFB 0,0, 64,0,159,255,255,255,248,128
			DEFB 0,1, 0,64,192,192,192,208,0,0
			DEFB 1,0, 128,130,135,143,151,160,192,128
			DEFB 1,1, 0,4,252,252,0,0,128,0

FLAG_ENEMY_04		DEFB 4
			DEFB 0,0, 64,0,191,255,255,255,224,128
			DEFB 0,1, 0,0,192,192,192,208,0,0
			DEFB 1,0, 128,130,135,143,150,160,192,128
			DEFB 1,1, 0,0,224,252,60,0,128,0


TRACK_DOWN
			DEFB 16
			DEFB 0,0, 0,0,0,3,2,2,2,3
			DEFB 0,1, 0,0,0,248,15,8,8,248
			DEFB 0,2, 0,0,0,15,248,8,8,15
			DEFB 0,3, 0,0,0,224,32,32,48,240
			DEFB 1,0, 2,2,2,2,2,2,2,2
			DEFB 1,1, 15,8,8,8,8,8,8,8
			DEFB 1,2, 248,8,8,8,8,8,8,8
			DEFB 1,3, 48,48,48,48,48,48,48,48
			DEFB 2,0, 2,2,2,2,2,2,2,2
			DEFB 2,1, 8,8,8,8,8,8,8,8
			DEFB 2,2, 8,8,8,8,8,8,8,8
			DEFB 2,3, 48,48,48,48,48,48,48,48
			DEFB 3,0, 2,3,2,3,1,0,0,0
			DEFB 3,1, 8,248,15,255,15,255,127,0
			DEFB 3,2, 8,15,248,255,248,255,255,0
			DEFB 3,3, 48,240,48,240,112,224,192,0

TRACK_DOWN_MASK
			DEFB 16
			DEFB 0,0, 255,255,255,252,252,252,252,252
			DEFB 0,1, 255,255,255,7,0,0,0,0
			DEFB 0,2, 255,255,255,240,0,0,0,0
			DEFB 0,3, 255,255,255,31,31,31,15,15
			DEFB 1,0, 252,252,252,252,252,252,252,252
			DEFB 1,1, 0,0,0,0,0,0,0,0
			DEFB 1,2, 0,0,0,0,0,0,0,0
			DEFB 1,3, 15,15,15,15,15,15,15,15
			DEFB 2,0, 252,252,252,252,252,252,252,252
			DEFB 2,1, 0,0,0,0,0,0,0,0
			DEFB 2,2, 0,0,0,0,0,0,0,0
			DEFB 2,3, 15,15,15,15,15,15,15,15
			DEFB 3,0, 252,252,252,252,254,255,255,255
			DEFB 3,1, 0,0,0,0,0,0,128,255
			DEFB 3,2, 0,0,0,0,0,0,0,255
			DEFB 3,3, 15,15,15,15,15,31,63,255

TRACK_UP
			DEFB 16
			DEFB 0,0, 0,0,0,3,2,2,2,2
			DEFB 0,1, 0,0,0,248,15,8,8,8
			DEFB 0,2, 0,0,0,15,248,8,8,8
			DEFB 0,3, 0,0,0,224,32,32,48,48
			DEFB 1,0, 2,2,2,2,2,2,2,2
			DEFB 1,1, 8,8,8,8,8,8,8,8
			DEFB 1,2, 8,8,8,8,8,8,8,8
			DEFB 1,3, 48,48,48,48,48,48,48,48
			DEFB 2,0, 2,2,2,2,2,3,2,2
			DEFB 2,1, 8,8,8,8,8,248,15,8
			DEFB 2,2, 8,8,8,8,8,15,248,8
			DEFB 2,3, 48,48,48,48,48,240,48,48
			DEFB 3,0, 2,3,2,3,2,1,0,0
			DEFB 3,1, 8,248,15,255,15,255,255,0
			DEFB 3,2, 8,15,248,255,248,255,255,0
			DEFB 3,3, 48,240,48,240,48,240,224,0

TRACK_UP_MASK
			DEFB 16
			DEFB 0,0, 255,255,255,252,252,252,252,252
			DEFB 0,1, 255,255,255,7,0,0,0,0
			DEFB 0,2, 255,255,255,240,0,0,0,0
			DEFB 0,3, 255,255,255,31,31,31,15,15
			DEFB 1,0, 252,252,252,252,252,252,252,252
			DEFB 1,1, 0,0,0,0,0,0,0,0
			DEFB 1,2, 0,0,0,0,0,0,0,0
			DEFB 1,3, 15,15,15,15,15,15,15,15
			DEFB 2,0, 252,252,252,252,252,252,252,252
			DEFB 2,1, 0,0,0,0,0,0,0,0
			DEFB 2,2, 0,0,0,0,0,0,0,0
			DEFB 2,3, 15,15,15,15,15,15,15,15
			DEFB 3,0, 252,252,252,252,252,254,255,255
			DEFB 3,1, 0,0,0,0,0,0,0,255
			DEFB 3,2, 0,0,0,0,0,0,0,255
			DEFB 3,3, 15,15,15,15,15,15,31,255

TRACK_LEFT
			DEFB 16
			DEFB 0,0, 0,0,0,0,0,63,64,64
			DEFB 0,1, 0,0,0,0,0,255,0,0
			DEFB 0,2, 0,0,0,0,0,255,0,0
			DEFB 0,3, 0,0,0,0,0,248,68,68
			DEFB 1,0, 64,127,32,32,32,32,32,32
			DEFB 1,1, 0,255,0,0,0,0,0,0
			DEFB 1,2, 0,255,0,0,0,0,0,0
			DEFB 1,3, 68,252,68,68,68,70,71,71
			DEFB 2,0, 32,63,96,64,64,127,64,66
			DEFB 2,1, 0,255,0,0,0,255,0,34
			DEFB 2,2, 0,255,0,0,0,255,0,34
			DEFB 2,3, 71,255,71,71,71,255,3,35
			DEFB 3,0, 37,18,8,7,1,0,0,0
			DEFB 3,1, 85,34,136,255,255,0,0,0
			DEFB 3,2, 85,34,136,255,255,0,0,0
			DEFB 3,3, 83,39,143,254,252,0,0,0

TRACK_LEFT_MASK
			DEFB 16
			DEFB 0,0, 255,255,255,255,255,192,128,128
			DEFB 0,1, 255,255,255,255,255,0,0,0
			DEFB 0,2, 255,255,255,255,255,0,0,0
			DEFB 0,3, 255,255,255,255,255,7,3,3
			DEFB 1,0, 128,128,192,192,192,192,192,192
			DEFB 1,1, 0,0,0,0,0,0,0,0
			DEFB 1,2, 0,0,0,0,0,0,0,0
			DEFB 1,3, 3,3,3,3,3,1,0,0
			DEFB 2,0, 192,192,128,128,128,128,128,128
			DEFB 2,1, 0,0,0,0,0,0,0,0
			DEFB 2,2, 0,0,0,0,0,0,0,0
			DEFB 2,3, 0,0,0,0,0,0,0,0
			DEFB 3,0, 192,224,240,248,254,255,255,255
			DEFB 3,1, 0,0,0,0,0,255,255,255
			DEFB 3,2, 0,0,0,0,0,255,255,255
			DEFB 3,3, 0,0,0,1,3,255,255,255

TRACK_RIGHT
			DEFB 16
			DEFB 0,0, 0,0,0,0,0,31,34,34
			DEFB 0,1, 0,0,0,0,0,255,0,0
			DEFB 0,2, 0,0,0,0,0,255,0,0
			DEFB 0,3, 0,0,0,0,0,252,2,2
			DEFB 1,0, 34,63,34,34,34,34,34,34
			DEFB 1,1, 0,255,0,0,0,0,0,0
			DEFB 1,2, 0,255,0,0,0,0,0,0
			DEFB 1,3, 2,254,4,4,4,6,7,7
			DEFB 2,0, 34,63,34,34,34,127,64,68
			DEFB 2,1, 0,255,0,0,0,255,0,68
			DEFB 2,2, 0,255,0,0,0,255,0,68
			DEFB 2,3, 7,255,3,3,3,255,3,67
			DEFB 3,0, 74,36,17,31,15,0,0,0
			DEFB 3,1, 170,68,17,255,255,0,0,0
			DEFB 3,2, 170,68,17,255,255,0,0,0
			DEFB 3,3, 167,78,28,248,240,0,0,0

TRACK_RIGHT_MASK
			DEFB 16
			DEFB 0,0, 255,255,255,255,255,224,192,192
			DEFB 0,1, 255,255,255,255,255,0,0,0
			DEFB 0,2, 255,255,255,255,255,0,0,0
			DEFB 0,3, 255,255,255,255,255,3,1,1
			DEFB 1,0, 192,192,192,192,192,192,192,192
			DEFB 1,1, 0,0,0,0,0,0,0,0
			DEFB 1,2, 0,0,0,0,0,0,0,0
			DEFB 1,3, 1,1,3,3,3,1,0,0
			DEFB 2,0, 192,192,192,192,192,128,128,128
			DEFB 2,1, 0,0,0,0,0,0,0,0
			DEFB 2,2, 0,0,0,0,0,0,0,0
			DEFB 2,3, 0,0,0,0,0,0,0,0
			DEFB 3,0, 128,192,224,224,240,255,255,255
			DEFB 3,1, 0,0,0,0,0,255,255,255
			DEFB 3,2, 0,0,0,0,0,255,255,255
			DEFB 3,3, 0,1,3,7,15,255,255,255

GUN_UP
			DEFB 12
			DEFB 0,1, 0,3,4,4,7,4,4,7
			DEFB 0,2, 0,128,64,64,192,64,64,192
			DEFB 1,1, 4,28,23,104,72,136,136,136
			DEFB 1,2, 64,112,208,44,38,35,35,35
			DEFB 2,0, 0,0,1,1,1,1,1,1
			DEFB 2,1, 136,156,34,66,66,34,28,128
			DEFB 2,2, 35,115,137,133,133,137,113,3
			DEFB 2,3, 0,0,128,128,128,128,128,128
			DEFB 3,0, 1,1,0,0,0,0,0,0
			DEFB 3,1, 127,0,192,127,0,0,0,0
			DEFB 3,2, 253,1,7,255,0,0,0,0
			DEFB 3,3, 128,128,128,0,0,0,0,0

GUN_UP_MASK
			DEFB 16
			DEFB 0,0, 255,255,255,255,255,255,255,255
			DEFB 0,1, 255,252,248,248,248,248,248,248
			DEFB 0,2, 255,127,63,63,63,63,63,63
			DEFB 0,3, 255,255,255,255,255,255,255,255
			DEFB 1,0, 255,255,255,255,255,255,255,255
			DEFB 1,1, 248,224,224,128,128,0,0,0
			DEFB 1,2, 63,15,15,3,1,0,0,0
			DEFB 1,3, 255,255,255,255,255,255,255,255
			DEFB 2,0, 255,255,254,254,254,254,254,254
			DEFB 2,1, 0,0,0,0,0,0,0,0
			DEFB 2,2, 0,0,0,0,0,0,0,0
			DEFB 2,3, 255,255,127,127,127,127,127,127
			DEFB 3,0, 254,254,255,255,255,255,255,255
			DEFB 3,1, 0,0,0,128,255,255,255,255
			DEFB 3,2, 0,0,0,0,255,255,255,255
			DEFB 3,3, 127,127,127,255,255,255,255,255

GUN_UP_RIGHT
			DEFB 13
			DEFB 0,1, 0,0,0,0,0,15,16,32
			DEFB 0,2, 0,0,0,0,0,252,6,3
			DEFB 0,3, 0,0,0,0,8,28,46,196
			DEFB 1,0, 0,0,1,1,1,1,1,1
			DEFB 1,1, 64,128,0,14,17,33,35,29
			DEFB 1,2, 3,6,12,30,51,113,155,14
			DEFB 1,3, 104,48,112,240,176,176,48,48
			DEFB 2,0, 1,1,0,0,0,0,0,0
			DEFB 2,1, 134,68,168,84,42,21,10,5
			DEFB 2,2, 12,24,60,98,194,196,57,3
			DEFB 2,3, 48,48,48,48,96,224,192,128
			DEFB 3,1, 3,1,0,0,0,0,0,0
			DEFB 3,2, 255,254,0,0,0,0,0,0

GUN_UP_RIGHT_MASK
			DEFB 16
			DEFB 0,0, 255,255,255,255,255,255,255,255
			DEFB 0,1, 255,255,255,255,255,240,224,192
			DEFB 0,2, 255,255,255,255,255,3,1,0
			DEFB 0,3, 255,255,255,255,247,227,193,3
			DEFB 1,0, 255,255,254,254,254,254,254,254
			DEFB 1,1, 128,0,0,0,0,0,0,0
			DEFB 1,2, 0,0,0,0,0,0,0,0
			DEFB 1,3, 7,15,15,15,15,15,15,15
			DEFB 2,0, 254,254,255,255,255,255,255,255
			DEFB 2,1, 0,0,0,128,192,224,240,248
			DEFB 2,2, 0,0,0,0,0,0,0,0
			DEFB 2,3, 15,15,15,15,31,31,63,127
			DEFB 3,0, 255,255,255,255,255,255,255,255
			DEFB 3,1, 252,254,255,255,255,255,255,255
			DEFB 3,2, 0,1,255,255,255,255,255,255
			DEFB 3,3, 255,255,255,255,255,255,255,255

GUN_RIGHT
			DEFB 10
			DEFB 0,0, 0,0,0,0,1,2,2,3
			DEFB 0,1, 0,0,0,248,7,0,120,132
			DEFB 0,2, 0,0,0,0,192,48,16,12
			DEFB 1,0, 2,2,2,2,3,2,2,2
			DEFB 1,1, 135,120,0,120,135,132,120,0
			DEFB 1,2, 246,15,9,9,255,14,6,6
			DEFB 1,3, 0,255,17,17,255,0,0,0
			DEFB 2,0, 2,2,2,2,2,3,0,0
			DEFB 2,1, 0,0,0,0,0,255,0,0
			DEFB 2,2, 6,14,28,56,112,192,0,0

GUN_RIGHT_MASK
			DEFB 16
			DEFB 0,0, 255,255,255,255,254,252,252,252
			DEFB 0,1, 255,255,255,7,0,0,0,0
			DEFB 0,2, 255,255,255,255,63,15,15,3
			DEFB 0,3, 255,255,255,255,255,255,255,255
			DEFB 1,0, 252,252,252,252,252,252,252,252
			DEFB 1,1, 0,0,0,0,0,0,0,0
			DEFB 1,2, 1,0,0,0,0,1,1,1
			DEFB 1,3, 255,0,0,0,0,255,255,255
			DEFB 2,0, 252,252,252,252,252,252,255,255
			DEFB 2,1, 0,0,0,0,0,0,255,255
			DEFB 2,2, 1,1,3,7,15,63,255,255
			DEFB 2,3, 255,255,255,255,255,255,255,255
			DEFB 3,0, 255,255,255,255,255,255,255,255
			DEFB 3,1, 255,255,255,255,255,255,255,255
			DEFB 3,2, 255,255,255,255,255,255,255,255
			DEFB 3,3, 255,255,255,255,255,255,255,255

GUN_DOWN_RIGHT
			DEFB 11
			DEFB 0,1, 0,1,2,4,11,21,40,80
			DEFB 0,2, 0,248,4,242,9,8,240,96
			DEFB 0,3, 0,0,0,0,0,192,64,96
			DEFB 1,0, 0,1,2,2,2,2,2,2
			DEFB 1,1, 136,60,66,67,60,0,0,0
			DEFB 1,2, 48,24,28,54,227,103,61,24
			DEFB 1,3, 96,96,96,96,96,96,224,192
			DEFB 2,0, 1,0,0,0,0,0,0,0
			DEFB 2,1, 0,128,64,32,31,0,0,0
			DEFB 2,2, 12,6,7,12,248,0,0,0
			DEFB 2,3, 96,208,136,92,56,16,0,0

GUN_DOWN_RIGHT_MASK
			DEFB 16
			DEFB 0,0, 255,255,255,255,255,255,255,255
			DEFB 0,1, 255,254,252,248,240,224,192,128
			DEFB 0,2, 255,7,3,1,0,0,0,0
			DEFB 0,3, 255,255,255,255,255,63,63,31
			DEFB 1,0, 255,254,252,252,252,252,252,252
			DEFB 1,1, 0,0,0,0,0,0,0,0
			DEFB 1,2, 0,0,0,0,0,0,0,0
			DEFB 1,3, 31,31,31,31,31,31,31,63
			DEFB 2,0, 254,255,255,255,255,255,255,255
			DEFB 2,1, 0,0,128,192,224,255,255,255
			DEFB 2,2, 0,0,0,3,7,255,255,255
			DEFB 2,3, 31,15,7,131,199,239,255,255
			DEFB 3,0, 255,255,255,255,255,255,255,255
			DEFB 3,1, 255,255,255,255,255,255,255,255
			DEFB 3,2, 255,255,255,255,255,255,255,255
			DEFB 3,3, 255,255,255,255,255,255,255,255

GUN_DOWN
			DEFB 12
			DEFB 0,0, 0,0,0,0,0,1,1,1
			DEFB 0,1, 0,0,0,127,128,28,34,66
			DEFB 0,2, 0,0,0,252,2,113,137,133
			DEFB 0,3, 0,0,0,0,0,0,128,128
			DEFB 1,0, 1,1,0,0,0,0,0,0
			DEFB 1,1, 66,34,156,136,136,136,136,72
			DEFB 1,2, 133,137,115,35,35,35,35,38
			DEFB 1,3, 128,128,0,0,0,0,0,0
			DEFB 2,1, 104,23,28,4,7,4,4,7
			DEFB 2,2, 46,220,112,96,192,64,64,192
			DEFB 3,1, 6,4,3,0,0,0,0,0
			DEFB 3,2, 192,64,128,0,0,0,0,0

GUN_DOWN_MASK
			DEFB 16
			DEFB 0,0, 255,255,255,255,255,254,254,254
			DEFB 0,1, 255,255,255,128,0,0,0,0
			DEFB 0,2, 255,255,255,3,1,0,0,0
			DEFB 0,3, 255,255,255,255,255,255,127,127
			DEFB 1,0, 254,254,255,255,255,255,255,255
			DEFB 1,1, 0,0,0,0,0,0,0,128
			DEFB 1,2, 0,0,0,0,0,0,0,1
			DEFB 1,3, 127,127,255,255,255,255,255,255
			DEFB 2,0, 255,255,255,255,255,255,255,255
			DEFB 2,1, 128,224,224,248,248,248,248,248
			DEFB 2,2, 1,3,15,31,63,63,63,63
			DEFB 2,3, 255,255,255,255,255,255,255,255
			DEFB 3,0, 255,255,255,255,255,255,255,255
			DEFB 3,1, 248,248,252,255,255,255,255,255
			DEFB 3,2, 63,63,127,255,255,255,255,255
			DEFB 3,3, 255,255,255,255,255,255,255,255

GUN_DOWN_LEFT
			DEFB 11
			DEFB 0,0, 0,0,0,0,0,3,2,2
			DEFB 0,1, 0,31,32,79,144,16,15,6
			DEFB 0,2, 0,128,64,32,208,168,20,10
			DEFB 1,0, 2,2,2,2,2,2,3,3
			DEFB 1,1, 12,24,56,108,199,230,188,24
			DEFB 1,2, 17,60,66,194,60,0,0,0
			DEFB 1,3, 0,128,64,64,96,96,96,96
			DEFB 2,0, 6,11,17,58,28,8,0,0
			DEFB 2,1, 48,96,224,48,31,15,0,0
			DEFB 2,2, 0,1,3,7,254,252,0,0
			DEFB 2,3, 224,192,128,0,0,0,0,0

GUN_DOWN_LEFT_MASK
			DEFB 16
			DEFB 0,0, 255,255,255,255,255,252,252,252
			DEFB 0,1, 255,224,192,128,0,0,0,0
			DEFB 0,2, 255,127,63,31,15,7,3,1
			DEFB 0,3, 255,255,255,255,255,255,255,255
			DEFB 1,0, 252,252,252,252,252,252,252,252
			DEFB 1,1, 0,0,0,0,0,0,0,0
			DEFB 1,2, 0,0,0,0,0,0,0,0
			DEFB 1,3, 255,127,63,63,31,31,31,31
			DEFB 2,0, 248,240,224,193,227,247,255,255
			DEFB 2,1, 0,0,0,192,224,240,255,255
			DEFB 2,2, 0,0,0,0,1,3,255,255
			DEFB 2,3, 31,63,127,255,255,255,255,255
			DEFB 3,0, 255,255,255,255,255,255,255,255
			DEFB 3,1, 255,255,255,255,255,255,255,255
			DEFB 3,2, 255,255,255,255,255,255,255,255
			DEFB 3,3, 255,255,255,255,255,255,255,255

GUN_LEFT
			DEFB 10
			DEFB 0,1, 0,0,0,0,3,12,8,48
			DEFB 0,2, 0,0,0,31,224,0,30,33
			DEFB 0,3, 0,0,0,0,128,64,64,224
			DEFB 1,0, 0,255,136,136,255,0,0,0
			DEFB 1,1, 47,240,144,144,255,48,32,32
			DEFB 1,2, 225,30,0,30,225,33,30,0
			DEFB 1,3, 96,96,96,96,224,96,96,96
			DEFB 2,1, 32,16,8,4,2,3,0,0
			DEFB 2,2, 0,0,0,0,0,255,0,0
			DEFB 2,3, 96,96,96,96,96,224,0,0

GUN_LEFT_MASK
			DEFB 16
			DEFB 0,0, 255,255,255,255,255,255,255,255
			DEFB 0,1, 255,255,255,255,252,240,240,192
			DEFB 0,2, 255,255,255,224,0,0,0,0
			DEFB 0,3, 255,255,255,255,127,63,63,31
			DEFB 1,0, 255,0,0,0,0,255,255,255
			DEFB 1,1, 192,0,0,0,0,192,192,192
			DEFB 1,2, 0,0,0,0,0,0,0,0
			DEFB 1,3, 31,31,31,31,31,31,31,31
			DEFB 2,0, 255,255,255,255,255,255,255,255
			DEFB 2,1, 192,224,240,248,252,252,255,255
			DEFB 2,2, 0,0,0,0,0,0,255,255
			DEFB 2,3, 31,31,31,31,31,31,255,255
			DEFB 3,0, 255,255,255,255,255,255,255,255
			DEFB 3,1, 255,255,255,255,255,255,255,255
			DEFB 3,2, 255,255,255,255,255,255,255,255
			DEFB 3,3, 255,255,255,255,255,255,255,255

GUN_UP_LEFT
			DEFB 13
			DEFB 0,0, 0,2,7,14,4,2,1,1
			DEFB 0,1, 0,0,0,128,64,255,176,28
			DEFB 0,2, 0,0,0,0,0,240,8,4
			DEFB 1,0, 1,3,6,4,4,4,4,4
			DEFB 1,1, 142,219,113,51,30,12,4,2
			DEFB 1,2, 2,25,164,226,98,50,28,12
			DEFB 1,3, 0,0,128,128,192,192,192,192
			DEFB 2,0, 4,4,4,4,2,1,0,0
			DEFB 2,1, 15,18,17,17,9,6,128,64
			DEFB 2,2, 5,138,213,43,23,46,92,184
			DEFB 2,3, 192,192,192,128,0,0,0,0
			DEFB 3,1, 63,0,0,0,0,0,0,0
			DEFB 3,2, 240,0,0,0,0,0,0,0

GUN_UP_LEFT_MASK
			DEFB 16
			DEFB 0,0, 255,253,248,240,248,252,254,254
			DEFB 0,1, 255,255,255,127,63,0,0,0
			DEFB 0,2, 255,255,255,255,255,15,7,3
			DEFB 0,3, 255,255,255,255,255,255,255,255
			DEFB 1,0, 254,252,248,248,248,248,248,248
			DEFB 1,1, 0,0,0,0,0,0,0,0
			DEFB 1,2, 1,0,0,0,0,0,0,0
			DEFB 1,3, 255,255,127,127,63,63,63,63
			DEFB 2,0, 248,248,248,248,252,254,255,255
			DEFB 2,1, 0,0,0,0,0,0,0,128
			DEFB 2,2, 0,0,0,0,0,1,3,7
			DEFB 2,3, 63,63,63,127,255,255,255,255
			DEFB 3,0, 255,255,255,255,255,255,255,255
			DEFB 3,1, 192,255,255,255,255,255,255,255
			DEFB 3,2, 15,255,255,255,255,255,255,255
			DEFB 3,3, 255,255,255,255,255,255,255,255


WORK
			DEFB 80
			DEFB 0,0, 1,2,6,10,19,226,166,170
			DEFB 0,1, 255,128,128,159,32,64,128,128
			DEFB 0,2, 255,0,0,255,1,0,0,0
			DEFB 0,3, 255,64,64,64,160,208,104,100
			DEFB 0,4, 255,4,28,36,36,36,36,36
			DEFB 0,5, 255,0,124,254,254,124,0,0
			DEFB 0,6, 255,24,44,22,14,22,14,22
			DEFB 0,7, 192,96,80,72,68,71,69,69
			DEFB 1,0, 178,226,162,162,162,162,162,162
			DEFB 1,1, 128,128,128,128,128,64,32,31
			DEFB 1,2, 0,0,0,0,0,0,1,255
			DEFB 1,3, 98,98,98,98,98,226,195,134
			DEFB 1,4, 36,42,41,48,32,64,255,1
			DEFB 1,5, 0,170,255,170,170,170,0,0
			DEFB 1,6, 46,124,248,112,255,224,224,240
			DEFB 1,7, 69,69,69,69,197,53,13,7
			DEFB 2,0, 166,170,179,226,162,163,164,168
			DEFB 2,1, 31,0,0,128,128,255,151,150
			DEFB 2,2, 255,0,0,0,0,255,51,102
			DEFB 2,3, 10,18,34,66,66,254,115,102
			DEFB 2,4, 109,217,217,145,73,1,255,102
			DEFB 2,5, 0,0,0,0,0,0,0,1
			DEFB 2,6, 239,240,232,243,234,240,235,242
			DEFB 2,7, 255,1,1,49,33,1,49,33
			DEFB 3,0, 176,191,128,128,128,255,128,128
			DEFB 3,1, 148,245,151,150,148,149,87,151
			DEFB 3,2, 204,153,51,102,204,153,51,255
			DEFB 3,3, 204,217,115,102,204,223,127,255
			DEFB 3,4, 206,154,50,102,206,154,255,255
			DEFB 3,5, 3,7,15,31,62,125,250,255
			DEFB 3,6, 232,215,160,64,131,2,0,254
			DEFB 3,7, 1,255,1,1,49,33,1,49
			DEFB 4,0, 129,130,132,140,148,164,164,164
			DEFB 4,1, 20,28,20,36,68,68,68,68
			DEFB 4,2, 0,10,42,106,106,106,42,10
			DEFB 4,3, 6,7,134,199,199,192,128,0
			DEFB 4,4, 128,0,128,0,255,205,153,179
			DEFB 4,5, 146,146,146,0,255,0,0,7
			DEFB 4,6, 75,74,74,2,194,98,95,66
			DEFB 4,7, 33,129,65,49,41,37,35,161
			DEFB 5,0, 164,164,164,164,164,164,164,164
			DEFB 5,1, 68,68,68,68,68,71,68,79
			DEFB 5,2, 0,0,0,1,2,252,4,116
			DEFB 5,3, 0,127,128,0,0,31,32,67
			DEFB 5,4, 231,255,179,153,205,255,0,240
			DEFB 5,5, 4,0,135,68,64,127,192,187
			DEFB 5,6, 66,66,66,66,66,194,34,146
			DEFB 5,7, 97,33,33,33,33,33,33,33
			DEFB 6,0, 164,164,167,164,168,177,225,129
			DEFB 6,1, 84,100,198,0,255,0,255,0
			DEFB 6,2, 68,69,102,4,248,0,255,0
			DEFB 6,3, 134,13,15,7,0,0,255,0
			DEFB 6,4, 248,252,252,248,0,0,255,0
			DEFB 6,5, 162,162,179,128,127,0,255,0
			DEFB 6,6, 10,6,3,0,255,0,255,0
			DEFB 6,7, 33,33,225,17,137,133,195,225
			DEFB 7,0, 129,129,128,128,128,128,128,255
			DEFB 7,1, 0,128,64,32,16,16,16,240
			DEFB 7,2, 255,247,162,128,128,162,255,255
			DEFB 7,3, 129,129,129,129,129,129,129,129
			DEFB 7,4, 255,31,91,31,219,31,255,255
			DEFB 7,5, 255,17,117,17,221,17,255,255
			DEFB 7,6, 0,1,3,7,15,15,15,15
			DEFB 7,7, 225,225,225,225,193,129,1,255
			DEFB 8,0, 128,128,128,128,128,64,96,80
			DEFB 8,1, 16,16,16,16,16,16,16,16
			DEFB 8,2, 0,255,255,255,255,255,255,255
			DEFB 8,3, 0,255,255,255,255,255,255,255
			DEFB 8,4, 0,255,255,255,255,255,255,255
			DEFB 8,5, 0,255,255,255,255,255,255,255
			DEFB 8,6, 15,15,15,15,15,15,15,15
			DEFB 8,7, 1,1,1,1,1,3,5,9
			DEFB 9,0, 80,72,72,120,8,15,0,0
			DEFB 9,1, 16,16,16,16,16,240,31,0
			DEFB 9,2, 255,255,255,255,252,240,192,0
			DEFB 9,3, 255,255,225,0,64,0,0,0
			DEFB 9,4, 255,64,0,84,0,0,0,0
			DEFB 9,5, 255,63,15,7,67,3,1,0
			DEFB 9,6, 15,15,15,15,15,15,252,0
			DEFB 9,7, 9,17,17,31,16,240,0,0

FORT_01
			DEFB 200
			DEFB 0,0, 128,0,0,4,32,0,0,16
			DEFB 0,1, 0,130,0,16,2,128,0,0
			DEFB 0,2, 0,1,3,7,15,31,63,127
			DEFB 0,3, 255,85,251,255,255,224,143,63
			DEFB 0,4, 255,85,170,245,255,7,241,252
			DEFB 0,5, 0,128,192,224,240,248,252,254
			DEFB 0,6, 0,0,0,32,0,0,0,0
			DEFB 0,7, 0,128,0,0,0,32,0,0
			DEFB 0,8, 128,0,0,4,32,0,0,16
			DEFB 0,9, 0,130,0,16,2,128,0,0
			DEFB 0,10, 0,0,0,32,0,0,0,0
			DEFB 0,11, 0,128,0,0,0,32,0,0
			DEFB 0,12, 0,0,0,32,0,0,0,0
			DEFB 0,13, 0,128,2,0,0,32,0,4
			DEFB 0,14, 0,1,3,7,15,31,63,127
			DEFB 0,15, 255,85,251,255,255,224,143,63
			DEFB 0,16, 255,85,170,245,255,7,241,252
			DEFB 0,17, 0,128,192,224,240,248,252,254
			DEFB 0,18, 0,0,0,32,0,0,0,0
			DEFB 0,19, 0,128,0,0,0,32,0,0
			DEFB 1,0, 2,64,0,0,2,0,8,0
			DEFB 1,1, 0,8,0,64,4,0,0,8
			DEFB 1,2, 190,254,190,222,174,222,174,214
			DEFB 1,3, 112,224,192,192,192,192,192,96
			DEFB 1,4, 6,1,1,1,1,1,1,2
			DEFB 1,5, 127,127,127,127,127,127,127,127
			DEFB 1,6, 0,64,0,0,0,0,0,0
			DEFB 1,7, 0,0,128,0,4,0,0,0
			DEFB 1,8, 2,64,0,0,2,0,8,0
			DEFB 1,9, 0,8,0,64,4,0,0,8
			DEFB 1,10, 0,64,0,0,0,0,16,0
			DEFB 1,11, 0,0,128,0,4,0,0,0
			DEFB 1,12, 4,64,0,0,2,0,16,0
			DEFB 1,13, 0,0,32,0,4,0,0,0
			DEFB 1,14, 190,254,190,222,174,222,174,214
			DEFB 1,15, 112,224,192,192,192,192,192,96
			DEFB 1,16, 6,1,1,1,1,1,1,2
			DEFB 1,17, 127,127,127,127,127,127,127,127
			DEFB 1,18, 0,64,0,0,0,0,16,0
			DEFB 1,19, 0,0,128,0,4,0,0,0
			DEFB 2,0, 0,0,0,32,0,0,0,0
			DEFB 2,1, 0,128,0,0,0,32,0,0
			DEFB 2,2, 171,149,138,197,162,145,136,132
			DEFB 2,3, 48,143,224,127,175,85,255,0
			DEFB 2,4, 12,241,7,255,255,95,255,0
			DEFB 2,5, 253,249,241,227,199,141,27,53
			DEFB 2,6, 127,199,64,64,127,64,64,127
			DEFB 2,7, 255,140,12,12,252,12,12,252
			DEFB 2,8, 255,144,128,128,144,255,128,144
			DEFB 2,9, 255,16,0,0,16,255,0,16
			DEFB 2,10, 255,8,0,0,8,255,0,8
			DEFB 2,11, 255,9,1,1,9,255,1,9
			DEFB 2,12, 255,17,16,16,31,16,16,31
			DEFB 2,13, 255,227,3,3,255,3,3,255
			DEFB 2,14, 171,149,138,197,162,145,136,132
			DEFB 2,15, 48,143,224,127,175,85,255,0
			DEFB 2,16, 12,241,7,255,255,95,255,0
			DEFB 2,17, 253,249,241,227,199,141,25,49
			DEFB 2,18, 128,0,0,4,32,0,0,16
			DEFB 2,19, 0,130,0,16,2,128,0,0
			DEFB 3,0, 0,64,0,0,0,0,16,0
			DEFB 3,1, 0,0,128,0,4,0,0,0
			DEFB 3,2, 130,129,160,160,160,164,164,164
			DEFB 3,3, 0,0,255,63,66,64,64,127
			DEFB 3,4, 0,0,255,255,170,86,10,254
			DEFB 3,5, 107,213,171,69,3,1,3,1
			DEFB 3,6, 63,0,255,0,0,28,28,255
			DEFB 3,7, 252,0,255,0,0,113,113,255
			DEFB 3,8, 255,0,255,0,0,199,199,255
			DEFB 3,9, 255,0,255,0,0,28,28,255
			DEFB 3,10, 255,0,255,0,0,113,113,255
			DEFB 3,11, 255,0,255,0,0,199,199,255
			DEFB 3,12, 15,0,255,0,0,28,28,255
			DEFB 3,13, 255,0,255,0,0,112,112,255
			DEFB 3,14, 130,129,128,128,128,128,128,128
			DEFB 3,15, 0,0,255,63,64,64,64,127
			DEFB 3,16, 0,0,255,255,2,2,2,254
			DEFB 3,17, 97,193,133,5,5,37,37,37
			DEFB 3,18, 2,64,0,0,2,0,8,0
			DEFB 3,19, 0,8,0,64,4,0,0,8
			DEFB 4,0, 64,8,0,4,32,0,0,16
			DEFB 4,1, 0,2,128,16,2,128,0,4
			DEFB 4,2, 164,164,164,164,132,132,132,128
			DEFB 4,3, 64,64,64,127,64,73,64,192
			DEFB 4,4, 3,2,2,255,2,38,2,3
			DEFB 4,5, 2,133,72,49,168,97,40,33
			DEFB 4,6, 32,4,32,4,32,0,39,4
			DEFB 4,7, 130,16,130,16,130,0,255,0
			DEFB 4,8, 8,65,8,65,8,0,255,0
			DEFB 4,9, 32,4,32,4,32,0,255,0
			DEFB 4,10, 130,16,130,16,130,0,255,0
			DEFB 4,11, 8,65,8,65,8,0,255,0
			DEFB 4,12, 32,4,32,4,32,0,255,0
			DEFB 4,13, 130,16,130,16,130,0,242,16
			DEFB 4,14, 64,33,18,76,5,70,4,68
			DEFB 4,15, 192,64,64,255,64,82,64,192
			DEFB 4,16, 2,2,2,254,2,74,3,2
			DEFB 4,17, 37,37,37,37,33,35,33,3
			DEFB 4,18, 0,128,2,0,0,32,0,4
			DEFB 4,19, 0,128,2,0,0,32,0,4
			DEFB 5,0, 2,64,0,16,2,64,8,0
			DEFB 5,1, 32,0,1,64,4,0,128,8
			DEFB 5,2, 128,128,128,128,128,128,128,128
			DEFB 5,3, 64,64,64,73,64,192,64,64
			DEFB 5,4, 2,2,2,38,2,3,2,2
			DEFB 5,5, 40,97,40,49,40,33,40,97
			DEFB 5,6, 36,4,36,4,36,4,36,4
			DEFB 5,7, 130,16,130,16,130,16,130,16
			DEFB 5,8, 8,64,25,89,0,65,24,89
			DEFB 5,9, 32,0,153,153,0,4,32,4
			DEFB 5,10, 130,0,153,153,0,16,130,16
			DEFB 5,11, 8,1,152,153,0,65,24,89
			DEFB 5,12, 32,4,32,4,32,4,32,4
			DEFB 5,13, 146,16,146,16,146,16,146,16
			DEFB 5,14, 4,70,4,76,4,68,4,70
			DEFB 5,15, 64,64,64,82,64,192,64,64
			DEFB 5,16, 2,2,2,74,2,3,2,2
			DEFB 5,17, 1,3,5,11,5,11,21,43
			DEFB 5,18, 254,255,255,255,255,255,255,255
			DEFB 5,19, 0,128,192,224,240,248,252,252
			DEFB 6,0, 0,1,3,7,15,31,63,127
			DEFB 6,1, 255,85,168,64,128,0,0,255
			DEFB 6,2, 128,65,35,23,15,31,63,127
			DEFB 6,3, 255,85,251,255,255,224,143,63
			DEFB 6,4, 255,85,170,245,255,7,241,252
			DEFB 6,5, 40,177,232,225,248,249,252,255
			DEFB 6,6, 36,4,36,4,36,4,36,4
			DEFB 6,7, 130,16,130,16,130,16,130,16
			DEFB 6,8, 0,65,24,89,0,65,24,89
			DEFB 6,9, 32,4,32,4,32,4,32,4
			DEFB 6,10, 130,16,130,16,130,16,130,16
			DEFB 6,11, 0,65,24,89,0,65,24,89
			DEFB 6,12, 32,4,32,4,32,4,32,4
			DEFB 6,13, 146,16,146,16,146,16,146,16
			DEFB 6,14, 4,77,7,71,15,95,63,127
			DEFB 6,15, 255,85,251,255,255,224,143,63
			DEFB 6,16, 255,85,170,245,255,7,241,252
			DEFB 6,17, 21,170,212,232,240,248,252,254
			DEFB 6,18, 255,170,21,2,1,0,0,255
			DEFB 6,19, 254,254,254,190,222,174,246,250
			DEFB 7,0, 255,254,253,250,245,234,212,168
			DEFB 7,1, 85,170,80,160,64,0,0,127
			DEFB 7,2, 190,254,190,222,174,222,174,214
			DEFB 7,3, 112,224,192,192,192,192,192,96
			DEFB 7,4, 6,1,1,1,1,1,1,2
			DEFB 7,5, 127,127,127,127,127,127,127,127
			DEFB 7,6, 36,4,36,4,36,4,36,4
			DEFB 7,7, 130,16,130,16,130,16,130,16
			DEFB 7,8, 0,64,25,89,0,65,8,65
			DEFB 7,9, 32,0,153,153,0,4,32,4
			DEFB 7,10, 130,0,153,153,0,16,130,16
			DEFB 7,11, 0,1,152,153,0,65,8,65
			DEFB 7,12, 32,4,32,4,32,4,32,4
			DEFB 7,13, 146,16,146,16,146,16,146,16
			DEFB 7,14, 190,254,190,222,174,222,174,214
			DEFB 7,15, 112,224,192,192,192,192,192,96
			DEFB 7,16, 6,1,1,1,1,1,1,2
			DEFB 7,17, 127,127,127,127,127,127,127,127
			DEFB 7,18, 170,85,10,5,2,0,0,254
			DEFB 7,19, 253,123,189,95,173,87,43,21
			DEFB 8,0, 212,169,209,161,193,161,193,131
			DEFB 8,1, 128,0,15,31,63,127,255,255
			DEFB 8,2, 171,149,138,197,162,145,136,132
			DEFB 8,3, 48,143,224,127,175,85,255,0
			DEFB 8,4, 12,241,7,255,255,95,255,0
			DEFB 8,5, 253,249,241,227,199,141,27,53
			DEFB 8,6, 36,4,36,4,36,4,36,4
			DEFB 8,7, 130,16,130,16,130,16,130,16
			DEFB 8,8, 8,65,8,65,8,65,8,65
			DEFB 8,9, 32,4,32,4,32,4,32,4
			DEFB 8,10, 130,16,130,16,130,16,130,16
			DEFB 8,11, 8,65,8,65,8,65,8,65
			DEFB 8,12, 32,4,32,4,32,4,32,4
			DEFB 8,13, 146,16,146,16,146,16,146,16
			DEFB 8,14, 171,149,138,197,162,145,136,132
			DEFB 8,15, 48,143,224,127,175,85,255,0
			DEFB 8,16, 12,241,7,255,255,95,255,0
			DEFB 8,17, 253,249,241,227,199,141,25,49
			DEFB 8,18, 255,255,255,255,255,255,255,255
			DEFB 8,19, 43,149,139,133,131,133,131,193
			DEFB 9,0, 193,131,133,131,133,139,149,255
			DEFB 9,1, 255,255,248,240,224,192,128,0
			DEFB 9,2, 130,129,160,160,160,164,164,164
			DEFB 9,3, 0,0,255,63,66,64,64,64
			DEFB 9,4, 0,0,255,255,170,86,10,6
			DEFB 9,5, 107,213,163,4,8,16,32,64
			DEFB 9,6, 127,64,192,64,66,127,66,66
			DEFB 9,7, 242,16,31,28,26,252,24,31
			DEFB 9,8, 8,65,255,64,64,80,64,255
			DEFB 9,9, 32,4,255,0,0,16,0,255
			DEFB 9,10, 130,16,255,0,0,8,0,255
			DEFB 9,11, 8,65,255,2,2,10,2,255
			DEFB 9,12, 47,8,248,8,8,15,8,248
			DEFB 9,13, 254,2,3,3,67,255,67,67
			DEFB 9,14, 130,129,192,160,80,136,4,130
			DEFB 9,15, 0,0,255,191,128,128,128,128
			DEFB 9,16, 0,0,255,255,2,2,2,2
			DEFB 9,17, 97,193,133,5,5,37,37,37
			DEFB 9,18, 255,255,255,255,255,255,255,255
			DEFB 9,19, 131,193,161,193,161,209,169,255

FORT_02
			DEFB 160
			DEFB 10,0, 0,0,0,32,0,0,0,0
			DEFB 10,1, 0,128,0,0,0,32,0,0
			DEFB 10,2, 164,164,164,164,132,132,132,128
			DEFB 10,3, 72,73,74,73,74,73,74,73
			DEFB 10,4, 255,136,138,136,136,138,136,136
			DEFB 10,5, 255,4,20,4,4,20,4,4
			DEFB 10,6, 194,66,64,64,64,64,64,64
			DEFB 10,7, 26,28,26,28,24,28,24,24
			DEFB 10,8, 80,64,64,64,80,64,127,0
			DEFB 10,9, 16,0,0,0,16,0,255,0
			DEFB 10,10, 8,0,0,0,8,0,255,0
			DEFB 10,11, 10,2,2,2,10,2,254,0
			DEFB 10,12, 8,8,8,8,8,8,8,8
			DEFB 10,13, 67,67,3,3,3,3,3,3
			DEFB 10,14, 255,96,168,96,160,40,160,32
			DEFB 10,15, 255,17,81,17,17,81,17,17
			DEFB 10,16, 18,146,210,146,210,146,210,146
			DEFB 10,17, 37,37,37,37,33,33,35,1
			DEFB 10,18, 255,255,255,255,255,255,255,255
			DEFB 10,19, 0,128,192,224,240,248,252,252
			DEFB 11,0, 0,1,3,7,15,31,63,127
			DEFB 11,1, 255,85,168,64,128,0,0,255
			DEFB 11,2, 128,128,128,128,128,128,128,128
			DEFB 11,3, 74,73,66,65,66,69,74,69
			DEFB 11,4, 138,136,255,136,136,138,136,136
			DEFB 11,5, 20,4,255,4,4,20,4,4
			DEFB 11,6, 127,64,192,64,64,69,127,63
			DEFB 11,7, 248,24,63,24,184,88,248,248
			DEFB 11,8, 0,3,255,3,3,3,3,3
			DEFB 11,9, 0,255,255,255,255,255,255,255
			DEFB 11,10, 0,255,255,255,255,255,255,255
			DEFB 11,11, 0,192,255,192,192,192,192,192
			DEFB 11,12, 15,8,248,8,8,8,15,7
			DEFB 11,13, 255,3,7,3,23,171,255,255
			DEFB 11,14, 40,32,255,32,32,40,32,32
			DEFB 11,15, 81,17,255,17,17,81,17,17
			DEFB 11,16, 210,146,194,162,194,162,210,162
			DEFB 11,17, 3,5,3,5,11,5,11,21
			DEFB 11,18, 255,170,21,2,1,0,0,255
			DEFB 11,19, 254,254,254,190,222,174,246,250
			DEFB 12,0, 255,254,253,250,245,234,212,168
			DEFB 12,1, 85,170,80,160,64,0,0,127
			DEFB 12,2, 192,160,144,136,132,130,193,128
			DEFB 12,3, 66,65,66,65,64,65,255,128
			DEFB 12,4, 138,248,143,128,255,128,128,128
			DEFB 12,5, 20,4,255,0,255,0,0,0
			DEFB 12,6, 0,0,255,0,192,64,127,64
			DEFB 12,7, 0,0,255,0,31,26,253,26
			DEFB 12,8, 0,0,255,64,208,255,64,80
			DEFB 12,9, 0,0,255,0,16,255,0,16
			DEFB 12,10, 0,0,255,0,8,255,0,8
			DEFB 12,11, 0,0,255,2,11,254,2,10
			DEFB 12,12, 0,0,255,0,248,8,15,8
			DEFB 12,13, 0,0,255,0,1,1,255,1
			DEFB 12,14, 40,32,255,0,255,170,208,160
			DEFB 12,15, 81,31,241,1,255,1,1,1
			DEFB 12,16, 194,162,194,130,194,130,255,129
			DEFB 12,17, 43,21,41,81,33,67,129,1
			DEFB 12,18, 170,85,10,5,2,0,0,254
			DEFB 12,19, 253,123,189,95,173,87,43,21
			DEFB 13,0, 212,169,209,161,193,161,193,131
			DEFB 13,1, 128,0,15,31,63,127,255,255
			DEFB 13,2, 136,128,129,128,192,128,136,128
			DEFB 13,3, 128,128,128,128,162,128,128,128
			DEFB 13,4, 255,129,129,129,129,129,129,129
			DEFB 13,5, 0,192,224,255,255,255,255,255
			DEFB 13,6, 64,64,64,192,127,10,0,0
			DEFB 13,7, 28,24,28,31,240,0,255,139
			DEFB 13,8, 64,64,80,255,0,0,255,0
			DEFB 13,9, 0,0,16,255,0,0,255,0
			DEFB 13,10, 0,0,8,255,0,0,255,0
			DEFB 13,11, 2,2,10,255,0,0,255,0
			DEFB 13,12, 8,8,8,248,15,0,255,209
			DEFB 13,13, 1,1,1,1,255,0,0,0
			DEFB 13,14, 192,128,192,255,0,0,0,0
			DEFB 13,15, 255,129,129,129,129,129,129,129
			DEFB 13,16, 129,129,129,129,197,129,129,129
			DEFB 13,17, 17,1,1,131,1,1,17,1
			DEFB 13,18, 255,255,255,255,255,255,255,255
			DEFB 13,19, 43,149,139,133,131,133,131,193
			DEFB 14,0, 193,131,133,131,133,139,149,255
			DEFB 14,1, 255,255,248,240,224,192,128,0
			DEFB 14,2, 129,192,128,200,224,240,249,252
			DEFB 14,3, 128,128,162,128,128,128,128,128
			DEFB 14,4, 131,129,131,129,131,133,131,133
			DEFB 14,5, 255,255,255,255,255,255,255,255
			DEFB 14,6, 0,0,0,0,255,0,64,64
			DEFB 14,7, 149,163,197,139,133,171,159,191
			DEFB 14,8, 0,4,4,4,4,4,0,0
			DEFB 14,9, 0,8,8,8,8,8,0,0
			DEFB 14,10, 0,16,16,16,16,16,0,0
			DEFB 14,11, 0,32,32,32,32,32,0,0
			DEFB 14,12, 169,213,171,193,161,209,185,245
			DEFB 14,13, 0,0,0,0,255,0,2,2
			DEFB 14,14, 0,0,0,0,255,0,0,0
			DEFB 14,15, 129,129,131,129,131,129,131,133
			DEFB 14,16, 129,129,197,129,129,129,129,129
			DEFB 14,17, 1,131,1,1,19,5,11,149
			DEFB 14,18, 255,255,255,255,255,255,255,255
			DEFB 14,19, 131,193,161,193,161,209,169,255
			DEFB 15,0, 0,128,2,0,0,32,0,4
			DEFB 15,1, 0,128,2,0,0,32,0,4
			DEFB 15,2, 127,63,31,15,7,3,1,0
			DEFB 15,3, 162,128,128,255,170,208,160,255
			DEFB 15,4, 139,149,255,129,129,131,129,131
			DEFB 15,5, 255,255,255,255,255,255,255,255
			DEFB 15,6, 64,64,64,16,240,248,248,255
			DEFB 15,7, 255,254,252,248,240,224,192,128
			DEFB 15,8, 255,0,0,0,0,0,0,0
			DEFB 15,9, 255,0,0,0,128,1,0,0
			DEFB 15,10, 255,0,0,0,0,4,0,0
			DEFB 15,11, 255,0,0,0,0,4,0,0
			DEFB 15,12, 255,127,63,31,15,7,3,1
			DEFB 15,13, 2,2,2,0,0,0,0,255
			DEFB 15,14, 0,0,0,0,0,0,0,255
			DEFB 15,15, 131,149,255,129,129,129,129,131
			DEFB 15,16, 197,129,129,255,170,133,130,255
			DEFB 15,17, 43,87,175,95,191,127,255,255
			DEFB 15,18, 254,252,248,240,224,224,192,128
			DEFB 15,19, 0,128,2,0,0,32,0,4
			DEFB 16,0, 128,0,0,4,32,0,0,16
			DEFB 16,1, 0,130,0,16,2,128,0,0
			DEFB 16,2, 128,0,0,4,32,0,0,16
			DEFB 16,3, 0,130,0,16,2,128,0,0
			DEFB 16,4, 133,131,133,139,149,255,129,131
			DEFB 16,5, 255,255,255,255,255,255,255,255
			DEFB 16,6, 252,248,248,248,252,248,252,248
			DEFB 16,7, 0,128,0,1,0,0,0,64
			DEFB 16,8, 32,0,0,0,0,0,8,0
			DEFB 16,9, 0,64,0,0,0,0,0,16
			DEFB 16,10, 0,128,0,0,0,0,0,0
			DEFB 16,11, 64,0,1,128,0,0,0,0
			DEFB 16,12, 0,16,0,0,0,0,0,4
			DEFB 16,13, 0,32,66,0,0,0,0,0
			DEFB 16,14, 0,128,2,0,0,32,0,4
			DEFB 16,15, 133,131,133,139,149,255,129,131
			DEFB 16,16, 255,255,255,255,255,255,255,255
			DEFB 16,17, 255,254,254,252,252,248,248,248
			DEFB 16,18, 0,0,0,32,0,0,0,0
			DEFB 16,19, 0,128,0,0,0,32,0,0
			DEFB 17,0, 2,64,0,0,2,0,8,0
			DEFB 17,1, 0,8,0,64,4,0,0,8
			DEFB 17,2, 2,64,0,0,2,0,8,0
			DEFB 17,3, 0,8,0,64,4,0,0,8
			DEFB 17,4, 129,131,133,131,133,139,149,255
			DEFB 17,5, 255,255,255,255,255,252,240,0
			DEFB 17,6, 240,240,224,192,2,0,0,0
			DEFB 17,7, 0,2,0,0,0,16,0,0
			DEFB 17,8, 0,0,2,0,32,0,0,0
			DEFB 17,9, 0,0,0,0,0,0,129,0
			DEFB 17,10, 32,0,0,0,0,4,0,0
			DEFB 17,11, 2,0,64,0,0,0,2,0
			DEFB 17,12, 0,0,16,0,0,0,0,0
			DEFB 17,13, 1,0,0,0,128,0,0,0
			DEFB 17,14, 0,128,2,0,0,32,0,4
			DEFB 17,15, 129,131,133,131,133,139,149,255
			DEFB 17,16, 255,255,255,255,255,252,240,0
			DEFB 17,17, 240,240,224,192,128,0,0,0
			DEFB 17,18, 0,64,0,0,0,0,16,0
			DEFB 17,19, 0,0,128,0,4,0,0,0

FORT_ENEMY_ENTRY
			DEFB 64
			DEFB 0,0, 0,0,0,0,255,0,64,64
			DEFB 0,1, 149,163,197,139,133,171,159,191
			DEFB 0,2, 0,4,4,4,4,4,0,0
			DEFB 0,3, 0,0,0,0,31,48,80,144
			DEFB 0,4, 0,0,0,0,248,12,10,9
			DEFB 0,5, 0,32,32,32,32,32,0,0
			DEFB 0,6, 169,213,171,193,161,209,185,245
			DEFB 0,7, 0,0,0,0,255,0,2,2
			DEFB 1,0, 64,64,64,16,240,248,248,255
			DEFB 1,1, 255,254,252,248,240,224,192,128
			DEFB 1,2, 255,0,0,0,0,0,64,0
			DEFB 1,3, 144,144,144,147,147,151,147,145
			DEFB 1,4, 9,9,9,201,201,233,201,137
			DEFB 1,5, 255,192,224,224,224,228,224,224
			DEFB 1,6, 255,127,63,31,15,7,3,1
			DEFB 1,7, 2,2,2,0,0,0,0,255
			DEFB 2,0, 252,248,248,248,252,248,253,250
			DEFB 2,1, 0,128,34,32,32,33,35,127
			DEFB 2,2, 0,16,0,0,0,0,4,255
			DEFB 2,3, 144,144,159,161,192,128,128,128
			DEFB 2,4, 9,9,249,85,43,5,3,1
			DEFB 2,5, 224,224,225,224,224,224,226,255
			DEFB 2,6, 0,16,0,0,0,0,4,254
			DEFB 2,7, 0,32,66,128,128,128,136,118
			DEFB 3,0, 240,240,232,212,42,93,235,85
			DEFB 3,1, 128,128,255,170,212,160,192,128
			DEFB 3,2, 0,0,255,161,0,0,0,0
			DEFB 3,3, 128,146,146,146,146,18,0,0
			DEFB 3,4, 3,73,73,73,73,72,0,0
			DEFB 3,5, 224,224,255,128,0,0,0,0
			DEFB 3,6, 1,1,255,1,1,1,1,1
			DEFB 3,7, 9,72,144,208,208,162,164,164
			DEFB 4,0, 42,85,42,81,59,21,43,21
			DEFB 4,1, 128,128,128,128,128,128,128,129
			DEFB 4,2, 255,255,255,255,255,255,255,255
			DEFB 4,3, 255,255,255,255,255,255,255,255
			DEFB 4,4, 255,255,255,255,255,255,255,255
			DEFB 4,5, 255,255,255,255,255,255,255,255
			DEFB 4,6, 1,1,1,1,1,3,1,3
			DEFB 4,7, 164,132,132,196,140,140,172,204
			DEFB 5,0, 59,81,42,21,40,29,42,21
			DEFB 5,1, 128,129,130,129,130,133,170,255
			DEFB 5,2, 255,255,255,255,254,254,252,252
			DEFB 5,3, 255,254,192,0,0,0,0,0
			DEFB 5,4, 255,1,0,0,0,0,0,0
			DEFB 5,5, 255,255,31,7,3,1,1,1
			DEFB 5,6, 1,3,5,3,5,11,85,255
			DEFB 5,7, 140,132,128,192,144,178,180,160
			DEFB 6,0, 184,21,43,31,43,23,47,31
			DEFB 6,1, 255,255,255,255,255,255,254,248
			DEFB 6,2, 248,248,240,224,128,0,0,0
			DEFB 6,3, 0,128,2,0,0,32,0,4
			DEFB 6,4, 128,0,0,4,32,0,0,16
			DEFB 6,5, 0,130,0,16,2,128,0,0
			DEFB 6,6, 0,128,2,0,0,32,0,4
			DEFB 6,7, 0,4,4,6,6,6,2,2
			DEFB 7,0, 47,95,47,31,0,0,16,0
			DEFB 7,1, 240,224,192,0,0,8,0,0
			DEFB 7,2, 0,0,0,32,0,1,0,0
			DEFB 7,3, 0,128,0,4,0,0,0,0
			DEFB 7,4, 2,64,0,0,0,0,32,0
			DEFB 7,5, 0,8,0,64,0,2,0,0
			DEFB 7,6, 0,128,2,0,0,0,2,0
			DEFB 7,7, 0,128,2,0,0,8,0,0

FORT_OUR_ENTRY
			DEFB 8
			DEFB 0,0, 255,145,129,129,145,255,129,145
			DEFB 0,1, 255,0,1,3,7,3,3,0
			DEFB 0,2, 255,0,128,192,224,192,192,0
			DEFB 0,3, 255,137,129,129,137,255,129,137
			DEFB 1,0, 255,0,255,0,0,199,199,255
			DEFB 1,1, 0,255,128,156,156,156,156,255
			DEFB 1,2, 0,255,1,113,113,113,113,255
			DEFB 1,3, 255,0,255,0,0,199,199,255

BRIDGE_LEFT_RIGHT
			DEFB 16
			DEFB 0,0, 241,31,81,21,17,17,17,17
			DEFB 0,1, 251,31,81,21,17,17,17,17
			DEFB 0,2, 249,31,81,21,17,17,17,17
			DEFB 0,3, 240,31,81,21,17,17,17,17
			DEFB 1,0, 17,17,17,17,17,17,17,17
			DEFB 1,1, 17,17,17,17,17,17,17,17
			DEFB 1,2, 17,17,17,17,17,17,17,17
			DEFB 1,3, 17,17,17,17,17,17,17,17
			DEFB 2,0, 17,17,17,17,17,17,17,17
			DEFB 2,1, 17,17,17,17,17,17,17,17
			DEFB 2,2, 17,17,17,17,17,17,17,17
			DEFB 2,3, 17,17,17,17,17,17,17,17
			DEFB 3,0, 17,17,17,17,81,21,241,31
			DEFB 3,1, 17,17,17,17,81,21,241,255
			DEFB 3,2, 17,17,17,17,81,21,241,255
			DEFB 3,3, 17,17,17,17,81,21,241,223

BRIDGE_UP_DOWN
			DEFB 16
			DEFB 0,0, 127,64,80,64,255,128,160,128
			DEFB 0,1, 255,0,0,0,255,0,0,0
			DEFB 0,2, 255,0,0,0,255,0,0,0
			DEFB 0,3, 255,1,5,1,255,3,11,3
			DEFB 1,0, 255,64,208,64,255,128,160,128
			DEFB 1,1, 255,0,0,0,255,0,0,0
			DEFB 1,2, 255,0,0,0,255,0,0,0
			DEFB 1,3, 255,1,5,1,255,3,11,3
			DEFB 2,0, 255,64,208,64,255,128,160,128
			DEFB 2,1, 255,0,0,0,255,0,0,0
			DEFB 2,2, 255,0,0,0,255,0,0,0
			DEFB 2,3, 255,1,5,1,255,3,11,3
			DEFB 3,0, 255,64,80,64,255,128,160,128
			DEFB 3,1, 255,0,0,0,255,0,0,0
			DEFB 3,2, 255,0,0,0,255,0,0,0
			DEFB 3,3, 255,1,5,1,255,2,10,2