;   ( .. )  8000.
;        ,   
; , 2008-2020
;  TASM - A Table Driven Cross Assembler for the MSDOS* Environment (tasm 3.01  3.2)


Begin		.equ	05000h

ClrTransTab	.equ	0EF00h

		.ORG Begin-26h

		.DB 1Fh, 0A6h, 0DEh, 0BAh, 0CCh, 13h, 7Dh, 74h
		.DB 0D0h, 0D0h, 0D0h, 0D0h, 0D0h, 0D0h, 0D0h, 0D0h, 0D0h, 0D0h
		.DB "ZXSCR "
		.DB 1Fh, 0A6h, 0DEh, 0BAh, 0CCh, 13h, 7Dh, 74h
		.DW Begin


;  
		.DW zxscr+6912
; 8x1
;		.DW zxscr+12288
; 8x2
;		.DW zxscr+9216

		
		.DW Begin

Start:
		push	psw
		push	b
		push	d
		push	h
		mvi	a,2
		call	006Ah		;  2
		
		lxi d,ClrTransTab
MakeClrTransTab:		
		call ClrTrans
		stax d
		inr e
		jnz MakeClrTransTab


;   6912
		lxi	h,zxscr
		lxi	d,0
		call zx6144nonLinear
		lxi	d,2000h	; CT  8000   2 (   )
		call zxatr768

;timex  8x1; 12288
;		lxi	h,zxscr
;		lxi	d,0
;		call zx6144nonLinear
;		lxi	d,2000h
;		call zxatr6144nonLinear

;mlt  8x1; 12288
;		lxi	h,zxscr
;		lxi	d,0
;		call zx6144nonLinear
;		lxi	d,2000h
;		call zxatr6144Linear

;mc  8x1; 12288
;		lxi	h,zxscr
;		lxi	d,0
;		call zx6144Linear
;		lxi	d,2000h
;		call zxatr6144Linear

;ifl  8x2; 9216
;		lxi	h,zxscr
;		lxi	d,0
;		call zx6144nonLinear
;		lxi	d,2000h
;		call zxatr3072Linear


KeyWait:	mvi	a,6
		call	0047h
		mov	c,a
		mvi	a,00100000b	;F1
		ana	c
		jnz	KeyWait

Exit:
		pop	h
		pop	d
		pop	b
		pop	psw
		jmp	0


zx6144nonLinear:
;
		mvi	a,3
ZxScreen:
		push psw
		push h
		mvi	b,8		;  8 
ZxThird:
		push h
		mvi	c,32		;32   
ZxLine:
		push h
		mov a,m\ stax d\ inr h\ inx d
		mov a,m\ stax d\ inr h\ inx d
		mov a,m\ stax d\ inr h\ inx d
		mov a,m\ stax d\ inr h\ inx d
		mov a,m\ stax d\ inr h\ inx d
		mov a,m\ stax d\ inr h\ inx d
		mov a,m\ stax d\ inr h\ inx d
		mov a,m\ stax d\ inx d
		pop	h
		inx	h
		dcr	c
		jnz	ZxLine
		pop	h
		push	d
		lxi	d,32
		dad	d
		pop	d
		dcr	b
		jnz	ZxThird
		pop	h
		push	d
		lxi	d,2048
		dad	d
		pop	d
		pop	psw
		dcr	a
		jnz	ZxScreen
		ret

zx6144Linear:
		mvi	a,3
		lxi b,32
ZxScreenLin:
		push psw
		push h
		mvi	a,8		;  8 
ZxThirdLin:
		push psw
		push h
		mvi	a,32		;32   
ZxLineLin:
		push psw
		push h
		mov	a,m\ stax d\ dad b\ inx d
		mov	a,m\ stax d\ dad b\ inx d
		mov	a,m\ stax d\ dad b\ inx d
		mov	a,m\ stax d\ dad b\ inx d
		mov	a,m\ stax d\ dad b\ inx d
		mov	a,m\ stax d\ dad b\ inx d
		mov	a,m\ stax d\ dad b\ inx d
		mov	a,m\ stax d\ inx d
		pop h
		inx h
		pop psw
		dcr a
		jnz	ZxLineLin
		pop	h
		inr h
		pop psw
		dcr	a
		jnz	ZxThirdLin
		pop	h
		push d
		lxi	d,2048
		dad	d
		pop	d
		pop	psw
		dcr	a
		jnz	ZxScreenLin
		ret		

zxatr6144Linear:
		mvi	a,3
		mvi b,ClrTransTab>>8
ZxAtrScreenLin:
		push psw
		push h
		mvi	a,8		;  8 
ZxAtrThirdLin:
		push psw
		push h
		mvi	a,32		;32   
ZxAtrLineLin:
		push psw
		push h
		mov	c,m\ ldax b\ stax d\ push d\ lxi d,32\ dad d\ pop d\ inx d
		mov	c,m\ ldax b\ stax d\ push d\ lxi d,32\ dad d\ pop d\ inx d
		mov	c,m\ ldax b\ stax d\ push d\ lxi d,32\ dad d\ pop d\ inx d
		mov	c,m\ ldax b\ stax d\ push d\ lxi d,32\ dad d\ pop d\ inx d
		mov	c,m\ ldax b\ stax d\ push d\ lxi d,32\ dad d\ pop d\ inx d
		mov	c,m\ ldax b\ stax d\ push d\ lxi d,32\ dad d\ pop d\ inx d
		mov	c,m\ ldax b\ stax d\ push d\ lxi d,32\ dad d\ pop d\ inx d
		mov	c,m\ ldax b\ stax d\ inx d
		pop h
		inx h
		pop psw
		dcr a
		jnz	ZxAtrLineLin
		pop	h
		inr h
		pop psw
		dcr	a
		jnz	ZxAtrThirdLin
		pop	h
		push d
		lxi	d,2048
		dad	d
		pop	d
		pop	psw
		dcr	a
		jnz	ZxAtrScreenLin
		ret
		
zxatr6144nonLinear:
		mvi	a,3
		mvi b,ClrTransTab>>8
ZxAtrScreen:
		push psw
		push h
		mvi	a,8		;  8 
ZxAtrThird:
		push psw
		push h
		mvi	a,32		;32   
ZxAtrLine:
		push psw
		push h
		mov	c,m\ ldax b\ stax d\ inr h\ inx d
		mov	c,m\ ldax b\ stax d\ inr h\ inx d
		mov	c,m\ ldax b\ stax d\ inr h\ inx d
		mov	c,m\ ldax b\ stax d\ inr h\ inx d
		mov	c,m\ ldax b\ stax d\ inr h\ inx d
		mov	c,m\ ldax b\ stax d\ inr h\ inx d
		mov	c,m\ ldax b\ stax d\ inr h\ inx d
		mov	c,m\ ldax b\ stax d\ inx d
		pop h
		inx h
		pop psw
		dcr a
		jnz	ZxAtrLine
		pop	h
		push d
		lxi	d,32
		dad	d
		pop	d
		pop psw
		dcr	a
		jnz	ZxAtrThird
		pop	h
		push d
		lxi	d,2048
		dad	d
		pop	d
		pop	psw
		dcr	a
		jnz	ZxAtrScreen
		ret

zxatr3072Linear:
		mvi	a,3
		mvi b,ClrTransTab>>8
ZxAtr3072ScreenLin:
		push psw
		push h
		mvi	a,8		;  8 
ZxAtr3072ThirdLin:
		push psw
		push h
		mvi	a,32		;32   
ZxAtr3072LineLin:
		push psw
		push h
		mov	c,m\ ldax b\ stax d\ push d\ lxi d,32\ dad d\ pop d\ inx d\ stax d\ inx d
		mov	c,m\ ldax b\ stax d\ push d\ lxi d,32\ dad d\ pop d\ inx d\ stax d\ inx d
		mov	c,m\ ldax b\ stax d\ push d\ lxi d,32\ dad d\ pop d\ inx d\ stax d\ inx d
		mov	c,m\ ldax b\ stax d\ inx d\ stax d\ inx d
		pop h
		inx h
		pop psw
		dcr a
		jnz	ZxAtr3072LineLin
		pop	h
		push d
		lxi d,32*4
		dad d
		pop d
		pop psw
		dcr	a
		jnz	ZxAtr3072ThirdLin
		pop	h
		push d
		lxi	d,1024
		dad	d
		pop	d
		pop	psw
		dcr	a
		jnz	ZxAtr3072ScreenLin
		ret

zxatr768:
;
;    HL
		mvi b,ClrTransTab>>8
		xra a
zxatr768_1:
		push psw
		mov c,m\ ldax b
		stax d\ inx d
		stax d\ inx d
		stax d\ inx d
		stax d\ inx d
		stax d\ inx d
		stax d\ inx d
		stax d\ inx d
		stax d\ inx d
		inx	h

		mov c,m\ ldax b
		stax d\ inx d
		stax d\ inx d
		stax d\ inx d
		stax d\ inx d
		stax d\ inx d
		stax d\ inx d
		stax d\ inx d
		stax d\ inx d
		inx	h

		mov c,m\ ldax b
		stax d\ inx d
		stax d\ inx d
		stax d\ inx d
		stax d\ inx d
		stax d\ inx d
		stax d\ inx d
		stax d\ inx d
		stax d\ inx d
		inx	h
		pop psw
		dcr a
		jnz	zxatr768_1
		ret

ClrTrans:
		mov a,e
		ani	00000111b
		lxi	h,ClrTab
		add	l
		mov	l,a
		mov	a,h
		aci	0
		mov	h,a
		mov	c,m		; 

		mov a,e
		rrc
		rrc
		rrc
		ani	00000111b
		lxi	h,ClrTab
		add	l
		mov	l,a
		mov	a,h
		aci	0
		mov	h,a
		mov	a,m		; 
		rlc
		rlc
		rlc
		rlc
		ora	c
		mov	c,a

		mov a,e
		ani	01000000b
		jz	NoBright
Bright:	mvi	a,00010001b
NoBright:
		ora	c
		ret
		

ClrTab:	.db 0		;0  zx -  (0)  8000
		.db 4		;1  zx -  (4)  8000
		.db 8		;2  zx -  (8)  8000
		.db 4+8	;3
		.db 2		;4  zx -  (2)  8000
		.db 4+2	;5
		.db 8+2	;6
		.db 4+8+2	;7

zxscr:
		.end
