; msx  SC2  8000.
;        ,   
; , 2008-2020
;  TASM - A Table Driven Cross Assembler for the MSDOS* Environment (tasm 3.01  3.2)


Begin		.equ	05000h

ClrTransTab	.equ	0EF00h

		.ORG Begin-26h

		.DB 1Fh, 0A6h, 0DEh, 0BAh, 0CCh, 13h, 7Dh, 74h
		.DB 0D0h, 0D0h, 0D0h, 0D0h, 0D0h, 0D0h, 0D0h, 0D0h, 0D0h, 0D0h
		.DB "SC2   "
		.DB 1Fh, 0A6h, 0DEh, 0BAh, 0CCh, 13h, 7Dh, 74h
		.DW Begin,sc2scr+14343,Begin

Start:
		push	psw
		push	b
		push	d
		push	h
		mvi	a,2
		call	006Ah		;  2
		
		lxi d,ClrTransTab
MakeClrTransTab:		
		call ClrTrans
		stax d
		inr e
		jnz MakeClrTransTab

		lxi h,sc2scr+7
		lxi d,0
		lxi b,6144+768
MovLoop1:
		mov a,m
		stax d
		inx h
		inx d
		dcx b
		mov a,b
		ora c
		jnz MovLoop1


		lxi h,6144
		shld SetCounter+1
		lxi h,sc2scr+8192+7
		lxi d,8192
		mvi b,ClrTransTab>>8
MovLoop2:
		mov c,m
		ldax b
		stax d
		inx h
		inx d
		push h
SetCounter:
		lxi h,0
		dcx h
		shld SetCounter+1
		mov a,h
		ora l
		pop h
		jnz MovLoop2

KeyWait:	mvi	a,6
		call	0047h
		mov	c,a
		mvi	a,00100000b	;F1
		ana	c
		jnz	KeyWait

Exit:
		pop	h
		pop	d
		pop	b
		pop	psw
		jmp	0

;  msx->8000
ClrTrans:
		mov a,e
		ani	00001111b
		lxi	h,ClrTab
		add	l
		mov	l,a
		mov	a,h
		aci	0
		mov	h,a
		mov	a,m
		rlc
		rlc
		rlc
		rlc
		mov	c,a		; 

		mov a,e
		rrc
		rrc
		rrc
		rrc
		ani	00001111b
		lxi	h,ClrTab
		add	l
		mov	l,a
		mov	a,h
		aci	0
		mov	h,a
		mov	a,m		; 
		ora	c
		ret

ClrTab:	.db 0		;0  msx
		.db 1		;1  msx
		.db 2		;2  msx
		.db 3		;3  msx
		.db 4		;4  msx
		.db 5		;5  msx
		.db 8		;6  msx  -  (8)  8000
		.db 7		;7  msx
		.db 8		;8  msx
		.db 9		;9  msx
		.db 10	;10  msx
		.db 11	;11  msx
		.db 2		;12  msx -  (2)  8000
		.db 13	;13  msx
		.db 14	;14  msx
		.db 15	;15  msx


sc2scr:
		.end
