;
;------------------------------------------------------;
; music player (new) - super mario bros. -06    ;
;-----------------------------------------------08.2020;
;
pit_init1      .equ  $36
pit_init2      .equ  $76
pit_init3      .equ  $b6
;
;------------------------------------

	.ORG	0100H
;   ᪥
M0000H:	DI
	XRA	A
	OUT	10H		; ⪫. 
;
	MVI	A,0C3H
	STA	0000H		;  
	STA	0038H		;  뢠
	LXI	H,M0000H
	SHLD	0001H
	LXI	H,vsync
	SHLD	0039H
;
	lxi	sp,$dff0

end_program:
  
  mvi  a, pit_init1
  out  $08
  mvi  a, pit_init2
  out  $08
  mvi  a, pit_init3
  out  $08
;
  lxi  h, sound_data  ;
  shld data_pointer   ;
  mvi  a, 30          ;
  sta  wait_counter   ;

  ei

command_line:
  jmp  command_line
;
;============================================
;
vsync:
  push  h
  push  d
  push  b
  push  psw
;
  lxi  h, wait_counter
  dcr  m
  jnz  end_int
;
read_command:
  call get_next_data
  ora  a               ;
  jnz  off_1           ;
  lxi  h, repeat_point ;
  shld data_pointer
  jmp  read_command


off_1:
  rlc
  mov  b,a
  jnc  off_2
  mvi  a, pit_init1
  out  $08

off_2:
  mov	a,b
  rlc
  mov  b,a
  jnc  off_3
  mvi  a, pit_init2
  out  $08


off_3:
  mov	a,b
  rlc
  mov  b,a
  jnc  set_1
  mvi  a, pit_init3
  out  $08

set_1:
  mov	a,b
  rlc
  mov  b, a
  jnc  set_2
  lxi  d, note_table_1
  call get_table_value
  mov  a, m
  out  $0b
  inx  h
  mov  a, m
  out  $0b


set_2:
  mov  a, b
  rlc
  mov  b, a
  jnc  set_3
  lxi  d, note_table_2
  call get_table_value
  mov  a, m
  out  $0a
  inx  h
  mov  a, m
  out  $0a


set_3:
  mov  a, b
  rlc
  jnc  set_timer
  lxi  d, note_table_3
  call get_table_value
  mov  a, m
  out  $09
  inx  h
  mov  a, m
  out  $09


set_timer:
  call get_next_data
  sta  wait_counter

end_int:
  pop  psw
  pop  b
  pop  d
  pop  h
;
  ei
  ret
;
;
;============================================================
get_table_value:
  call get_next_data
  mov  l, a
  mvi  h, 0
  dad  h
  dad  d
  ret
;
get_next_data:
  lhld data_pointer
  mov  a, m           
  inx  h              
  shld data_pointer
  ret
;
;---------------------------
note_table_1:
;  .dw 7216, 6811, 6430, 6070, 5409, 5107, 4821, 4551, 4057, 3616, 3414, 3223, 3043, 2713
   .dw 6074, 5733, 5412, 5108, 4551, 4295, 4054, 3827, 3409, 3037, 2867, 2706, 2554, 2275
note_table_2:
;  .dw 6070, 5409, 4821, 4551, 4057, 3830, 3616, 3414, 3223, 3043, 2873, 2713, 2561, 2284, 2020
   .dw 5108, 4551, 4054, 3827, 3409, 3218, 3037, 2867, 2706, 2554, 2411, 2275, 2148, 1913, 1705
note_table_3:
;  .dw 27213, 18173, 15287, 14431, 13622, 12860, 12140, 10819, 10213, 9642, 9103, 8113, 7660, 7232, 6827, 6446, 6086, 5425, 5123
   .dw 22932, 15306, 12871, 12149, 11466, 10823, 10216, 9102,  8590,  8108, 7653, 6818, 6436, 6074, 5733, 5412, 5108, 4551, 4295

sound_data:
  .db 
repeat_point:
  .db 56, 3, 0, 16, 24, 2, 1, 16, 24, 1, 2, 16, 24, 0, 3, 16, 24, 1, 4, 16, 24, 2, 5, 16, 24, 3, 6, 8, 216, 3, 6, 8, 216, 3, 6, 8, 192, 8, 28, 4, 6, 10, 8, 224, 8, 28, 5, 6, 10, 32, 8, 3, 8, 128
  .db 8, 60, 7, 11, 4, 8, 32, 8, 4, 10, 8, 32, 8, 4, 14, 8, 224, 8, 28, 6, 10, 3, 8, 32, 8, 4, 10, 8, 32, 8, 4, 13, 8, 224, 8, 28, 7, 11, 4, 8, 32, 8, 4, 10, 8, 32, 8, 4, 14, 8, 224, 8, 4, 7, 8
  .db 40, 3, 8, 12, 4, 10, 8, 40, 6, 8, 12, 7, 14, 8, 40, 9, 8, 28, 7, 11, 4, 8, 32, 8, 4, 10, 8, 32, 8, 4, 14, 8, 224, 8, 28, 6, 10, 3, 8, 32, 8, 4, 10, 8, 32, 8, 28, 8, 12, 13, 8, 32, 8, 28, 7
  .db 11, 4, 8, 32, 8, 4, 10, 8, 32, 8, 4, 14, 8, 224, 8, 4, 7, 8, 32, 8, 4, 10, 8, 32, 8, 4, 14, 8, 40, 3, 8, 28, 5, 9, 6, 8, 32, 8, 4, 10, 8, 32, 8, 4, 13, 8, 224, 8, 28, 4, 8, 5, 8, 32, 8, 4
  .db 9, 8, 32, 8, 4, 12, 8, 224, 8, 28, 5, 9, 6, 8, 32, 8, 4, 10, 8, 32, 8, 4, 13, 8, 224, 8, 4, 3, 8, 40, 3, 8, 12, 4, 10, 8, 40, 6, 8, 12, 7, 13, 8, 40, 8, 8, 28, 5, 9, 6, 8, 32, 8, 4, 10, 8
  .db 32, 8, 4, 13, 8, 224, 8, 28, 0, 3, 3, 8, 32, 8, 4, 10, 8, 32, 8, 28, 8, 12, 13, 8, 32, 8, 28, 7, 11, 4, 8, 32, 8, 4, 10, 8, 32, 8, 4, 14, 8, 224, 8, 4, 1, 8, 32, 8, 4, 10, 8, 32, 8, 4, 14
  .db 8, 40, 3, 8, 28, 13, 13, 4, 8, 32, 8, 4, 10, 8, 32, 8, 4, 17, 8, 224, 8, 28, 12, 13, 3, 8, 32, 8, 4, 10, 8, 32, 8, 4, 16, 8, 224, 8, 28, 11, 13, 2, 8, 32, 8, 4, 10, 8, 32, 8, 4, 15, 8, 224
  .db 8, 12, 13, 5, 8, 32, 8, 12, 14, 10, 8, 96, 8, 4, 17, 8, 40, 13, 8, 28, 12, 12, 6, 8, 32, 8, 4, 11, 8, 32, 8, 4, 18, 8, 224, 8, 28, 11, 12, 5, 8, 32, 8, 4, 11, 8, 32, 8, 4, 18, 8, 224, 8, 28
  .db 10, 12, 4, 8, 32, 8, 4, 11, 8, 32, 8, 4, 18, 8, 224, 8, 12, 12, 3, 8, 32, 8, 12, 13, 10, 8, 96, 8, 4, 18, 8, 40, 12, 8, 28, 1, 11, 0, 8, 32, 8, 4, 10, 8, 32, 8, 4, 17, 8, 224, 8, 28, 5, 4
  .db 1, 8, 32, 8, 28, 7, 6, 10, 8, 32, 8, 28, 9, 12, 10, 8, 32, 8, 156, 9, 11, 8, 8, 252, 9, 11, 8, 8, 252, 9, 11, 8, 24, 60, 5, 6, 3, 8, 60, 4, 7, 4, 40, 192, 8, 0  ; eof

;---------------------------

data_pointer:
  .dw 0

wait_counter:
  .db 0

;=======================================
  .end
