<?php

    $mainRAM = Array();
    for ($i=0; $i<0x10000; $i++) $mainRAM[$i] = 0x00;
    
    $gAddr = 0;     // address in $mainRAM
    $gAddrRel = 0;

    
function GetLineNumber ($s, &$lnum)
{
    $s1 = trim(substr($s, 0, 8));
    $lnum = intval($s1, 10);
    return substr($s, 8);
}


function GetOctal ( $s, &$num, &$type )
{
    $l = 0;
    $sbuf = "";
    while ($l<8 && strlen($s) > 0)
    {
        $fc = ord($s[0]);
        if ($fc == 0x09) { $l = (($l+8) >> 3) << 3; $s = substr($s, 1); break; }
        if ($fc == 0x20) { $l++; $s = substr($s, 1); continue; }
        if ($fc < 0x30 || $fc > 0x37) { $type = -1; return ""; }
        $sbuf .= chr($fc);
        $s = substr($s, 1);
        $l++;
    }
    if (strlen($sbuf) == 0) {
        $type = 0;
        return $s;
    }
    $type = 1; if (strlen($sbuf) > 3) $type = 2;
    $num = octdec($sbuf);
    return $s;
}


function PutBytes ($a, $w, $t, $rel)
{
    global $mainRAM;
    
    if (($a+$rel) >= 0150000) return $a; // it's exchange PPU->CPU addresses, do not use them
    if ($t==0) return $a;
    if ($t==1) {
        $mainRAM[$a+$rel] = $w & 0xFF;
        return ($a+1);
    }
    if ($t==2) {
        $mainRAM[$a+$rel] = $w & 0xFF;
        $mainRAM[$a+$rel+1] = ($w>>8) & 0xFF;
        return ($a+2);
    }
    echo "ERROR in PutBytes! $a $w $t\n";
    die;
}


function UseLine ( $sline )
{
    global  $gAddr, $gAddrRel;
    
    // empty string?
    $sline = rtrim($sline); if (strlen($sline)==0) return true;
    // assume 'Symbol table' as end
    if (strcasecmp($sline, "Symbol table") == 0) return false;
    // first character
    $fc = ord($sline[0]);
    // it's a page description - skip it
    if ($fc == 0x0C) return true;
    // no line number
    $lnum = 0;
    if ($fc == 0x09) $sline = substr($sline, 1);
                else $sline = GetLineNumber($sline, $lnum);

    // try to get addr
    $gAddr = 0; $type0 = -1;
    $sline = GetOctal($sline, $gAddr, $type0);
    if ($type0 < 0) {
        echo "ERROR: in ADDR on $lnum\n";
        die;
    }
    if ($gAddr == 0) return true;
    // now trying to get three octals
    $oct1 = 0; $type1 = -1; $sline = GetOctal($sline, $oct1, $type1);
    $oct2 = 0; $type2 = -1; $sline = GetOctal($sline, $oct2, $type2);
    $oct3 = 0; $type3 = -1; $sline = GetOctal($sline, $oct3, $type3);
    if ($type1 < 0 || $type2 < 0 || $type3 < 0) {
        echo "ERROR: in DATA on $lnum\n";
        die;
    }
    if ($type1==0 && $type2==0 && $type3==0) return true;
    if ($type1==0 && ($type2>0 || $type3>0)) {
        echo "ERROR: in DATA on $lnum\n";
        die;
    }
    if ($type2==0 && $type3>0) {
        echo "ERROR: in DATA on $lnum\n";
        die;
    }    
    // echo decoct($gAddr)."-".$type0."\t\t".decoct($oct1)."-".$type1."\t\t".decoct($oct2)."-".$type2."\t\t".decoct($oct3)."-".$type3."\n";
    // now we have addr and up to three octals
    $gAddr = PutBytes($gAddr, $oct1, $type1, $gAddrRel);
    $gAddr = PutBytes($gAddr, $oct2, $type2, $gAddrRel);
    $gAddr = PutBytes($gAddr, $oct3, $type3, $gAddrRel);
    return true;
}
    
    
function ProcessFile ( $fname )
{   
    global $mainRAM;
    
    $lcount = 0;
    $fin = fopen($fname.".LST", "r");
    // skip 3 lines
    fgets($fin);
    fgets($fin);
    fgets($fin);
    while (!feof($fin))
    {
        $s = fgets($fin);
        $b = UseLine($s);
        if (!$b) break;
        $lcount++;
    }
    fclose($fin);
    
    echo "-IN:$fname, used $lcount lines\n";
}


function WriteOutput ()
{
    global $mainRAM;
    $fname = "KRKBIN.DAT";
    
    $fout = fopen($fname, "w");
    for ($i=0; $i<0x10000; $i++)
    {
        $byte = $mainRAM[$i];
        $s = chr($byte);
        fwrite($fout, $s, 1);
    }
    fclose($fout);

    echo "-OUT:$fname\n";
}

    // in FILE from 0, in RAM from 10000 (octal) 
    // max size must not exceed 70000 (octal) ~28k
    $gAddrRel = 0 - 4096; 
    ProcessFile("KRKPPU");
    
    // in FILE from 70000, in RAM from 2000 (octal)
    // max size must not exceed 110000 (octal) ~36k
    $gAddrRel = 28672 - 1024; 
    ProcessFile("KRKCPU");
    
    WriteOutput();
    
