--------------------------------------------------------------------------------
--     : "ZXKit1 -  VGA & PAL"                  --                        
--  :  V2.0.9.02                                          : 100304  --
--  :                                                     --
--                                                                            --
--  : EPM3128ATC100-10N (128 MACROCELLS,  TQFP100)                  --
--  :  K6R4016V1D-UI10 (256K * 16 )                                     --
--   : 14/12/10/8 ,                                         --
--                      , ,       --
--   : Quartus II Version 9.0 Web Edition                      --
--------------------------------------------------------------------------------

-- Compilation Report:
-- Warnings        = 50
-- Total macrocels = 126/128
-- Total pins      = 69/80

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;


entity VGA_PAL is
	port
	(

--------------------------------------------------------------------------------
--                                       091103  --
--------------------------------------------------------------------------------

R_IN        : in std_logic := '1'; --  RED
G_IN        : in std_logic := '1'; --  GREEN
B_IN        : in std_logic := '1'; --  BLUE
I_IN        : in std_logic := '1'; --  BRIGHT

KSI_IN      : in std_logic := '1'; --  
SSI_IN      : in std_logic := '1'; --  
F14         : in std_logic := '1'; --    14 
F14_2       : in std_logic := '1'; -- F14,     


--------------------------------------------------------------------------------
--              /               090812  --
--------------------------------------------------------------------------------

INVERSE_RGBI  : in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .
                                      
INVERSE_KSI   : in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .
                                      
INVERSE_SSI   : in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .
                                      
INVERSE_F14MHZ: in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .

VGA_SCART     : in std_logic := '1'; --     VGA: 
                                     -- 0 -  SCART, 1 -  VGA.

SET_FK_IN     : in std_logic := '1'; --    : 
                                     -- 0 - 50 (312 ), 1 - 48 (320 .)
                                      
SET_FK_OUT    : in std_logic := '1'; --    : 
                                     -- 1 - 60 , 0 - 50/48 .

--------------------------------------------------------------------------------
--                         VGA                    090728  --
--------------------------------------------------------------------------------

R_VGA      : out std_logic := '0'; --  RED
G_VGA      : out std_logic := '0'; --  GREEN
B_VGA      : out std_logic := '0'; --  BLUE
I_VGA      : out std_logic_vector (2 downto 0) := "000"; --   VGA

VSYNC_VGA  : out std_logic := '1'; --  /. SCART
HSYNC_VGA  : out std_logic := '1'; --  /enable RGB SCART



--------------------------------------------------------------------------------
--                         VIDEO                  091025  --
--------------------------------------------------------------------------------

R_VIDEO    : out std_logic := '0'; --  RED
G_VIDEO    : out std_logic := '0'; --  GREEN
B_VIDEO    : out std_logic := '0'; --  BLUE
I_VIDEO    : out std_logic_vector (2 downto 0) := "000"; --   VIDEO

-- SYNC_VIDEO : out std_logic := '1'; --     .


--------------------------------------------------------------------------------
--                                             100304  --
--------------------------------------------------------------------------------
--A17       : out std_logic; --     
A          : out std_logic_vector(16 downto 0); -- 

WE         : out std_logic := '1'; --       
OE         : buffer std_logic := '1'; --       
--UB        : out std_logic := '1'; --      (D15..D8)
--LB        : out std_logic := '1'; --       (D7..D0)


--------------------------------------------------------------------------------
--                                      090821  --
--------------------------------------------------------------------------------

D          : inout std_logic_vector(15 downto 0) := "ZZZZZZZZZZZZZZZZ" -- 

	);
    end VGA_PAL;
architecture RTL of VGA_PAL is

--------------------------------------------------------------------------------
--                                               090804  --
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--                                       090805  --
--------------------------------------------------------------------------------

signal R      : std_logic; --  RED
signal G      : std_logic; --  GREEN
signal B      : std_logic; --  BLUE
signal I      : std_logic; --  BRIGHT
signal RGBI_CLK : std_logic; --     

signal KSI    : std_logic; --  
signal SSI    : std_logic; --  

--------------------------------------------------------------------------------
--                                            100304  --
--------------------------------------------------------------------------------
signal R3          : std_logic; --  RED      --    
signal G3          : std_logic; --  GREEN
signal B3          : std_logic; --  BLUE
signal I3          : std_logic; --  BRIGHT
signal BLACK       : std_logic; --  BLACK

--------------------------------------------------------------------------------
--                                           091220  --
--------------------------------------------------------------------------------

--signal KSI_1  : std_logic; --   
signal KSI_2  : std_logic; --   
signal SSI_2  : std_logic; --   

--------------------------------------------------------------------------------
--                   VGA  VIDEO        091223  --
--------------------------------------------------------------------------------
--   VGA:

signal VGA_H_CLK     : std_logic; --      
signal VGA_H         : std_logic_vector(8 downto 0); --    
signal VGA_H_MIN     : std_logic_vector(8 downto 0); -- . .. 
signal VGA_H_MAX     : std_logic_vector(8 downto 0); -- ... 
signal VGA_SSI1_BGN   : std_logic_vector(9 downto 0); --   
signal VGA_SSI1_END   : std_logic_vector(9 downto 0); --    
signal VGA_SSI2_BGN   : std_logic_vector(9 downto 0); --   
signal VGA_SSI2_END   : std_logic_vector(9 downto 0); --    
signal VGA_SGI1_BGN   : std_logic_vector(9 downto 0); --   
signal VGA_SGI1_END   : std_logic_vector(9 downto 0); --    
signal VGA_SGI2_BGN   : std_logic_vector(9 downto 0); --   
signal VGA_SGI2_END   : std_logic_vector(9 downto 0); --    
--------------------------------------------------------------------------------
--   VGA:

signal VGA_V_CLK     : std_logic; --      
signal VGA_V         : std_logic_vector(9 downto 0); --    
signal VGA_V_MIN     : std_logic_vector(9 downto 0); -- . . 
signal VGA_V_MAX     : std_logic_vector(9 downto 0); -- .. 
signal VGA_KSI_BGN   : std_logic_vector(9 downto 0); --   
signal VGA_KSI_END   : std_logic_vector(9 downto 0); --    
signal VGA_KGI1_END  : std_logic_vector(9 downto 0); --    
signal VGA_KGI2_BGN  : std_logic_vector(9 downto 0); --   
--------------------------------------------------------------------------------
--   VIDEO:

signal VIDEO_H_CLK   : std_logic; --      
signal VIDEO_H       : std_logic_vector(9 downto 0); --    
signal VIDEO_H_MAX   : std_logic_vector(9 downto 0); -- .. . 
signal VIDEO_SSI_BGN : std_logic_vector(9 downto 0); --   
signal VIDEO_SSI_END : std_logic_vector(9 downto 0); --    
signal VIDEO_SGI_BGN : std_logic_vector(9 downto 0); --   
signal VIDEO_SGI_END : std_logic_vector(9 downto 0); --    
--------------------------------------------------------------------------------
--   VIDEO:

signal VIDEO_V_CLK   : std_logic;  --     
signal VIDEO_V       : std_logic_vector(8 downto 0); --    
signal VIDEO_V_MAX   : std_logic_vector(8 downto 0); -- .. . 
signal VIDEO_KSI_BGN : std_logic_vector(8 downto 0); --   
signal VIDEO_KSI_END : std_logic_vector(8 downto 0); --    
signal VIDEO_KGI_BGN : std_logic_vector(8 downto 0); --   
signal VIDEO_KGI_END : std_logic_vector(8 downto 0); --    
signal SCREEN_V_END  : std_logic_vector(8 downto 0); --  .  
--------------------------------------------------------------------------------
--  /   : 

signal H_TYPE : std_logic_vector(1 downto 0); 
                
                --  10 -     
                --         "",   14 
                --         896  (895 = 1 10 1111111)
                
                --  01 -   "",   12 
                --         768  (767 = 1 01 1111111)

                --  00 -   "",   10 
                --         640  (639 = 1 00 1111111)

                --  11 -   "",   8 
                --         512  (511 = 0 11 1111111)
--------------------------------------------------------------------------------
--signal V_TYPE : std_logic; --   - /    : 
                --   0 - 312  (311 = 10011 0 111)
                --   1 - 320  (319 = 10011 1 111)

--------------------------------------------------------------------------------
--                       VGA  VIDEO                 091220  --
--------------------------------------------------------------------------------

signal VGA_KSI      : std_logic; --    VGA
signal VGA_SSI      : std_logic; --    VGA

signal VIDEO_KSI    : std_logic; --    VIDEO
signal VIDEO_SSI1   : std_logic; --     VIDEO
signal VIDEO_SSI2   : std_logic; --   -   VIDEO
-- signal VIDEO_SYNC   : std_logic; --   VIDEO

signal VGA_RBGI_CLK : std_logic; --     VGA 

signal RESET_ZONE   : std_logic; --     
signal RESET_H      : std_logic; --  0,         
signal RESET_V      : std_logic; --  0,         
 
--------------------------------------------------------------------------------
--                       VGA  VIDEO                091102  --
--------------------------------------------------------------------------------

signal VGA_KGI      : std_logic; --     VGA
signal VGA_SGI      : std_logic; --     VGA
signal VGA_BLANK    : std_logic; --    VGA

signal VIDEO_KGI    : std_logic; --     VIDEO
signal VIDEO_SGI    : std_logic; --     VIDEO
signal VIDEO_BLANK  : std_logic; --    VIDEO

--------------------------------------------------------------------------------
--                                   090821  --
--------------------------------------------------------------------------------

signal WR_REG       : std_logic_vector(15 downto 0); --  3-R, 2-G, 1-B, 0-I

--------------------------------------------------------------------------------
--                                   100304  --
--------------------------------------------------------------------------------

signal RD_REG       : std_logic_vector(11 downto 0); --  3-R, 2-G, 1-B, 0-I

begin

--------------------------------------------------------------------------------
--                                                                    --
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--                                         090826  --
--------------------------------------------------------------------------------

--   /    ON, 
--    ,   .
--    
--------------------------------------------------------------------------------
RGBI_CLK <= F14 xnor INVERSE_F14MHZ; --   
--------------------------------------------------------------------------------
process (RGBI_CLK)   
begin
  if (falling_edge(RGBI_CLK)) then --    
--------------------------------------------------------------------------------
        B   <=   B_IN xnor INVERSE_RGBI;    --   -  
        R   <=   R_IN xnor INVERSE_RGBI; 
        G   <=   G_IN xnor INVERSE_RGBI;
        I   <=   I_IN xnor INVERSE_RGBI;
  end if;
end process;

--------------------------------------------------------------------------------
--                              100304  --
--------------------------------------------------------------------------------
process (F14, VIDEO_H(8),VIDEO_H(9))
begin

  if (rising_edge(F14)) then  --    ,   0  1
      SSI   <= SSI_IN xnor INVERSE_SSI;
      SSI_2 <= not SSI;       --     
  end if;

  --       1/4...1/2  VIDEO
  if (rising_edge(VIDEO_H(8)) and VIDEO_H(9)='0') then
      KSI   <= KSI_IN xnor INVERSE_KSI;
      KSI_2 <= not KSI;       --      
  end if;
end process;

RESET_H <= SSI or SSI_2;      --  0,         
RESET_V <= KSI or KSI_2;      --  0,     
--    , 0     -
RESET_ZONE <= (not VIDEO_V(7) or VIDEO_V(8)); 

VGA_V_CLK   <= (VGA_H(7)   or VGA_H(8));
VIDEO_V_CLK <= (VIDEO_H(8) or VIDEO_H(9));


--------------------------------------------------------------------------------
--                                    091016  --
--------------------------------------------------------------------------------
--process (KSI)
--begin
--  if (falling_edge(KSI)) then --     ,
--    V_TYPE <= VIDEO_V(3); --      VIDEO
--                          -- 0 = 312 , 1 = 320 
--  end if;
--end process;
--

--------------------------------------------------------------------------------
--                                  100304  --
--------------------------------------------------------------------------------
process (F14, SSI, SSI_2)
begin  
  if (falling_edge(SSI)) then --     ,
    if RESET_ZONE = '0'  then --     
      --       
--      VIDEO_H_MAX <= VIDEO_H;
      VGA_H_MAX   <= (VIDEO_H(9 downto 1) );
    end if;
  end if;
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
  if (falling_edge(F14)) then         --    :
--------------------------------------------------------------------------------
    if (RESET_H = '0')  then          --    ,
      VIDEO_H <= (others => '0');     --    
    else 
      VIDEO_H <= VIDEO_H + 1;         --  -  
    end if;   
--------------------------------------------------------------------------------
    --           -:
    --      
    -- ,      VGA,
    if ((RESET_H or RESET_ZONE) = '0') or (VGA_H = VGA_H_MAX)  then
      VGA_H   <= (others => '0');     --    VGA
    else
      VGA_H   <= VGA_H   + 1;         --  -    VGA
    end if;   
  end if;   
end process;

--------------------------------------------------------------------------------
--                                     091223  --
--------------------------------------------------------------------------------
--         VGA 60  
--  29.5     , 
--   59  VGA.


process (VGA_H(8), VIDEO_H(9))
begin
--------------------------------------------------------------------------------
--   VGA:
  if (falling_edge(VGA_V_CLK)) then  --     . 

    --     48/50 
    if (SET_FK_OUT = '0') then
      if (RESET_V) = '0' then        --    :
        VGA_V <= (others => '0');    --    VGA
      else                           --  
        VGA_V <= VGA_V   + 1;        --    VGA
      end if;    
    else  

    -- ,     60 
      if VGA_V = 582 then            --      (523+59=585):
        VGA_V <= ("0000111011");     --    VGA:  59
      else                           --  
        VGA_V <= VGA_V   + 1;        --    VGA
      end if;    

    end if;    
  end if;    
--------------------------------------------------------------------------------
--   VIDEO:
  if (falling_edge(VIDEO_V_CLK)) then --     .
    if (RESET_V) = '0' then           --    :
      VIDEO_V <= (others => '0');     --    VIDEO
    else    
      VIDEO_V <= VIDEO_V + 1;         --    VIDEO
    end if;    
  end if;    
-------------------------------------------------------------------------------
end process;

--------------------------------------------------------------------------------
--                                               100304  --
--------------------------------------------------------------------------------
--   JP6 (SET_FK_IN)  JP5 (VGA_SCART) , 
--    .
--        ,   

--   ( , 0 - ) :
--                --  10 -     
--                --         "",   14 
--                --         896  (895 = 1 10 1111111)
--                
--                --  01 -   "",   12 
--                --         768  (767 = 1 01 1111111)
--
--                --  00 -   "",   10 
--                --         640  (639 = 1 00 1111111)
--
--                --  11 -   "",   8 
--                --         512  (511 = 0 11 1111111)
process (H_TYPE)                   
begin
  if (SET_FK_IN = '1' and VGA_SCART = '1') then
    H_TYPE(1) <= VGA_H_MAX(7); --   
    H_TYPE(0) <= VGA_H_MAX(6);
  else
    H_TYPE(1) <= SET_FK_IN;    --   
    H_TYPE(0) <= VGA_SCART;
  end if;
end process;

--H_TYPE(1) <= VGA_H_MAX(7);
--H_TYPE(0) <= VGA_H_MAX(6);
--H_TYPE(1) <= (VGA_H_MAX(7) or SET_FK_IN);
--H_TYPE(0) <= (VGA_H_MAX(6) or VGA_SCART);

--------------------------------------------------------------------------------
--                   VGA               100304  --
--------------------------------------------------------------------------------

--    VGA:

process (H_TYPE)                   
begin
  case H_TYPE is
 
    when "10" =>   -- ""
      --   VGA:
      VGA_SSI1_BGN <= "0000000000"; --   0 -  1  
      VGA_SSI1_END <= "0000100110"; --  38 -   1  
      VGA_SSI2_BGN <= "1101110010"; -- 882 -  2  
      VGA_SSI2_END <= "1101111111"; -- 895 -   2  
      VGA_SGI1_END <= "0001000001"; --  65 -   1  
      VGA_SGI2_BGN <= "1101110010"; -- 882 -  2  

    when "01" =>   -- ""
      VGA_SSI1_BGN <= "0000000000"; --   0 -  1  
      VGA_SSI1_END <= "0000100010"; --  34 -   1  
      VGA_SSI2_BGN <= "1011110101"; -- 757 -  2  
      VGA_SSI2_END <= "1011111111"; -- 767 -   2  
      VGA_SGI1_END <= "0000111001"; --  57 -   1  
      VGA_SGI2_BGN <= "1011101101"; -- 749 -  2  

    when "00" =>   -- ""
      VGA_SSI1_BGN <= "0000000000"; --   0 -  1  
      VGA_SSI1_END <= "0000100101"; --  37 -   1  
      VGA_SSI2_BGN <= "0000000000"; --   0 -  2  
      VGA_SSI2_END <= "0000100101"; --  37 -   2  
      VGA_SGI1_END <= "0000111000"; --  56 -   1  
      VGA_SGI2_BGN <= "1001111010"; -- 634 -  2  

    when "11" =>   -- ""
      VGA_SSI1_BGN <= "0000000000"; --   0 -  1  
      VGA_SSI1_END <= "0000010001"; --  17 -   1  
      VGA_SSI2_BGN <= "0111110011"; -- 499 -  2  
      VGA_SSI2_END <= "0111111111"; -- 511 -   2  
      VGA_SGI1_END <= "0000100000"; --  32 -   1  
      VGA_SGI2_BGN <= "0111101110"; -- 494 -  2  

  end case;
end process;
--------------------------------------------------------------------------------
--   VGA:

--         VGA 60  
--  32     , 
--   64  VGA.

process (SET_FK_OUT)                   
begin
  case SET_FK_OUT is
 
    when '0' =>  --    48/50 :

      VGA_KSI_BGN  <= "0000001011"; --  11 -   
      VGA_KSI_END  <= "0000001100"; --  12 -    
      VGA_KGI1_END <= "0000101100"; --  44 -    
      VGA_KGI2_BGN <= "1001110001"; -- 625 -   

    when '1' =>  --    60 :

      VGA_KSI_BGN  <= "0000111011"; --  59 -   
      VGA_KSI_END  <= "0000111100"; --  60 -    
      VGA_KGI1_END <= "0001011100"; --  92 -    
      VGA_KGI2_BGN <= "1000111110"; -- 574 -   
      
  end case;
end process;

--------------------------------------------------------------------------------
--                      VGA              091223  --
--------------------------------------------------------------------------------
--     VIDEO
VGA_SSI  <= '0' when (VGA_H >= VGA_SSI1_BGN and VGA_H <= VGA_SSI1_END) 
                  or (VGA_H >= VGA_SSI2_BGN and VGA_H <= VGA_SSI2_END) 
                else '1';

--     VIDEO
VGA_SGI  <= '0' when (VGA_H <= VGA_SGI1_END)
                  or (VGA_H >= VGA_SGI2_BGN)
                else '1';

--------------------------------------------------------------------------------
--                      VGA              091223  --
--------------------------------------------------------------------------------
--    VIDEO
VGA_KSI  <= '0' when (VGA_V >= VGA_KSI_BGN) 
                 and (VGA_V <= VGA_KSI_END) 
                else '1';
--     VIDEO
VGA_KGI  <= '0' when (VGA_V <= VGA_KGI1_END) 
                  or (VGA_V >= VGA_KGI2_BGN )  
                else '1';
                  
--------------------------------------------------------------------------------
--                       VIDEO           091223  --
--------------------------------------------------------------------------------

--     VIDEO:

                       --   (14 )
VIDEO_SSI1 <= '0' when (VIDEO_H > 20 and VIDEO_H < 87 and H_TYPE = "10")
                       --  (12 )
                    or (VIDEO_H > 17 and VIDEO_H < 75 and H_TYPE = "01")
                       --  (10 )
                    or (VIDEO_H > 14 and VIDEO_H < 62 and H_TYPE = "00")
                
                  else '1';

--   -   VIDEO:
                       --   (14 )
VIDEO_SSI2 <= '0' when (VIDEO_H > 20 and VIDEO_H < 851 and H_TYPE = "10")
                       --  (12 )
                    or (VIDEO_H > 17 and VIDEO_H < 729 and H_TYPE = "01")
                       --  (10 )
                    or (VIDEO_H > 14 and VIDEO_H < 608 and H_TYPE = "00")
                
                  else '1';

--     VIDEO:
                       --   (14 )
VIDEO_SGI  <= '0' when (VIDEO_H < 168 and H_TYPE = "10")
                       --  (12 )
                    or (VIDEO_H < 144 and H_TYPE = "01")
                       --  (10 )
                    or (VIDEO_H < 120 and H_TYPE = "00")
                
                  else '1';

--------------------------------------------------------------------------------
--                      VIDEO            091103  --
--------------------------------------------------------------------------------
--    VIDEO
VIDEO_KSI  <= '0' when VIDEO_V < 4 else '1';

--     VIDEO
VIDEO_KGI  <= '0' when VIDEO_V < 16 else '1';


--------------------------------------------------------------------------------
--                       VIDEO              090820  --
--------------------------------------------------------------------------------
--VIDEO_SYNC <= VIDEO_SSI2 when VIDEO_KSI = '0' else VIDEO_SSI1;

--------------------------------------------------------------------------------
--                                   100304  --
--------------------------------------------------------------------------------
----    VGA
--VGA_BLANK   <= VGA_KGI and VGA_SGI;

----    VIDEO
--VIDEO_BLANK <= VIDEO_KGI and VIDEO_SGI;

--------------------------------------------------------------------------------
--                                       090812  --
--------------------------------------------------------------------------------

--        50/48 :
A <= "00000000" & VIDEO_V(0) & VIDEO_H(9 downto 2)
                                        when (VIDEO_H(0)='1' and SET_FK_OUT='0')

--        60 :
else VIDEO_V(8 downto 0) & VIDEO_H(9 downto 2) 
                                        when (VIDEO_H(0)='1' and SET_FK_OUT='1')

--        50/48 :
else "00000000" & (not VIDEO_V(0)) & VGA_H(8 downto 1) 
                                        when (VIDEO_H(0)='0' and SET_FK_OUT='0')

--        60 :
else VGA_V(9 downto 1) & VGA_H(8 downto 1);


--------------------------------------------------------------------------------
--                                              100304  --
--------------------------------------------------------------------------------
--      (    WE) 
D(15 downto 0) <= WR_REG when VIDEO_H(0) = '1' else (others => 'Z');

process (F14)                   
begin
  if (falling_edge(F14)) then --   
--------------------------------------------------------------------------------
    --     VIDEO      16  :
    case VIDEO_H(1 downto 0) is
      when "00" =>      
        WR_REG(11 downto  8) <= R & G & B & I; --     
      when "01" =>      
        WR_REG( 7 downto  4) <= R & G & B & I; --      
      when "10" =>      
        WR_REG( 3 downto  0) <= R & G & B & I; --     .  
      when "11" =>      
        WR_REG(15 downto 12) <= R & G & B & I; --      
    end case;
--------------------------------------------------------------------------------
  end if;

  if (rising_edge(F14) and VGA_H(0)='0') then --   OE
      --            VGA
      RD_REG(11 downto 0) <= D(11 downto 0);

--------------------------------------------------------------------------------
  end if;

end process;


--------------------------------------------------------------------------------
--                                   100304  --
--------------------------------------------------------------------------------

--       
WE <= F14 or (VIDEO_H(1) nand VIDEO_H(0));
--       
OE <= F14 or VIDEO_H(0);
--UB <= '0'; --      (D15..D8)
--LB <= '0'; --      ( D7..D0)


--------------------------------------------------------------------------------
--                          VGA                  090826  --
--------------------------------------------------------------------------------

--        :

process (F14, VGA_H(0))                   
variable sel:std_logic_vector(1 downto 0);
begin
 
sel:=VGA_H(0) & F14 ;
  case sel is
    when "00" =>       --   
      R3 <= RD_REG(3); 
      G3 <= RD_REG(2);
      B3 <= RD_REG(1);
      I3 <= RD_REG(0);
    when "01" =>       --   
      R3 <= D(15);
      G3 <= D(14);
      B3 <= D(13);
      I3 <= D(12);

--      R3 <= RD_REG(15);
--      G3 <= RD_REG(14);
--      B3 <= RD_REG(13);
--      I3 <= RD_REG(12);

    when "10" =>       --   
      R3 <= RD_REG(11);
      G3 <= RD_REG(10);
      B3 <= RD_REG(9);
      I3 <= RD_REG(8);
    when "11" =>       --   
      R3 <= RD_REG(7);
      G3 <= RD_REG(6);
      B3 <= RD_REG(5);
      I3 <= RD_REG(4);
  end case;

end process;

--------------------------------------------------------------------------------
--      

process (F14) 
begin
  if (rising_edge(F14)) then  --    ,   0  1

    --    VGA
    VGA_BLANK   <= VGA_KGI and VGA_SGI;

    ----    VIDEO
    VIDEO_BLANK <= VIDEO_KGI and VIDEO_SGI;
      

    VSYNC_VGA <= VGA_KSI;      --    VGA
    HSYNC_VGA <= VGA_SSI;      --    VGA
      
  end if;
end process;

--------------------------------------------------------------------------------

--      
VGA_RBGI_CLK <= (not F14) xor F14_2; 
      
--------------------------------------------------------------------------------
--                       RGBI   VGA                      100304  --
--------------------------------------------------------------------------------
process (VGA_RBGI_CLK) 
begin

    BLACK     <= R3 or G3 or B3;

  if (rising_edge(VGA_RBGI_CLK)) then  --    ,

    R_VGA     <= R3 and VGA_BLANK;
    G_VGA     <= G3 and VGA_BLANK;
    B_VGA     <= B3 and VGA_BLANK;
    
--    BLACK     <= R3 or G3 or B3;        
    
    if ((I3 and VGA_BLANK) = '0') or (BLACK = '0')  then  --   :
        I_VGA <= "000";          --      0
    else
        I_VGA <= "ZZZ";          --  
    end if;

  end if;
end process;

----------------------------------------------------------------------------------
----                         PAL-CODER                   100304  --
----------------------------------------------------------------------------------
--process (F14) 
--begin
--if (rising_edge(F14)) then  --    ,   0  1
----if (falling_edge(F14)) then  --    ,   1  0
--      R_VIDEO     <= VIDEO_BLANK and R;       --    
--      G_VIDEO     <= VIDEO_BLANK and G;
--      B_VIDEO     <= VIDEO_BLANK and B;
--
--      if (I and VIDEO_BLANK) = '0'  then          --   :
--          I_VIDEO <= "000";      --      0
--      else
--          I_VIDEO <= "ZZZ";      --  
--      end if;
--
--      SYNC_VIDEO  <= VIDEO_SYNC;              --   VIDEO
--  end if;
--end process;
----------------------------------------------------------------------------------

end RTL;

