#ifndef ps2_codes_h
#define ps2_codes_h

// Extended codes are going as scancode+0x100

// A-Z
#define PS2_A		0x1C
#define PS2_B		0x32
#define PS2_C		0x21
#define PS2_D		0x23
#define PS2_E		0x24
#define PS2_F		0x2B
#define PS2_G		0x34
#define PS2_H		0x33
#define PS2_I		0x43
#define PS2_J		0x3B
#define PS2_K		0x42
#define PS2_L		0x4B
#define PS2_M		0x3A
#define PS2_N		0x31
#define PS2_O		0x44
#define PS2_P		0x4D
#define PS2_Q		0x15
#define PS2_R		0x2D
#define PS2_S		0x1B
#define PS2_T		0x2C
#define PS2_U		0x3C
#define PS2_V		0x2A
#define PS2_W		0x1D
#define PS2_X		0x22
#define PS2_Y		0x35
#define PS2_Z		0x1A

// 0-9
#define PS2_0		0x45
#define PS2_1		0x16
#define PS2_2		0x1E
#define PS2_3		0x26
#define PS2_4		0x25
#define PS2_5		0x2E
#define PS2_6		0x36
#define PS2_7		0x3D
#define PS2_8		0x3E
#define PS2_9		0x46

// Others
#define PS2_ACCENT	0x0E	// '`'
#define PS2_MINUS	0x4E	// '-'
#define PS2_EQUALS	0x55	// '='
#define PS2_BACK_SLASH	0x5D	// '\'
#define PS2_SPACE	0x29	// ' '
#define PS2_TAB		0x0D	// '\t'
#define PS2_L_BRACKET	0x54	// '['
#define PS2_R_BRACKET	0x5B	// ']'
#define PS2_SEMICOLON	0x4C	// ';'
#define PS2_QUOTE	0x52	// '''
#define PS2_COMMA	0x41	// ','
#define PS2_PERIOD	0x49	// '.'
#define PS2_SLASH	0x4A	// '/'

// Control
#define PS2_BACKSPACE	0x66
#define PS2_CAPS	0x58
#define PS2_SCROLL	0x7E
#define PS2_NUM		0x77
#define PS2_L_SHIFT	0x12
#define PS2_R_SHIFT	0x59
#define PS2_L_CTRL	0x14
#define PS2_R_CTRL	0x114
#define PS2_L_ALT	0x11
#define PS2_R_ALT	0x111
#define PS2_ENTER	0x5A
#define PS2_ESC		0x76
#define PS2_INSERT	0x170
#define PS2_DELETE	0x171
#define PS2_HOME	0x16C
#define PS2_END		0x169
#define PS2_PGUP	0x17D
#define PS2_PGDN	0x17A
#define PS2_UP		0x175
#define PS2_DOWN	0x172
#define PS2_LEFT	0x16B
#define PS2_RIGHT	0x174
#define PS2_PSCR1 0x112
#define PS2_PSCR2 0x17c

// F1..F12
#define PS2_F1		0x05
#define PS2_F2		0x06
#define PS2_F3		0x04
#define PS2_F4		0x0C
#define PS2_F5		0x03
#define PS2_F6		0x0B
#define PS2_F7		0x83
#define PS2_F8		0x0A
#define PS2_F9		0x01
#define PS2_F10		0x09
#define PS2_F11		0x78
#define PS2_F12		0x07

// Keypad
#define PS2_NUMLOCK	0x77
#define PS2_KP_SLASH	0x14A
#define PS2_KP_STAR	0x7C
#define PS2_KP_MINUS	0x7B
#define PS2_KP_PLUS	0x79
#define PS2_KP_ENTER	0x15A
#define PS2_KP_PERIOD	0x71
#define PS2_KP_0	0x70
#define PS2_KP_1	0x69
#define PS2_KP_2	0x72
#define PS2_KP_3	0x7A
#define PS2_KP_4	0x6B
#define PS2_KP_5	0x73
#define PS2_KP_6	0x74
#define PS2_KP_7	0x6C
#define PS2_KP_8	0x75
#define PS2_KP_9	0x7D

#endif

