;  
;
;---------------------
;32
ODE     MACRO:POP DE:LD (HL),E:INC H:LD (HL),D:INC H:ENDM
;21
OE      MACRO:POP DE:LD (HL),E:INC H:ENDM
;21
OD      MACRO:POP DE:LD (HL),D:INC H:ENDM
;32
OEE     MACRO:POP DE:LD (HL),E:INC H:LD (HL),E:INC H:ENDM
;43
ODDE    MACRO:POP DE:LD (HL),E:INC H:LD (HL),D:INC H:LD (HL),D:INC H:ENDM
;43
ODEE    MACRO:POP DE:LD (HL),E:INC H:LD (HL),E:INC H:LD (HL),D:INC H:ENDM
;54
ODDEE   MACRO:POP DE:LD (HL),E:INC H:LD (HL),E:INC H:LD (HL),D:INC H:LD (HL),D:INC H:ENDM
;65
ODDEEE  MACRO:POP DE:LD (HL),E:INC H:LD (HL),E:INC H:LD (HL),E:INC H:LD (HL),D:INC H:LD (HL),D:INC H:ENDM
;54
ODDDE   MACRO:POP DE:LD (HL),E:INC H:LD (HL),D:INC H:LD (HL),D:INC H:LD (HL),D:INC H:ENDM
;65
ODDDEE  MACRO:POP DE:LD (HL),E:INC H:LD (HL),E:INC H:LD (HL),D:INC H:LD (HL),D:INC H:LD (HL),D:INC H:ENDM
;76
ODDDEEE MACRO:POP DE:LD (HL),E:INC H:LD (HL),E:INC H:LD (HL),E:INC H:LD (HL),D:INC H:LD (HL),D:INC H:LD (HL),D:INC H:ENDM
;54
ODEEE   MACRO:POP DE:LD (HL),E:INC H:LD (HL),E:INC H:LD (HL),E:INC H:LD (HL),D:INC H:ENDM
;11
MVE     MACRO:LD (HL),E:INC H:ENDM
;11
MVD     MACRO:LD (HL),D:INC H:ENDM

D7      MACRO:OR (HL):ENDM
;T=8
HLDE    MACRO:LD H,D:LD L,E:ENDM
;T=11
H0      MACRO:ADD HL,HL:ENDM
;T=22
H00     MACRO:ADD HL,HL:ADD HL,HL:ENDM
;T=22
H1      MACRO:ADD HL,HL:ADD HL,DE:ENDM
;T=33
H10     MACRO:ADD HL,HL:ADD HL,DE:ADD HL,HL:ENDM
;T=44
H11     MACRO:ADD HL,HL:ADD HL,DE:ADD HL,HL:ADD HL,DE:ENDM

INTTAB  EQU #BE00
CHUNKY  EQU INTTAB-#2000        ;AT CHUNKY+64 PLACED MULADE ROUTINES
MAP     EQU CHUNKY+#42          ; 32*32
SCALETB EQU CHUNKY-#100         ;SCALE TABLE
TAB1X   EQU SCALETB-#200        ;Y=1/X
MULADEJ EQU TAB1X-#200          ;JUMP TABLE
ZDATA   EQU MULADEJ-#200

;PAGE0
SEGMTB  EQU -#100               ;SEGMENT OF LEFT COLUMN
DELTB0  EQU SEGMTB-#100
DELTB1  EQU DELTB0-#100
DELTB2  EQU DELTB1-#100
DELTB3  EQU DELTB2-#100
DELTB4  EQU DELTB3-#100
DELTB5  EQU DELTB4-#100
DELTB6  EQU DELTB5-#100
STEPTB  EQU DELTB6-#3000         ; 
SEGM    EQU STEPTB-#400
TRROUTS EQU SEGM-#100


CORRECTION EQU 1    ;   
CORR    EQU 5       ;  
WIDE    EQU 0       ;1-   128 , 0 - 90 
EDINITSA EQU #108   ;   #100 (1.0 FIXED POINT)
SKYDELAY EQU 7940   ;   ,    ,   
NOSCREEN EQU 0      ; .

;PAGE1
MULTB   EQU #C000

;PAGE3
TEXTURE EQU #C000

;PAGE7
SKYTEX  EQU #F000
MUNKS   EQU SKYTEX-#800
M2P     EQU SKYTEX-#100
SKY_    EQU MUNKS-#C00

;  
;  #F1  #F6  -1024
MODE128

;  MODE128,  ,
;    #17
;  #F7
;KEEP_STS

;, , 
;  
        INCLUDE "E:PAGES.asm"

;TEMPORARY DATA
SIN16   EQU #5600

PAGEPORT EQU #7FFD
PAGE0B  EQU PG0
PAGE0A  EQU PG0|8
PAGE1B  EQU PG1
PAGE1A  EQU PG1|8
PAGE3B  EQU PG3

PAGE7A  EQU PG7
PAGE7B  EQU PG7|8


;QUALITY EQU 1

;PAGE 4
SCREENZ EQU #C000       ;[#900]   



;MEMORY ALLOCATION:
;0 PAGE - MAP, SOME TABLES
;1 PAGE - TEXTURES
;3RD PAGE - ADDITIONAL TABLES

        ORG #6000
        JP BEGIN
        INCLUDE "E:ROUTS.inc"
BEGIN   CALL INIT       ;
        LD D,0
        LD A,INTTAB.h
        CALL SETINT     ;IM2
        CALL TESTIN     ;

        LD IY,#5C3A
        IM 1
        EI
        RET

SETINT  DI
        LD H,A
        LD L,0
        LD I,A
        INC A
SETINT1 LD (HL),A
        INC L
        JR NZ,SETINT1
        INC H
        LD (HL),A
        LD L,A
        LD H,A
        LD (HL),#C9
        IM 2
        INC D
        DEC D
        RET Z
        STB #C3
        LD (HL),E
        INC HL
        LD (HL),D
        RET

INIT    LD HL,UPSCR
        LD DE,#4000
        PUSH DE
        LD BC,ESCRS-UPSCR
        PUSH BC
        LDIR
        CALL PAG4
        POP BC
        POP HL
        LD DE,SCREENZ
        LDIR
        CALL PAG0
        LD HL,ITBS
        LD DE,INITTB
        LD BC,EITBS-ITBS
        LDIR            ;     
        CALL INITTB     ;
        RET


;SCALE INDEX
SCLIDX  DB  4, 6, 8,10,12,14,16,18
        DB 20,22,24,26,28,30,32,34
        DB 36,40,42,46,52,56,64,74
        DB 86,102,128
SCLIDXE

; -
CLRBF   LD H,CHUNKY.h
        LD C,#20
CLRB1   LD L,CHUNKY+2
        LD B,#40
CLRB2   LD (HL),MUNKS.h:INC L:DJNZ CLRB2
        INC H:DEC C:JR NZ,CLRB1
        RET

MAKESCR LD HL,#4000
        LD DE,#4001
        LD BC,6144
        LD (HL),#F0
        LDIR
        LD (HL),#00
        LD BC,767
        LDIR
        CALL PAG4
        DEPSCR SCREENZ,#4000
        DEPSCR SCREENZ+DNSCR-UPSCR,#5080
        LD HL,#5800
        CALL FILL07
        LD HL,#5A80
        CALL FILL07
        CALL PAG7
        LD HL,#4000
        LD DE,#C000
        LD BC,6912
        LDIR
        RET

FILL07  LD B,#80
F1      LD (HL),7:INC L:DJNZ F1
        RET

TESTIN  CALL MAKESCR
TEST    EI:HALT
        LD A,#10
        LD BC,#7FFD
        OUT (C),A
        LD HL,#5C00
TX      EQU $-2
        LD DE,#AA60
TY      EQU $-2
        LD C,#29
TANGLE  EQU $-1
        LD (0),DE
        LD (0),HL
        LD (0),BC
        CALL DTRACE
        LD HL,(TANGLE)
        CALL SKYLOOP
;
        LD (TMPSP),SP

        LD B,700/13
        DJNZ $
        LD BC,PAGEPORT
        LD A,PAGE1B
        OUT (C),A
        LD B,720/13
        DJNZ $

        LD HL,ZDATA
        LD (TSSP),HL
        LD IX,#0F02
        LD IY,RETAD
TEST1   LD A,XL                 ;1634
        AND 7                   ;1641
        OUT (255),A             ;1652
        REPT 4:ADD HL,HL:ENDR   ;1796
        INC HL:NOP              ;1706
        LD SP,#3131             ;1716
TSSP    EQU $-2
        LD HL,6                 ;1726
        ADD HL,SP               ;1737
        LD (TSSP),HL            ;1753
        POP DE                  ;1763
        LD BC,PAGEPORT          ;1773
        LD A,PAGE1A             ;1780
        OUT (C),A               ;0 /1792
        POP BC
        RET                     ;20
RETAD   INC XL                  ;1608
        DEC XH                  ;1616
        JP NZ,TEST1             ;1626
        LD SP,(TMPSP)
;  
;SECOND FRAME
        EI
        HALT
        LD HL,(TSSP)
        LD (TSSRP),HL
        LD XH,33
        LD IY,RETAD1
        LD B,860-140/13
        DJNZ $
        JR MUZVON
TEST2   LD A,XL                 ;1634

;        CP 32
;        JR NZ,$+5
;        DS 3

        AND 7                   ;1641
        OUT (255),A             ;1652
        REPT 4:ADD HL,HL:ENDR   ;1796
        INC HL:NOP              ;1706
MUZVON  LD SP,#3131             ;1716
TSSRP   EQU $-2
        LD HL,6                 ;1726
        ADD HL,SP               ;1737
        LD (TSSRP),HL           ;1753
        POP DE                  ;1763
        LD BC,PAGEPORT          ;1773
        LD A,PAGE1A             ;1780
        OUT (C),A               ;0 /1792
        POP BC
        RET                     ;20
RETAD1  INC XL                  ;1608
        DEC XH                  ;1616
        JP NZ,TEST2             ;1626

        LD SP,(TMPSP)
;  
;THIRD FRAME
        EI
        HALT
        LD HL,(TSSRP)
        LD (TUSRP),HL
        LD XH,16
        LD IY,RETAD2
        LD B,860-140/13
        DJNZ $
        JR HTRE
TEST3   LD A,XL                 ;1634
        AND 7                   ;1641
        OUT (255),A             ;1652
        REPT 4:ADD HL,HL:ENDR   ;1796
        INC HL:NOP              ;1706
HTRE    LD SP,#3131             ;1716
TUSRP   EQU $-2
        LD HL,6                 ;1726
        ADD HL,SP               ;1737
        LD (TUSRP),HL           ;1753
        POP DE                  ;1763
        LD BC,PAGEPORT          ;1773
        LD A,PAGE1A             ;1780
        OUT (C),A               ;0 /1792
        POP BC
        RET                     ;20
RETAD2  INC XL                  ;1608
        DEC XH                  ;1616
        JP NZ,TEST3             ;1626
        XOR A
        OUT (254),A

        LD SP,(TMPSP)
        CALL PUTM2P
FRAIME

OBHOD1  LD A,#7F
        IN A,(254)
        RRCA
        RET NC
        LD A,#DF        ;O/P
        IN A,(254)
        RRCA
        LD DE,1
        LD HL,(TANGLE)
        JR C,NO_P
        ADD HL,DE
NO_P    RRCA
        JR C,NO_O
        SBC HL,DE
NO_O    LD A,L
        LD (TANGLE),A
        LD A,#BF
        IN A,(#FE)
        RRCA
        LD HL,(TX)
        LD DE,16
        JR C,NO_L
        ADD HL,DE
NO_L    RRCA
        JR C,NO_K
        SBC HL,DE
NO_K    LD (TX),HL
        LD HL,(TY)
        LD A,#FB
        IN A,(#FE)
        RRCA
        JR C,NO_Q
        SBC HL,DE
NO_Q    LD A,#FD
        IN A,(#FE)
        RRCA
        JR C,NO_A
        ADD HL,DE
NO_A    LD (TY),HL
        IF 0
        LD A,#F7
        IN A,(#FE)
        LD C,A
        LD A,(LULI)
        RRC C
        JR C,NO_1
        DEC A
        JR NZ,$+3
        INC A
NO_1    RRC C
        JR C,NO_2
        CP 896/13
        ADC A,0
NO_2    LD (LULI),A
        ENDIF
        JP TEST

TMPSP   DW 0

PUTM2P  LD BC,#7FFD
        LD A,PG7
        OUT (C),A
        LD (TSSP),SP
        LD HL,CHUNKY
        LD BC,PAGEPORT
        LD DE,PAGE7A*256+PAGE7B
        LD XH,16
        JP M2P
M2PR    LD SP,(TSSP)
        XOR A
        OUT (254),A
        RET

;L-X
SKYLOOP CALL PAG7
        LD (TSSP),SP
        LD C,L
        EXX
        LD BC,PAGEPORT
        LD DE,PAGE7B*256+PAGE7A
        EXX
        LD H,SKYTEX.h
        JP SKY_
SKYRET  LD SP,(TSSP)
        RET


;C-ANGLE
;DE-Y0        ;D-IN MAP (#40-#5F)
;HL-X0        ;H-MAP.h-MAP.h+31
; 9000 
DTRACE  CALL PAG0
        LD (TMPSP),SP
        LD A,E
        ADD A,8
        LD (T1Y0),A
        LD (T2Y0),A
        CPL
        LD (T5Y0),A
        LD (T6Y0),A
        LD A,E
        RRCA
        RRCA
        ADD A,MULTB.h
        LD (T0Y0),A
        LD (T0Y1),A
        LD (T7Y0),A
        LD (T7Y1),A
        CPL
        ADD A,MULTB.h*2+#3D
        LD (T3Y0),A
        LD (T3Y1),A
        LD (T4Y0),A
        LD (T4Y1),A
;
        LD A,L
        ADD A,8
        LD (T0X0),A
        LD (T7X0),A
        CPL
        LD (T4X0),A
        LD (T3X0),A
        LD A,L
        RRCA
        RRCA
        ADD A,MULTB.h
        LD (T5X0),A
        LD (T5X1),A
        LD (T6X0),A
        LD (T6X1),A
        CPL
        ADD A,MULTB.h*2+#3D
        LD (T1X0),A
        LD (T1X1),A
        LD (T2X0),A
        LD (T2X1),A
;
        LD L,H
        LD H,D
        LD (T0MAP),HL
        LD (T1MAP),HL
        LD (T2MAP),HL
        LD (T3MAP),HL
        LD (T4MAP),HL
        LD (T5MAP),HL
        LD (T6MAP),HL
        LD (T7MAP),HL
        LD B,SEGMTB.h
        LD A,(BC)
        LD XH,A
        LD A,C
        AND #3F
        INC A
        LD C,A
        ADD A,A
        ADD A,C
        RRCA
        RRCA
        LD H,A
        AND #C0
        LD L,A
        XOR H
        ADD A,STEPTB.h
        LD H,A
        DEC HL
        LD A,C
        EXX
        RRCA
        RRCA
        RRCA
        RRCA
        LD D,A
        AND #F0
        LD E,A
        XOR D
        ADD A,SEGM.h
        LD D,A
        DEC DE
        LD H,TRROUTS.h
        EXX
        LD B,16
        LD SP,ZDATA+#180
;--
PREPCOD EXX
        LD A,(DE):DEC E
        EXX
        LD C,A
        EXX
        AND 3
        ADD A,A
        OR XH
        LD L,A
        LD C,(HL):INC L:LD B,(HL)
        PUSH BC
        EXX
        LD E,(HL)
        PUSH DE
        DEC L
        LD D,(HL)
        DEC L
        LD E,(HL)
        DEC L
        PUSH DE
;
        LD A,C
        RRCA
        RRCA
        LD C,A
        EXX
        AND 3
        ADD A,A
        OR XH
        LD L,A
        LD C,(HL):INC L:LD B,(HL)
        PUSH BC
        EXX
        LD E,(HL)
        PUSH DE
        DEC HL
        LD D,(HL)
        DEC L
        LD E,(HL)
        DEC L
        PUSH DE
;
        LD A,C
        RRCA
        RRCA
        LD C,A
        EXX
        AND 3
        ADD A,A
        OR XH
        LD L,A
        LD C,(HL):INC L:LD B,(HL)
        PUSH BC
        EXX
        LD E,(HL)
        PUSH DE
        DEC L
        LD D,(HL)
        DEC HL
        LD E,(HL)
        DEC L
        PUSH DE
;
        LD A,C
        RRCA
        RRCA
        AND 3
        EXX
        ADD A,A
        OR XH
        LD L,A
        LD C,(HL):INC L:LD B,(HL)
        PUSH BC
        EXX
        LD E,(HL)
        PUSH DE
        DEC L
        LD D,(HL)
        DEC L
        LD E,(HL)
        DEC HL
        PUSH DE
        DJNZ PREPCOD
        LD SP,(TMPSP)
        RET

;---------------------
;HL=JUMP ADDRESS
;33 
JUMPER  LD BC,PAGEPORT
        LD A,PAGE3B
        OUT (C),A
        JP (HL)

;HL=A*DE
;T=204 TACTS PER ONE MULTIPLICATION
MULADE  LD L,A
        LD H,MULADEJ.h
        LD A,(HL)
        INC H
        LD H,(HL)
        LD L,A
        JP (HL)


MULTAB  DB 0:DW M0
        DB 191:DW M191
        DB 223:DW M223
        DB 239:DW M239
        DB 247:DW M247
        DB 251:DW M251
        DB 253:DW M253
        DB 254:DW M254
        DB 255:DW M255
MULTBE
M0      LD HL,0:LD A,8:DEC A:JR NZ,$-1:RET
M191    HLDE:H10:H00:H00:H0:OR A:SBC HL,DE:D7:D7:D7:NOP:RET
M223    HLDE:H11:H00:H00:H0:OR A:SBC HL,DE:D7:D7:RET
M239    LD H,E:LD L,0:PUSH DE:LD A,E:ADD A,A:RL D:ADD A,A:RL D:ADD A,A:RL D:ADD A,A:RL D:LD E,A:OR A:SBC HL,DE:POP DE
        OR A:SBC HL,DE:D7:D7:RET
M247    LD H,E:LD L,0:PUSH DE:SLA E:RL D:SLA E:RL D:SLA E:RL D:OR A:SBC HL,DE:POP DE:OR A:SBC HL,DE:D7:D7:NOP:NOP:RET
M251    LD H,E:LD L,0:PUSH DE:SLA E:RL D:SLA E:RL D:OR A:SBC HL,DE:POP DE:OR A:SBC HL,DE:ADD HL,DE:OR A:SBC HL,DE:DS 2:RET
M253    LD H,E:LD L,0:OR A:SBC HL,DE:OR A:SBC HL,DE:OR A:SBC HL,DE
        ADD HL,DE:OR A:SBC HL,DE:ADD HL,DE:OR A:SBC HL,DE:BIT 7,(HL):RET
M254    LD H,E:LD L,0:OR A:SBC HL,DE:OR A:SBC HL,DE:LD A,5:DEC A:JR NZ,$-1:LD A,R:RET
M255    LD H,E:LD L,0:OR A:SBC HL,DE:LD A,6:DEC A:JR NZ,$-1:BIT 0,(HL):RET
;---------------------

        INCLUDE "E:TRACE0-3.inc"
        INCLUDE "E:TRACE4-7.inc"
        INCLUDE "E:OUTH.inc"
ENDCOD
;---DYNAMIC INCUDES---------------------
        INCLUDE "E:DELAYS.inc"
MAPDAT  INSERT "E:doomm_p1.map"
TEXDAT  INSERT "E:doomwall.tex"
ETEXDAT
SKYDAT  INSERT "E:SKYTEX.C"
;--------------------------------------
ITBS    PHASE #4000
INITTB
;-----------MOVE TEXTURE--------------
        CALL PAG3
        LD HL,TEXDAT
        LD DE,TEXTURE
        LD BC,ETEXDAT-TEXDAT/256
MVTEX1  XOR A:RLD:AND 7:ADD A,MUNKS.h:LD (DE),A:INC DE
        XOR A:RLD:AND 7:ADD A,MUNKS.h:LD (DE),A:INC DE,HL
        DJNZ MVTEX1
        DEC C:JR NZ,MVTEX1
;DECRUNCH SKY
        CALL PAG7
        LD HL,SKYDAT
        LD DE,SKYTEX
        LD BC,#0008
MVSKY   XOR A:RLD:ADD A,MUNKS.h:LD (DE),A:INC DE
        XOR A:RLD:ADD A,MUNKS.h:LD (DE),A:INC DE,HL
        DJNZ MVSKY
        DEC C
        JR NZ,MVSKY

;        LD HL,#C000
;        LD DE,#C400
;        LD BC,#3C00
;        LDIR
;DECRUNCH MULTIPLICATION TABLE
        CALL PAG1
        LD HL,MULTB
DMLT    PUSH HL
        LD C,L:LD A,H:AND 1:LD B,A
        LD DE,8
        LD XL,16
DMLT1   LD A,D:LD (HL),E
        RRA:RR (HL):RRA:RR (HL)
        RRA:RR (HL):RRA:RR (HL):AND #1
        INC H,H
        LD (HL),A
        EX DE,HL
        ADD HL,BC
        EX DE,HL
        INC H,H
        DEC XL:JRNZ DMLT1
        POP HL
        INC HL:LD A,H:CP MULTB.h+2
        JR C,DMLT
;------DECRUNCH MAP--------------
        LD HL,MAPDAT+#3FF
        LD D,MAP.h+#1F
        LD C,32
DECRMAP LD E,MAP+#1F
        LD B,32
DCRMP1  LD A,(HL):DEC HL
        DEC A:JP P,$+5:LD A,#80
        ADD A,#60:LD (DE),A:DEC E
        DJNZ DCRMP1
        DEC D,C:JRNZ DECRMAP
;-------------------------------
        IF 0
;GEN TEXTURE
        LD HL,#C000
M1      LD A,L
        RRCA
        AND 3
        OR 4
        LD (HL),A
        INC HL
        LD A,H
        OR A
        JR NZ,M1
        ENDIF
;-------------------------------
        CALL PAG0
;----DECRUNCH 16 BIT SINUS TABLE----
        LD HL,_SIN16
        LD DE,SIN16
DSIN16  LD A,(HL):LD (DE),A
        INC HL,D
        LD A,(HL):LD (DE),A
        INC HL:DEC D
        INC E
        JR NZ,DSIN16
;DECRUNCH DELAY ROUTINES
        LD IX,DELDAT
        LD HL,DEL0
        LD A,EDELDAT-DELDAT
        LD DE,DELTB0+54
DCRDEL  LD C,(IX):LD B,0
        INC IX
        PUSH DE
        LDIR
        POP DE
        DEC D
        DEC A
        JR NZ,DCRDEL
;--------GEN 1/X TABLE--------------
        LD HL,TAB1X
CLC1X0  XOR A
        PUSH HL
        SUB L
        LD C,A
        SBC A,A
        LD B,A
        LD HL,0
        SCF
        LD A,17
CLC1X1  ADC HL,HL
        ADD HL,BC
        JR C,$+4
        SBC HL,BC
        RL E
        RL D
        SUB 1
        JR NZ,CLC1X1
        POP HL
        LD (HL),E
        INC H
        LD (HL),D
        DEC H
        INC L
        JR NZ,CLC1X0
;DECRUNCH SCALE TABLE
;Y=256/X*2
        LD HL,SCALETB
        LD B,4
GSCTB0  LD (HL),SCLIDXE-SCLIDX-1*2
        INC L
        DJNZ GSCTB0
GSCTB1  PUSH HL
        LD C,L
        LD DE,512
        LD B,E
        CALL DIVWU
        LD A,E
        INC A
        AND #FE
        LD HL,SCLIDX
        LD BC,SCLIDXE-SCLIDX
        CPIR
        LD A,L
        SUB SCLIDX+1
        ADD A,A
        POP HL
        LD (HL),A
        INC L
        JR NZ,GSCTB1
;DECRUNCH DELAY JUMP TABLES
        LD HL,DELADRZ
        LD D,DELTB0.h
        LD A,7
DECRJD  LD E,(HL):INC HL
        LD C,(HL):INC HL
        LD B,0
        LDIR
        DEC D
        DEC A
        JR NZ,DECRJD
;------------------------
;DECRUNCH OFFSET TABLE
;------------------------
DOFS0   LD HL,SIN16
DANGL   EQU $-2
        LD E,(HL)               ;SIN
        INC H
        LD D,(HL)
        LD A,64:SUB L:LD L,A
        LD B,(HL)
        DEC H
        LD C,(HL)               ;COS
;X=W*COS+D*SIN
;Y=D*COS-W*SIN

;X0=-2*COS+1*SIN
;Y0=1*COS+2*SIN
        LD H,D:LD L,E
        LD (MXM),HL
        XOR A
        SBC HL,BC:SBC A,A
        IF WIDE
        OR A
        SBC HL,BC
        SBC A,0
        ENDIF
        LD (MX0),HL:LD (MX0+2),A
        LD H,D:LD L,E
        XOR A
        IF WIDE
        ADD HL,HL:RLA
        ENDIF
        ADD HL,BC:ADC A,0
        LD (MY0),HL:LD (MY0+2),A
;X1=2*COS+1*SIN
;Y1=1*COS-2*SIN
        LD H,B:LD L,C
        LD (MYM),HL
        XOR A
        IF WIDE
        ADD HL,HL:RLA
        ENDIF
        ADD HL,DE:ADC A,0
        LD (MX1),HL:LD (MX1+2),A
        LD H,B:LD L,C
        XOR A
        SBC HL,DE:SBC A,A
        IF WIDE
        OR A
        SBC HL,DE:SBC A,0
        ENDIF
        LD (MY1),HL:LD (MY1+2),A
;
        LD HL,MX0
        LD DE,MY0
        CALL GETSEGM
        LD (SEGM0),A    ; . 
        LD HL,SEGMTB
SGMTP   EQU $-2
        ADD A,A
        ADD A,A
        ADD A,A
        LD (HL),A
        INC L
        LD (SGMTP),HL
        LD A,(DANGL)
        CP 64
        JP NC,LAKO
;GET DX AND DY
        LD HL,(MX1):LD A,(MX0+2)
        LD C,A:LD A,(MX1+2)
        LD DE,(MX0):OR A
        SBC HL,DE
        EX DE,HL
        SBC A,C
        LD B,6:SRA A:RR D:RR E:DJNZ $-6
        LD B,A                  ;BDE-DX
                                ;CHL-X0
        ADD HL,HL
        LD A,C:RLA
        ADD HL,DE
        ADC A,B
        LD C,A
        SRA C
        RR H
        RR L
        EXX
        LD HL,(MY1):LD A,(MY0+2)
        LD C,A:LD A,(MY1+2)
        LD DE,(MY0):OR A
        SBC HL,DE
        EX DE,HL
        SBC A,C
        LD B,6:SRA A:RR D:RR E:DJNZ $-6
        LD B,A                  ;BDE'-DY
                                ;CHL'-Y0
        ADD HL,HL
        LD A,C:RLA
        ADD HL,DE
        ADC A,B
        LD C,A
        SRA C
        RR H
        RR L

        LD IX,STEPTB
CURSTPA EQU $-2
        LD A,#40
DOFS1   PUSH AF
        PUSH HL,DE,BC
;CHECK FOR Y
        LD (TMPY),HL:LD A,C
        LD (TMPY+2),A
        BIT 7,C
        JR Z,NONEGY
        LD A,C
        CPL
        LD C,A
        LD A,H
        CPL
        LD H,A
        LD A,L
        CPL
        INC A
        LD L,A
        JR NZ,$+3:INC H:JR NZ,$+3:INC C
NONEGY  EXX
        PUSH HL,DE,BC
;CHECK FOR X
        LD (TMPX),HL:LD A,C
        LD (TMPX+2),A
        BIT 7,C
        JR Z,NONEGX
        LD A,C
        CPL
        LD C,A
        LD A,H
        CPL
        LD H,A
        LD A,L
        CPL
        INC A
        LD L,A
        JR NZ,$+3:INC H:JR NZ,$+3:INC C
NONEGX
;CHL-ABS X
;CHL'-ABS Y
        PUSH HL,DE,BC
        LD HL,TMPX
        LD DE,TMPY
        CALL GETSEGM
        LD (TMPSEG),A
        PUSH AF
        SUB 0
SEGM0   EQU $-1
        AND 3
        LD HL,SEGM
SEGMAD  EQU $-2
        SLA (HL)
        SLA (HL)
        OR (HL)
        LD (HL),A
        LD A,0
ZUM     EQU $-1
        INC A:LD (ZUM),A
        INC HL
        AND 3
        JR NZ,$+5
        LD (SEGMAD),HL
        POP AF,BC,DE,HL
        INC A
        BIT 1,A
        JP Z,YMAIN
;MAIN AXIS IS X
;AUX STEP = Y/X
        EXX
        PUSH HL
        LD A,C
        EXX
        EX DE,HL
        LD B,C
        POP HL
        ADD HL,HL
        ADC A,A
        ADD HL,HL
        ADC A,A
        LD C,A
        CALL DIV2424    ;HL-STEP Y*4
        PUSH HL
        INC HL,HL
        LD A,L
        SRL H:RRA
        SRL H:RRA
        LD L,A
        JR Z,$+5
        LD HL,#FF
        LD (IX+2),L
;DISTANCE STEP = SGN(X)*XM+YM*STEPY
        LD A,(MXM)
        LD HL,(MXM+1)
        RLA:ADC HL,HL
        RLA:ADC HL,HL
        RLA:ADC HL,HL
        RLA:ADC HL,HL
        LD A,0
TMPSEG  EQU $-1
        AND 4
        JR Z,XHX
        NEGHL
XHX     POP BC      ;ABS(SX)*4
        PUSH HL
        LD A,(MYM)
        LD HL,(MYM+1)
        RLA:ADC HL,HL
        RLA:ADC HL,HL
        EX DE,HL
        LD A,(TMPSEG)
        ADD A,2
        AND 4
        JR Z,ZKL
        NEGBC
ZKL     CALL MUL1616
        POP DE
        ADD HL,DE
        LD DE,8
        ADD HL,DE
        BIT 7,H
        JRZ $+5
        LD HL,0
        LD A,L
        LD B,4:SRL H:RRA:DJNZ $-3
        LD (IX+0),A
        LD (IX+1),H
        LD A,(DANGL)
        OR A
        JP NZ,YCONT
        LD A,(IX+2)
        LD (IX+0),A
        LD (IX+1),0
        JP YCONT
YMAIN
;AUXSTEP=X/Y
        PUSH HL
        LD A,C
        EXX
        EX DE,HL
        LD B,C
        POP HL
        ADD HL,HL
        ADC A,A
        ADD HL,HL
        ADC A,A
        LD C,A
        CALL DIV2424
        PUSH HL
        INC HL,HL
        LD A,L
        SRL H:RRA
        SRL H:RRA
        LD L,A
        JR Z,$+5
        LD HL,#FF
        LD (IX+2),L
;DISTANCE STEP = YM*Y+XM*X
        LD A,(MYM)
        LD HL,(MYM+1)
        RLA:ADC HL,HL
        RLA:ADC HL,HL;*4
        RLA:ADC HL,HL;
        RLA:ADC HL,HL;*16
        LD A,(TMPSEG)
        INC A,A:AND 4
        JR Z,YHY
        NEGHL
YHY     POP BC         ;ABS(DE-STEP X)*4
        PUSH HL
        LD A,(MXM)
        LD HL,(MXM+1)
        RLA:ADC HL,HL
        RLA:ADC HL,HL
        EX DE,HL
        LD A,(TMPSEG)
        BIT 2,A
        JR Z,JKI
        NEGBC
JKI     CALL MUL1616
        POP DE
        ADC HL,DE
        LD DE,8
        ADD HL,DE
        LD B,4:LD A,L
        SRL H:RRA:DJNZ $-3
        LD L,A
        IF CORRECTION
        LD A,(DANGL)
        OR A
        JR NZ,$+5
        LD HL,EDINITSA
        ENDIF
        LD (IX+0),L
        LD (IX+1),H
        EXX
YCONT   LD DE,3:ADD IX,DE
        LD (CURSTPA),IX
        POP BC,DE,HL
        ADD HL,DE
        LD A,C
        ADC A,B
        LD C,A
        EXX
        POP BC,DE,HL
        ADD HL,DE
        LD A,C
        ADC A,B
        LD C,A
        POP AF
        DEC A
        JP NZ,DOFS1
LAKO    LD HL,DANGL
        LD A,(HL)
        INC A
        LD (HL),A
        CP 64
        JP C,DOFS0
;  
        LD HL,SEGMTB
        LD DE,SEGMTB+64
FINSTB  LD A,(HL):ADD A,16:AND #38:LD (DE),A
        INC L,E:JR NZ,FINSTB
;DECRUNCH MULTIPLY ROUTINE
        CREATE $GM,13
        LD HL,CHUNKY+96+2
        LD C,0
$GM1    LD DE,MULTAB
        LD B,MULTBE-MULTAB/3
$GM2    LD A,(DE)
        INC DE
        CP C
        JR Z,$GM3
        INC DE,DE
        DJNZ $GM2
;   
        LD B,8
        LD A,C
$GM4    ADD A,A
        JR C,$GM5
        DJNZ $GM4
$GM5    PUSH HL
        LD (HL),#62     ;LD H,D
        INC L
        JR Z,$GM6
        LD (HL),#6B     ;LD L,E
        INC L
        JR Z,$GM6
        LD E,13
        DJNZ $GM7
        JR $GM9
$GM7    LD (HL),#29     ;ADD HL,HL
        DEC E
        INC L
        JR Z,$GM6
        ADD A,A
        JR NC,$GM8
        LD (HL),#19     ;ADD HL,DE
        INC L
        JR Z,$GM6
        DEC E
$GM8    DJNZ $GM7
$GM9    LD B,E
        JR $GM13
$GM10   LD (HL),#7E     ;LD A,(HL)
        INC L
        JR Z,$GM6
        LD (HL),0       ;NOP
        INC L
        JR Z,$GM6
$GM13   DJNZ $GM10
$GM11   LD (HL),#C9     ;RET
        INC L
        JR NZ,$+5
        INC H
        LD L,#62
        POP DE
        LD B,MULADEJ.h
        LD A,E
        LD (BC),A
        INC B
        LD A,D
        JR $GM12
$GM6    POP HL:INC H:LD L,96+2:JR $GM1
$GM3    LD B,MULADEJ.h
        LD A,(DE):LD (BC),A:INC DE,B
        LD A,(DE)
$GM12   LD (BC),A
        INC C
        JR NZ,$GM1
        LD HL,TRRINF
        LD DE,TRROUTS
        LD BC,ETRINF-TRRINF
        LDIR
;DECRUNCH M2P
        CALL PAG7
        LD HL,M2PNF0
        LD DE,M2P
        LD BC,M2PNF2-M2PNF0
        LDIR
        PUSH HL
        LD HL,M2P+M2PNF1-M2PNF0
        LD C,M2PNF2-M2PNF1*31
        LDIR
        POP HL
        LD C,M2PNF4-M2PNF2
        LDIR
        PUSH HL
        LD HL,M2PNF2-M2PNF1*31+M2PNF3-M2PNF0+M2P
        LD C,M2PNF4-M2PNF3*31
        LDIR
        POP HL
        LD C,M2PNF5-M2PNF4
        LDIR
;DECRUNCH MUNKY DATA
        LD H,MUNKS.h
        LD A,#40
DMND    LD B,8
        LD L,MUNKS.h
DMND1   LD (HL),A
        INC A
        INC L
        DJNZ DMND1
        INC H
        CP #80
        JR C,DMND
;CREATE SCREEN ADDRZ
        LD HL,CHUNKY
        LD DE,#5880
        LD B,32
CSA     LD (HL),E
        INC L
        IF NOSCREEN
        LD (HL),0
        ELSE
        LD (HL),D
        ENDIF
        INC H
        DEC L
        LD A,D
        ADD A,#80
        LD D,A
        SBC A,A
        AND 32
        ADD A,E
        LD E,A
        ADC A,D
        SUB E
        LD D,A
        DJNZ CSA
;CREATE SKY OUTPUT
        LD HL,SKY_
        LD DE,SKYDELAY
        LD C,16
CSKO    STW #4231       ;LD SP,#NN42
        LD A,16+CHUNKY.h
        SUB C
        STA
        LD A,-10
        CALL SKDM
        LD B,32
CSKO1   STW #2D56       ;LD D,(HL):DEC L
        LD A,-11:CALL SKDM
        STW #D55E     ;LD E,(HL):PUSH DE
        LD A,-18:CALL SKDM
        LD A,B
        DEC A
        JR Z,CSKO2
        STB #2D         ;DEC L
        LD A,-4:CALL SKDM
CSKO2   DJNZ CSKO1
        LD A,C
        DEC A
        JR Z,CSKO3
        STW #6924       ;INC H:LD L,C
        LD A,-8
        CALL SKDM
CSKO3   DEC C
        JRNZ CSKO
;CREATE FLOOR
        STB #11         ;LD DE,0
        STW MUNKS.h*257
        LD A,-10
        CALL SKDM
        LD C,16
CSKO4   STW #4231       ;LD SP,XX32
        LD A,32+CHUNKY.h
        SUB C
        STA
        LD A,-10
        CALL SKDM
        LD B,32
CSKO5   STB #D5         ;PUSH DE
        LD A,-11
        CALL SKDM
        DJNZ CSKO5
        DEC C
        JR NZ,CSKO4
        STB #C3         ;JP SKYRET
        STW SKYRET
        RET

SKDM    ADD A,E
        LD E,A
        RETC
        DEC D
        RETP
        ADD A,876
        LD E,A
        LD D,876.h
        STW #EDD9       ;EXX:OUT (C),X
        LD A,#51
SKSC    EQU $-1
        XOR 8
        LD (SKSC),A
        STA
        STB #D9         ;EXX
        RET

M2PNF0  OUT (C),E
        LD SP,HL
        INC H
        EXX
        POP DE
M2PNF1  POP HL
        LDI
M2PNF2  EXX                     ;872
        LD SP,HL
        INC H
        INC HL:NOP:NOP          ;896
        OUT (C),D
        DEC HL                  ;914
        EXX
        POP DE                  ;928
M2PNF3  POP HL
        LDI                     ;1760
M2PNF4  INC HL:NOP              ;1770
        EXX:DEC XH              ;1782
        JP NZ,M2P               ;1792
        JP M2PR
M2PNF5

        INCLUDE "E:3DINCL.inc"
        UNPHASE
EITBS
UPSCR   DB #20,#04
        INSERT "E:DMFACEUP.scr"
DNSCR   DB #20,#04
        INSERT "E:DMFACEDN.scr"
ESCRS
