;ZASM SOURCE
;RESIDENT ROUTINES
        IFNDEF PG0
        INCLUDE "E:PAGES.asm"
        ENDIF
        INCLUDE "E:MACROS.mac"
PAG0    LD A,PG0:JR LKL
PAG1    LD A,PG1:JR LKL
PAG3    LD A,PG3:JR LKL
PAG4    LD A,PG4:JR LKL
PAG6    LD A,PG6:JR LKL
PAG7    LD A,PG7
LKL     PUSH BC:LD (PAGE),A:OR #00
SCREEN  EQU $-1:LD BC,#7FFD:OUT (C),A:POP BC:RET
PAGE    DB PG0
;HL-SRC
;DE-DEST
;B-COUNT
;C-LENGTH
CLONE   PUSH HL,BC:LD B,0:LDIR:POP BC,HL:DJNZ CLONE:RET
DNHL    EX DE,HL:CALL DNDE:EX DE,HL:RET
DNDE    INC D:LD A,D:AND 7:RET NZ:LD A,E:ADD A,32:LD E,A:RET C:LD A,D:ADD A,#F8:LD D,A:RET

;--------------------
;SCREEN FORMAT:
;WIDTH,LENGTH
;DEPACK SCREEN
;IN:
; HL-SOURCE
; DE-DEST
; CY=1    
_DEPSCR EXA
        LODBC
        PUSH BC,DE
DEPSC1  PUSH BC,DE
        LD C,B
DEPSC2  LD B,8
DEPSC3  LODA:LD (DE),A
        INC D
        DJNZ DEPSC3
        DEC D
        CALL DNDE
        DEC C
        JR NZ,DEPSC2
        POP DE,BC
        INC E
        DEC C
        JR NZ,DEPSC1
        POP DE,BC
        EXA
        RET NC
        LD A,D
        AND #18
        RRCA:RRCA:RRCA
        OR #58
        LD D,A
DEPSC4  PUSH BC,DE
        LD B,0
        LDIR
        POP DE
        LD C,32
        EX DE,HL
        ADD HL,BC
        EX DE,HL
        POP BC
        DJNZ DEPSC4
        RET

;HL=From
;DE=To

;HL=From
;DE=To

TableAdr       EQU #5000;[#05C0]
Tree1Adr       EQU TableAdr+#0000;[#0480]
Tree2Adr       EQU TableAdr+#0480;[#0080]
BitLenTb1      EQU TableAdr+#0480;[#0120]
BitLenTb2      EQU TableAdr+#05A0;[#0020]

;RELOCATE DEPACKER
;HL-BASE ADR
RELOCATE


DEPACK         PUSH DE
               LD C,(HL):INC HL
               LD B,(HL):INC HL
               EX DE,HL
               ADD HL,BC
               EX DE,HL
               LD C,(HL):INC HL
               LD B,(HL)
               ADD HL,BC
               SBC HL,DE
               ADD HL,DE
               JR C,$+4
               LD D,H:LD E,L
               LDDR
               INC DE

               PUSH DE:POP IX

UnpackTree     LD DE,(TREE1P)
               ld hl,Tree2Adr-Tree1Adr
               add hl,de
               ld (TREE2P),hl
               LD HL,BitLenTb1-1-Tree1Adr
;***
               add hl,de
               ex de,hl

               PUSH DE
               LD BC,#1201
               LD A,#10
               SRL C:CALL Z,GetNextByte
               RLA:JR NC,$-6
               INC DE:LD (DE),A
               DJNZ $-12

               PUSH BC
               LD DE,#0012
               CALL Tree1Create
               POP BC

               POP DE
UT0            CALL GetWord1
               CP #10
               JR C,UT1
               JR Z,UT2
               LD A,(DE)
               INC DE:LD (DE),A
UT1            INC DE:LD (DE),A
               JR UT0
UT2
               PUSH BC
               LD DE,#0120
               CALL Tree1Create
               LD HL,(TREE1P)
               LD BC,BitLenTb2-Tree1Adr
               ADD HL,BC
               LD BC,Tree2Adr
TREE2P         EQU $-2
BL1P           EQU $-2
               LD DE,#0020
               CALL TreeCreate
               POP BC
               POP DE

               XOR A
               PUSH AF:CALL GetWord1
               DEC H:JR NZ,$-5


UnpackWord     DEC DE
               CALL GetWord1
               INC DE:LD (DE),A
               DEC H:JR NZ,$-6
               OR A:JR Z,Stop
               CALL DecodeNum
               PUSH HL


               LD HL,(TREE2P)
               CALL GetWord
               OR A:JR Z,UW1
               CALL DecodeNum
               LD (LastDist),HL

               LD A,H
UW1            POP HL
               CP #01:JR C,$+8:INC HL
               CP #20:JR C,$+3:INC HL
               PUSH BC
               LD B,H:LD C,L
               LD H,D:LD L,E
               PUSH DE
LastDist       EQU $+1
               LD DE,#0000
               OR A:SBC HL,DE
               POP DE
               LDIR
               POP BC
               JR UnpackWord

Stop           POP AF:RET Z
               LD (DE),A:INC DE:JR $-4

DecodeNum      ADD A,-#05
               RET NC
               ADD A,#05-#03:RRA
               LD L,#01:RL L
               SRL C:CALL Z,GetNextByte
               ADC HL,HL:DEC A
               JR NZ,$-8
               INC HL
               RET

GetWord1       LD HL,(TREE1P)

GetWord        SRL C:CALL Z,GetNextByte
               JR NC,$+4:INC HL,HL
               LD A,(HL):INC HL
               LD L,(HL):LD H,A
               CP #40:JR NC,GetWord
               LD A,L
               RET
GetNextByte    LD C,(IX):INC IX:RR C
               RET

Tree1Create    LD HL,(BL1P)
               LD BC,Tree1Adr
TREE1P         EQU $-2

;HL= ⠡  ᫮
;BC= ॢ
;DE= ⠡  ᫮

TreeCreate     INC DE
               DEC HL,HL
               PUSH BC
               EXX
               POP DE:LD H,D:LD L,E
               XOR A:PUSH AF
               INC A
               PUSH HL
               PUSH AF
               LD C,A

TC1            EXX
               LD B,D:LD C,E:ADD HL,BC
               EXX

TC2            LD B,A
               LD A,C
               EXX
               CPDR:LD A,B:OR C
               EXX
               LD A,B
               JR NZ,TC4
               INC C:JR TC1
TC3            INC DE,DE,DE,DE
               LD (HL),D:INC HL
               LD (HL),E
               LD H,D:LD L,E
               INC A
               PUSH HL
               PUSH AF
TC4            CP C:JR NZ,TC3
               EXX:PUSH BC
               EXX:POP BC
               DEC BC
               LD (HL),B:INC HL
               LD (HL),C
               LD C,A
               POP AF:RET Z
               POP HL
               INC HL,HL
               JR TC2

;C*L=HL (ALL UNSIGNED)
MULBU:   XOR A:RR L:LD B,8
MULBU1  JR NC,$+3:ADD A,C:RRA:RR L
        DJNZ MULBU1:LD H,A:RET
;HL=A*DE (ALL SIGNED)
MULBWS: OR A:JP P,MULBWU:NEG:CALL MULBWU
        NEGHL:RET
MULBWU  LD B,8:LD HL,0
MULBWS1 ADD HL,HL:ADD A,A:JR NC,$+3
        ADD HL,DE
        DJNZ MULBWS1
        RET

;D-ADR OF TABLE
INISIN_ LD HL,SINTAB-1
        LD E,255
        LD BC,#06FA
INS     INC E
        LD A,E
        AND 3
        JR NZ,$+3
        INC HL
        XOR A
        RLC (HL)
        RLA
        RLC (HL)
        RLA
        DEC A
        ADD A,B
        LD B,A
        ADD A,C
        LD C,A
        CALL INSSR
        PUSH DE
        LD A,128
        SUB E
        LD E,A
        LD A,C
        CALL INSSR
        POP DE
        BIT 6,E
        JR Z,INS
        RET
INSSR   LD (DE),A
        SET 7,E
        NEG
        LD (DE),A
        INC D
        SBC A,A
        LD (DE),A
        RES 7,E
        XOR A
        LD (DE),A
        DEC D
        RET
SINTAB ;㯠 
        DB #58,#56,#15,#55
        DB #49,#21,#85,#52
        DB #21,#54,#88,#54
        DB #85,#52,#15,#48,#55
;div/mod: HL=DE\BC,DE=DE/BC
DIVWU   NEGBC:LD HL,0:RL E:RL D:LD A,16
DVW0    ADC HL,HL:ADD HL,BC:JR C,$+4
        SBC HL,BC:RL E:RL D:DEC A
        JR NZ,DVW0:RET
;UNSIGNED/SIGNED multiply HL=HL*DE
MULW    LD A,H:LD C,L:LD HL,0:LD B,16
MWS1    ADD HL,HL:RL C:RLA:JR NC,$+3
        ADD HL,DE:DJNZ MWS1
        RET
;HL=HL/A; HL- SIGNED,A-UNSIGNED
DIVWBS  INC H
        DEC H
        JP P,DIVWBU
        NEG
        LD C,A
        NEGHL
        CALL DWBU0
        NEGHL
        RET
DIVWBU  NEG:LD C,A
DWBU0   XOR A:ADD HL,HL
        LD B,16
DWBU1   RLA:ADD A,C:JR C,$+3:SUB C
        ADC HL,HL:DJNZ DWBU1:RET

;GEN TABLE Y.W=X*X
;D-ADDRES OF TABLE
GENXX_  LD E,0
        PUSH DE:POP IX
        LD L,E:LD H,E:LD B,E:LD C,E
GNXX    CALL GNXX1
        LD (IX),L:INC XH
        LD (IX),H:DEC XH
        ADD HL,BC:INC C
        ADD HL,BC
        DEC XL
        INC E:JP P,GNXX
GNXX1   LD A,L:LD (DE),A:INC D
        LD A,H:LD (DE),A:DEC D
        RET

