MODULE [noinit] Rsrc; IMPORT SYSTEM;

TYPE
  LevelsData = ARRAY 25*367 OF SYSTEM.BYTE;
  TilesData = ARRAY 10*9 OF SYSTEM.BYTE;

CONST
  Tiles* = TilesData(
    000H,000H,000H,000H,000H,000H,000H,000H, 000H, (* 0 - Empty *)
    000H,00CH,012H,03DH,041H,07FH,067H,07EH, 046H, (* 1 - Klad *)
    060H,070H,060H,070H,060H,070H,060H,070H, 043H, (* 2 - Door w/o key *)
    060H,070H,060H,070H,060H,070H,060H,070H, 043H, (* 3 - Door next level *)
    000H,000H,000H,000H,000H,000H,000H,080H, 045H, (* 4 - Water surface *)
    0DDH,0DDH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH, 041H, (* 5 - Water deep *)
    042H,0FFH,042H,042H,042H,0FFH,042H,042H, 045H, (* 6 - Stairs *)
    000H,0FFH,0AAH,0AAH,000H,000H,000H,000H, 044H, (* 7 - Bridge *)
    000H,0BFH,0BFH,0BFH,000H,0FDH,0FDH,0FDH, 042H, (* 8 - Brick *)
    04BH,0FEH,0CFH,0B9H,073H,0FEH,093H,0EDH, 047H  (* 9 - Concrete *)
   );

  Levels* = LevelsData(
    (* Level 1: *)
    1CH,00H,62H,00H,0FH,00H,00H,00H,00H,02H,03H,01H,04H,07H,01H,
    99H,88H,88H,88H,88H,88H,88H,08H,88H,88H,88H,88H,88H,88H,86H,99H,
    99H,00H,00H,00H,00H,00H,00H,00H,00H,00H,10H,00H,08H,03H,06H,99H,
    99H,00H,60H,88H,88H,88H,68H,88H,88H,88H,88H,08H,68H,88H,88H,99H,
    99H,10H,67H,00H,00H,10H,60H,00H,00H,00H,60H,00H,60H,68H,18H,99H,
    99H,80H,60H,08H,88H,88H,88H,80H,60H,88H,68H,78H,88H,60H,88H,99H,
    99H,80H,60H,00H,00H,00H,00H,00H,60H,00H,80H,00H,00H,60H,08H,99H,
    99H,80H,60H,00H,70H,88H,88H,87H,87H,88H,88H,76H,77H,08H,08H,99H,
    99H,80H,60H,78H,06H,00H,00H,80H,00H,00H,00H,06H,00H,00H,00H,99H,
    99H,80H,00H,00H,76H,88H,88H,80H,60H,88H,88H,78H,78H,88H,88H,99H,
    99H,80H,77H,08H,06H,10H,80H,80H,60H,00H,00H,00H,00H,00H,00H,99H,
    99H,80H,00H,08H,86H,88H,80H,00H,90H,77H,88H,78H,78H,88H,06H,99H,
    99H,80H,01H,08H,06H,80H,80H,88H,90H,44H,94H,10H,08H,88H,06H,99H,
    99H,80H,08H,08H,06H,00H,00H,80H,90H,99H,99H,80H,08H,00H,06H,99H,
    99H,80H,08H,49H,89H,86H,87H,00H,00H,00H,00H,80H,78H,88H,06H,99H,
    99H,80H,08H,99H,89H,86H,80H,88H,87H,88H,08H,00H,00H,88H,06H,99H,
    99H,80H,18H,00H,00H,06H,00H,00H,00H,00H,78H,87H,08H,88H,06H,99H,
    99H,80H,88H,80H,86H,88H,87H,88H,88H,08H,00H,00H,00H,88H,06H,99H,
    99H,80H,88H,00H,06H,00H,00H,10H,00H,00H,69H,87H,00H,00H,06H,99H,
    99H,80H,88H,88H,86H,88H,77H,88H,88H,77H,69H,80H,78H,08H,06H,99H,
    99H,00H,00H,00H,06H,00H,00H,00H,00H,00H,61H,80H,08H,08H,06H,99H,
    99H,00H,00H,00H,96H,44H,44H,44H,44H,44H,99H,44H,44H,99H,99H,99H,
    99H,99H,99H,99H,99H,55H,55H,55H,55H,55H,55H,55H,55H,99H,99H,99H,

01DH,000H,062H,002H,009H,000H,015H,000H,000H,01BH,015H,00FH,00CH,002H,009H,099H,000H,
000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,069H,099H,099H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,069H,099H,099H,
010H,066H,066H,016H,066H,066H,016H,066H,066H,016H,066H,066H,016H,063H,099H,099H,060H,000H,006H,060H,000H,006H,060H,000H,006H,060H,000H,006H,060H,099H,099H,
099H,060H,000H,006H,060H,000H,006H,060H,000H,006H,060H,000H,006H,060H,090H,099H,099H,060H,066H,061H,066H,066H,061H,066H,066H,061H,066H,066H,061H,066H,090H,
099H,099H,060H,000H,006H,060H,000H,006H,060H,000H,006H,060H,000H,006H,060H,090H,099H,099H,060H,000H,006H,060H,000H,006H,060H,000H,006H,060H,000H,006H,060H,
090H,099H,099H,010H,066H,066H,016H,066H,066H,016H,066H,066H,016H,066H,066H,016H,090H,099H,099H,060H,000H,006H,060H,000H,006H,060H,000H,006H,060H,000H,006H,
060H,090H,099H,099H,060H,000H,006H,060H,000H,006H,060H,000H,006H,060H,000H,006H,060H,090H,099H,099H,060H,066H,061H,066H,066H,061H,066H,066H,061H,066H,066H,
061H,066H,090H,099H,099H,060H,000H,006H,060H,000H,006H,060H,000H,006H,060H,000H,006H,060H,090H,099H,099H,060H,000H,006H,060H,000H,006H,060H,000H,006H,060H,
000H,006H,060H,090H,099H,099H,010H,066H,066H,016H,066H,066H,016H,066H,066H,016H,066H,066H,016H,090H,099H,099H,060H,000H,006H,060H,000H,006H,060H,000H,006H,
060H,000H,006H,060H,090H,099H,099H,060H,000H,006H,060H,000H,006H,060H,000H,006H,060H,000H,006H,060H,090H,099H,099H,060H,066H,061H,066H,066H,061H,066H,066H,
061H,066H,066H,061H,066H,090H,099H,099H,060H,000H,006H,060H,000H,006H,060H,000H,006H,060H,000H,006H,060H,090H,099H,099H,060H,000H,006H,060H,000H,006H,060H,
000H,006H,060H,000H,006H,060H,090H,099H,099H,099H,044H,044H,044H,044H,044H,044H,044H,044H,044H,044H,044H,044H,094H,099H,099H,099H,055H,055H,055H,055H,055H,
055H,055H,055H,055H,055H,055H,055H,095H,099H,01CH,000H,0E4H,001H,00FH,002H,011H,002H,000H,001H,002H,005H,006H,009H,003H,099H,009H,000H,000H,000H,000H,000H,
000H,000H,000H,000H,000H,000H,000H,096H,099H,099H,069H,077H,077H,077H,077H,077H,077H,008H,000H,000H,000H,000H,000H,096H,099H,099H,069H,000H,000H,000H,000H,
000H,000H,008H,000H,000H,000H,000H,000H,096H,099H,099H,069H,000H,000H,000H,000H,000H,088H,088H,008H,000H,000H,000H,000H,096H,099H,099H,069H,000H,000H,000H,
000H,080H,088H,080H,088H,000H,000H,000H,000H,096H,099H,099H,069H,000H,000H,000H,000H,000H,080H,081H,000H,000H,000H,000H,000H,096H,099H,099H,069H,000H,000H,
000H,000H,080H,088H,086H,088H,000H,000H,000H,000H,096H,099H,099H,069H,000H,000H,000H,000H,088H,008H,006H,088H,008H,000H,000H,000H,096H,099H,099H,069H,000H,
000H,000H,000H,000H,018H,016H,008H,000H,000H,000H,000H,096H,099H,099H,069H,000H,000H,000H,000H,080H,088H,086H,088H,000H,000H,000H,000H,096H,099H,099H,069H,
000H,000H,000H,000H,088H,008H,006H,088H,008H,000H,000H,000H,096H,099H,099H,069H,000H,000H,000H,000H,000H,018H,016H,008H,000H,000H,000H,000H,096H,099H,099H,
069H,000H,000H,000H,000H,088H,088H,086H,088H,008H,000H,000H,000H,096H,099H,099H,069H,000H,000H,000H,080H,088H,008H,006H,088H,088H,000H,000H,000H,096H,099H,
099H,069H,000H,000H,000H,000H,000H,018H,016H,008H,000H,000H,000H,000H,096H,099H,099H,069H,000H,000H,000H,080H,088H,088H,086H,088H,088H,000H,000H,000H,096H,
099H,099H,069H,000H,000H,000H,088H,088H,008H,006H,088H,088H,008H,000H,000H,096H,099H,099H,069H,000H,000H,000H,000H,080H,000H,006H,080H,000H,000H,000H,090H,
096H,099H,099H,069H,090H,000H,000H,000H,080H,010H,016H,080H,000H,000H,000H,030H,096H,099H,099H,099H,099H,077H,077H,088H,088H,088H,088H,088H,088H,078H,077H,
097H,099H,099H,099H,049H,044H,044H,044H,088H,088H,088H,088H,088H,088H,048H,044H,044H,094H,099H,099H,059H,055H,055H,055H,088H,088H,088H,088H,088H,088H,058H,
055H,055H,095H,099H,004H,000H,082H,002H,046H,000H,000H,000H,000H,004H,00EH,00FH,005H,002H,00AH,099H,000H,006H,000H,000H,000H,000H,000H,000H,000H,000H,000H,
000H,000H,000H,099H,099H,000H,006H,000H,000H,000H,000H,001H,000H,077H,077H,077H,077H,077H,006H,099H,099H,000H,006H,000H,000H,000H,000H,077H,006H,000H,000H,
000H,000H,000H,006H,099H,099H,030H,006H,006H,000H,000H,000H,000H,006H,071H,077H,077H,006H,000H,006H,099H,099H,076H,000H,060H,000H,000H,000H,060H,000H,000H,
000H,000H,060H,000H,006H,099H,099H,006H,009H,000H,006H,000H,000H,006H,000H,060H,077H,077H,007H,000H,006H,099H,099H,086H,078H,077H,060H,000H,000H,006H,000H,
060H,000H,000H,000H,000H,006H,099H,099H,060H,000H,000H,000H,006H,000H,060H,000H,000H,077H,077H,006H,001H,006H,099H,099H,060H,001H,000H,000H,060H,000H,000H,
006H,000H,000H,000H,006H,000H,006H,099H,099H,060H,008H,000H,000H,000H,006H,000H,006H,060H,077H,077H,000H,001H,006H,099H,099H,060H,010H,011H,011H,001H,060H,
006H,060H,060H,000H,000H,000H,000H,006H,099H,099H,060H,080H,077H,077H,007H,061H,060H,060H,000H,077H,077H,006H,001H,006H,099H,099H,060H,001H,011H,011H,001H,
077H,000H,060H,000H,000H,000H,006H,000H,006H,099H,099H,000H,008H,078H,077H,077H,077H,006H,006H,077H,077H,077H,000H,078H,006H,099H,099H,000H,000H,000H,000H,
000H,000H,060H,000H,000H,000H,000H,000H,000H,006H,099H,099H,000H,060H,077H,077H,077H,067H,000H,060H,077H,077H,077H,077H,077H,000H,099H,099H,000H,060H,000H,
000H,000H,000H,077H,007H,000H,000H,000H,000H,000H,000H,099H,099H,000H,000H,077H,077H,077H,006H,000H,000H,076H,077H,077H,077H,077H,006H,099H,099H,000H,000H,
000H,000H,000H,070H,077H,077H,000H,000H,000H,000H,000H,006H,099H,099H,000H,060H,077H,077H,067H,000H,000H,000H,060H,077H,077H,077H,077H,000H,099H,099H,000H,
060H,000H,000H,000H,077H,077H,077H,007H,000H,000H,000H,000H,000H,099H,099H,099H,099H,044H,044H,044H,044H,044H,044H,044H,044H,044H,044H,044H,044H,099H,01EH,
000H,082H,002H,048H,000H,057H,000H,000H,005H,00DH,019H,017H,00FH,003H,099H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,096H,099H,
000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,096H,099H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,096H,
099H,000H,088H,088H,088H,088H,067H,077H,077H,076H,088H,088H,088H,088H,000H,096H,099H,000H,008H,010H,001H,090H,060H,000H,000H,006H,009H,010H,001H,080H,000H,
096H,099H,000H,080H,088H,088H,097H,060H,000H,000H,006H,079H,088H,088H,008H,000H,096H,099H,000H,008H,010H,001H,090H,060H,000H,000H,006H,009H,010H,001H,080H,
000H,096H,099H,000H,080H,088H,088H,097H,060H,000H,000H,006H,079H,088H,088H,008H,000H,096H,099H,000H,008H,010H,001H,090H,060H,000H,000H,006H,009H,010H,001H,
080H,000H,096H,099H,000H,080H,088H,088H,097H,060H,000H,000H,006H,079H,088H,088H,008H,000H,096H,099H,000H,008H,010H,001H,090H,060H,000H,000H,006H,009H,010H,
001H,080H,000H,096H,099H,000H,080H,088H,088H,097H,060H,000H,000H,006H,079H,088H,088H,008H,000H,096H,099H,000H,008H,010H,001H,090H,060H,000H,000H,006H,009H,
010H,001H,080H,000H,096H,099H,000H,080H,088H,088H,097H,060H,000H,000H,006H,079H,088H,088H,008H,000H,096H,099H,000H,008H,010H,001H,090H,060H,000H,000H,006H,
009H,010H,001H,080H,000H,096H,099H,000H,080H,088H,088H,097H,060H,000H,000H,006H,079H,088H,088H,008H,000H,096H,099H,000H,008H,010H,001H,090H,060H,000H,000H,
006H,009H,010H,001H,080H,000H,096H,099H,000H,080H,088H,088H,097H,060H,000H,000H,006H,079H,088H,088H,008H,000H,096H,099H,000H,008H,010H,001H,080H,060H,000H,
000H,006H,008H,010H,001H,080H,000H,096H,099H,000H,088H,088H,088H,097H,060H,000H,000H,006H,079H,088H,088H,088H,090H,096H,099H,000H,002H,000H,000H,020H,060H,
000H,000H,006H,002H,000H,000H,020H,030H,096H,099H,099H,099H,099H,099H,099H,099H,044H,044H,099H,099H,099H,099H,099H,099H,099H,019H,000H,001H,000H,00BH,000H,
018H,000H,001H,005H,001H,002H,003H,006H,002H,009H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,060H,000H,000H,090H,009H,000H,076H,087H,099H,099H,
099H,009H,000H,000H,000H,000H,060H,000H,000H,090H,009H,060H,000H,000H,019H,010H,010H,009H,000H,000H,000H,000H,060H,000H,000H,090H,009H,006H,000H,000H,069H,
060H,060H,069H,000H,080H,088H,001H,060H,000H,069H,090H,009H,060H,000H,000H,069H,060H,060H,009H,000H,090H,099H,099H,099H,099H,069H,090H,009H,000H,006H,000H,
069H,060H,060H,009H,000H,008H,000H,000H,000H,000H,069H,090H,009H,000H,060H,000H,069H,060H,060H,009H,040H,000H,000H,000H,000H,000H,069H,090H,009H,000H,060H,
010H,069H,060H,060H,009H,009H,000H,000H,000H,000H,000H,069H,090H,009H,060H,069H,000H,069H,060H,060H,009H,009H,060H,009H,000H,096H,000H,069H,090H,009H,060H,
009H,006H,069H,060H,060H,009H,018H,062H,009H,000H,096H,000H,069H,090H,009H,060H,009H,006H,069H,060H,060H,009H,090H,067H,009H,068H,090H,000H,069H,090H,009H,
060H,069H,000H,069H,060H,060H,009H,000H,060H,009H,006H,090H,000H,069H,090H,009H,060H,069H,000H,069H,060H,060H,009H,080H,068H,009H,060H,090H,000H,069H,090H,
009H,060H,009H,006H,069H,060H,060H,009H,076H,007H,009H,000H,096H,000H,069H,090H,009H,060H,009H,006H,069H,060H,060H,009H,086H,008H,009H,068H,090H,000H,069H,
090H,009H,060H,069H,000H,069H,060H,060H,009H,070H,067H,009H,006H,090H,000H,069H,090H,009H,060H,069H,000H,069H,060H,060H,009H,080H,068H,009H,060H,090H,000H,
063H,090H,009H,060H,009H,006H,069H,060H,060H,009H,076H,007H,009H,000H,096H,060H,099H,090H,009H,060H,009H,006H,069H,069H,069H,009H,086H,008H,009H,060H,090H,
060H,089H,090H,009H,060H,069H,000H,060H,060H,060H,000H,070H,067H,009H,006H,090H,060H,009H,099H,009H,060H,069H,000H,060H,060H,060H,000H,000H,060H,068H,000H,
090H,060H,049H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,01CH,000H,085H,002H,00DH,000H,014H,000H,000H,007H,005H,
003H,002H,003H,003H,044H,044H,044H,044H,044H,044H,009H,049H,044H,094H,090H,044H,044H,094H,096H,044H,055H,099H,099H,099H,059H,055H,009H,059H,055H,095H,090H,
099H,059H,095H,096H,055H,055H,019H,000H,010H,059H,099H,009H,099H,059H,095H,001H,000H,059H,095H,096H,055H,055H,099H,096H,099H,059H,009H,060H,000H,059H,095H,
099H,069H,099H,099H,096H,059H,055H,095H,096H,055H,055H,069H,099H,069H,059H,055H,055H,069H,000H,030H,006H,059H,055H,095H,096H,055H,055H,069H,059H,069H,059H,
055H,055H,099H,096H,099H,099H,059H,055H,095H,096H,055H,055H,069H,059H,069H,059H,055H,055H,095H,096H,055H,055H,055H,055H,095H,096H,099H,099H,069H,059H,069H,
099H,099H,099H,095H,096H,099H,099H,059H,055H,095H,006H,000H,000H,060H,059H,069H,000H,000H,091H,095H,006H,000H,001H,059H,055H,095H,096H,099H,099H,069H,059H,
069H,099H,099H,099H,095H,069H,099H,049H,059H,055H,095H,096H,055H,055H,069H,059H,069H,059H,055H,055H,055H,069H,059H,099H,059H,095H,099H,096H,055H,055H,069H,
059H,069H,099H,099H,059H,055H,069H,059H,055H,055H,095H,000H,096H,055H,055H,069H,059H,069H,000H,010H,059H,055H,069H,059H,099H,099H,095H,096H,099H,099H,099H,
069H,099H,099H,099H,096H,059H,099H,069H,059H,009H,091H,095H,006H,000H,000H,000H,060H,000H,059H,095H,096H,055H,009H,060H,059H,069H,099H,095H,096H,099H,099H,
099H,099H,099H,059H,095H,096H,055H,069H,099H,059H,069H,059H,095H,096H,055H,055H,055H,055H,055H,055H,095H,096H,055H,069H,059H,055H,069H,059H,095H,096H,055H,
095H,099H,095H,099H,099H,099H,096H,099H,069H,099H,055H,069H,059H,095H,096H,055H,095H,091H,095H,010H,000H,000H,006H,000H,060H,090H,099H,069H,059H,095H,096H,
099H,099H,096H,095H,094H,099H,099H,099H,099H,099H,006H,000H,060H,059H,095H,006H,000H,000H,096H,095H,099H,055H,055H,055H,055H,095H,099H,099H,099H,059H,095H,
099H,099H,099H,099H,055H,055H,055H,055H,055H,055H,055H,055H,055H,055H,055H,01DH,000H,082H,002H,00AH,000H,016H,000H,000H,006H,005H,004H,003H,002H,004H,099H,
099H,099H,099H,099H,090H,099H,099H,099H,099H,099H,090H,099H,099H,069H,099H,099H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,069H,099H,
099H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,069H,099H,099H,000H,060H,077H,076H,067H,077H,076H,078H,076H,067H,077H,076H,067H,069H,
099H,099H,000H,060H,000H,006H,060H,000H,006H,008H,006H,060H,000H,006H,060H,069H,099H,099H,000H,060H,077H,076H,067H,077H,086H,080H,076H,067H,077H,076H,067H,
069H,099H,099H,000H,060H,000H,006H,060H,000H,086H,081H,006H,060H,000H,006H,060H,069H,099H,099H,000H,060H,077H,076H,067H,077H,078H,077H,078H,067H,077H,076H,
067H,069H,099H,099H,000H,060H,000H,006H,060H,000H,008H,001H,008H,060H,000H,006H,060H,069H,099H,099H,000H,060H,077H,076H,060H,080H,077H,077H,087H,060H,070H,
076H,067H,069H,099H,099H,000H,060H,000H,006H,060H,000H,000H,001H,000H,060H,000H,006H,060H,069H,099H,099H,000H,060H,077H,076H,060H,008H,006H,077H,006H,068H,
070H,076H,067H,069H,099H,099H,000H,060H,000H,006H,060H,008H,006H,001H,006H,068H,000H,006H,060H,069H,099H,099H,000H,060H,077H,076H,080H,000H,076H,007H,006H,
080H,070H,076H,067H,069H,099H,099H,000H,060H,000H,006H,020H,070H,006H,001H,076H,020H,000H,006H,060H,069H,099H,099H,000H,060H,077H,076H,088H,008H,006H,077H,
006H,088H,078H,076H,067H,069H,099H,099H,000H,060H,000H,006H,000H,000H,006H,001H,006H,000H,000H,006H,060H,063H,099H,099H,069H,069H,077H,006H,008H,070H,076H,
007H,076H,000H,008H,076H,067H,099H,099H,099H,069H,049H,044H,044H,088H,048H,044H,044H,044H,088H,048H,044H,044H,099H,099H,099H,060H,059H,055H,055H,055H,055H,
055H,055H,055H,055H,055H,055H,055H,055H,099H,099H,060H,059H,055H,055H,055H,055H,055H,055H,055H,055H,055H,055H,055H,055H,099H,099H,099H,059H,055H,055H,055H,
055H,055H,055H,055H,055H,055H,055H,055H,055H,099H,010H,000H,082H,002H,023H,001H,03CH,001H,000H,00AH,00BH,00AH,01FH,00BH,01CH,099H,000H,000H,000H,000H,000H,
000H,090H,096H,000H,000H,000H,000H,000H,000H,099H,099H,076H,000H,000H,000H,000H,000H,030H,096H,000H,000H,000H,000H,000H,067H,099H,099H,076H,077H,077H,077H,
077H,077H,097H,099H,077H,077H,077H,077H,077H,067H,099H,099H,016H,000H,001H,010H,000H,001H,010H,000H,001H,010H,000H,001H,010H,060H,099H,099H,076H,077H,077H,
077H,077H,077H,077H,077H,077H,077H,077H,077H,077H,067H,099H,099H,006H,001H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,010H,060H,099H,099H,006H,099H,
044H,094H,099H,044H,094H,099H,044H,094H,049H,099H,094H,060H,099H,099H,016H,059H,055H,055H,059H,055H,055H,059H,055H,055H,059H,099H,095H,061H,099H,099H,006H,
059H,099H,059H,059H,099H,059H,059H,099H,059H,059H,099H,095H,060H,099H,099H,006H,059H,099H,059H,059H,099H,099H,059H,099H,099H,059H,099H,095H,060H,099H,099H,
016H,059H,099H,059H,059H,055H,055H,059H,099H,099H,059H,099H,095H,061H,099H,099H,006H,059H,055H,055H,099H,099H,059H,059H,099H,099H,059H,099H,095H,060H,099H,
099H,006H,059H,055H,055H,059H,099H,059H,059H,099H,059H,059H,099H,095H,060H,099H,099H,016H,059H,099H,059H,059H,055H,055H,059H,055H,055H,059H,099H,095H,061H,
099H,099H,006H,059H,099H,059H,099H,055H,095H,099H,055H,095H,059H,099H,095H,060H,099H,099H,006H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,
060H,099H,099H,016H,010H,010H,010H,010H,010H,010H,010H,010H,010H,010H,010H,010H,060H,099H,099H,006H,006H,006H,006H,006H,006H,006H,006H,006H,006H,006H,006H,
006H,006H,099H,099H,060H,060H,060H,060H,060H,060H,060H,061H,060H,060H,060H,060H,060H,060H,099H,099H,006H,006H,006H,006H,016H,006H,006H,006H,006H,016H,006H,
006H,006H,006H,099H,099H,060H,060H,061H,060H,060H,060H,060H,061H,060H,060H,060H,060H,061H,060H,099H,099H,088H,088H,088H,088H,088H,088H,088H,088H,088H,088H,
088H,088H,088H,088H,099H,01EH,000H,081H,002H,045H,000H,000H,000H,001H,004H,004H,01CH,005H,004H,004H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,
099H,099H,099H,099H,096H,009H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,096H,009H,000H,000H,000H,011H,000H,000H,000H,000H,008H,
000H,000H,000H,000H,031H,096H,069H,088H,088H,088H,088H,088H,088H,088H,080H,086H,088H,088H,088H,088H,088H,098H,069H,000H,000H,000H,000H,000H,000H,000H,060H,
008H,000H,000H,000H,000H,000H,090H,069H,000H,000H,000H,000H,000H,000H,000H,060H,006H,000H,000H,000H,010H,000H,090H,069H,000H,000H,090H,099H,099H,099H,099H,
000H,006H,000H,000H,000H,000H,000H,090H,069H,000H,000H,090H,016H,016H,016H,096H,000H,006H,000H,010H,001H,000H,000H,090H,069H,000H,000H,090H,061H,061H,061H,
091H,000H,086H,088H,088H,088H,088H,088H,096H,069H,000H,000H,090H,016H,016H,016H,096H,000H,000H,000H,000H,000H,000H,000H,096H,069H,000H,000H,090H,061H,061H,
061H,091H,010H,000H,000H,000H,000H,000H,000H,096H,069H,077H,077H,097H,016H,016H,016H,096H,000H,000H,000H,000H,000H,000H,000H,096H,069H,000H,000H,090H,099H,
069H,099H,099H,000H,076H,077H,077H,077H,077H,077H,090H,069H,000H,000H,000H,000H,060H,000H,000H,000H,006H,000H,000H,000H,000H,000H,096H,069H,000H,000H,086H,
088H,068H,000H,000H,000H,070H,077H,077H,077H,077H,077H,096H,069H,000H,000H,006H,000H,060H,000H,000H,010H,000H,000H,000H,000H,000H,000H,096H,069H,000H,000H,
006H,000H,060H,010H,000H,000H,000H,000H,001H,000H,000H,000H,096H,009H,006H,000H,006H,000H,080H,087H,087H,087H,087H,088H,088H,088H,088H,088H,098H,009H,060H,
000H,070H,077H,077H,077H,006H,010H,000H,000H,000H,000H,000H,000H,090H,009H,000H,006H,000H,000H,000H,000H,088H,088H,008H,000H,000H,000H,000H,000H,090H,009H,
080H,096H,044H,044H,044H,044H,044H,044H,044H,044H,044H,044H,044H,044H,094H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,
03EH,000H,042H,002H,024H,000H,01CH,000H,001H,002H,003H,014H,007H,002H,003H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,009H,090H,099H,
069H,066H,000H,000H,000H,000H,000H,020H,038H,000H,000H,000H,000H,000H,008H,096H,069H,000H,077H,077H,077H,077H,077H,077H,078H,077H,077H,077H,077H,087H,000H,
096H,069H,000H,000H,000H,000H,000H,000H,000H,008H,000H,000H,000H,000H,000H,000H,096H,069H,000H,000H,000H,000H,000H,000H,000H,008H,000H,000H,000H,000H,000H,
000H,096H,069H,000H,000H,000H,000H,000H,000H,000H,008H,000H,000H,000H,000H,000H,000H,096H,069H,000H,000H,000H,000H,000H,000H,000H,008H,000H,000H,000H,000H,
000H,000H,096H,069H,010H,000H,000H,000H,000H,000H,010H,018H,000H,000H,000H,000H,000H,001H,096H,069H,000H,000H,000H,000H,000H,000H,080H,088H,000H,000H,000H,
000H,000H,000H,096H,069H,000H,000H,000H,000H,000H,000H,080H,086H,000H,000H,000H,000H,000H,000H,096H,069H,000H,000H,000H,000H,000H,000H,088H,086H,008H,000H,
000H,000H,000H,000H,096H,069H,010H,000H,000H,000H,000H,084H,080H,086H,080H,004H,000H,000H,000H,001H,096H,069H,000H,000H,000H,000H,000H,088H,081H,086H,081H,
008H,000H,000H,000H,000H,096H,069H,000H,000H,000H,000H,040H,018H,008H,006H,018H,048H,000H,000H,000H,000H,096H,069H,080H,000H,000H,000H,084H,078H,077H,076H,
077H,088H,004H,000H,000H,008H,096H,069H,000H,000H,000H,000H,008H,018H,000H,006H,010H,008H,008H,000H,000H,000H,096H,069H,000H,000H,000H,084H,076H,078H,077H,
076H,077H,078H,086H,004H,000H,000H,096H,069H,000H,000H,040H,008H,006H,018H,000H,006H,010H,008H,006H,048H,000H,010H,096H,069H,000H,000H,080H,010H,006H,078H,
077H,076H,077H,008H,016H,080H,044H,094H,096H,069H,099H,000H,080H,000H,006H,018H,000H,006H,010H,009H,006H,080H,099H,095H,096H,069H,020H,000H,080H,000H,096H,
099H,099H,099H,099H,099H,006H,080H,091H,095H,096H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,01DH,000H,084H,002H,005H,
000H,01AH,000H,000H,012H,006H,008H,00BH,012H,005H,099H,099H,009H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,090H,069H,099H,099H,096H,069H,011H,096H,
069H,099H,006H,060H,099H,016H,061H,099H,096H,069H,099H,099H,096H,069H,099H,096H,069H,099H,096H,069H,099H,096H,069H,099H,096H,069H,099H,099H,006H,060H,099H,
096H,069H,099H,096H,069H,099H,096H,069H,099H,096H,069H,099H,099H,099H,069H,099H,006H,060H,000H,096H,069H,000H,096H,069H,011H,096H,069H,099H,099H,096H,069H,
099H,099H,099H,099H,096H,099H,099H,096H,099H,099H,099H,069H,099H,099H,096H,069H,099H,096H,069H,099H,096H,069H,099H,096H,069H,099H,096H,069H,099H,099H,096H,
069H,099H,096H,069H,099H,096H,069H,099H,096H,069H,099H,096H,069H,099H,099H,096H,069H,000H,006H,060H,099H,016H,061H,099H,006H,060H,000H,096H,069H,099H,099H,
096H,099H,099H,096H,069H,099H,099H,099H,099H,096H,099H,099H,096H,069H,099H,099H,096H,069H,099H,096H,069H,099H,096H,069H,099H,096H,069H,099H,096H,069H,099H,
099H,096H,069H,099H,096H,069H,099H,096H,069H,099H,096H,069H,099H,096H,069H,099H,099H,016H,061H,099H,096H,069H,000H,096H,069H,011H,096H,069H,000H,096H,069H,
099H,099H,096H,099H,099H,099H,069H,099H,096H,099H,099H,099H,069H,099H,099H,069H,099H,099H,096H,069H,099H,096H,069H,099H,096H,069H,099H,096H,069H,099H,096H,
069H,099H,099H,096H,069H,099H,096H,069H,099H,096H,069H,099H,096H,069H,099H,096H,069H,099H,099H,006H,060H,099H,006H,060H,009H,006H,060H,000H,096H,069H,011H,
096H,069H,099H,099H,096H,099H,099H,096H,069H,099H,096H,099H,099H,096H,099H,099H,096H,069H,099H,099H,096H,069H,099H,096H,069H,099H,096H,069H,099H,096H,069H,
099H,096H,069H,099H,099H,096H,069H,099H,096H,069H,099H,096H,069H,099H,096H,069H,099H,096H,069H,099H,099H,006H,060H,000H,096H,069H,011H,006H,060H,099H,016H,
061H,099H,006H,063H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,03EH,000H,082H,002H,0C8H,000H,0BBH,000H,001H,001H,
00DH,00AH,00BH,01AH,01AH,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,009H,000H,000H,000H,000H,000H,000H,000H,000H,000H,
000H,000H,000H,000H,000H,096H,009H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,096H,009H,000H,000H,000H,000H,000H,000H,000H,000H,
000H,000H,000H,000H,000H,000H,096H,009H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,096H,069H,077H,077H,088H,078H,077H,077H,088H,
077H,077H,077H,088H,088H,007H,000H,096H,069H,000H,080H,001H,080H,000H,080H,000H,008H,000H,000H,008H,000H,008H,000H,096H,069H,000H,080H,001H,080H,000H,080H,
000H,008H,000H,000H,008H,000H,008H,000H,096H,069H,000H,080H,001H,080H,000H,080H,011H,008H,000H,000H,008H,000H,008H,000H,096H,069H,000H,080H,011H,081H,000H,
010H,088H,000H,000H,000H,008H,000H,008H,000H,096H,069H,000H,080H,088H,088H,000H,081H,080H,001H,000H,000H,008H,000H,008H,000H,096H,069H,000H,080H,001H,081H,
000H,008H,000H,008H,000H,000H,008H,000H,008H,000H,096H,069H,000H,080H,001H,081H,000H,008H,000H,008H,000H,000H,008H,000H,008H,000H,096H,069H,000H,080H,001H,
081H,000H,008H,000H,080H,081H,000H,008H,000H,008H,000H,096H,069H,000H,080H,000H,080H,000H,018H,000H,080H,008H,000H,008H,000H,008H,000H,096H,069H,000H,080H,
000H,080H,000H,080H,011H,081H,000H,000H,018H,011H,008H,090H,096H,069H,000H,080H,000H,080H,000H,000H,088H,018H,008H,000H,088H,088H,000H,030H,096H,069H,080H,
088H,088H,088H,088H,088H,088H,088H,088H,088H,088H,088H,088H,088H,098H,069H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,090H,069H,
000H,049H,044H,044H,044H,044H,044H,044H,044H,044H,044H,044H,044H,044H,094H,069H,000H,059H,055H,055H,055H,055H,055H,055H,055H,055H,055H,055H,055H,055H,095H,
099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,01EH,000H,022H,000H,00FH,000H,011H,000H,001H,005H,004H,003H,001H,004H,004H,
099H,099H,099H,099H,099H,099H,099H,009H,009H,099H,099H,099H,099H,099H,099H,096H,009H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,090H,
096H,069H,077H,077H,077H,077H,077H,077H,077H,077H,077H,077H,077H,077H,077H,096H,096H,069H,000H,000H,000H,000H,000H,000H,000H,008H,000H,000H,000H,000H,000H,
096H,096H,069H,000H,000H,000H,000H,000H,000H,000H,008H,000H,000H,000H,000H,000H,096H,096H,069H,000H,000H,000H,000H,000H,000H,080H,088H,000H,000H,000H,000H,
000H,096H,096H,069H,060H,077H,077H,077H,077H,077H,087H,088H,077H,077H,077H,077H,077H,096H,096H,069H,060H,000H,000H,000H,000H,000H,088H,080H,008H,000H,000H,
000H,000H,096H,096H,069H,000H,077H,077H,006H,000H,000H,088H,081H,008H,000H,000H,076H,077H,090H,096H,069H,060H,077H,077H,007H,000H,080H,078H,077H,088H,000H,
000H,077H,077H,096H,096H,069H,060H,000H,000H,000H,000H,080H,008H,001H,088H,000H,000H,000H,000H,096H,096H,069H,070H,077H,077H,077H,077H,088H,077H,077H,087H,
078H,077H,077H,077H,097H,096H,069H,000H,000H,000H,000H,000H,088H,000H,001H,080H,008H,000H,000H,000H,090H,096H,069H,000H,000H,000H,000H,080H,078H,076H,007H,
076H,088H,000H,000H,000H,090H,096H,069H,000H,000H,000H,000H,080H,008H,006H,001H,006H,088H,000H,000H,000H,090H,096H,069H,000H,000H,000H,000H,088H,070H,006H,
077H,076H,080H,008H,000H,000H,090H,096H,069H,000H,000H,000H,000H,008H,000H,006H,001H,006H,000H,008H,000H,000H,030H,096H,099H,077H,077H,077H,077H,008H,078H,
076H,007H,076H,008H,078H,077H,077H,097H,099H,099H,044H,044H,044H,044H,088H,048H,044H,044H,044H,088H,048H,044H,044H,094H,099H,099H,055H,055H,055H,055H,055H,
055H,055H,055H,055H,055H,055H,055H,055H,095H,099H,099H,055H,055H,055H,055H,055H,055H,055H,055H,055H,055H,055H,055H,055H,095H,099H,099H,055H,055H,055H,055H,
055H,055H,055H,055H,055H,055H,055H,055H,055H,095H,099H,03EH,000H,081H,002H,02DH,000H,02FH,000H,000H,00DH,00EH,002H,004H,002H,008H,099H,099H,099H,099H,099H,
099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,009H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,096H,069H,077H,000H,000H,
000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,096H,069H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,096H,069H,000H,000H,
000H,086H,008H,008H,008H,008H,088H,006H,000H,000H,000H,000H,096H,069H,000H,000H,000H,086H,078H,077H,087H,077H,088H,006H,000H,000H,000H,000H,096H,009H,006H,
000H,000H,086H,018H,000H,000H,010H,088H,006H,000H,000H,000H,000H,096H,019H,016H,000H,000H,080H,088H,096H,099H,080H,088H,000H,000H,000H,000H,000H,096H,009H,
006H,000H,000H,000H,090H,006H,000H,090H,000H,000H,000H,000H,000H,000H,096H,019H,016H,000H,000H,000H,090H,006H,000H,090H,000H,000H,000H,000H,000H,000H,096H,
009H,006H,090H,000H,000H,090H,086H,088H,096H,000H,000H,000H,000H,000H,000H,096H,069H,000H,090H,000H,000H,090H,090H,090H,096H,000H,000H,000H,000H,000H,000H,
096H,009H,006H,090H,000H,000H,090H,090H,090H,096H,000H,000H,000H,000H,000H,000H,096H,069H,000H,090H,000H,000H,090H,091H,091H,096H,000H,001H,000H,000H,000H,
000H,096H,009H,006H,090H,000H,000H,020H,008H,008H,096H,000H,077H,077H,077H,077H,077H,096H,069H,000H,090H,076H,077H,097H,000H,000H,096H,000H,000H,000H,000H,
000H,000H,096H,009H,006H,008H,006H,000H,090H,060H,077H,097H,000H,000H,000H,000H,000H,000H,096H,069H,000H,079H,009H,000H,090H,060H,001H,090H,000H,000H,000H,
000H,000H,000H,096H,069H,000H,019H,009H,000H,090H,077H,077H,096H,000H,000H,000H,000H,000H,000H,096H,079H,067H,069H,019H,000H,090H,000H,000H,096H,096H,044H,
009H,000H,060H,000H,096H,009H,060H,068H,068H,010H,090H,060H,069H,091H,076H,077H,003H,000H,086H,006H,096H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,
099H,099H,099H,099H,099H,099H,01CH,000H,086H,002H,010H,000H,00FH,000H,000H,008H,007H,005H,002H,001H,001H,099H,099H,099H,099H,099H,099H,099H,009H,090H,099H,
099H,099H,099H,099H,096H,099H,099H,000H,000H,080H,098H,010H,009H,000H,000H,000H,088H,088H,008H,000H,006H,099H,099H,086H,088H,000H,090H,096H,019H,080H,088H,
006H,000H,000H,068H,088H,088H,099H,099H,086H,081H,077H,090H,096H,070H,087H,088H,086H,088H,080H,068H,000H,000H,099H,099H,086H,088H,000H,090H,006H,000H,000H,
000H,086H,008H,030H,060H,000H,060H,099H,099H,006H,010H,000H,090H,006H,077H,097H,006H,006H,088H,087H,088H,088H,060H,099H,099H,006H,080H,000H,090H,006H,000H,
090H,006H,006H,000H,000H,000H,000H,060H,099H,099H,006H,000H,000H,090H,006H,090H,096H,006H,076H,077H,077H,077H,077H,067H,099H,099H,006H,076H,007H,090H,088H,
007H,096H,006H,000H,000H,000H,000H,000H,060H,099H,099H,006H,006H,000H,000H,000H,000H,096H,006H,088H,088H,086H,098H,094H,067H,099H,099H,006H,006H,088H,087H,
088H,087H,098H,006H,010H,098H,086H,090H,099H,060H,099H,099H,006H,006H,000H,000H,000H,000H,000H,006H,087H,088H,086H,080H,088H,060H,099H,099H,006H,006H,099H,
097H,099H,097H,099H,009H,080H,088H,086H,080H,081H,060H,099H,099H,006H,006H,000H,000H,000H,000H,000H,000H,000H,098H,086H,087H,088H,060H,099H,099H,006H,078H,
077H,088H,008H,088H,088H,078H,009H,000H,006H,080H,088H,060H,099H,099H,006H,000H,000H,000H,000H,000H,000H,000H,009H,001H,006H,008H,088H,060H,099H,099H,096H,
099H,044H,044H,044H,044H,044H,044H,009H,009H,006H,088H,010H,060H,099H,099H,096H,099H,099H,099H,099H,099H,099H,099H,009H,009H,006H,088H,088H,060H,099H,099H,
006H,000H,000H,000H,000H,000H,000H,000H,000H,008H,006H,000H,000H,060H,099H,099H,006H,088H,088H,088H,068H,088H,088H,088H,088H,088H,076H,077H,077H,067H,099H,
099H,006H,000H,000H,000H,009H,000H,000H,000H,000H,000H,006H,000H,000H,060H,099H,099H,088H,088H,088H,088H,088H,088H,088H,088H,088H,088H,088H,044H,044H,084H,
099H,01EH,000H,04CH,002H,0B3H,000H,0B5H,000H,000H,003H,007H,009H,013H,017H,00EH,099H,009H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,
096H,099H,009H,000H,000H,000H,000H,000H,080H,088H,077H,077H,077H,077H,077H,006H,096H,099H,009H,000H,000H,000H,000H,000H,080H,081H,000H,000H,000H,000H,000H,
006H,096H,099H,009H,000H,000H,000H,000H,000H,080H,081H,000H,000H,000H,000H,000H,006H,096H,099H,009H,000H,000H,000H,000H,000H,080H,081H,000H,000H,000H,000H,
000H,006H,096H,099H,009H,000H,000H,000H,000H,000H,080H,081H,000H,000H,000H,000H,000H,006H,096H,099H,009H,000H,000H,000H,000H,000H,080H,081H,000H,000H,000H,
000H,000H,006H,096H,099H,009H,000H,000H,000H,088H,088H,088H,087H,088H,088H,008H,000H,000H,006H,096H,099H,009H,000H,000H,000H,018H,011H,011H,011H,011H,011H,
008H,000H,000H,006H,096H,099H,009H,000H,000H,000H,088H,088H,088H,087H,088H,088H,078H,077H,000H,006H,096H,099H,009H,000H,000H,000H,000H,000H,080H,081H,000H,
000H,000H,000H,000H,006H,096H,099H,009H,000H,000H,000H,000H,000H,080H,081H,000H,000H,000H,076H,077H,007H,096H,099H,009H,000H,000H,000H,000H,000H,080H,081H,
000H,000H,000H,006H,000H,000H,096H,099H,009H,000H,000H,000H,000H,000H,080H,081H,000H,000H,000H,006H,097H,009H,096H,099H,009H,000H,000H,000H,000H,000H,080H,
081H,000H,000H,000H,006H,080H,003H,096H,099H,009H,000H,000H,000H,000H,000H,080H,081H,000H,000H,000H,006H,099H,079H,096H,099H,009H,000H,000H,000H,000H,000H,
080H,081H,000H,000H,000H,006H,000H,000H,099H,099H,009H,000H,000H,000H,000H,000H,080H,081H,000H,000H,000H,006H,000H,000H,099H,099H,009H,000H,000H,000H,000H,
000H,080H,081H,000H,000H,000H,006H,000H,000H,099H,099H,001H,000H,000H,000H,000H,000H,080H,081H,000H,000H,000H,006H,000H,000H,099H,099H,079H,077H,077H,077H,
006H,000H,080H,081H,000H,000H,076H,007H,000H,000H,099H,099H,049H,044H,044H,044H,099H,099H,099H,099H,099H,099H,049H,044H,044H,044H,099H,01DH,000H,082H,002H,
0DBH,000H,00BH,001H,001H,002H,011H,00FH,015H,008H,001H,099H,088H,088H,088H,088H,088H,088H,088H,088H,088H,088H,088H,088H,088H,069H,099H,099H,088H,088H,088H,
088H,088H,086H,088H,088H,088H,086H,088H,088H,068H,069H,099H,099H,000H,090H,077H,087H,077H,096H,000H,080H,077H,096H,077H,087H,067H,069H,099H,099H,000H,090H,
000H,090H,000H,096H,000H,090H,001H,096H,000H,090H,060H,069H,099H,099H,000H,090H,011H,081H,001H,086H,011H,091H,008H,086H,011H,091H,061H,069H,099H,099H,000H,
099H,099H,099H,077H,097H,099H,099H,077H,097H,099H,099H,069H,069H,099H,099H,000H,002H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,060H,069H,099H,099H,
090H,099H,099H,099H,077H,097H,099H,099H,007H,097H,099H,099H,069H,069H,099H,099H,010H,021H,000H,000H,000H,020H,000H,000H,000H,020H,000H,000H,060H,063H,099H,
049H,094H,099H,069H,099H,099H,069H,099H,099H,079H,099H,099H,099H,099H,099H,099H,059H,095H,090H,060H,090H,000H,060H,000H,090H,044H,094H,000H,091H,000H,090H,
099H,099H,099H,090H,060H,090H,000H,099H,000H,090H,099H,099H,000H,096H,000H,090H,099H,099H,000H,020H,060H,020H,000H,089H,000H,080H,010H,000H,000H,096H,010H,
090H,099H,099H,069H,099H,099H,099H,099H,088H,088H,088H,088H,088H,088H,096H,099H,096H,099H,099H,060H,080H,000H,090H,000H,090H,077H,097H,077H,097H,099H,099H,
000H,096H,099H,099H,067H,087H,060H,090H,000H,090H,044H,094H,044H,094H,019H,088H,000H,096H,099H,099H,060H,080H,060H,091H,000H,091H,055H,095H,055H,095H,086H,
086H,090H,096H,099H,099H,069H,099H,069H,099H,096H,099H,099H,099H,099H,099H,096H,096H,099H,096H,099H,099H,060H,080H,060H,090H,006H,000H,000H,091H,000H,090H,
096H,096H,000H,096H,099H,099H,067H,087H,060H,090H,070H,077H,077H,090H,000H,090H,096H,096H,000H,096H,099H,099H,060H,020H,060H,020H,080H,088H,088H,088H,000H,
080H,096H,026H,000H,096H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,01DH,000H,045H,002H,012H,000H,00EH,000H,000H,
00FH,010H,006H,005H,003H,004H,099H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,060H,099H,099H,000H,000H,000H,000H,000H,000H,000H,008H,
000H,000H,000H,000H,000H,060H,099H,099H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,060H,099H,099H,060H,077H,077H,077H,077H,077H,087H,
087H,000H,000H,000H,000H,000H,060H,099H,099H,060H,000H,000H,000H,000H,000H,010H,010H,000H,000H,000H,000H,000H,060H,099H,099H,060H,000H,000H,000H,000H,000H,
088H,087H,008H,000H,000H,000H,000H,060H,099H,099H,060H,000H,000H,000H,000H,000H,010H,010H,000H,000H,000H,000H,000H,060H,099H,099H,060H,000H,000H,000H,000H,
080H,080H,080H,080H,000H,000H,000H,000H,060H,099H,099H,060H,000H,000H,000H,000H,000H,010H,010H,000H,000H,000H,000H,000H,060H,099H,099H,060H,000H,000H,000H,
000H,088H,080H,080H,080H,008H,000H,000H,000H,060H,099H,099H,060H,000H,000H,000H,000H,000H,010H,010H,000H,000H,000H,000H,000H,060H,099H,099H,060H,000H,000H,
000H,080H,008H,088H,080H,008H,088H,000H,000H,000H,060H,099H,099H,060H,000H,000H,000H,000H,000H,010H,010H,000H,000H,000H,000H,000H,060H,099H,099H,060H,000H,
000H,000H,088H,080H,088H,080H,088H,080H,008H,000H,000H,060H,099H,099H,060H,000H,000H,000H,000H,000H,010H,010H,000H,000H,000H,000H,000H,060H,099H,099H,060H,
000H,000H,080H,008H,088H,088H,080H,088H,008H,088H,000H,000H,060H,099H,099H,060H,000H,000H,000H,000H,000H,010H,010H,000H,000H,000H,000H,000H,060H,099H,099H,
060H,000H,000H,088H,080H,088H,088H,080H,088H,088H,080H,008H,000H,060H,099H,099H,060H,000H,000H,000H,000H,000H,010H,010H,000H,000H,000H,000H,000H,060H,099H,
099H,060H,000H,080H,088H,088H,088H,088H,080H,088H,088H,088H,088H,000H,069H,099H,099H,060H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,063H,
099H,099H,099H,099H,049H,044H,044H,044H,044H,044H,044H,044H,044H,044H,099H,099H,099H,01DH,000H,084H,002H,0B2H,000H,04FH,002H,001H,006H,00CH,010H,00FH,005H,
010H,099H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,069H,099H,099H,000H,000H,000H,000H,000H,000H,000H,000H,000H,006H,010H,016H,000H,
069H,099H,099H,000H,060H,088H,088H,088H,098H,099H,099H,088H,006H,060H,066H,000H,069H,099H,099H,010H,000H,000H,001H,001H,091H,000H,090H,000H,006H,066H,060H,
006H,069H,099H,099H,060H,000H,000H,078H,088H,098H,096H,096H,009H,006H,006H,000H,006H,069H,099H,099H,060H,000H,000H,000H,000H,000H,096H,016H,000H,096H,009H,
000H,099H,069H,099H,099H,060H,077H,077H,077H,077H,007H,096H,099H,079H,000H,000H,000H,060H,069H,099H,099H,060H,000H,000H,000H,000H,000H,006H,000H,000H,000H,
077H,077H,067H,069H,099H,099H,066H,080H,088H,088H,088H,088H,008H,010H,081H,097H,090H,090H,060H,069H,099H,099H,006H,000H,099H,099H,099H,099H,079H,097H,099H,
090H,090H,094H,060H,069H,099H,099H,006H,000H,099H,099H,099H,099H,049H,094H,044H,094H,090H,099H,060H,069H,099H,099H,006H,000H,000H,000H,000H,090H,099H,055H,
055H,099H,000H,000H,060H,069H,099H,099H,006H,090H,079H,000H,000H,000H,099H,099H,099H,008H,008H,010H,060H,069H,099H,099H,096H,044H,044H,079H,000H,000H,000H,
088H,008H,090H,066H,078H,060H,069H,099H,099H,096H,055H,055H,009H,011H,011H,096H,096H,086H,090H,086H,019H,060H,069H,099H,099H,096H,099H,059H,009H,077H,077H,
077H,006H,006H,000H,000H,070H,060H,069H,099H,099H,006H,000H,059H,009H,090H,000H,000H,078H,078H,078H,078H,008H,060H,069H,099H,099H,006H,000H,059H,009H,090H,
099H,099H,086H,086H,086H,086H,086H,060H,069H,099H,099H,066H,000H,059H,009H,030H,090H,001H,068H,068H,068H,068H,068H,060H,069H,099H,099H,060H,000H,059H,049H,
099H,090H,099H,099H,099H,099H,099H,099H,099H,069H,099H,099H,060H,000H,059H,059H,009H,000H,000H,000H,000H,000H,000H,000H,000H,060H,099H,099H,099H,099H,099H,
099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,01DH,000H,003H,002H,012H,000H,00EH,000H,001H,009H,00AH,009H,00AH,00AH,00BH,099H,000H,000H,000H,
000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,060H,099H,099H,000H,000H,000H,000H,000H,000H,000H,008H,000H,000H,000H,000H,000H,060H,099H,099H,000H,000H,
000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,060H,099H,099H,000H,060H,077H,077H,077H,077H,087H,088H,000H,000H,000H,000H,000H,060H,099H,099H,000H,
060H,000H,000H,000H,000H,000H,001H,000H,000H,000H,000H,000H,060H,099H,099H,000H,060H,000H,000H,000H,000H,078H,078H,008H,000H,000H,000H,000H,060H,099H,099H,
000H,060H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,060H,099H,099H,000H,060H,000H,000H,000H,080H,080H,088H,080H,000H,000H,000H,000H,060H,099H,
099H,000H,060H,000H,000H,000H,000H,001H,000H,001H,000H,000H,000H,000H,060H,099H,099H,000H,060H,000H,000H,000H,008H,088H,080H,008H,008H,000H,000H,000H,060H,
099H,099H,000H,060H,000H,000H,000H,010H,000H,000H,010H,000H,000H,000H,000H,060H,099H,099H,000H,060H,000H,000H,080H,070H,009H,000H,089H,087H,000H,000H,000H,
060H,099H,099H,000H,060H,000H,000H,000H,000H,049H,044H,009H,000H,000H,000H,000H,060H,099H,099H,000H,060H,000H,000H,008H,006H,099H,099H,009H,006H,008H,000H,
000H,060H,099H,099H,000H,060H,000H,000H,010H,020H,000H,000H,000H,010H,000H,000H,000H,060H,099H,099H,000H,060H,000H,080H,080H,077H,088H,080H,088H,088H,080H,
000H,000H,060H,099H,099H,000H,060H,000H,000H,001H,000H,010H,000H,000H,000H,001H,000H,000H,060H,099H,099H,000H,060H,000H,078H,088H,080H,088H,007H,088H,080H,
078H,008H,000H,060H,099H,099H,000H,006H,000H,002H,000H,000H,000H,010H,000H,000H,000H,000H,000H,060H,099H,099H,000H,006H,080H,088H,080H,008H,088H,080H,088H,
008H,088H,080H,000H,069H,099H,099H,000H,006H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,063H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,
099H,099H,099H,099H,099H,099H,099H,007H,000H,0E5H,001H,008H,000H,01AH,000H,000H,019H,01CH,014H,008H,019H,01CH,099H,000H,000H,060H,010H,000H,000H,000H,000H,
000H,000H,000H,090H,090H,099H,099H,099H,000H,010H,060H,071H,077H,077H,077H,077H,077H,076H,069H,030H,001H,000H,099H,099H,076H,077H,070H,077H,077H,077H,077H,
077H,077H,007H,060H,088H,086H,006H,099H,099H,096H,000H,000H,000H,077H,077H,077H,077H,077H,067H,000H,000H,001H,006H,099H,099H,096H,076H,077H,077H,077H,077H,
077H,077H,007H,060H,000H,086H,086H,000H,099H,099H,096H,006H,091H,000H,000H,001H,010H,000H,010H,060H,000H,006H,001H,000H,099H,099H,096H,070H,097H,076H,077H,
007H,060H,077H,067H,060H,000H,080H,086H,006H,099H,099H,096H,006H,091H,006H,000H,000H,001H,001H,000H,060H,000H,000H,001H,006H,099H,099H,096H,076H,097H,006H,
090H,076H,067H,007H,000H,060H,000H,086H,086H,000H,099H,099H,096H,000H,000H,077H,096H,006H,001H,060H,077H,077H,000H,006H,001H,000H,099H,099H,096H,000H,010H,
000H,096H,006H,008H,060H,000H,000H,000H,080H,086H,006H,099H,099H,096H,010H,099H,000H,096H,006H,001H,060H,060H,017H,000H,000H,001H,006H,099H,099H,096H,060H,
000H,000H,096H,006H,008H,060H,060H,080H,000H,086H,086H,000H,099H,099H,096H,094H,096H,077H,077H,006H,000H,060H,060H,010H,000H,006H,001H,000H,099H,099H,096H,
099H,096H,079H,099H,009H,076H,088H,090H,087H,077H,088H,086H,000H,099H,099H,096H,000H,096H,000H,000H,060H,079H,077H,000H,010H,000H,000H,000H,000H,099H,099H,
096H,096H,099H,020H,000H,060H,099H,099H,097H,087H,077H,086H,080H,006H,099H,099H,096H,096H,000H,070H,077H,037H,021H,001H,000H,010H,000H,020H,000H,006H,099H,
099H,096H,096H,070H,097H,077H,097H,096H,099H,097H,087H,000H,060H,087H,008H,099H,099H,096H,006H,090H,001H,000H,000H,006H,000H,000H,000H,000H,060H,000H,000H,
099H,099H,006H,077H,097H,077H,077H,077H,077H,077H,077H,077H,077H,077H,077H,077H,099H,099H,099H,099H,099H,044H,044H,044H,044H,044H,044H,044H,044H,044H,044H,
044H,099H,06EH,000H,090H,002H,0ADH,000H,0B3H,000H,001H,008H,01BH,01CH,00BH,024H,01FH,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,
099H,099H,099H,009H,000H,000H,000H,000H,000H,060H,066H,000H,000H,000H,000H,000H,000H,099H,099H,009H,000H,000H,000H,000H,000H,006H,000H,006H,000H,000H,000H,
000H,000H,099H,099H,069H,088H,088H,006H,000H,000H,006H,000H,006H,000H,000H,086H,088H,068H,099H,099H,069H,019H,011H,009H,000H,000H,000H,030H,006H,000H,000H,
019H,011H,069H,099H,099H,069H,019H,011H,009H,000H,000H,000H,066H,000H,000H,000H,019H,011H,069H,099H,099H,069H,019H,011H,008H,000H,000H,000H,006H,000H,000H,
000H,018H,011H,069H,099H,099H,069H,088H,088H,078H,077H,077H,000H,006H,070H,077H,077H,088H,088H,068H,099H,099H,069H,079H,077H,009H,008H,000H,000H,006H,000H,
000H,008H,079H,077H,069H,099H,099H,069H,019H,011H,009H,069H,000H,000H,006H,000H,060H,009H,019H,011H,069H,099H,099H,069H,019H,011H,009H,069H,000H,000H,006H,
000H,060H,009H,019H,011H,069H,099H,099H,069H,019H,011H,009H,069H,000H,000H,006H,000H,060H,009H,019H,011H,069H,099H,099H,069H,000H,000H,000H,069H,099H,000H,
006H,090H,069H,009H,000H,000H,060H,099H,099H,069H,060H,099H,099H,099H,099H,079H,076H,099H,099H,099H,099H,069H,060H,099H,099H,079H,067H,049H,044H,044H,044H,
044H,049H,044H,044H,044H,044H,069H,077H,099H,099H,009H,060H,059H,055H,055H,055H,055H,055H,055H,055H,055H,055H,069H,000H,099H,099H,009H,060H,059H,055H,055H,
055H,055H,055H,055H,055H,055H,055H,069H,000H,099H,099H,009H,060H,059H,055H,055H,055H,055H,055H,055H,055H,055H,055H,069H,000H,099H,099H,009H,060H,059H,055H,
055H,055H,055H,055H,055H,055H,055H,055H,069H,000H,099H,099H,009H,060H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,069H,000H,099H,099H,009H,060H,000H,
000H,000H,000H,000H,000H,000H,000H,000H,000H,060H,000H,099H,099H,049H,094H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H,044H,099H,001H,000H,09CH,
002H,0D0H,000H,084H,000H,001H,00EH,00FH,012H,013H,00AH,00EH,009H,009H,000H,001H,000H,000H,000H,000H,001H,000H,000H,000H,001H,000H,000H,099H,069H,009H,000H,
077H,077H,077H,077H,077H,077H,077H,077H,077H,077H,077H,067H,099H,069H,009H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,060H,099H,069H,099H,
000H,000H,000H,000H,000H,000H,077H,077H,077H,077H,077H,077H,067H,099H,069H,003H,080H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,060H,099H,099H,
088H,088H,087H,088H,088H,088H,088H,088H,088H,088H,088H,008H,000H,060H,099H,099H,000H,000H,080H,000H,000H,000H,000H,000H,000H,000H,000H,008H,000H,060H,099H,
099H,000H,000H,080H,010H,000H,000H,010H,000H,000H,000H,001H,008H,000H,060H,099H,099H,000H,000H,080H,080H,088H,088H,069H,086H,088H,088H,008H,008H,000H,060H,
099H,099H,000H,000H,080H,080H,000H,000H,089H,086H,000H,000H,008H,008H,000H,060H,099H,099H,000H,010H,080H,081H,000H,000H,019H,086H,000H,000H,018H,008H,070H,
067H,099H,099H,000H,000H,087H,088H,067H,000H,069H,088H,000H,077H,088H,078H,001H,060H,099H,099H,000H,010H,000H,000H,060H,000H,069H,086H,010H,000H,000H,000H,
008H,060H,099H,099H,000H,087H,000H,000H,000H,067H,009H,086H,000H,000H,001H,000H,000H,060H,099H,099H,000H,010H,000H,000H,000H,060H,019H,086H,000H,000H,070H,
006H,001H,060H,099H,099H,000H,000H,000H,000H,000H,060H,009H,086H,000H,001H,077H,006H,008H,060H,099H,099H,000H,010H,000H,000H,000H,060H,069H,081H,000H,067H,
007H,006H,000H,060H,099H,099H,076H,077H,077H,001H,000H,060H,009H,086H,000H,000H,076H,000H,001H,060H,099H,099H,006H,060H,000H,079H,067H,060H,069H,080H,000H,
000H,070H,006H,098H,060H,099H,099H,006H,060H,000H,060H,000H,067H,068H,081H,006H,000H,000H,006H,000H,060H,099H,099H,077H,007H,077H,077H,007H,060H,009H,097H,
006H,000H,000H,070H,036H,060H,099H,099H,044H,044H,044H,044H,044H,084H,048H,084H,088H,044H,044H,044H,099H,099H,099H,041H,000H,088H,000H,044H,000H,04CH,002H,
000H,02EH,029H,014H,00EH,02CH,038H,
  009H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,000H,090H,
  009H,000H,000H,000H,000H,060H,079H,067H,000H,000H,000H,000H,000H,000H,000H,096H,
  009H,030H,000H,008H,060H,009H,000H,000H,079H,077H,077H,077H,087H,077H,077H,096H,
  009H,077H,076H,077H,007H,000H,000H,000H,000H,000H,000H,000H,000H,000H,077H,096H,
  009H,000H,001H,000H,080H,088H,006H,080H,098H,069H,000H,000H,010H,010H,010H,096H,
  009H,010H,010H,000H,009H,081H,006H,080H,010H,068H,000H,000H,000H,080H,000H,096H,
  009H,000H,006H,010H,009H,086H,006H,080H,001H,068H,000H,000H,010H,000H,010H,096H,
  019H,060H,060H,000H,009H,096H,016H,080H,010H,069H,000H,010H,080H,000H,000H,096H,
  079H,006H,000H,006H,009H,096H,070H,090H,001H,068H,000H,001H,009H,000H,010H,096H,
  009H,096H,001H,000H,009H,096H,044H,094H,010H,069H,010H,090H,010H,010H,000H,096H,
  019H,006H,009H,010H,009H,096H,099H,069H,001H,068H,000H,009H,000H,081H,010H,096H,
  079H,006H,000H,001H,008H,006H,000H,060H,077H,069H,060H,000H,080H,008H,000H,096H,
  009H,006H,010H,000H,098H,099H,099H,096H,001H,068H,060H,000H,000H,010H,010H,096H,
  019H,006H,000H,069H,000H,000H,000H,086H,010H,069H,060H,000H,000H,080H,000H,096H,
  079H,006H,090H,061H,000H,000H,000H,096H,001H,068H,060H,000H,000H,000H,076H,090H,
  009H,060H,010H,069H,000H,000H,000H,086H,010H,069H,060H,000H,000H,000H,006H,090H,
  019H,060H,097H,061H,000H,000H,000H,096H,001H,068H,000H,017H,000H,076H,010H,090H,
  079H,007H,000H,069H,010H,000H,000H,086H,010H,069H,000H,000H,000H,006H,000H,090H,
  009H,000H,000H,000H,077H,000H,000H,096H,001H,068H,000H,000H,076H,010H,010H,090H,
  019H,000H,001H,010H,000H,001H,000H,086H,010H,069H,000H,000H,036H,037H,037H,091H,
  079H,077H,076H,077H,077H,067H,000H,096H,001H,060H,000H,062H,031H,037H,030H,098H,
  049H,044H,049H,044H,044H,094H,099H,099H,099H,099H,099H,099H,099H,099H,099H,099H
    );

END Rsrc.
