#include <stdio.h>

#ifndef MIDI_SIMP_01
#define MIDI_SIMP_01
#endif

#pragma pack(push,1)				//    

typedef struct {						
	unsigned char header[4];		// ,  MTrk
	unsigned int length;			//  
	unsigned char* Data;		//  
}TRACK_HEADER;

typedef struct {						
	unsigned char header[4];		// ,  MThd
	unsigned int length;				//  ,  6 
	unsigned short type;			//   0,1,2
	unsigned short numTracks;		//  
	signed char tempo1;			//  ,   1- 
	signed char tempo2;			//  tempo1<0  SMPTE  PPQT
	TRACK_HEADER *track;		//     
}FILE_HEADER;

#pragma pack(pop)	

typedef struct {
	int delta;						//    						
	int status;						//  
	int channal;						// 
	int data1;						//  1
	int data2;						//  2
	int text;							//     
	int length;						//    
}TRACK_DECODED;

typedef struct {
	int channal1;					//    1				
	int channal2;					//    2
	int channal3;					//    3
}SPECCY_NOTE;

unsigned short ShortLeBe(unsigned short i);//  2   Little-Endian   Big-endian
unsigned long LongLeBe(unsigned long i);//  4   Little-Endian   Big-endian

int LoadMIDIz(FILE_HEADER *midi,char * lpFile);		//  MIDI   0 -  1 - 
void SaveMIDIz(FILE_HEADER *midi,char * lpFile);		//  MIDI  
void CreateMIDIz(FILE_HEADER *midi,int trackNum);	//   MIDI 
void DeleteMIDIz(FILE_HEADER *midi);				//   MIDI 
void GetTrackData(TRACK_HEADER *trk,TRACK_DECODED *arr);//       
int getDeltaLegth(unsigned char* data,int pos);			//     
int getDeltaData(unsigned char* data,int pos);			//   
int getStatusLength(unsigned char* data,int pos);		//    
int getTrackLength(TRACK_HEADER *trk);				//     
void getDecodeData(TRACK_DECODED *trk,unsigned char* data,int pos);		//    
														//    Vortex Tracker
