#include <stdlib.h>
#include <string.h>
#include "simmidi.h"

//   
// 0 -      ,   
// 1 -      ,   
// 2 -      ,  
// 3 -      ,  

//   
char *NOTE_TABLE[]={"C-1","C#1","D-1","D#1","E-1","F-1","F#1","G-1","G#1","A-1","A#1","B-1",
						"C-1","C#1","D-1","D#1","E-1","F-1","F#1","G-1","G#1","A-1","A#1","B-1",						
						"C-1","C#1","D-1","D#1","E-1","F-1","F#1","G-1","G#1","A-1","A#1","B-1",
						"C-2","C#2","D-2","D#2","E-2","F-2","F#2","G-2","G#2","A-2","A#2","B-2",
						"C-3","C#3","D-3","D#3","E-3","F-3","F#3","G-3","G#3","A-3","A#3","B-3",
						"C-4","C#4","D-4","D#4","E-4","F-4","F#4","G-4","G#4","A-4","A#4","B-4",
						"C-5","C#5","D-5","D#5","E-5","F-5","F#5","G-5","G#5","A-5","A#5","B-5",
						"C-6","C#6","D-6","D#6","E-6","F-6","F#6","G-6","G#6","A-6","A#6","B-6",
						"C-7","C#7","D-7","D#7","E-7","F-7","F#7","G-7","G#7","A-7","A#7","B-7",
						"C-8","C#8","D-8","D#8","E-8","F-8","F#8","G-8","G#8","A-8","A#8","B-8",
						"C-9","C#9","D-9","D#9","E-9","F-9","F#9","G-9",
						};
char *VORTEX_FILE_HEADER="[Module]\nVortexTrackerII=1\nVersion=3.6\nTitle=\nAuthor=MidiToVt v1.0\nNoteTable=2\nSpeed=3\nPlayOrder=L0";
char *VORTEX_FILE_INSTRUMENT="[Sample1]\nTnE +004_ +00_ F_\nTnE +002_ +00_ E_\nTnE +001_ +00_ D_\nTnE +000_ +00_ C_ L\nTnE -001_ +00_ C_\nTnE +000_ +00_ C_\nTnE +000_ +00_ C_\nTnE +001_ +00_ C_\nTnE +000_ +00_ C-\n";

int main(int argc, char *argv[])
{
	printf("MIDI to Vortex Tracker II Converter 1.0 (C) 2010 By Shadowsshot\n");
	printf("Use: MidiToVt.exe input.mid out.txt channal mode quantizer\n");
	printf("Channal - channal number, mode - from 0 to 3, quantizer - value\n\n");
	if(argc<3 || argc>6)printf("Too many or too less arguments. Exit now...\n");
	else{
	FILE_HEADER tr;
	int load=LoadMIDIz(&tr,argv[1]);
	if('M'!=tr.header[0] || 'T'!=tr.header[1] || 'h'!=tr.header[2] || 'd'!=tr.header[3])load=1;
	if(load==1)printf("File not read or not MIDI. Exit now...");
	else{

		printf("MIDI Type=%i\n",tr.type);
		printf("Track Max=%i\n",tr.numTracks);
		//   
		int convtrack,convmode;float quant;
		if(argc>3)convtrack=atoi(argv[3]);else convtrack=0;
		if(convtrack>=tr.numTracks)convtrack=0;
		printf("Track Use=%i\n",convtrack);
		//    
		if(argc>4)convmode=atoi(argv[4]);else convmode=0;
		if(convmode>3 || convmode<0)convmode=0;
		printf("Mode Use=%i\n",convmode);
		//     
		if(argc>5)quant=atof(argv[5]);else quant=1;
		//if((int)quant==0)quant=1;
		//printf("argc=%i",argc);

		//     	
		int len=getTrackLength(&tr.track[convtrack]);
		//   
		TRACK_DECODED *deco;
		deco=(TRACK_DECODED*)malloc(len*sizeof(TRACK_DECODED));
		//   
		GetTrackData(&tr.track[convtrack],deco);
		//     
		//for(int i=0;i<len;i++)printf("Comm= %i %i %i %i %i %i\n",deco[i].delta,deco[i].status,deco[i].channal,deco[i].data1,deco[i].data2,deco[i].length);
		
		int minstep,lenstep,numstep;

//    
		//     
		minstep=65536;
		for(int i=0;i<len;i++)if(deco[i].delta>0 && deco[i].delta<minstep)minstep=deco[i].delta;
		if(convmode==0 || convmode==1)minstep=minstep*quant;else minstep=quant;
		if(minstep==0)minstep=1;
		//printf("Minimal step=%i\n",minstep);
		//     
		lenstep=0;	
		for(int i=0;i<len;i++)lenstep=lenstep+deco[i].delta;
		//printf("All length=%i\n",lenstep);
		//     
		numstep=lenstep/minstep;	
		//printf("Speccy note=%i\n",numstep);
		printf("Quantizer=%i\n",minstep);


		//    
		SPECCY_NOTE *vortex;
		vortex=(SPECCY_NOTE*)malloc(numstep*sizeof(SPECCY_NOTE));

		int currnote=0;
		int chan1=-1;
		int chan2=-1;
		int chan3=-1;
		for(int i=0;i<len;i++){
			if(deco[i].delta==0){
				vortex[currnote].channal1=chan1;
				vortex[currnote].channal2=chan2;
				vortex[currnote].channal3=chan3;
				if(convmode==1 || convmode==3){chan1=-1;chan2=-1;chan3=-1;}
			}else{
				for(int n=0;n<deco[i].delta/minstep;n++){
					vortex[currnote].channal1=chan1;
					vortex[currnote].channal2=chan2;
					vortex[currnote].channal3=chan3;
					if(convmode==1 || convmode==3){chan1=-1;chan2=-1;chan3=-1;}
					currnote++;
				}
			}

			if(deco[i].status>=0x90 && deco[i].status<=0x9F){//  
				if(chan1==-1)chan1=deco[i].data1;else
				if(chan2==-1)chan2=deco[i].data1;else
				if(chan3==-1)chan3=deco[i].data1;
			};
			if(deco[i].status>=0x80 && deco[i].status<=0x8F){//  
				if(chan1==deco[i].data1)chan1=-1;
				if(chan2==deco[i].data1)chan2=-1;
				if(chan3==deco[i].data1)chan3=-1;
			};
		}
		printf("Out Note=%i\n",currnote);

		//     Vortex Tracker
		int pattern=currnote/255;
		FILE * pFile=fopen(argv[2],"w");
		fprintf(pFile,VORTEX_FILE_HEADER);
		int pattmax=1+(currnote/255);if(pattmax>48)pattmax=48;
		for(int t=1;t<pattmax;t++)fprintf(pFile,",%i",t);
		fprintf(pFile,"\n\n");		
		fprintf(pFile,VORTEX_FILE_INSTRUMENT);
		//fprintf(pFile,"[Pattern0]\n");
		for(int k=0;k<currnote;k++)if(k<255*pattmax){
			if(k%255==0)fprintf(pFile,"\n[Pattern%i]\n",k/255);
			fprintf(pFile,"....|..|");
			if(vortex[k].channal1==-1)fprintf(pFile,"---");else fprintf(pFile,NOTE_TABLE[vortex[k].channal1]);			
			fprintf(pFile," .... ....|");
			if(vortex[k].channal2==-1)fprintf(pFile,"---");else fprintf(pFile,NOTE_TABLE[vortex[k].channal2]);
			fprintf(pFile," .... ....|");
			if(vortex[k].channal3==-1)fprintf(pFile,"---");else fprintf(pFile,NOTE_TABLE[vortex[k].channal3]);
			fprintf(pFile," .... ....\n");	
		}
		fclose(pFile);
		free(vortex);
	}
DeleteMIDIz(&tr);
}
return 0;
}

