#include "simmidi.h"
#include <stdlib.h>

unsigned short ShortLeBe(unsigned short i)//  2   Little-Endian   Big-endian
{
	return ((i>>8)&0xff)+((i << 8)&0xff00);
}

unsigned long LongLeBe(unsigned long i)//  4   Little-Endian   Big-endian
{
    return((i&0xff)<<24)+((i&0xff00)<<8)+((i&0xff0000)>>8)+((i>>24)&0xff);
}

int LoadMIDIz(FILE_HEADER *midi,char * lpFile)		//  MIDI  
{
	FILE * pFile=fopen(lpFile,"rb");
	if(pFile==NULL)return 1;
	fread(midi->header,14,1,pFile);
	//     Little-Endian   Big-endian
	midi->type=ShortLeBe(midi->type);
	midi->numTracks=ShortLeBe(midi->numTracks);
	midi->length=LongLeBe(midi->length);
	//     
	midi->track=(TRACK_HEADER *)malloc(midi->numTracks*sizeof(TRACK_HEADER));
	//     
	for(int t=0;t<midi->numTracks;t++){
		fread(midi->track[t].header,8,1,pFile);
		midi->track[t].length=LongLeBe(midi->track[t].length);
		midi->track[t].Data=(unsigned char *)malloc(midi->track[t].length);
		fread(midi->track[t].Data,midi->track[t].length,1,pFile);
	}
	fclose(pFile);
	return 0;
}
void SaveMIDIz(FILE_HEADER *midi,char * lpFile)		//  MIDI  
{
	FILE * pFile=fopen(lpFile,"wb");
	//      Little-Endian
	midi->type=ShortLeBe(midi->type);
	midi->numTracks=ShortLeBe(midi->numTracks);
	midi->length=LongLeBe(midi->length);
	fwrite(midi->header,14,1,pFile);
	//      Big-endian
	midi->type=ShortLeBe(midi->type);
	midi->numTracks=ShortLeBe(midi->numTracks);
	midi->length=LongLeBe(midi->length);
	//     
	for(int t=0;t<midi->numTracks;t++){
		midi->track[t].length=LongLeBe(midi->track[t].length);
		fwrite(midi->track[t].header,8,1,pFile);
		midi->track[t].length=LongLeBe(midi->track[t].length);
		fwrite(midi->track[t].Data,midi->track[t].length,1,pFile);
	}
	fclose(pFile);
}

void CreateMIDIz(FILE_HEADER *midi,int trackNum)	//   MIDI 
{
}

void DeleteMIDIz(FILE_HEADER *midi)	//    MIDI 
{
	//     
	for(int t=0;t<midi->numTracks;t++)free(midi->track[t].Data);
	//  
	midi->track=NULL;
}

int getDeltaLegth(unsigned char* data,int pos)//     
{
	unsigned char tmp=data[pos];
	if((tmp&128)==0)return 1;
	tmp=data[pos+1];
	if((tmp&128)==0)return 2;
	tmp=data[pos+2];
	if((tmp&128)==0)return 3;
	tmp=data[pos+3];
	if((tmp&128)==0)return 4;
	return 0;
}
int getDeltaData(unsigned char* data,int pos)//   
{
	int len=getDeltaLegth(data,pos);
	int a=(int)(data[pos]&127);
	int b=(int)(data[pos+1]&127);
	int c=(int)(data[pos+1]&127);
	int d=(int)(data[pos+1]&127);
	switch(len){
		case(0):return 0;break;
		case(1):return a;break;
		case(2):return (a<<7)|b;break;
		case(3):return (a<<14)|(b<<7)|c;break;
		case(4):return (a<<21)|(b<<14)|(c<<7)|d;break;
	}
	return 0;
}

void GetTrackData(TRACK_HEADER *trk,TRACK_DECODED *arr)	//       
{
	TRACK_DECODED com;
	int pos=0;int tim;int note=0;
	getDeltaLegth(trk->Data,pos);
	while(pos<trk->length)
	{
	tim=getDeltaData(trk->Data,pos);
	pos=pos+getDeltaLegth(trk->Data,pos);
	getDecodeData(&com,trk->Data,pos);
		arr[note].channal=com.channal;
		arr[note].data1=com.data1;
		arr[note].data2=com.data2;
		arr[note].length=com.length;
		arr[note].status=com.status;
		arr[note].text=com.text;
		arr[note].delta=tim;
	pos=pos+getStatusLength(trk->Data,pos);
	note++;
	};
}

int getStatusLength(unsigned char* data,int pos)
{
	int tmp=data[pos]&240;
	switch(tmp){
		case(0x80):return(3);break;
		case(0x90):return(3);break;
		case(0xA0):return(3);break;
		case(0xB0):return(3);break;
		case(0xC0):return(2);break;
		case(0xD0):return(2);break;
		case(0xE0):return(3);break;
		case(0xF0):{
			tmp=data[pos]&15;
			switch(tmp){
				case(0x00):return(1+getDeltaLegth(data,pos+1)+getDeltaData(data,pos+1));break;
				case(0x01):return(1);break;
				case(0x02):return(3);break;
				case(0x03):return(2);break;
				case(0x04):return(1);break;
				case(0x05):return(1);break;
				case(0x06):return(1);break;
				case(0x07):return(1);break;
				case(0x08):return(1);break;
				case(0x09):return(1);break;
				case(0x0A):return(1);break;
				case(0x0B):return(1);break;
				case(0x0C):return(1);break;
				case(0x0D):return(1);break;
				case(0x0E):return(1);break;
				case(0x0F):return(2+getDeltaLegth(data,pos+2)+getDeltaData(data,pos+2));break;
			}
		}break;
	}
return 0;
}

int getTrackLength(TRACK_HEADER *trk)
{
	int pos=0;int count=0;
	while(pos<trk->length)
	{
		pos=pos+getDeltaLegth(trk->Data,pos);
		pos=pos+getStatusLength(trk->Data,pos);
		count++;
	};
	return count;
}

void getDecodeData(TRACK_DECODED *trk,unsigned char* data,int pos)
{
	trk->channal=0;
	trk->data1=0;
	trk->data2=0;
	trk->delta=0;
	trk->status=0;
	trk->text=0;
	trk->length=0;
	int tmp=data[pos]&240;
	switch(tmp){
		case(0x80):{
			trk->status=tmp;
			trk->channal=data[pos]&15;
			trk->data1=data[pos+1];
			trk->data2=data[pos+2];
		}break;
		case(0x90):{
			trk->status=tmp;
			trk->channal=data[pos]&15;
			trk->data1=data[pos+1];
			trk->data2=data[pos+2];
		}break;
		case(0xA0):{
			trk->status=tmp;
			trk->channal=data[pos]&15;
			trk->data1=data[pos+1];
			trk->data2=data[pos+2];
		}break;
		case(0xB0):{
			trk->status=tmp;
			trk->channal=data[pos]&15;
			trk->data1=data[pos+1];
			trk->data2=data[pos+2];
		}break;
		case(0xC0):{
			trk->status=tmp;
			trk->channal=data[pos]&15;
			trk->data1=data[pos+1];
		}break;
		case(0xD0):{
			trk->status=tmp;
			trk->channal=data[pos]&15;
			trk->data1=data[pos+1];
		}break;
		case(0xE0):{
			trk->status=tmp;
			trk->channal=data[pos]&15;
			trk->data1=data[pos+1];
			trk->data2=data[pos+2];
		}break;
		case(0xF0):{
			tmp=data[pos]&15;
			switch(tmp){
				case(0x00):{
					trk->status=0xF0;trk->channal=tmp;trk->text=pos+2;trk->length=getDeltaData(data,pos+1);
				}break;
				case(0x01):trk->status=0xF0;trk->channal=tmp;break;
				case(0x02):trk->status=0xF0;trk->channal=tmp;trk->data1=data[pos+1];trk->data2=data[pos+2];break;
				case(0x03):trk->status=0xF0;trk->channal=tmp;trk->data1=data[pos+1];break;
				case(0x04):trk->status=0xF0;trk->channal=tmp;break;
				case(0x05):trk->status=0xF0;trk->channal=tmp;break;
				case(0x06):trk->status=0xF0;trk->channal=tmp;break;
				case(0x07):trk->status=0xF0;trk->channal=tmp;break;
				case(0x08):trk->status=0xF0;trk->channal=tmp;break;
				case(0x09):trk->status=0xF0;trk->channal=tmp;break;
				case(0x0A):trk->status=0xF0;trk->channal=tmp;break;
				case(0x0B):trk->status=0xF0;trk->channal=tmp;break;
				case(0x0C):trk->status=0xF0;trk->channal=tmp;break;
				case(0x0D):trk->status=0xF0;trk->channal=tmp;break;
				case(0x0E):trk->status=0xF0;trk->channal=tmp;break;
				case(0x0F):{
					trk->status=0xF0;trk->channal=tmp;trk->data1=data[pos+1];
					trk->text=pos+3;trk->length=getDeltaData(data,pos+2);
				}break;
			}
		}break;
	}
}
