include "8085.inc"
;--------------------------------------------------------------------------------------------------------------------
start:	di
	lxi	sp,ramtop
	jmp	init
	nop
	jmp	chout	; RST1  		
	nop
	nop
	nop
	nop
	nop
	jmp	hexout	; RST2   A HEX
	nop
	nop
	nop
	nop
	nop
	jmp	strout	; RST3   (HL)
	nop
	nop
	nop
	nop
	nop
chin:	hlt		; RST4  
	ret
	nop
	nop
	nop
	nop
	nop
	nop
	mvi	a,rxe+txen+dtr	; RST5
	out	cusart	; /RTS 
	ret
	nop
	nop
	nop
	mvi	a,rxe+txen+dtr+rts	; RST6
	out	cusart	; /RTS 
	ret
	nop
	nop
	nop
;---  ----------------------------------------------------------
int:	di
	push	psw
	mvi	a,rxe+txen+dtr;	+rts
	out	cusart	; /RTS 
	in	dusart	;   
	sta	lastch	;    
	pop	psw
	ei
	ret
;------ --------------------------------------------------------------------------------------
loop:	hlt		; 
	lda	lastch	;   
	rst	1	;  
	cpi	06Ch	;  "L"
	jz	sload	;    
	cpi	067h	;  "G"
	jz	goto	;    
	rst	6	; /RTS 
	jmp	loop
;------  --------------------------------------------------------------------------
sload:	lxi	h,loadstr	;  
	rst	3
	lxi	h,ramp	;  
	rst	6	; /RTS 
sload1:	hlt
	lda	lastch	;    
	mov	m,a	;   
	inx	h	; HL+1
	rst	2
	mvi	a,20h
	rst	1
	rst	6	; /RTS 
	jmp	sload1	;  
;------    8000h---------------------------------------------------
goto:	lxi	h,gotostr	;  
	rst	3
	rst	6	; /RTS 
	call	08000h
	lxi	h,endstr	;  
	rst	3
	rst	6	; /RTS 
	ret
;-----------------------------------------------------------------------------------------
init:	call	initusart
	lxi	h,introstr	;  
	rst	3
	nop ;   Z80    IM1 -	EDH
	nop ; 											56H
	ei
	jmp	loop
;--- 51   -----------------------------------------------
initusart:	xra	a
	out	cusart
	out	cusart
	out	cusart
	mvi	a,ir	; 
	out	cusart
	mvi	a,v9600
	out	cusart	;   
	rst	6	; /RTS 
	in	dusart
	ret
;---- HEX   ----------------------------------------------------
hexout:	push	psw	;  
	rrc		;   4 
	rrc
	rrc
	rrc
	ani	0fh
	mov	c,a
	pop	psw
	ani	0fh
	mov	b,a
	lxi	d,hextab	;   
	mov	l,b	;   L
	dad	d	;     HL
	mov	a,m	;    
	rst	1	;  
	mov	l,c	;   L
	dad	d	;     HL
	mov	a,m	;    
	rst	1	;  
	ret
;------------- ----------------------------------------------------------------------------
strout:	mov	a,m	;  
	ana	a
	rz		;   
	rst	1	;  
	inx	h
	jmp	strout	;   
;------------- ------------------------------------------------------------
chout:	push	psw
sym1:	in	cusart	;   
	ani	txrdy+dsr	;  
	cpi	txrdy+dsr	;   
	jnz	sym1	;     sym1
	pop	psw
	out	dusart	;   
	ret
;-----------------------------------------------------------------------------------------------------
hextab:	db	'0123456789ABCDEF'
introstr:	db	0dh,'Monitor 580: ',0dh,00h
loadstr:	db	0dh,'Loading: ',0dh,00h
gotostr:	db	0dh,'Go 8000h ',0dh,00h
endstr:	db	0dh,'End program.',0dh,00h
;--------------------  --------------------------------------------------------
ramtop=	0FFF0h	;   
ramp=	08000h	;   
lastch=	0FFFFh	;  
;---  ----------------------------------------------------------------------
dusart	=	08h		;  
cusart	=	09h		;  
;--- --------------------------------------------------------------------------------------
v9600	=	04Eh	;9600_8_no_1
v2400	=	04Fh	;2400_8_no_1
;--- ------------------------------------------------------------------------------------
txen=	01h	;  
dtr=	02h	;  
rxe=	04h	;  
sbrk=	08h	;  
er=	10h	;   
rts=	20h	;  
ir=	40h	;  
eh=	80h	;  Hunt
;---  -----------------------------------------------------------------------
txrdy=	01h	;  
rxrdy=	02h	;  
txe=	04h	;  
pe=	08h	;  
oe=	10h	;  
fe=	20h	;  
syndet=	40h	;  
dsr=	80h	;   
;--------------------------------------------------------------------------------------------------------
CR=0Dh
BS=08h
ld=06Ch
go=067h