
; Copyright 2021 Mark Woodmass

; This program is licensed under the GNU General Public License. See the
; file `COPYING' for details

; Only compatible on ZX Spectrum 48K

                        org   60000

start                   proc
                        call  3435
                        ld    a,2
                        call  #1601

                        call  print_text
                        db    "ADDR  CYCLE R",6,"ADDR  CYCLE R",13,255

                        ld    hl,results_obtained
                        ld    (results_obtained_ptr),hl

                        ld    hl,12000          ; top border area
                        call  do_test_set

                        ld    hl,14335          ; first contended cycle on early machine
                        call  do_test_set

                        ld    hl,14336          ; first contended cycle on late machine
                        call  do_test_set

                        ld    hl,14335+224+3    ; first contended sequence on scan 2; 3T on early, 4T on late
                        call  do_test_set

                        ld    hl,57239          ; 6T on last contended sequence on scan 191; 0T on late as last contended sequence starts at 57240 
                        call  do_test_set

                        call  display_machine_timings
                        ret
                        endp

do_test_set             proc
                        ld    (halt_ts),hl

                        ld    hl,16384
                        call  do_test

                        ld    hl,32767
                        call  do_test

                        ld    hl,32768
                        call  do_test

                        ld    hl,49151
                        call  do_test

                        ld    hl,49152
                        call  do_test

                        ld    hl,65535
                        call  do_test

                        ld    a,13
                        rst   16
                        ld    a,13
                        rst   16
                        ret
                        endp

do_test                 proc

                        push  hl
                        pop   ix
                        ld    (hl),#76    ; HALT opcode

                        ld    de,num_txt
                        call  word_to_string
                        call  print_dec_16
                        ld    a,"/"
                        rst   16
                        ld    hl,(halt_ts)
                        ld    de,num_txt
                        call  word_to_string
                        call  print_dec_16
                        call  print_text
                        db    ":",255


                        di
                        ld    (oldstack),sp
                        ld    sp,63999

                        ld    hl,(halt_ts)
                        ld    de,-10000+38
                        add   hl,de
                        ld    (set_delay_2+1),hl

                        ld    hl,#f100
                        ld    de,#f101
                        ld    bc,256
                        ld    (hl),#f2
                        ldir

                        ld    a,195
                        ld    hl,syncint1
                        ld    (#f2f2),a
                        ld    (#f2f3),hl

                        ld    a,#f1
                        ld    i,a
                        im    2

                        ei
                        halt

syncint1                ei
                        ld    hl,0
                        ld    de,0
                        ld    bc,3325
                        ldir
                        nop

                        ; we have synchronised to framestart here
                        di

                        ld    hl,exitint
                        ld    (#f2f3),hl

                        ; 29t here
                        ld    hl,10000-39
                        call  delay

                        ; 10000t here
set_delay_2             ld    hl,0
                        call  delay

                        ld    a,#7d
                        ld    r,a   ; makes R=0 when it hits the HALT opcode

                        ei
                        jp    (ix)  ; jump to HALT opcode
                        endp


                        ; exit interrupt-driven test code runs here
exitint                 proc
                        ld    a,r
                        ld    sp,(oldstack)

                        push  af
                        ld    hl,0
                        ld    (16384),hl
                        call  restore_BASIC
                        pop   af

                        ld    hl,(results_obtained_ptr)
                        ld    (hl),a
                        inc   hl
                        ld    (results_obtained_ptr),hl

                        call  print_hex_8

                        ld    a,6
                        rst   16
                        ret
                        endp

restore_BASIC           proc
                        di
                        ld    a,63
                        ld    i,a
                        im    1
                        ei
                        ret
                        endp


print_hex_16            proc
                        ld    a,h
                        call  print_hex_8
                        ld    a,l
                        call  print_hex_8
                        ret
                        endp

print_hex_8             proc
                        push  af
                        rra
                        rra
                        rra
                        rra
                        call  print_hex_char
                        pop   af
                        call  print_hex_char
                        ret
                        endp

print_hex_char          proc
                        and   15
                        cp    10
                        sbc   a,#69
                        daa
                        rst   16
                        ret
                        endp

print_text              proc
                        pop   de
      _loop             ld    a,(de)
                        inc   de
                        cp    255
                        jr    z,_exit
                        rst   16
                        jr    _loop

      _exit             push  de
                        ret
                        endp

; HL = value, DE = text ptr
word_to_string          proc
                        ld    bc,-10000
                        call  _getdigit
                        ld    bc,-1000
                        call  _getdigit
                        ld    bc,-100
                        call  _getdigit
                        ld    bc,-10
                        call  _getdigit
                        ld    a,"0"
                        add   a,l
                        ld    (de),a
                        ret

      _getdigit         ld    a,"0"-1
      _getdig1          inc   a
                        add   hl,bc
                        jr    c,_getdig1
                        sbc   hl,bc
                        ld    (de),a
                        inc   de
                        ret
                        endp

display_machine_timings proc

                        call  print_text
                        db    "Machine timings:",16,2,255

                        ld    de,results_early
                        call  comp_30_result_bytes
                        jr    z,_machine_early

                        ld    de,results_late
                        call  comp_30_result_bytes
                        jr    z,_machine_late

                        call  print_text
                        db    "Unknown",16,0,13,255
                        ret

      _machine_early    call  print_text
                        db    "Early",16,0,13,255
                        ret

      _machine_late     call  print_text
                        db    "Late",16,0,13,255
                        ret
                        endp

comp_30_result_bytes    proc
                        ld    hl,results_obtained
                        ld    b,30
      _comp_loop        ld    a,(de)
                        cp    (hl)
                        ret   nz
                        inc   de
                        inc   hl
                        djnz  _comp_loop
                        ret
                        endp

print_dec_16            proc
                        call  print_text
num_txt                 ds    5
                        db    255
                        ret
                        endp

                        include     delay.asm

oldstack                dw    0
halt_ts                 dw    0

results_early           db    #0c, #0c, #0c, #0c, #0c, #0c
                        db    #44, #43, #45, #45, #45, #45
                        db    #44, #43, #44, #44, #44, #44
                        db    #1c, #0b, #0c, #0c, #0c, #0c
                        db    #5d, #5d, #5f, #5f, #5f, #5f

results_late            db    #0c, #0c, #0c, #0c, #0c, #0c
                        db    #45, #45, #45, #45, #45, #45
                        db    #44, #43, #44, #44, #44, #44
                        db    #1c, #0b, #0c, #0c, #0c, #0c
                        db    #5e, #5f, #5f, #5f, #5f, #5f

results_obtained_ptr    dw    0
results_obtained        ds    30

                        end   start


