    device ZXSPECTRUM48	;it maps pages just 0,1,2,3
	OPT --syntax=m	; Remove warning: Accessing low memory address
    
VDPVRAM   	EQU	$98		; VRAM Data (Read/Write)
VDPSTATUS 	EQU	$99		; VDP Status Registers
VDPPALETTE 	equ #9A

MSXVER 		EQU $002D
BAKCLR 		EQU $F3EA	; Background color
BDRCLR 		EQU $F3EB	; Border color

DISSCR 		equ $0041	;  Function: Disable Screen Display
CHGCLR		equ $0062	;  Function: Change Screen Color
CHGMOD		equ $005F	;  Function: Change Screen Mode
ENASCR		equ $0044	;  Function: Enable Screen Display

    org $4000	; Cart mapped in $4000
	
	;================
	; MSX ROM Header
	;================
    db "AB"  ; Identification Code ("AB" ($4241) = ROM Cartridge, "CD" ($4443) = SUBROM)
    dw Start ; Pointer To Start Of InitCode, 0 IF No InitCode ($0000..$BFFF)
    dw $0000 ; Pointer To CALL Statement Handler, 0 IF No Statement Handler ($0000..$BFFF)
    dw $0000 ; Pointer To Expansion Device Handler, 0 IF No Expansion Device Handler ($0000..$BFFF)
    dw $0000 ; Pointer To Start Of Tokenized BASIC-Program, 0 IF No Tokenized BASIC-Program ($0000..$BFFF)
    block 6,0; Fill Rest Of 16 Byte Header With Zeros (Room Reserved For Future Extensions) 

Start:
    di
    ld sp,#F380		; init the stack

	call DISSCR		; Выключение экрана

	call set_palette

	ld   A,8		; Цвет фона
	ld   [BAKCLR],A	
	ld   A,1		; Цвет бордюра
	ld   [BDRCLR],A 
	call CHGCLR
	
	ld   A,2
	call CHGMOD		; Установка режима screen 2

	ld   HL,zx_screen
	ld de,#4000
	call pixel_data

	ld   HL,zx_screen + #1800
    ld de,#6000
	call color_data

	call ENASCR		; Включение экрана
 
dead_loop:
	jr dead_loop

; Заполнение данных о пикселях
pixel_data:
	ld	A,E    
	out	(VDPSTATUS),A
	ld	A,D        
	out	(VDPSTATUS),A

	ld c,#03	; Количество третей
next_third:

	ld b,#08	; Количество строк знакомест в трети экрана
next_row:
	push bc

	ld c,#20	; Количество знакомест в строке
next_column:

	ld d,h
	ld e,l

	ld b,#08	; Количество линий в знакоместе
next_line:
	ld a,(hl)
	out   (VDPVRAM),A    ;write in VRAM     
	inc h
	djnz next_line

	ld h,d
	inc l
	dec c
	ld a,c
	or c
	jr nz, next_column

	pop bc
	djnz next_row
	
	ld a,d
	add a,#08
	ld h,a
	dec c
	ld a,c
	or c
	jr nz,next_third

	ret

; Заполнение данных о цветах
color_data:
	ld	A,E    
	out	(VDPSTATUS),A
	ld	A,D        
	out	(VDPSTATUS),A

	ld de,#300
next_byte:
	push de
	ld a,(hl)
	ld c,a
	and a,%01000000
	rra
	rra
	rra
	ld b,a
	ld a,c
	and %111
	or b
	rla
	rla
	rla
	rla
	ld b,a
	
	; Обработка прозрачного пикселя (цвет 0), если бордюр не чёрный
	or b
	jr nz,fill_color_1
	ld b,#80
fill_color_1:
	
	ld a,c
	rra
	rra
	rra
	and %1111

	; Обработка прозрачного пикселя (цвет 0), если бордюр не чёрный
	jr nz,fill_color_2
	ld a,#08
fill_color_2:

	or b
	ld b,8
fill_color_3:
	out   (VDPVRAM),A    ;write in VRAM     
	djnz fill_color_3
	
	inc hl
	pop de
	dec de
	ld a,d
	or e
	jr nz,next_byte

	ret

set_palette:
	ld hl,palette
	ld b,#0f
set_palette_1:
	ld e,(hl)
	inc hl
	ld d,(hl)
	inc hl
	ld a,b
	
	out (VDPSTATUS),a		;Send palette number to the VDP
	ld a,128+16				;Copy Value to Register 16 (Palette)
	out (VDPSTATUS),a

	ld a,e
	and %11101110			;We only want 3 bits for the MSX2 (V9k takes all 4)
	rrca
	out (VDPPALETTE),a		;-RRR-BBB	

	ld a,d
	and %11101110
	rrca
	out (VDPPALETTE),a		;-----GGG	

	djnz set_palette_1
	ret

palette:
	;   GGG RRR BBB
	dw %111111111111 ; F White Bright
	dw %111111110000 ; E Yellow Bright
	dw %111100001111 ; D Cyan Bright
	dw %111100000000 ; C Green Bright
	dw %000011111111 ; B Magenta Bright
	dw %000011110000 ; A Red Bright
	dw %000000001111 ; 9 Blue Bright
	dw %000000000000 ; 8 Black

	dw %110011001100 ; 7 White
	dw %110011000000 ; 6 Yellow
	dw %110000001100 ; 5 Cyan
	dw %110000000000 ; 4 Green
	dw %000011001100 ; 3 Magenta
	dw %000011000000 ; 2 Red
	dw %000000001100 ; 1 Blue
	dw %000000000000 ; 0 Alpha

	align #100
zx_screen:	
	incbin "zx.scr"

	savebin "zxscreen.rom",16384,8192 ; 8kb ROM
