//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

Level level;


TForm1 *Form1;


void RefreshImgForm1()
{
	Form1->PaintBox1->Width = level.bitmap->Width;
    Form1->PaintBox1->Height = level.bitmap->Height;
    if (Form1->PaintBox1->Width < Form1->ScrollBox1->Width)
		Form1->PaintBox1->Width = Form1->ScrollBox1->Width;
	Form1->PaintBox1->Canvas->Draw(0, 0, level.bitmap);
}


//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button1Click(TObject *Sender)
{
	Form2->Show();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button2Click(TObject *Sender)
{
	Form3->Show();
    	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button3Click(TObject *Sender)
{
	level.AddRibbon();
    RefreshImgForm1();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button4Click(TObject *Sender)
{
	level.DeleteRibbon();
    RefreshImgForm1();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormActivate(TObject *Sender)
{
	RefreshImgForm1();
}
//---------------------------------------------------------------------------






void __fastcall TForm1::Button5Click(TObject *Sender)
{
	if (SaveDialog1->Execute())
    {
        level.Save(SaveDialog1->FileName);
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button6Click(TObject *Sender)
{
	if (OpenDialog1->Execute())
    {
    	if (FileExists(OpenDialog1->FileName))
        {
			level.Load(OpenDialog1->FileName);
            RefreshImgForm1();
        }
        else ShowMessage("  ");
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button7Click(TObject *Sender)
{
	if (SaveDialog2->Execute())
    {
    	AnsiString fname = SaveDialog2->FileName;
        if ((SaveDialog2->FilterIndex == 2) && (ExtractFileExt(fname) != ".txt")) fname += ".txt";
        level.SaveCode(fname);
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::PaintBox1MouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
	level.SetCurrent(X, Y);
    level.RefreshBitmap();
    RefreshImgForm1();	
}
//---------------------------------------------------------------------------

void __fastcall TForm1::PaintBox1Paint(TObject *Sender)
{
	PaintBox1->Canvas->Draw(0, 0, level.bitmap);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormCreate(TObject *Sender)
{
    level.RefreshBitmap();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::PaintBox1MouseMove(TObject *Sender,
      TShiftState Shift, int X, int Y)
{
	StatusBar1->SimpleText = "[Y=" + IntToStr(int(Y/S_Level) * 8) + ":X=" + IntToStr(X/S_Level-15) + "]    " + "[Y=" + IntToStr(int(Y/S_Level) * 8) + ":X=" + IntToStr(X/S_Level) + "]";
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button8Click(TObject *Sender)
{
        Form5->Show();        
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button9Click(TObject *Sender)
{
    level.AddBlock();
    RefreshImgForm1();	
}
//---------------------------------------------------------------------------

