#ifndef SPRITE_H
#define SPRITE_H

#define S_Size 24
#define S_Level 16
#define gap 2

#include <vcl.h>
#include <fstream.h>
#include <vector.h>

class Sprite
{
public:
	Sprite();
    ~Sprite();
    bool Empty();
    void LoadFromFile(AnsiString fname);
    void RefreshBitmap();
    AnsiString GetDataText();
    Graphics::TBitmap * bitmap;
    unsigned char data[8];
	
    byte attr;
};

class SpriteSet
{
public:
	SpriteSet();
    ~SpriteSet();
    
    void SaveSet(AnsiString fname);
    void SaveCode(AnsiString fname);
    void LoadSet(AnsiString fname);
    void LoadCurrentFromFile(AnsiString fname);
    void SetCurrent(int x, int y);
    void DrawSprite(int nom);


	Graphics::TBitmap * bitmap;
    Sprite sprite[256];
	int current;

};

struct RibSprite
{
	unsigned char num;
    unsigned char attr;
    void Ink(int c);
    void Paper(int c);
    void Flash(bool c);
    void Bright(bool c);
};

class Ribbon
{
public:
	Ribbon();
    Ribbon(const Ribbon & r);
    void AddSprite(int nom, int attr = 56);
    void InsertSprite(int nom);
    void DeleteSprite();
    vector <RibSprite> sprite;
	unsigned int current;
};

class RibbonSet
{
public:
	RibbonSet();
    ~RibbonSet();

    void SaveSet(AnsiString fname);
    void SaveCode(AnsiString fname);
    void LoadSet(AnsiString fname);

	void DeleteRibbon();
    void InsertRibbon();
    void InsertSprite();
    void DeleteSprite();
    void SetCurrent(unsigned int x, unsigned int y);
    void DrawRibbon(int nom);
    void DrawCursor();
    void UpdateBitmapSize();
    void RefreshBitmap();
    void RefreshRibbonBitmap(int nom);

    Graphics::TBitmap * bitmap;
    vector <Graphics::TBitmap *> r_bitmap;

    SpriteSet sprite_set;
	vector <Ribbon> ribbons;
	unsigned int current;


};

class Block
{
public:
	Block();
    Block(const Block & b);
    vector <unsigned short> rib_noms;
    AnsiString name;
	unsigned int current;
};

class BlockSet
{
public:
    BlockSet();
    ~BlockSet();
    void InsertBlock();
    void DeleteBlock();
    void EraseRecalc(int n);
    void InsertRecalc(int n);
    void RefreshBitmap();
    void UpdateBitmapSize();
    void DrawRibbon(int ry, int rnom);
    void InsertRibbon();
    void SetCurrent(unsigned int c);
    void SetRibCurrent(unsigned int y);
    void DrawCursor();

    RibbonSet * r_set;
    vector <Block> blocks;
    Graphics::TBitmap * bitmap;
	unsigned int current;
};


class Level
{
public:
    Level();
    ~Level();
    void SaveRBSet(AnsiString fname);
    void LoadRBSet(AnsiString fname);
    void Save(AnsiString fname);
    void SaveCode(AnsiString fname);
    void Load(AnsiString fname);

	void DeleteRibbon();
    void AddRibbon();
    void AddBlock();

    void EraseRecalc(int n);
    void InsertRecalc(int n);
    
    void SetCurrent(unsigned int x, unsigned int y);
    void DrawLine(int nom);
    void UpdateBitmapSize();
    void RefreshBitmap();
    void DrawCursor();
    Graphics::TBitmap * bitmap;
    RibbonSet r_set;
    BlockSet b_set;
	vector <unsigned char> lines[24];
	unsigned int current_line;
    unsigned int current_rib;

};







#endif //SPRITE_H
