	.ORG    00000h
;         
;   = 8 
; 1   = 128 

SPini		.equ 0DCF0h
SectorAdr	.equ 0DED0h
TrackNum	.equ 0DED3h
SectorNum	.equ 0DED4h
BufferAdr	.equ 0DED5h
SPtmp		.equ 0DED7h


;Restart: 
	DI
	LXI  SP,SPini
	LXI  H, 0F800h	;      
	SHLD    BufferAdr	; ...
	XRA  A		;      
	CALL    ReadTrack	;   0 
	MVI  A, 001h
	CALL    ReadTrack	;   1 
	LXI  D, 00100h
	XCHG
	SHLD    BufferAdr	;     
	XCHG
L_NAME:	CALL    ChkName  ;      "OS.COM"
	JZ      LoadOS	; >> , 
	DAD  D		; +10h,  
	JNC     L_NAME	;  HL   0,   
NoOS:
	lxi d,0CFF5h
	lxi h,NoOSgrf
NoOSloop:
	mov a,m
	stax d
	inx h
	inr e
	jnz NoOSloop
	hlt
NoOSgrf:
	.db 11101110b
	.db 10100010b
	.db 10101110b
	.db 10101000b
	.db 11101110b
	.db 00000000b
	.db 10101110b
	.db 10101010b
	.db 10101010b
	.db 10101010b
	.db 11001110b

;	
LoadOS: MVI  C, 010h   ; <<<----    
LoadOS1: MOV  A, M
	ORA  A
	JZ      00100h	; --------->>>>>>>>>  
	CALL    ReadTrack	;    (  )
	INX  H
	DCR  C
	JNZ     LoadOS1
	CALL    ChkName	;     , == "OS.COM"?
	JNZ     00100h	; --------->>>>>>>>>  
	JMP     LoadOS	;  
;
	;      
	; BufferAdr = . 
	; A =    (  TrackNum)
ReadTrack:	PUSH H
	PUSH B
	LXI  H, 00000h
	DAD  SP
	shld SPtmp		;    
	LXI  D, 00380h	; (  )
	STA     TrackNum	;    
	CMA		;  
	CPI     0FCh
	JNC     ReadTrack1	;   >= FCh
	SUI     010h	;  :=  - 10h
ReadTrack1: SUI     004h	;  :=  - 04h
	MOV  L, A
	ADD  A		;
	ADD  A		;
	MOV  H, A	; H :=  * 4
	MOV  A, L	; . 
	MVI  L, 000h	; L := 0
	DAD  D		; HL := HL + DE = HL - 020h
	STC		; (  =1)
	RAR		; (    )
	RRC		; ( )
	RRC
	RRC
	ANI     01Ch	;  2,3  4 
	mov b,a			;   
	xra a
L_LOOP:	SHLD    SectorAdr	;   
	STA     SectorNum	;     
	mov a,b
	OUT     010h    ;  
	SPHL		;    
	LHLD    BufferAdr	;  
	XRA  A
	MVI  C, 020h	; , 20h*4 = 128 
ReadTrack2: POP  D		;   DE
	ADD  E		; A:= A+E (.)
	MOV  M, E	;  E  
	INX  H
	MOV  M, D
	ADD  D
	INX  H
	POP  D		;  2  DE
	ADD  E
	MOV  M, E
	INX  H
	MOV  M, D
	ADD  D
	INX  H
	DCR  C
	JNZ     ReadTrack2	;    (128 )
	SHLD    BufferAdr	;       
	;   
	MOV  C, A	; C =  
	MVI  A, 01Fh	; 0001 1111 --  0  
	OUT     010h	;   
	;   
	LDA     TrackNum	;   
	MOV  L, A
	mvi h,1111b
	DAD  H
	DAD  H
	DAD  H
	DAD  H
	LDA     SectorNum	;   
	ADD  L
	MOV  L, A
	SPHL
	POP  D		;  
	XRA  A
	OUT     010h	;  
	lhld SPtmp
	sphl
	MOV  A, E
	CMP  D
	JNZ     NoOS	; >>    , 
	CMP  C
	JNZ    	NoOS	; >>   ,  , 
	LHLD    SectorAdr	;   
	LXI  D, 0FF80h	; DE = -80h
	DAD  D		; HL =    
	LDA     SectorNum	;   
	adi 2
	cpi 16
	JNZ     L_LOOP
	POP  B
	POP  H
	RET		; >>>
;
	;    "OS.COM"
ChkName: PUSH H
	LXI  D, OS_COM
ChkName1: LDAX D
	CMP  M
	JNZ     ChkName2
	INX  H
	inr e
	JNZ     ChkName1
ChkName2: POP  H
	LXI  D, 00010h
	DAD  D		;      
	RET
;
	.org 0F4h
OS_COM: .db 000h
	.db "OS      COM"
	.END
