#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>

int main(int argc, char **argv)
{
  unsigned char buf[16386];
  int i, ed;
  int h = open("TRD504T.ROM", _O_RDONLY);
  if (h < 0) {
    return 1;
  }

  memset(buf, 0, sizeof(buf));

  read(h, buf, 16384);
  close(h);
  ed = 0;
  for (i = 0; i < 16384; i++) {
    if (buf[i] == 0xd3) {
      if (buf[i + 1] == 0x1f || buf[i + 1] == 0x3f || buf[i + 1] == 0x5f || buf[i + 1] == 0x7f || buf[i + 1] == 0xff) {
        printf("%04x (%05u): out (#%x),a\n", i, i, buf[i+1]);
      }
    }
    if (buf[i] == 0xdb) {
      if (buf[i + 1] == 0x1f || buf[i + 1] == 0x3f || buf[i + 1] == 0x5f || buf[i + 1] == 0x7f || buf[i + 1] == 0xff) {
        printf("%04x (%05u): in (#%x),a\n", i, i, buf[i+1]);
      }
    }
    if (buf[i] == 0xed) {
      ed = 1;
    } else if (ed) {
      if (buf[i] == 0x40) {
        printf("%04x (%05u): in  b,(c)\n", i, i);
      }
      if (buf[i] == 0x41) {
        printf("%04x (%05u): out  (c),b\n", i, i);
      }
      if (buf[i] == 0x48) {
        printf("%04x (%05u): in  c,(c)\n", i, i);
      }
      if (buf[i] == 0x49) {
        printf("%04x (%05u): out  (c),c\n", i, i);
      }
      if (buf[i] == 0x50) {
        printf("%04x (%05u): in  d,(c)\n", i, i);
      }
      if (buf[i] == 0x51) {
        printf("%04x (%05u): out  (c),d\n", i, i);
      }
      if (buf[i] == 0x58) {
        printf("%04x (%05u): in  e,(c)\n", i, i);
      }
      if (buf[i] == 0x59) {
        printf("%04x (%05u): out  (c),e\n", i, i);
      }
      if (buf[i] == 0x60) {
        printf("%04x (%05u): in  h,(c)\n", i, i);
      }
      if (buf[i] == 0x61) {
        printf("%04x (%05u): out  (c),h\n", i, i);
      }
      if (buf[i] == 0x68) {
        printf("%04x (%05u): in  l,(c)\n", i, i);
      }
      if (buf[i] == 0x69) {
        printf("%04x (%05u): out  (c),l\n", i, i);
      }
      if (buf[i] == 0x70) {
        printf("%04x (%05u): in  (hl),(c)\n", i, i);
      }
      if (buf[i] == 0x71) {
        printf("%04x (%05u): out  (c),(hl)\n", i, i);
      }
      if (buf[i] == 0x78) {
        printf("%04x (%05u): in  a,(c)\n", i, i);
      }
      if (buf[i] == 0x79) {
        printf("%04x (%05u): out  (c),a\n", i, i);
      }
      if (buf[i] == 0xa2) {
        printf("%04x (%05u): ini\n", i, i);
      }
      if (buf[i] == 0xa3) {
        printf("%04x (%05u): outi\n", i, i);
      }
      if (buf[i] == 0xaa) {
        printf("%04x (%05u): ind\n", i, i);
      }
      if (buf[i] == 0xab) {
        printf("%04x (%05u): outd\n", i, i);
      }
      if (buf[i] == 0xb2) {
        printf("%04x (%05u): inir\n", i, i);
      }
      if (buf[i] == 0xb3) {
        printf("%04x (%05u): otir\n", i, i);
      }
      if (buf[i] == 0xba) {
        printf("%04x (%05u): indr\n", i, i);
      }
      if (buf[i] == 0xbb) {
        printf("%04x (%05u): otdr\n", i, i);
      }
      ed = 0;
    }
  }

  return 0;
}
