;
; A simple mouse drawing program
;
; Care is taken to read mouse as accurately as possible
; and minimize noise from Covox sound device
; 
; (c) Alexander "Sandro" Tishin
;
.link 1000
msrs = 7 ; to minimize the Covox noise
msnr = 10
start:	mtps #340
	mov #1000, sp
	emt 14
	call cls
	mov #177714, r5
	mov #177660, r4
	mov #msnr, @r5
moveloop:
	; invert the dot (blink?)
	mov mx, r1
	mov my, r2
	call inv_dot
mswait:	tstb @r4 ; was a key pressed?
	bmi 2$
	mov @r5, r0
	mov r0, @#40000 ; test dispay
	bit #77, r0
	beq mswait
	; "reset" the mouse ASAP
	mov #msrs, @r5
	nop ; delay (is it needed?)
	mov #msnr, @r5
	mov r0, @#40100 ; test dispay
	call inv_dot
	asr r0 ; y+
	sbcb r2
	adcb r2
	asr r0 ; x+
	adcb r1
	sbcb r1
	asr r0 ; y-
	adcb r2
	sbcb r2
	asr r0 ; x-
	sbcb r1
	adcb r1
	mov r1, mx
	mov r2, my
	;
	asr r0 ; skip wheel down event
	;
	asr r0 ; lmb
	bcc 1$
	mov @#fg, r0
	call draw_dot
	br moveloop
1$:	asr r0 ; rmb
	bcc moveloop
	mov @#bg, r0
	call draw_dot
	br moveloop
; keyboard processing
2$:	mov @#177662, r0
	sub #'1', r0
	bmi mswait
	cmp #10, r0
	blos mswait
	bit #4, r0
	bne 3$
	mov r0, @#fg
	br mswait
3$:	sub #4, r0
	mov r0, @#bg
	br mswait
; colors
fg:	.word 3
bg:	.word 1

; mouse coords	
mx:	.word 200
my:	.word 200

;
; Masks a pixel at the given x, y cordinates
;
; Entry points:
; set_dot -- set all bits of a dot
; clear_dot -- reset al bits of a dot
; inv_dot -- invert all bits of a dot 
; mask_dot -- mask with the last used mode
;
; draws a dot at given point
; r1 - x
; r2 - y
; clobbers: nothing
inv_dot:
	mov #74062, @#drawop ; xor r0,xxx(r2)
	br mask_dot
clear_dot:
	mov #40062, @#drawop ; bic r0,xxx(r2)
	br mask_dot
set_dot:
	mov #50062, @#drawop ; bis r0,xxx(r2)
mask_dot:
	mov r0, -(sp)
	mov r1, -(sp)
	mov r2, -(sp)
	; convert x,y pixel address to the linear one th the R2
	swab r2
	clrb r2
	bisb r1, r2
	; split linear pixel address into word address and the bit mask
	mov r2, r0
	bic #177770, r0
	asl r0
	mov dotmask(r0), r0
	;clc ; no need -- cleared by asl r0 above
	ror r2
	asr r2
drawop:	bis r0, 40000(r2)
	mov (sp)+, r2
	mov (sp)+, r1
	mov (sp)+, r0
	ret
;
; fills a pixel at the given x, y coordinates with specified color
;
; r0 - color index
; r1 - x
; r2 - y
draw_dot:
	mov r0, -(sp)
	mov r1, -(sp)
	mov r2, -(sp)
	; convert x,y pixel address to the linear one th the R2
	swab r2
	clrb r2
	bisb r1, r2
	; get color bit pattern
	bic #177774, r0
	asl r0
	mov colors(r0), r1
	; split linear pixel address into word address and the bit mask
	mov r2, r0
	bic #177770, r0
	asl r0
	mov dotmask(r0), r0
	;clc ; no need -- cleared by asl r0 above
	ror r2
	asr r2
	; xor-trick is unusable, because xor insn doesn't got memory source operand
	; clear destination
	bic r0, 40000(r2)
	; mask pixel
	com r0
	bic r0, r1
	bis r1, 40000(r2)
	;
	mov (sp)+, r2
	mov (sp)+, r1
	mov (sp)+, r0
	ret


dotmask: .word 3, 14, 60, 300, 1400, 6000, 30000, 140000

colors: .word 0, 52525, 125252, 177777

;
; clears the screen
; clobbers: r0-r2
cls:	clr r0
	mov #40000, r1
	mov #4000, r2
1$:	mov r0, (r1)+
	mov r0, (r1)+
	mov r0, (r1)+
	mov r0, (r1)+
	sob r2, 1$
	mov #1330, @#177664 ; reset the scrolling position
	ret
;
; variables
;

.end
