                                      ; программирование таймера

0000 21 ef ff                         ld hl,0xffef ; регистр управления таймера
0003 36 36                            ld (hl),0x36
0005 36 66                            ld (hl),0x66
0007 36 90                            ld (hl),0x90
0009 2b                               dec hl
000a 36 10                            ld (hl),0x10
000c 2b                               dec hl
000d 36 4e                            ld (hl),0x4e
000f 2b                               dec hl
0010 36 10                            ld (hl),0x10
0012 36 15                            ld (hl),0x15

                                      ; звуковой сигнал
0014 01 ff ff                         ld bc,0xffff
0017 3e 0a                            ld a,0x0a     ; команда для ВВ55 - установить PC5 в 0

                                      ; цикл звукового сигнала
0019 32 e3 ff                         ld (0xffe3),a ; запись команды в регистр управления порта клавиатуры ВВ55
001c 05                               dec b         ; задержка на FFh циклов (в b)
001d c2 1c 00                         jp nz,0x001c
0020 ee 01                            xor 0x01      ; команда для ВВ55 - установить PC5 в инверсное значение
0022 0d                               dec c
0023 c2 19 00                         jp nz,0x0019	; повторить FFh раз (в C)

                                      ; тест банка 8000-FFFF основной памяти (ПЗУ должно быть отключено с этих адресов!)
0026 21 00 80                         ld hl,0x8000 ; адрес начала
0029 01 e0 ff                         ld bc,0xffe0 ; адрес конца + 1
002c 11 00 00                         ld de,0x0000
002f 3e 82                            ld a,0x82
0031 32 e3 ff                         ld (0xffe3),a ; запись 82h (PA - вывод, PB - ввод, PC - вывод) в регистр управления клавиатуры ВВ55
0034 3e 44                            ld a,0x44
0036 32 f8 ff                         ld (0xfff8),a ; запись 44h в регистр цвета (цвет точек = цвет фона = темно-синий)

                                      ; цикл теста "клетки 2х2"
0039 3e 33                            ld a,0x33
003b 77                               ld (hl),a ; записываем в память 33h (00110011b)
003c ae                               xor (hl)  ; читаем только что записанный байт и делаем xor A, должно стать 00h
003d b3                               or e      ; ИЛИ с предыдущим результатом, должно быть 00h
003e 5f                               ld e,a    ; запоминаем результат в E
003f 3e cc                            ld a,0xcc
0041 77                               ld (hl),a ; записываем в память CCh (11001100b)
0042 ae                               xor (hl)  ; читаем только что записанный байт и делаем xor A, должно стать 00h
0043 b3                               or e      ; ИЛИ с предыдущим результатом, должно быть 00h
0044 5f                               ld e,a    ; запоминаем результат в E
0045 23                               inc hl    ; следующий адрес
0046 7d                               ld a,l
0047 e6 01                            and 0x01
0049 c2 39 00                         jp nz,0x0039 ; повторяем цикл 2 раза

                                      ; цикл теста "инверсные клетки 2х2"
004c 3e cc                            ld a,0xcc
004e 77                               ld (hl),a ; записываем в память CCh (11001100b)
004f ae                               xor (hl)  ; читаем только что записанный байт и делаем xor A, должно стать 00h
0050 b3                               or e      ; ИЛИ с предыдущим результатом, должно быть 00h
0051 5f                               ld e,a    ; запоминаем результат в E
0052 3e 33                            ld a,0x33
0054 77                               ld (hl),a ; записываем в память 33h (00110011b)
0055 ae                               xor (hl)  ; читаем только что записанный байт и делаем xor A, должно стать 00h
0056 b3                               or e      ; ИЛИ с предыдущим результатом, должно быть 00h
0057 5f                               ld e,a    ; запоминаем результат в E
0058 23                               inc hl    ; следующий адрес
0059 7d                               ld a,l
005a e6 01                            and 0x01
005c c2 4c 00                         jp nz,0x004c ; повторяем цикл 2 раза

                                      ; повторяем цикл до конца блока памяти (FFE0h)
005f 7c                               ld a,h
0060 b8                               cp b
0061 da 39 00                         jp c,0x0039
0064 7d                               ld a,l
0065 b9                               cp c
0066 da 39 00                         jp c,0x0039

                                      ; проверяем результат теста
0069 53                               ld d,e  ; копируем результат теста в D
006a 7b                               ld a,e  ; копируем результат теста в A
006b b7                               or a    ; сравниваем с нулем
006c c2 54 01                         jp nz,0x0154 ; если не ноль (ошибка памяти) - прыгаем на рисование таблицы

                                      ; запрет прерываний (?)
006f f3                               di

                                      ; звуковой сигнал
0070 3e 0a                            ld a,0x0a     ; команда для ВВ55 - установить PC5 в 0
0072 26 70                            ld h,0x70

                                      ; цикл звукового сигнала
0074 6c                               ld l,h
0075 32 e3 ff                         ld (0xffe3),a ; запись команды в регистр управления порта клавиатуры ВВ55
0078 2d                               dec l
0079 c2 78 00                         jp nz,0x0078  ; задержка
007c ee 01                            xor 0x01      ; команда для ВВ55 - установить PC5 в инверсное значение
007e 25                               dec h
007f c2 74 00                         jp nz,0x0074  ; повторить

0082 3e 82                            ld a,0x82
0084 32 e3 ff                         ld (0xffe3),a ; запись 82h (PA - вывод, PB - ввод, PC - вывод) в регистр управления клавиатуры ВВ55
0087 3e 55                            ld a,0x55
0089 32 f8 ff                         ld (0xfff8),a ; запись 55h в регистр цвета (цвет точек = цвет фона = темно-сиреневый)

                                      ; цикл теста "клетки 1х1"
008c 21 00 80                         ld hl,0x8000 ; адрес начала
008f 01 e0 ff                         ld bc,0xffe0 ; адрес конца + 1

                                      ; начало цикла
0092 36 55                            ld (hl),0x55 ; записываем в память 55h (01010101b)
0094 23                               inc hl       ; следующий адрес
0095 36 aa                            ld (hl),0xaa ; записываем в память AAh (10101010b)
0097 23                               inc hl       ; следующий адрес
0098 3e 1f                            ld a,0x1f    ; длина задержки 31 цикл
009a 3d                               dec a
009b c2 9a 00                         jp nz,0x009a ; задержка

                                      ; повторяем цикл до конца блока памяти (FFE0h)
009e 7c                               ld a,h
009f b8                               cp b
00a0 da 92 00                         jp c,0x0092
00a3 7d                               ld a,l
00a4 b9                               cp c
00a5 da 92 00                         jp c,0x0092

                                      ; запрет прерываний (?)
00a8 f3                               di

                                      ; звуковой сигнал
00a9 3e 0a                            ld a,0x0a     ; команда для ВВ55 - установить PC5 в 0
00ab 26 70                            ld h,0x70

                                      ; цикл звукового сигнала
00ad 6c                               ld l,h
00ae 32 e3 ff                         ld (0xffe3),a ; запись команды в регистр управления порта клавиатуры ВВ55
00b1 2d                               dec l
00b2 c2 b1 00                         jp nz,0x00b1  ; задержка
00b5 ee 01                            xor 0x01      ; команда для ВВ55 - установить PC5 в инверсное значение
00b7 25                               dec h
00b8 c2 ad 00                         jp nz,0x00ad  ; повторить

00bb 3e 82                            ld a,0x82
00bd 32 e3 ff                         ld (0xffe3),a ; запись 82h (PA - вывод, PB - ввод, PC - вывод) в регистр управления клавиатуры ВВ55
00c0 3e 33                            ld a,0x33
00c2 32 f8 ff                         ld (0xfff8),a ; запись 55h в регистр цвета (цвет точек = цвет фона = темно-желтый)

                                      ; проверка цикла теста "клетки 1х1" в экранной области (8000-BFFF)
									  ; и цикл "инверсные клетки 1х1" там же
00c5 21 00 80                         ld hl,0x8000  ; адрес начала
00c8 01 00 c0                         ld bc,0xc000  ; адрес конца + 1
00cb 11 00 00                         ld de,0x0000

                                      ; начало цикла
00ce 3e 55                            ld a,0x55
00d0 ae                               xor (hl)  ; читаем записанный ранее байт и делаем xor A, должно стать 00h
00d1 b3                               or e      ; ИЛИ с предыдущим результатом, должно быть 00h
00d2 5f                               ld e,a    ; запоминаем результат в E
00d3 3e aa                            ld a,0xaa
00d5 77                               ld (hl),a ; записываем в память AAh (10101010b)
00d6 23                               inc hl    ; следующий адрес
00d7 ae                               xor (hl)  ; читаем записанный ранее байт и делаем xor A, должно стать 00h
00d8 b3                               or e      ; ИЛИ с предыдущим результатом, должно быть 00h
00d9 5f                               ld e,a    ; запоминаем результат в E
00da 3e 55                            ld a,0x55
00dc 77                               ld (hl),a ; записываем в память 55h (01010101b)
00dd 23                               inc hl    ; следующий адрес
00de 3e 19                            ld a,0x19 ; длина задержки 25 циклов
00e0 3d                               dec a
00e1 c2 e0 00                         jp nz,0x00e0 ; задержка

                                      ; повторяем цикл до конца блока памяти (C000h)
00e4 7c                               ld a,h
00e5 b8                               cp b
00e6 da ce 00                         jp c,0x00ce
00e9 7d                               ld a,l
00ea b9                               cp c
00eb da ce 00                         jp c,0x00ce

                                      ; обмен E и D через C
00ee 4b                               ld c,e
00ef 5a                               ld e,d
00f0 51                               ld d,c

                                      ; что это за дичь?
00f1 0e e0                            ld c,0xe0 ; BC = C0E0h
00f3 3e 3f                            ld a,0x3f
00f5 b7                               or a
00f6 80                               add a,b   ; A = FFh
00f7 47                               ld b,a    ; BC = FFE0h

                                      ; прыжок на начало цикла "клетки 1х1", теперь
                                      ; адрес начала     HL = C000h
                                      ; адрес конца + 1  BC = FFE0h
00f8 d2 ce 00                         jp nc,0x00ce

                                      ; звуковой сигнал
00fb 3e 0a                            ld a,0x0a     ; команда для ВВ55 - установить PC5 в 0
00fd 26 70                            ld h,0x70

                                      ; цикл звукового сигнала
00ff 6c                               ld l,h
0100 32 e3 ff                         ld (0xffe3),a ; запись команды в регистр управления порта клавиатуры ВВ55
0103 2d                               dec l
0104 c2 03 01                         jp nz,0x0103  ; задержка
0107 ee 01                            xor 0x01      ; команда для ВВ55 - установить PC5 в инверсное значение
0109 25                               dec h
010a c2 ff 00                         jp nz,0x00ff  ; повторить

010d 3e 82                            ld a,0x82
010f 32 e3 ff                         ld (0xffe3),a ; запись 82h (PA - вывод, PB - ввод, PC - вывод) в регистр управления клавиатуры ВВ55
0112 3e ee                            ld a,0xee
0114 32 f8 ff                         ld (0xfff8),a ; запись EEh в регистр цвета (цвет точек = цвет фона = ярко-голубой)

                                      ; проверка цикла теста "инверсные клетки 1х1" в экранной области (8000-BFFF)
									  ; и цикл "клетки 1х1" там же
0117 21 00 80                         ld hl,0x8000  ; адрес начала
011a 01 00 c0                         ld bc,0xc000  ; адрес конца + 1

                                      ; начало цикла
011d 3e aa                            ld a,0xaa
011f ae                               xor (hl)  ; читаем записанный ранее байт и делаем xor A, должно стать 00h
0120 b3                               or e      ; ИЛИ с предыдущим результатом, должно быть 00h
0121 5f                               ld e,a    ; запоминаем результат в E
0122 3e 55                            ld a,0x55
0124 77                               ld (hl),a ; записываем в память 55h (01010101b)
0125 23                               inc hl    ; следующий адрес
0126 ae                               xor (hl)  ; читаем записанный ранее байт и делаем xor A, должно стать 00h
0127 b3                               or e      ; ИЛИ с предыдущим результатом, должно быть 00h
0128 5f                               ld e,a    ; запоминаем результат в E
0129 3e aa                            ld a,0xaa
012b 77                               ld (hl),a ; записываем в память AAh (10101010b)
012c 23                               inc hl    ; следующий адрес
012d 3e 19                            ld a,0x19 ; длина задержки 25 циклов
012f 3d                               dec a
0130 c2 2f 01                         jp nz,0x012f ; задержка

                                      ; повторяем цикл до конца блока памяти (C000h)
0133 7c                               ld a,h
0134 b8                               cp b
0135 da 1d 01                         jp c,0x011d
0138 7d                               ld a,l
0139 b9                               cp c
013a da 1d 01                         jp c,0x011d

                                      ; обмен E и D через C
013d 4b                               ld c,e
013e 5a                               ld e,d
013f 51                               ld d,c

                                      ; что это за дичь?
0140 0e e0                            ld c,0xe0 ; BC = C0E0h
0142 3e 3f                            ld a,0x3f
0144 b7                               or a
0145 80                               add a,b   ; A = FFh
0146 47                               ld b,a    ; BC = FFE0h

                                      ; прыжок на начало цикла "инверсные клетки 1х1", теперь
                                      ; адрес начала     HL = C000h
                                      ; адрес конца + 1  BC = FFE0h
0147 d2 1d 01                         jp nc,0x011d

014a 3e 82                            ld a,0x82
014c 32 e3 ff                         ld (0xffe3),a ; запись 82h (PA - вывод, PB - ввод, PC - вывод) в регистр управления клавиатуры ВВ55
014f 3e 22                            ld a,0x22
0151 32 f8 ff                         ld (0xfff8),a ; запись 22h в регистр цвета (цвет точек = цвет фона = темно-зеленый)

                                      ; рисуем таблицу
0154 26 9d                            ld h,0x9d ; координаты на экране x = 68

                                      ; начало цикла по столбцам
0156 2e 30                            ld l,0x30 ; координаты на экране y = 48

                                      ; начало цикла по строкам
0158 36 aa                            ld (hl),0xaa ; записываем в память AAh (10101010b)
015a 2c                               inc l        ; следующий адрес (строка)
015b 36 55                            ld (hl),0x55 ; записываем в память 55h (01010101b)
015d 2c                               inc l        ; следующий адрес (строка)
015e 3e c2                            ld a,0xc2    ; рисуем до y = 194
0160 ad                               xor l
0161 c2 58 01                         jp nz,0x0158 ; повтор цикла по строкам
0164 6f                               ld l,a
0165 24                               inc h        ; следующий адрес (столбец)
0166 3e b3                            ld a,0xb3    ; рисуем до столбца 35 (x = 118)
0168 ac                               xor h
0169 c2 56 01                         jp nz,0x0156 ; повтор цикла по столбцам

016c 3e 31                            ld a,0x31
016e 32 f8 ff                         ld (0xfff8),a ; запись 31h в регистр цвета (цвет точек = желтый, цвет фона = темно-красный)

0171 26 a0                            ld h,0xa0 ; координаты на экране x = 128
0173 2e 4f                            ld l,0x4f ; координаты на экране y = 79
0175 3e 02                            ld a,0x02
0177 84                               add a,h
0178 67                               ld h,a
0179 06 4f                            ld b,0x4f
017b 3e 08                            ld a,0x08
017d 80                               add a,b
017e 47                               ld b,a
017f 3e 01                            ld a,0x01
0181 85                               add a,l
0182 6f                               ld l,a
0183 7a                               ld a,d
0184 e6 01                            and 0x01
0186 c2 94 01                         jp nz,0x0194
0189 36 00                            ld (hl),0x00
018b 2c                               inc l
018c 7d                               ld a,l
018d b8                               cp b
018e c2 89 01                         jp nz,0x0189
0191 c3 9c 01                         jp 0x019c
0194 36 ff                            ld (hl),0xff
0196 2c                               inc l
0197 7d                               ld a,l
0198 b8                               cp b
0199 c2 94 01                         jp nz,0x0194
019c 7a                               ld a,d
019d 0f                               rrca
019e 53                               ld d,e
019f 5f                               ld e,a
01a0 78                               ld a,b
01a1 fe 5f                            cp 0x5f
01a3 c2 7b 01                         jp nz,0x017b

01a6 7c                               ld a,h
01a7 fe b0                            cp 0xb0
01a9 c2 73 01                         jp nz,0x0173 ; повтор цикла по столбцам

01ac eb                               ex de,hl ; обмен DE <-> HL
01ad f9                               ld sp,hl ; инициализация указателя стека

                                      ; вывод текста на экран картинкой из ПЗУ
01ae 3e 53                            ld a,0x53
01b0 32 f8 ff                         ld (0xfff8),a ; запись 53h в регистр цвета (цвет точек = темно-сиреневый, цвет фона = темно-желтый)

01b3 21 3f a2                         ld hl,0xa23f ; координаты на экране (x = 144, y = 63)
01b6 11 df 01                         ld de,0x01df ; адрес картинки1 в ПЗУ
01b9 01 16 0a                         ld bc,0x0a16

                                      ; начало цикла
01bc 1a                               ld a,(de)   ; считать байт картинки из ПЗУ
01bd 13                               inc de      ; следующий адрес в ПЗУ
01be fe 00                            cp 0x00
01c0 ca 9a 02                         jp z,0x029a ; если байт = 00H, прыгнуть на 029Ah (конец вывода текста)
01c3 fe 0a                            cp 0x0a
01c5 ca d9 01                         jp z,0x01d9 ; если байт = 0Ah, прыгнуть на 01D9h (вывод второй картинки)
01c8 fe 0d                            cp 0x0d
01ca ca d2 01                         jp z,0x01d2 ; если байт = 0Ah, прыгнуть на 01D2h (переход к следующему столбцу)
01cd 77                               ld (hl),a   ; записать байт в экран
01ce 2c                               inc l       ; следующая строка
01cf c3 bc 01                         jp 0x01bc   ; повтор цикла

01d2 24                               inc h       ; следующий столбец
01d3 7d                               ld a,l      ; уменьшаем...
01d4 90                               sub b       ; ...L на 10...
01d5 6f                               ld l,a      ; ...(высота символов)
01d6 c3 bc 01                         jp 0x01bc   ; повтор цикла

01d9 21 5b 9f                         ld hl,0x9f5b; новые координаты на экране (x = 120, y = 91)
01dc c3 bc 01                         jp 0x01bc   ; повтор цикла

                                      ; картинка1: текст " ТЕСТ ОЗУ  64К " картинкой
01df                                  .db ff ff ff ff ff ff ff ff ff ff 0d ;
                                      .db ff 01 ef ef ef ef ef ef ef ff 0d ; Т
                                      .db ff 01 7f 7f 07 7f 7f 7f 01 ff 0d ; Е
                                      .db ff 83 7d 7f 7f 7f 7f 7d 83 ff 0d ; С
                                      .db ff 01 ef ef ef ef ef ef ef ff 0d ; Т
                                      .db ff ff ff ff ff ff ff ff ff ff 0d ;
                                      .db ff 83 7d 7d 7d 7d 7d 7d 83 ff 0d ; О
                                      .db ff 83 7d fd e3 fd fd 7d 83 ff 0d ; З
                                      .db ff 7d 7d 7d 7d 81 fd fd 83 ff 0d ; У
                                      .db ff ff ff ff ff ff ff ff ff ff 0d ; 
                                      .db ff ff ff ff ff ff ff ff ff ff 0d ; 
                                      .db ff e3 df bf 83 bd bd bd c3 ff 0d ; 6
                                      .db ff f7 e7 d7 b7 77 03 f7 f7 ff 0d ; 4
                                      .db ff 7d 7b 77 6f 4f 37 7b 7d ff 0d ; К
                                      .db ff ff ff ff ff ff ff ff ff ff 0a ; 

                                      ; картинка2: текст "V5" картинкой
                                      .db ff be be be dd dd eb eb f7 ff 0d ; V 
                                      .db ff 81 bf bf 83 fd fd bd c3 ff 00 ; 5

                                      ; конец вывода текста
029a 21 00 00                         ld hl,0x0000
029d 39                               add hl,sp
029e 7d                               ld a,l
029f b4                               or h
02a0 b7                               or a
02a1 ca cf 02                         jp z,0x02cf
02a4 21 78 aa                         ld hl,0xaa78
02a7 06 0a                            ld b,0x0a
02a9 78                               ld a,b
02aa 55                               ld d,l
02ab 5c                               ld e,h
02ac 32 e3 ff                         ld (0xffe3),a
02af 15                               dec d
02b0 c2 af 02                         jp nz,0x02af
02b3 55                               ld d,l
02b4 ee 01                            xor 0x01
02b6 1d                               dec e
02b7 c2 ac 02                         jp nz,0x02ac
02ba 4c                               ld c,h
02bb 65                               ld h,l
02bc 69                               ld l,c
02bd 05                               dec b
02be c2 aa 02                         jp nz,0x02aa
02c1 3e 00                            ld a,0x00
02c3 32 e0 ff                         ld (0xffe0),a ; запись 00h в порт PA порта клавиатуры ВВ55
02c6 32 e2 ff                         ld (0xffe2),a ; запись 00h в порт PС порта клавиатуры ВВ55
02c9 32 f8 ff                         ld (0xfff8),a ; запись 00h в регистр цвета (цвет точек = цвет фона = черный)
02cc c3 00 00                         jp 0x0000     ; перезапуск всей программы

                                      ; копирование второй половины программы в ОЗУ
02cf 21 00 04                         ld hl,0x0400 ; адрес откуда (в ПЗУ)
02d2 11 e0 fb                         ld de,0xfbe0 ; адрес куда (в ОЗУ) -- под самый потолок, задевая "окно процессора"
02d5 01 ff 03                         ld bc,0x03ff ; размер-1 (1 кб)

                                      ; цикл копирования
02d8 7e                               ld a,(hl)
02d9 12                               ld (de),a
02da 78                               ld a,b
02db b1                               or c
02dc ca e0 fb                         jp z,0xfbe0 ; копирование завершено - прыжок на FBE0h (новый адрес посадки в ОЗУ)
02df 23                               inc hl
02e0 13                               inc de
02e1 0b                               dec bc
02e2 c3 d8 02                         jp 0x02d8 ; повтор цикла

02e5 f7                               rst 0x30
02e6 e7                               rst 0x20
02e7 d7                               rst 0x10
02e8 f7                               rst 0x30
02e9 f7                               rst 0x30
02ea f7                               rst 0x30
02eb f7                               rst 0x30
02ec c1                               pop bc
02ed ff                               rst 0x38
02ee 00                               nop
02ef 00                               nop
02f0 f3                               di
02f1 3e 0a                            ld a,0x0a
02f3 26 70                            ld h,0x70
02f5 6c                               ld l,h
02f6 32 e3 ff                         ld (0xffe3),a
02f9 2d                               dec l
02fa c2 d9 fe                         jp nz,0xfed9
02fd ee 01                            xor 0x01
02ff 25                               dec h
0300 c2 d5 fe                         jp nz,0xfed5
0303 c9                               ret
0304 3e 55                            ld a,0x55
0306 cd bd ff                         call 0xffbd
0309 b3                               or e
030a 5f                               ld e,a
030b 3e aa                            ld a,0xaa
030d cd c4 ff                         call 0xffc4
0310 23                               inc hl
0311 cd bd ff                         call 0xffbd
0314 b3                               or e
0315 5f                               ld e,a
0316 3e 55                            ld a,0x55
0318 cd c4 ff                         call 0xffc4
031b 23                               inc hl
031c 3e 19                            ld a,0x19
031e 3d                               dec a
031f c2 fe fe                         jp nz,0xfefe
0322 7c                               ld a,h
0323 b8                               cp b
0324 c2 e4 fe                         jp nz,0xfee4
0327 7d                               ld a,l
0328 b9                               cp c
0329 c2 e4 fe                         jp nz,0xfee4
032c c9                               ret
032d 3e aa                            ld a,0xaa
032f cd bd ff                         call 0xffbd
0332 b3                               or e
0333 5f                               ld e,a
0334 3e 55                            ld a,0x55
0336 cd c4 ff                         call 0xffc4
0339 23                               inc hl
033a cd bd ff                         call 0xffbd
033d b3                               or e
033e 5f                               ld e,a
033f 3e aa                            ld a,0xaa
0341 cd c4 ff                         call 0xffc4
0344 23                               inc hl
0345 3e 19                            ld a,0x19
0347 3d                               dec a
0348 c2 27 ff                         jp nz,0xff27
034b 7c                               ld a,h
034c b8                               cp b
034d c2 0d ff                         jp nz,0xff0d
0350 7d                               ld a,l
0351 b9                               cp c
0352 c2 0d ff                         jp nz,0xff0d
0355 c9                               ret
0356 3e 82                            ld a,0x82
0358 32 e3 ff                         ld (0xffe3),a
035b 3e 31                            ld a,0x31
035d 32 f8 ff                         ld (0xfff8),a
0360 16 08                            ld d,0x08
0362 e5                               push hl
0363 cd 83 ff                         call 0xff83
0366 06 0a                            ld b,0x0a
0368 77                               ld (hl),a
0369 2c                               inc l
036a 05                               dec b
036b c2 48 ff                         jp nz,0xff48
036e e1                               pop hl
036f 7b                               ld a,e
0370 0f                               rrca
0371 5f                               ld e,a
0372 24                               inc h
0373 24                               inc h
0374 15                               dec d
0375 c2 42 ff                         jp nz,0xff42
0378 b7                               or a
0379 c8                               ret z
037a 21 78 aa                         ld hl,0xaa78
037d 06 0a                            ld b,0x0a
037f 78                               ld a,b
0380 55                               ld d,l
0381 5c                               ld e,h
0382 32 e3 ff                         ld (0xffe3),a
0385 15                               dec d
0386 c2 65 ff                         jp nz,0xff65
0389 55                               ld d,l
038a ee 01                            xor 0x01
038c 1d                               dec e
038d c2 62 ff                         jp nz,0xff62
0390 4c                               ld c,h
0391 65                               ld h,l
0392 69                               ld l,c
0393 05                               dec b
0394 c2 60 ff                         jp nz,0xff60
0397 3e 00                            ld a,0x00
0399 32 e0 ff                         ld (0xffe0),a
039c 32 e2 ff                         ld (0xffe2),a
039f 32 f8 ff                         ld (0xfff8),a
03a2 c9                               ret


03a3 7b                               ld a,e
03a4 e6 01                            and 0x01
03a6 c8                               ret z
03a7 3e ff                            ld a,0xff
03a9 c9                               ret


03aa 11 00 00                         ld de,0x0000
03ad e5                               push hl
03ae c5                               push bc
03af cd e4 fe                         call 0xfee4
03b2 cd d0 fe                         call 0xfed0
03b5 c1                               pop bc
03b6 e1                               pop hl
03b7 cd 0d ff                         call 0xff0d
03ba cd d0 fe                         call 0xfed0
03bd c9                               ret


03be 3e 82                            ld a,0x82
03c0 32 e3 ff                         ld (0xffe3),a
03c3 3e 53                            ld a,0x53
03c5 32 f8 ff                         ld (0xfff8),a
03c8 e5                               push hl
03c9 0a                               ld a,(bc)
03ca b7                               or a
03cb ca b4 ff                         jp z,0xffb4
03ce 77                               ld (hl),a
03cf 2c                               inc l
03d0 03                               inc bc
03d1 c3 a9 ff                         jp 0xffa9
03d4 e1                               pop hl
03d5 24                               inc h
03d6 03                               inc bc
03d7 0a                               ld a,(bc)
03d8 b7                               or a
03d9 c2 9e ff                         jp nz,0xff9e
03dc c9                               ret


03dd c5                               push bc
03de cd d3 ff                         call 0xffd3
03e1 a9                               xor c
03e2 c1                               pop bc
03e3 c9                               ret


03e4 c5                               push bc
03e5 4f                               ld c,a
03e6 cd cb ff                         call 0xffcb
03e9 c1                               pop bc
03ea c9                               ret

                                      ; запись байта в RAM-диск
                                      ; HL - адрес
									  ; A  - номер страницы
                                      ; C  - байт
03eb 32 fd ff                         ld (0xfffd),a ; включить RAM-диск, страница A
03ee 71                               ld (hl),c     ; записать байт
03ef 32 fc ff                         ld (0xfffc),a ; включить основную RAM
03f2 c9                               ret

                                      ; чтение байта из RAM-диска
                                      ; HL - адрес
									  ; A  - номер страницы
                                      ; C  - байт
03f3 32 fd ff                         ld (0xfffd),a ; включить RAM-диск, страница A
03f6 4e                               ld c,(hl)     ; считать байт
03f7 32 fc ff                         ld (0xfffc),a ; включить основную RAM
03fa c9                               ret

                                      ; хвостик
03fb ff ff ff ff ff                   .db ff ff ff ff ff 
