-- -----------------------------------------------
-- CLi² (Command Line Interface)
-- 2021 © breeze/fishbone crew
-- -----------------------------------------------
-- split
-- -----------------------------------------------

function splitByChunk(text, chunkSize)
	local s = {}
	for i=1, #text, chunkSize do
		s[#s+1] = text:sub(i,i+chunkSize - 1)
	end
	return s
end

-- -----------------------------------------------
-- convert unicode to cp866
-- -----------------------------------------------
function _u(text)

	local s
	local i
	local is_c2 = false
	local is_c3 = false
	local is_c9 = false
	local is_d0 = false
	local is_d1 = false
	local is_e2 = false
	local is_e2_80 = false
	local is_e2_81 = false
	local is_e2_82 = false
	local is_e2_84 = false
	local is_e2_85 = false
	local is_e2_86 = false
	local is_e2_87 = false
	local is_e2_88 = false
	local is_e2_89 = false
	local is_e2_8a = false
	local is_e2_8c = false
	local is_e2_8d = false
	local is_e2_94 = false
	local is_e2_96 = false
	local is_e2_97 = false
	local is_e2_98 = false
	local is_e2_99 = false
	local is_e2_9a = false
	local is_e2_9c = false
	local is_e2_9d = false

	local ret = ""

			--         0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_c2 = {
			--	            ¢     £     ¤     ¥           §           ©           «                 ®
				            0x00, 0x00, 0x0f, 0x00, 0x00, 0x15, 0x00, 0x7f, 0x00, 0xfe, 0x00, 0x00, 0xfc, 0x00, -- Ax
			--	°     ±     ²     ³                 ¶                 ¹           »     ¼     ½     ¾     
				0xf8, 0x00, 0xfd, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00	-- Bx
			}

			--  0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_c3 = {
			--	                                                      ÷
				                                                      0x00					-- Bx
	}

			--         0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_c9 = {
			--	                  Ƀ     Ʉ
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	-- 8x
			--
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	-- 9x
			--                                                              ɪ
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00	-- Ax
	}

			--         0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_d0 = {
			--	      Ё                 Є           І     Ї                                         Ў
				0x00, 0xf0, 0x00, 0x00, 0xf2, 0x00, 0x49, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf6, 0x00,	-- 8x
			--	А     Б     В     Г     Д     Е     Ж     З     И     Й     К     Л     М     Н     О     П    
				0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,	-- 9x
			--	Р     С     Т     У     Ф     Х     Ц     Ч     Ш     Щ     Ъ     Ы     Ь     Э     Ю     Я
				0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,	-- Ax
			--	а     б     в     г     д     е     ж     з     и     й     к     л     м     н     о     п
				0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf	-- Bx
	}

			--         0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_d1 = {
			--	р     с     т     у     ф     х     ц     ч     ш     щ     ъ     ы     ь     э     ю     я
				0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,	-- 8x
			--	      ё                 є           і     ї                                         ў
				0x00, 0xf1, 0x00, 0x00, 0xf3, 0x00, 0x69, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf7, 0x00	-- 9x
	}

			--         0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_80 = {
			--	                                                                        ‼
				                                                                        0x13			-- Bx
	}

			--         0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_81 = {
			--	⁰                       ⁴     ⁵     ⁶     ⁷     ⁸     ⁹
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	0x00, 0x00					-- Bx
	}

			--         0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_82 = {
			--	                                                                              ₽
				                                                                              0x00		-- Bx
	}

			--         0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_84 = {
			--	                                    №
				                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	-- 9x
			--	            ™
				0x00, 0x00, 0x00										-- Ax
	}

			--         0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_85 = {
			--	                  ⅓
				                  0x00										-- 9x
	}

			--         0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_86  = {
			--	←     ↑     →     ↓     ↔     ↕
				0x1b, 0x18, 0x1a, 0x19, 0x1d, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	-- 9x
			--                                                  ↨
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	-- Ax
			--                                          ↶     ↷
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00      						-- Bx
	}

			--         0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_87 = {
			--                                                                                          ⇎
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	-- 8x
			--	⇐           ⇒           ⇔                                
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00	-- 9x
			}

			--         0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_88 = {
			--	                                                            √                             ∟
				                                                            0x00, 0x00, 0x00, 0x00, 0x00, 0x1c	-- 9x
	}

			--         0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_89 = {
			--	≠                       ≤     ≥
				0xb1, 0x00, 0x00, 0x00, 0x00, 0x00								-- Ax
	}

			--         0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_8a = {
			--                                    ⊕     ⊖
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	-- 9x
			--	      ⊡
				0x00, 0x00											-- Ax
			}

			--         0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_8c = {
			--	            ⌂
				            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	-- 8x
			--  
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	-- 9x
			--
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, -- Ax
			--	                                                ⌸     ⌹
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  					-- Bx
	}

			--         0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_8d  = {
			--	⍐                                         ⍗                                         ⍞
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00	-- 9x
	}

			--         0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s94 = {
			--      ─           │
				0xc4, 0x00, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	-- 8x
			--                                └                                               ├
				0x00, 0x00, 0x00, 0x00, 0xd5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd4, 0x00, 0x00, 0x00,	-- 9x
			--
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, -- Ax
			--                                                                              ┼
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc5, 0x00, 0x00, 0x00	-- Bx
	}

			--         0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s96 = {
			--                    ▂
				0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	-- 8x
			--        ░     ▒     ▓
				0xb0, 0xb1, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	-- 9x
			--                                                                    ▪                 ▭           ▯
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, -- Ax
			--	      ▱     ▲                       ▶                                   ▼
				0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f			-- Bx
			}

			--         0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_97 = {
			--	◀                                                     ◉     ◊     ○                 ◎     ●
				0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf9,	-- 8x
			--                                                      ◘     ◙
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00					-- 9x
	}

			--         0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_98 = {
			--      ☐     ☑     ☒
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	-- 9x
			--
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	-- Ax
			--	                                                            ☺     ☻     ☼
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00			-- Bx
	}

			--         0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_99 = {
			--	♀           ♂
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	-- 8x
			--
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	-- 9x
			--	♠                 ♣           ♥     ♦                       ♪           ♬
				0x06, 0x00, 0x00, 0x05, 0x00, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00			-- Ax
	}

			--         0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_9a = {
			--                                                                  ⚪
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00	-- Ax
	}

			--         0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_9c = {
			--                  ✂                                         ✉
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00	-- 8x
	}

			--         0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_9d = {
			--                                                                                                ❏
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00	-- 8x
	}

	for i = 1, #text do
		s = string.byte(text, i)
		if is_c2 then
			is_c2 = false
			v = string.byte(text, i) - 0xa2
			s = s_c2[v+1]
			sj.add_byte(s)
			ret = ret .. string.char(s)

		elseif is_c3 then
			is_c3 = false
			v = string.byte(text, i) - 0xb7
			s = s_c3[v+1]
			sj.add_byte(s)
			ret = ret .. string.char(s)

		elseif is_c9 then
			is_c9 = false
			v = string.byte(text, i) - 0x80
			s = s_c9[v+1]
			sj.add_byte(s)
			ret = ret .. string.char(s)

		elseif is_d0 then
			is_d0 = false
			v = string.byte(text, i) - 0x80
			s = s_d0[v+1]
			sj.add_byte(s)
			ret = ret .. string.char(s)

		elseif is_d1 then
			is_d1 = false
			v = string.byte(text, i) - 0x80
			s = s_d1[v+1]
			sj.add_byte(s)
			ret = ret .. string.char(s)

		elseif is_e2_80 then
			is_e2 = false
			is_e2_80 = false
			v = string.byte(text, i) - 0xbc
			s = s_80[v+1]
			sj.add_byte(s)
			ret = ret .. string.char(s)

		elseif is_e2_81 then
			is_e2 = false
			is_e2_81 = false
			v = string.byte(text, i) - 0xb0
			s = s_81[v+1]
			sj.add_byte(s)
			ret = ret .. string.char(s)

		elseif is_e2_82 then
			is_e2 = false
			is_e2_82 = false
			v = string.byte(text, i) - 0xbd
			s = s_82[v+1]
			sj.add_byte(s)
			ret = ret .. string.char(s)

		elseif is_e2_84 then
			is_e2 = false
			is_e2_84 = false
			v = string.byte(text, i) - 0x96
			s = s_84[v+1]
			sj.add_byte(s)
			ret = ret .. string.char(s)

		elseif is_e2_85 then
			is_e2 = false
			is_e2_85 = false
			v = string.byte(text, i) - 0x93
			s = s_85[v+1]
			sj.add_byte(s)
			ret = ret .. string.char(s)

		elseif is_e2_86 then
			is_e2 = false
			is_e2_86 = false
			v = string.byte(text, i) - 0x90
			s = s_86[v+1]
			sj.add_byte(s)
			ret = ret .. string.char(s)

		elseif is_e2_87 then
			is_e2 = false
			is_e2_87 = false
			v = string.byte(text, i) - 0x80
			s = s_87[v+1]
			sj.add_byte(s)
			ret = ret .. string.char(s)

		elseif is_e2_88 then
			is_e2 = false
			is_e2_88 = false
			v = string.byte(text, i) - 0x9a
			s = s_88[v+1]
			sj.add_byte(s)
			ret = ret .. string.char(s)

		elseif is_e2_89 then
			is_e2 = false
			is_e2_89 = false
			v = string.byte(text, i) - 0xa0
			s = s_89[v+1]
			sj.add_byte(s)
			ret = ret .. string.char(s)

		elseif is_e2_8c then
			is_e2 = false
			is_e2_8c = false
			v = string.byte(text, i) - 0x82
			s = s_8c[v+1]
			sj.add_byte(s)
			ret = ret .. string.char(s)

		elseif is_e2_8a then
			is_e2 = false
			is_e2_8a = false
			v = string.byte(text, i) - 0x90
			s = s_8a[v+1]
			sj.add_byte(s)
			ret = ret .. string.char(s)

		elseif is_e2_8d then
			is_e2 = false
			is_e2_8d = false
			v = string.byte(text, i) - 0x90
			s = s_8d[v+1]
			sj.add_byte(s)
			ret = ret .. string.char(s)

		elseif is_e2_96 then
			is_e2 = false
			is_e2_96 = false
			v = string.byte(text, i) - 0x80
			s = s96[v+1]
			sj.add_byte(s)
			ret = ret .. string.char(s)

		elseif is_e2_94 then
			is_e2 = false
			is_e2_94 = false
			v = string.byte(text, i) - 0x80
			s = s94[v+1]
			sj.add_byte(s)
			--print(s)
			--print('"' .. string.format("%c", 1) .. '"')
			--print('"' .. string.format("%c", 127) .. '"')
			--print('"' .. string.format("%c", 128) .. '"')
			--print('"' .. string.format("%c%c%c", s,s,s) .. '"')
			ret = ret .. string.char(s)

		elseif is_e2_97 then
			is_e2 = false
			is_e2_97 = false
			v = string.byte(text, i) - 0x80
			s = s_97[v+1]
			sj.add_byte(s)
			ret = ret .. string.char(s)

		elseif is_e2_98 then
			is_e2 = false
			is_e2_98 = false
			v = string.byte(text, i) - 0x90
			s = s_98[v+1]
			sj.add_byte(s)
			ret = ret .. string.char(s)

		elseif is_e2_99 then
			is_e2 = false
			is_e2_99 = false
			v = string.byte(text, i) - 0x80
			s = s_99[v+1]
			sj.add_byte(s)
			ret = ret .. string.char(s)

		elseif is_e2_9a then
			is_e2 = false
			is_e2_9a = false
			v = string.byte(text, i) - 0xa0
			s = s_9a[v+1]
			sj.add_byte(s)
			ret = ret .. string.char(s)

		elseif is_e2_9c then
			is_e2 = false
			is_e2_9c = false
			v = string.byte(text, i) - 0x80
			s = s_9c[v+1]
			sj.add_byte(s)
			ret = ret .. string.char(s)

		elseif is_e2_9d then
			is_e2 = false
			is_e2_9d = false
			v = string.byte(text, i) - 0x80
			s = s_9d[v+1]
			sj.add_byte(s)
			ret = ret .. string.char(s)

		else
			if (s == 0xc2) then
				is_c2 = true

			elseif (s == 0xc3) then
				is_c3 = true

			elseif (s == 0xc9) then
				is_c9 = true

			elseif (s == 0xd0) then
				is_d0 = true
			
			elseif (s == 0xd1) then
				is_d1 = true
			
			elseif (s == 0xe2) then
				is_e2 = true
			
			elseif (is_e2 and s == 0x80) then
				is_e2_80 = true

			elseif (is_e2 and s == 0x81) then
				is_e2_81 = true

			elseif (is_e2 and s == 0x82) then
				is_e2_82 = true

			elseif (is_e2 and s == 0x84) then
				is_e2_84 = true

			elseif (is_e2 and s == 0x85) then
				is_e2_85 = true

			elseif (is_e2 and s == 0x86) then
				is_e2_86 = true

			elseif (is_e2 and s == 0x87) then
				is_e2_87 = true

			elseif (is_e2 and s == 0x88) then
				is_e2_88 = true

			elseif (is_e2 and s == 0x89) then
				is_e2_89 = true

			elseif (is_e2 and s == 0x8c) then
				is_e2_8c = true

			elseif (is_e2 and s == 0x8a) then
				is_e2_8a = true

			elseif (is_e2 and s == 0x8d) then
				is_e2_8d = true
			
			elseif (is_e2 and s == 0x94) then
				is_e2_94 = true
			
			elseif (is_e2 and s == 0x96) then
				is_e2_96 = true
			
			elseif (is_e2 and s == 0x97) then
				is_e2_97 = true

			elseif (is_e2 and s == 0x98) then
				is_e2_98 = true

			elseif (is_e2 and s == 0x99) then
				is_e2_99 = true

			elseif (is_e2 and s == 0x9a) then
				is_e2_9a = true

			elseif (is_e2 and s == 0x9c) then
				is_e2_9c = true

			elseif (is_e2 and s == 0x9d) then
				is_e2_9d = true
			else
				sj.add_byte(s)
				ret = ret .. string.char(s)
			end
		end			
	end

	return ret
end

function _U(text)
	local s
	local i
	local is_d0 = false
	local is_d1 = false
			--  0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_d0 = {
			--	      Ё
				0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	-- 8x
			--	А	  Б     В     Г     Д     Е     Ж     З     И     Й     К     Л     М     Н     О     П    
				0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,	-- 9x
			--	Р     С     Т     У     Ф     Х     Ц     Ч     Ш     Щ     Ъ     Ы     Ь     Э     Ю     Я
				0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,	-- Ax
			--	а     б     в     г     д     е     ж     з     и     й     к     л     м     н     о     п
				0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf	-- Bx
	}

			--  0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
	local s_d1 = {
			--	р     с     т     у     ф     х     ц     ч     ш     щ     ъ     ы     ь     э     ю     я
				0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,	-- 8x
			--	      ё
				0x00, 0xf1											-- 9x
	}

	for i = 1, #text do
		s = string.byte(text, i)
		if is_d0 then
			is_d0 = false
			v = string.byte(text, i) - 0x80
			s = s_d0[v+1]
			sj.add_byte(s)

		elseif is_d1 then
			is_d1 = false
			v = string.byte(text, i) - 0x80
			s = s_d1[v+1]
			sj.add_byte(s)

		else
			if (s == 0xd0) then
				is_d0 = true
			
			elseif (s == 0xd1) then
				is_d1 = true

			else
				sj.add_byte(s)
			end
		end			
	end

end
