;       INT 10h, function 00h-1ch video bios. v0.3
;	TASM 3.0
;	(c) Freddy 2021 antenn@land.ru
; Not for publication in any media. For non-comercial use only.
;-------------------------------------------------------------------------
use_cli		=	1
;debug		=	1
;DBG_PORT	EQU	80h ; 330h

.8086
model tiny
.code
start:

start_io	equ	0300h		; Videocard start io adr
end_io		equ	03e0h		; Videocard end io adr
vbuf_adr	equ	0b800h		; Videobufer start adr
biosdseg	equ	0040h		; Sys bios data seg
bios_size	equ	16		; 64*512=32Kb ROM

; Sys bios data area structure
video_mode	equ	49h	; byte - active video mode number
video_columns	equ	4Ah	; word - number of text columns for active mode
video_page_size	equ	4Ch	; word - size of video page in bytes
video_page_offt	equ	4Eh	; word - offset of the active video page
video_cur_pos	equ	50h	; byte[16] - cursor position for each page
video_cur_shape	equ	60h	; word - cursor shape
video_page	equ	62h	; byte - active video page
video_port	equ	63h	; word - I/O port for the display adapter
video_mode_reg	equ	65h	; byte - video adapter mode register
video_palet_reg	equ	66h	; byte - color palette
video_rows	equ	84h	; byte - nuber of video rows -1
video_char_scl	equ	85h	; word - number of scanlines per character
video_options	equ	87h	; byte - video adapter options
	; bit7 indicates of bit7 of last change video mode
	; 0 = clear video memory when setting videomode
	; 1 = don't clear video memory
	; Bits 6-5  indicates the video memory size
	; 00b = 64K, 01b = 128K, 10b = 192K, 11b = 256K
	; Bit4 reserved
	; Bit3 indicate active video adapter for EGA+
	; 0b = not active, 1b = ative
	; Bit2 reserved
	; Bit1 is monitior type. 0b = color, 1b = monochrome
	; Bit0 alphanumeric cursor emulation
	; 0b = disabled, 1b = enabled
video_vga_fl1	equ	89h	; byte - vga video flags 1
	; bits 7 and 4 indicates number of scanlines
	; 00b = 350, 01b = 400, 10b = 200, 11b = reserved
	; bit6 - display switch, 0b = disabled, 1b = enabled
	; bit5 reserved  <-- used as vga detect semaphore [ah=1a00h]
	; bit3 - default palette loading, 0b = disabled, 1b = enabled
	; bit2 - monitor type, 0b = color, 1b = monochrome
	; bit1 - grayscale summing, 0b = disabled, 1b = enabled
	; bit0 - indicates VGA active state, 0b = off, 1b = VGA on
	
;-------------------------------------------------------------------------
; VG75 registers
vg75_dat	equ	0ch	; CRTC data reg
vg75_cmd	equ	0dh	; CRTC cmd and status reg
;-------------------------------------------------------------------------
; VT57 registers
vt57_cmd	equ	018h	; DMA control reg
vt57_ch2_adr	equ	014h	; DMA 2nd chanel start adr
vt57_ch2_cn	equ	015h	; DMA 2nd chanel counter+mode
vt57_ch3_adr	equ	016h	; DMA 3rd chanel start adr
;-------------------------------------------------------------------------
; System board registers
timer_cmd	equ	43h		; System PIT contol reg
timer_ch2	equ	42h		; Systemp PIT ch2 divider
port_b_reg	equ	61h		; Sys CTRL reg
;-------------------------------------------------------------------------

; control characters
bel	equ	07h
bs	equ	08h
lf	equ	0Ah
cr	equ	0Dh

	org	0000h			; Vbios start adress C000:0000h
;-------------------------------------------------------------------------
vb_sign		dw	0aa55h		; Vbios signature
vb_size		db	bios_size	; Vbios size/512
;------------------<Magic bytes>------------------------------------------
	jmp	powerup

kr580_msg	db	'<<<KR580VG75>>>',0	

already_set:
	jmp	vg75_not_found


	org	01eh
		db	'IBM VGA Compatible BIOS',0
;--------------------------------------------------------------------
powerup:	;First start up
		push	bp		;Save all registers to stack
		push	es
		push	ds
		push	si
		push	di
		push	dx
		push	cx
		push	bx
		push	ax
		pushf
ifdef DEBUG
mov dx,DBG_PORT
mov al,0F0h	; STARTUP [F0]
out dx,al
jmp $+2
jmp $+2
push cs
pop ax
xchg al,ah
out dx,al	; PRINT CODE SEG
jmp $+2
jmp $+2
mov al,ah
out dx,al
jmp $+2
jmp $+2
endif

		;mov 	byte ptr es:[video_vga_fl1],0

		xor	di,di		;Get int10h vector
		mov	es,di
		mov	di,10h*4
		cld
		mov	ax,offset int_10
		cmp	es:[di],ax
		je	already_set

		mov	ax,biosdseg
		mov	es,ax		;ES point to bios data area seg

ifdef DEBUG
mov dx,330h
mov al,0F1h	; START SEARCH [F1]
out dx,al
jmp $+2
jmp $+2
endif
;----------------VG75 search routine-----------------------------------
		mov	dx,start_io-20h+vg75_cmd
next_io_adr:	add	dx,20h			;dx=vg75 command registr
		cmp	dx,end_io+vg75_cmd	;check for end of range
		jnc	vg75_not
		xor	al,al
		out	dx,al			;send reset CMD to VG75
		dec	dx
		out	dx,al
		out	dx,al
		out	dx,al
		out	dx,al
		inc	dx
		in	al,dx			;read VG75 status
		and	al,11000000b		;7,6 bits must be 0
		jnz	next_io_adr		;it's not VG75
		mov	al,10100000b		;send enable interrupt CMD
		out	dx,al
		nop
		nop
		nop
		in	al,dx			;read VG75 status
		and	al,01000000b		;6th bit must be 1
		jz	next_io_adr		;if not > continue search
		sub	dx,vg75_cmd		;dx= base io port number
		jmp 	set_vg_port
vg75_not:
		call	beep			; error
		jmp vg75_not_found

set_vg_port:
		CLI
		mov	es:[video_port],dx 	; store base io port
		mov	byte ptr es:[video_options],01101000b
		STI
				;256Kb,color,cursor emu off,disp active
;----------------------------------------------------------------------
ifdef DEBUG
mov bx,dx
mov dx,DBG_PORT
mov al,0F2h	; END SEARCH [F2]
out dx,al
jmp $+2
jmp $+2

mov al,bh	; PRINT IO PORT
out dx,al
jmp $+2
jmp $+2
mov al,bl
out dx,al
jmp $+2
jmp $+2
endif

ifdef DEBUG
mov bx,dx
mov dx,DBG_PORT
mov al,0F3h	; READY TO SETUP CARD [F3]
out dx,al
jmp $+2
jmp $+2
endif
		CLI
		xor	di,di		;Set int10h vector
		mov	es,di
		mov	di,10h*4
		cld
		mov	ax,offset int_10

		stosw			;Store int10h entry point
		mov	ax,0c000h
		stosw			;Store Vbios segment
		mov	ax,biosdseg
		mov	es,ax		;ES point to bios data area seg
		STI

		mov	ax,0003h		;startup videocard
		int	10h
				
ifdef DEBUG
mov bx,dx
mov dx,DBG_PORT
mov al,0F4h	; SETUP MODE OK [F4]
out dx,al
jmp $+2
jmp $+2
endif
		mov	ax,vbuf_adr		;print titul msg
		mov	es,ax			;es:di=video bufer addr
		mov	ax,0c000h
		mov	ds,ax			;ds:si=video bios addr
		xor	di,di
		mov	si,offset kr580_msg
		mov	ah,08h
m0002:		lodsb
		cmp	al,0
		je	m0001
		inc	ah
		and	ah,0fh
		jnz	m0005
		mov	ah,09h
m0005:		stosw
		jmp	m0002
		
m0001:		mov	ah,02h			;set cursor function
		xor	bh,bh
		mov	dx,0100h		;1row,0col
		int	10h

		mov	si,offset welcome_msg
m0004:		lodsb
		or	al,al
		jz	m0003
		mov	ah,0eh
		mov	bl,0fh
		int	10h
		jmp	m0004
		
m0003:		mov	ah,02h			;set cursor function
		xor	bh,bh
		mov	dx,2500h		;hide cursor
		int	10h

		mov	ax,biosdseg
		mov	ds,ax		;DS point to bios data area seg
		mov	cx,210		;~3 seconds to view hello msg
		call	wait_time
		
;		mov	ax,0003h	;reinit video
;		int	10h
	
ifdef DEBUG
mov bx,dx
mov dx,DBG_PORT
mov al,0FEh	; NORMAL EXIT [FE]
out dx,al
jmp $+2
jmp $+2
endif

vg75_not_found:	
ifdef DEBUG
mov bx,dx
mov dx,DBG_PORT
mov al,0FFh	; GLOBAL EXIT [FF]
out dx,al
jmp $+2
jmp $+2
endif

		popf
		pop	ax		;Restore registers
		pop	bx
		pop	cx
		pop	dx
		pop	di
		pop	si
		pop	ds
		pop	es
		pop	bp
		retf		;Far return to system bios

;--------------------------------------------------------------------		
int_10_dispatch:
	dw	int_10_fn00		; Set video mode
	dw	int_10_fn01		; Set text mode cursor shape
	dw	int_10_fn02		; Set cursor position
	dw	int_10_fn03		; Get cursor position and shape
	dw	int_10_fn04		; Read light pen position
	dw	int_10_fn05		; Set active display page
	dw	int_10_fn06		; Scroll up window
	dw	int_10_fn07		; Scroll down window
	dw	int_10_fn08		; Read character and attribute
	dw	int_10_fn09		; Write character and attribute
	dw	int_10_fn0A		; Write character only
	dw	int_10_fn0B		; Set background color or palette
	dw	int_10_fn0C		; Write graphics pixel
	dw	int_10_fn0D		; Read graphics pixel
	dw	int_10_fn0E		; Teletype output
	dw	int_10_fn0F		; Get current video mode
	dw	int_10_fn10		; Get/Set palette registers
	dw	int_10_fn11		; Character generator control
	dw	int_10_fn12		; Video subsystem configuration
	dw	int_10_fn13		; Write string
	dw	int_10_exit		; 14h Load LCD Character font
	dw	int_10_exit		; 15h return physical display params
	dw	int_10_exit		; 16h not exist
	dw	int_10_exit		; 17h not exist
	dw	int_10_exit		; 18h not exist
	dw	int_10_exit		; 19h not exist
	dw	int_10_fn1a		; Get video subsystem combination
	dw	int_10_exit		; Video bios functionality state table
	dw	int_10_exit		; Save/Restore video state
	
int_10_num_func	equ ($-int_10_dispatch)/2


;-------------------------------------------------------------------------
; offsets for registers on stack

int_10_ax	equ	0
int_10_al	equ	int_10_ax
int_10_ah	equ	int_10_ax+1
int_10_bx	equ	int_10_ax+2
int_10_bl	equ	int_10_bx
int_10_bh	equ	int_10_bx+1
int_10_cx	equ	int_10_bx+2
int_10_ch	equ	int_10_cx+1
int_10_dx	equ	int_10_cx+2
int_10_dl	equ	int_10_dx

;=========================================================================
; int_10 - BIOS video services
; Input:
;	AH - Function
;		00h - Set video mode
;		01h - Set text mode cursor shape
;		02h - Set cursor position
;		03h - Get cursor position and shape
;		04h - Read light pen position
;		05h - Select active display page
;		06h - Scroll up window
;		07h - Scroll down window
;		08h - Read character and attribute at cursor position
;		09h - Write character and attribute at cursor position
;		0Ah - Write character only at cursor position
;		0Bh -
;			BH = 00h - Set background/border color
;			BH = 01h - Set palette
;		0Ch - Write graphics pixel
;		0Dh - Read graphics pixel
;		0Eh - Teletype output
;		0Fh - Get current video mode
;		10h - Get/Set palette registers
;			AL = 00h - set individual register
;			AL = 01h - set border color
;			AL = 02h - set all palette registers and border
;			AL = 03h - toggle intensity/blinking
;			AL = 07h - read palette registr
;			AL = 08h - read border color
;			AL = 09h - read all palette registers and border
;			AL = 10h - set DAC color register
;			AL = 12h - set block of DAC color registers
;			AL = 13h - set attribute controller color select state
;			AL = 15h - read DAC color register
;			AL = 17h - read block of DAC regs
;			AL = 18h - update video DAC mask reg
;			AL = 19h - read video DAC mask reg
;			AL = 1Ah - read color page state
;			AL = 1Bh - sum color values to shades of gray
;	11H - Character generator settings
;			AL = 00h - user charset load
;			AL = 01h - 8x14 ROM BIOS set load
;			AL = 02h - 8x8 ROM BIOS set load
;			AL = 03h - set displayed definition table
;			AL = 04h - 8x16 ROM BIOS set load
;			AL = 10h - user charset + display reset
;			AL = 11h - ROM BIOS 8x14 + display reset
;			AL = 12h - ROM BIOS 8x8 + dosplay reset
;			AL = 14h - ROM BIOS 8x16 + disp reset
;		AL = 20h - pointer to graphics character table for INT 1FH
;			AL = 21h - user graphics character pointer for INT 43
;			AL = 22h - ROM 8x14 for INT 43h
;			AL = 23h - ROM 8x8 for INT 43h
;			AL = 24h - ROM 8x16 for INT 43H
;			AL = 30h - get current character generator info
;	12H - Video Subsystem configuration
;			BL = 10h - return video config info
;			BL = 20h - set alternate print screen routine
;			BL = 30h - selet scan lines for alphanumeric modes
;			BL = 31h - select default palette loading
;			BL = 32h - CPU access to VRAM
;			BL = 33h - Grayscale summing
;			BL = 34h - Cursor emulation
;			BL = 35h - video display switching
;			BL = 36h - video refresh control
;	13H - Write string

;-------------------------------------------------------------------------
; int 10 Entry Point
int_10:
	sti
	cld				;  ...strings auto-increment
	push	bp
	push	es
	push	ds
	push	si
	push	di
	push	dx
	push	cx
	push	bx
	push	ax
	CLI
	mov	bx,biosdseg
	mov	ds,bx
	mov	bx,vbuf_adr		; assume CGA, BX = CGA video segment
	mov	es,bx			; load video segment to ES
	mov	bp,sp			;  ...start of stack frame
	STI
	cmp	ah,int_10_num_func	; dispatch table size
	jae	exit			; invalid function
	mov	bh,0
	mov	bl,ah
	shl	bx,1
	call	word ptr cs:[int_10_dispatch+bx]

exit:
	pop	ax
	pop	bx
	pop	cx
	pop	dx
	pop	di
	pop	si
	pop	ds
	pop	es
	pop	bp
	iret


;=========================================================================
; int_10_fn00 - Set video mode
; Input:
;	AH = 00h
;	AL = video mode
;		00h - CGA - text 40x25, 16 shades of gray
;		01h - CGA - text 40x25, 16 colors
;		02h - CGA - text 80x25, 16 shades of gray
;		03h - CGA - text 80x25, 16 colors
;		04h - CGA - graphics 320x200, 4 colors
;		05h - CGA - graphics 320x200, 4 shades of gray
;		06h - CGA - graphics 640x200, monochrome
;		07h - MDA - text 80x25, monochrome
;-------------------------------------------------------------------------
int_10_fn00:
	mov	al,byte ptr [bp+int_10_al]	; AL = video mode
	mov	si,offset mode_80x25
	cmp	al,03h		; check for 03h mode
	je	fn00_setup1
	cmp	al,83h		; check non clear video bufer bit
	je	fn00_setup2	; don't clear
	mov	si,offset mode_80x30
	cmp	al,50h
	jne	test51
	jmp	fn11_set_mode
test51:	mov	si,offset mode_80x43
	cmp	al,51h
	jne	test52
	jmp	fn11_set_mode
test52:	mov	si,offset mode_80x60
	cmp	al,52h
	jne	n_mode
	jmp	fn11_set_mode
n_mode:	ret			; if not -> exit
set_curs1:
	jmp set_curs
fn00_setup1:	;mov	al,byte ptr [bp+int_10_al]

; clear	videobufer
ifdef DEBUG
mov dx,DBG_PORT
mov al,0e0h
out dx,al
jmp $+2
jmp $+2
endif
		CLI
		mov	ax,0720h	;white FG, space
		mov	cx,4000h	;32kb buf size
		xor	di,di
		rep	stosw
		STI

fn00_setup2:	
ifdef DEBUG
mov dx,DBG_PORT
mov al,0e1h
out dx,al
jmp $+2
jmp $+2
endif
		mov	ax,ds
		mov	es,ax
		mov	ax,0c000h
		mov	ds,ax
		
; if video enable then not need to be reinitialised	
		cmp	byte ptr es:[video_rows],24
		jnz	set_vmode
		
ifdef DEBUG
mov dx,DBG_PORT
mov al,0eah
out dx,al
jmp $+2
jmp $+2
endif

ifdef DEBUG
mov	dx,es:[video_port]
mov bx,dx
mov dx,DBG_PORT
mov al,0a0h	; END SEARCH [F2]
out dx,al
jmp $+2
jmp $+2

mov al,bh	; PRINT IO PORT
out dx,al
jmp $+2
jmp $+2
mov al,bl
out dx,al
jmp $+2
jmp $+2
endif
		mov	dx,es:[video_port]
		add	dx,vg75_cmd
		in	al,dx
ifdef DEBUG
push ax
mov dx,DBG_PORT
mov al,0ebh
out dx,al
pop ax
jmp $+2
jmp $+2
endif
		test	al,00000100b
		jnz	set_curs1

set_vmode:
ifdef DEBUG
mov dx,DBG_PORT
mov al,0e2h
out dx,al
jmp $+2
jmp $+2
endif

ifdef DEBUG
mov	dx,es:[video_port]
mov bx,dx
mov dx,DBG_PORT
mov al,0a1h	; END SEARCH [F2]
out dx,al
jmp $+2
jmp $+2

mov al,bh	; PRINT IO PORT
out dx,al
jmp $+2
jmp $+2
mov al,bl
out dx,al
jmp $+2
jmp $+2
endif
		mov	dx,es:[video_port]
		add	dx,vt57_cmd	; Stop DMA
		xor	al,al
		out	dx,al
	jmp $+2
	jmp $+2
; CRTC init	
crtc_ini:	
ifdef DEBUG
mov dx,DBG_PORT
mov al,0e3h
out dx,al
jmp $+2
jmp $+2
endif
		push	si		;store pointer to mode table

		mov	dx,es:[video_port]
		add	dx,vg75_cmd	; Reset CRTC cmd
		xor	al,al
		out	dx,al
	jmp $+2
		dec	dx
		lodsb
		out	dx,al
	jmp $+2
		lodsb
		out	dx,al
	jmp $+2
		lodsb
		out	dx,al
	jmp $+2
		lodsb
		out	dx,al
	jmp $+2
		
		inc	dx		; Reset counters
		mov	al,11100000b
		out	dx,al
	jmp $+2

ifdef DEBUG
mov dx,DBG_PORT
mov al,0e4h
out dx,al
jmp $+2
jmp $+2
endif
		call	run_DMA		; Used to time delay for previous cmd
ifdef DEBUG
mov dx,DBG_PORT
mov al,0d4h
out dx,al
jmp $+2
jmp $+2
endif

		mov	dx,es:[video_port]
		add	dx,vg75_cmd	; Start display
		lodsb
		out	dx,al
	jmp $+2

		mov	cx,5
wait_frame:	in	al,dx
		test	al,00000010b	; Check DMA underrun
		jz	frame_loop
		pop	si		; Restore mode table pointer
		jmp	crtc_ini	; Reinit CRTC if DMA underrun
frame_loop:	test	al,00100000b	; Checkin end of current frame
		jz	wait_frame
	loop	wait_frame		;Checking until 5 frame complited
		
ifdef DEBUG
mov dx,DBG_PORT
mov al,0e5h
out dx,al
jmp $+2
jmp $+2
endif
		call	run_DMA		; Start DMA service
		
;enable default charset page
		lodsb
		mov	dx,es:[video_port]	; Set charset page
		out	dx,al
	jmp	$+2
ifdef DEBUG
mov dx,DBG_PORT
mov al,0d9h
out dx,al
jmp $+2
jmp $+2
endif

; Store bios variables block
	cli
	mov	byte ptr es:[video_mode],03h	; store video mode
	mov	word ptr es:[video_columns],80	; store screen width
	lodsb
	mov	byte ptr es:[video_rows],al	; rows-1
	lodsw
	mov	word ptr es:[video_char_scl],ax		; bytes per character
	lodsw
	mov	word ptr es:[video_page_size],ax	 ; Set page size
	lodsw
	mov	word ptr es:[video_cur_shape],ax	 ; cursor shape
	sti

	pop	si				; Correct stack pointer

;Set cursor to left top corner		
set_curs:	
ifdef DEBUG
mov dx,DBG_PORT
mov al,0e6h
out dx,al
jmp $+2
jmp $+2
endif
		xor	dx,dx
		mov	ah,02h
		xor	bh,bh
		int	10h		; set cursor

ifdef DEBUG
mov dx,DBG_PORT
mov al,0e7h
out dx,al
jmp $+2
jmp $+2
endif
	CLI
	mov	byte ptr es:[video_page],0	; active page 0

	xor	ax,ax
	mov	di,video_page_offt
	mov	cx,9
	rep	stosw				;zero page offset and curs pos
	STI

ifdef DEBUG
mov dx,DBG_PORT
mov al,0e8h
out dx,al
jmp $+2
jmp $+2
endif
fn00_exit:	ret


;=========================================================================
; int_10_fn01 - Set text-mode cursor shape
; Input:
;	AH = 01h
;	CH = cursor scan line start
;	CL = cursor scan line end
; Output:
;	none
;-------------------------------------------------------------------------
int_10_fn01:	;no hardware for change cursor shape
	mov	word ptr ds:[video_cur_shape],cx ;save curs shape to BIOS data
	test	ch,00100000b		; check for hide cursor bit
	je	fn01_restart_cur

	mov	dx,ds:[video_port]
	add	dx,VT57_cmd
	mov	al,80h		; Temporary stop DMA service
ifdef USE_CLI
	cli
endif
	out	dx,al
	mov	dx,ds:[video_port]	;hide cursor
	add	dx,vg75_cmd
	mov	al,10000000b	; CRTC set curs CMD
	out	dx,al
	dec	dx
	mov	al,80		; set column
	out	dx,al
	out	dx,al		; set row
	
	mov	dx,ds:[video_port]
	add	dx,VT57_cmd
	mov	al,84h		; Start DMA service
	out	dx,al
ifdef USE_CLI
	sti
endif	
	ret

fn01_restart_cur:	;Set cursor visible
		mov	bl,byte ptr ds:[video_page]	;get active page
		mov	bh,0
		shl	bl,1
		mov	cx,word ptr ds:[bx+video_cur_pos] ;get cursor position

		mov	dx,ds:[video_port]
		add	dx,VT57_cmd
		mov	al,80h		; Temporary stop DMA service
ifdef USE_CLI
		cli
endif
		out	dx,al

		mov	dx,ds:[video_port]
		add	dx,vg75_cmd
		mov	al,10000000b	; CRTC set curs CMD
		out	dx,al
		dec	dx
		mov	al,cl		; set column
		out	dx,al
		mov	al,ch		; set row
		out	dx,al
	
		mov	dx,ds:[video_port]
		add	dx,VT57_cmd
		mov	al,84h		; Start DMA service
		out	dx,al
ifdef USE_CLI
		sti
endif
		
		ret
	
;=========================================================================
; int_10_fn02 - Set cursor position
; Input:
;	AH = 02h
;	BH = page number
;	DH = cursor row (00h is top)
;	DL = cursor column (00h is left)
; Output:
;	none
;-------------------------------------------------------------------------
int_10_fn02:
	mov	cx,dx
	mov	bl,byte ptr [bp+int_10_bh]	; BL = page number
	cmp	byte ptr ds:[video_page],bl	; is it on current page?
	jne	bios_set_cur_pos	; if not visible only update BIOS data

set_cur_pos:	
	mov	dx,word ptr ds:[video_cur_shape]	;get cursor shape
	test	dh,00100000b	; check hide cursor bit
	jne	bios_set_cur_pos	; if not visible only update BIOS data
;=========================================================================
; set_cur_pos - set CRTC cursor position, update BIOS cursor location
;	BL = page
;	CH = cursor row (00h is top)
;	CL = cursor column (00h is left)
;-------------------------------------------------------------------------
set_cur_pos1:
	mov	dx,ds:[video_port]
	add	dx,VT57_cmd
	mov	al,80h		; Temporary stop DMA service
ifdef USE_CLI
	cli
endif
	out	dx,al
	mov	dx,ds:[video_port]
	add	dx,vg75_cmd
	mov	al,10000000b	; CRTC set curs CMD
	out	dx,al
	dec	dx
	mov	al,cl		; set column
	out	dx,al
	mov	al,ch		; set row
	out	dx,al
	
	mov	dx,ds:[video_port]
	add	dx,VT57_cmd
	mov	al,84h		; Start DMA service
	out	dx,al
ifdef USE_CLI
	sti
endif

bios_set_cur_pos:
	mov	bh,0
	shl	bl,1			; index to words table
	mov	word ptr ds:[bx+video_cur_pos],cx ; save pos to BIOS data area
	ret

;=========================================================================
; int_10_fn03 - Get cursor position and shape
; Input:
;	AH = 03h
;	BH = page number
; Output:
;	CH = cursor start scan line
;	CL = cursor end scan line
;	DH = cursor row (00h is top)
;	DL = cursor column (00h is left)
;-------------------------------------------------------------------------
int_10_fn03:
	mov	bh,0
	mov	bl,byte ptr [bp+int_10_bh]	; BL = page number
	shl	bl,1
	mov	ax,word ptr ds:[bx+video_cur_pos] ; get current curs position
	mov	word ptr [bp+int_10_dx],ax	; return position in DX
	mov	ax,word ptr ds:[video_cur_shape]  ; get cursor shape
	mov	word ptr [bp+int_10_cx],ax	; return cursor shape in CX
	ret

;=========================================================================
; int_10_fn04 - Read light pen position
; Input:
;	AH = 04h
; Output:
;	AH - light pen trigger flag
;		00h not down/triggered
;		01h down/triggered
;	If light pen is triggered:
;		DH = character row
;		DL = character column
;		CH = pixel row
;		BX = pixel column
;-------------------------------------------------------------------------
int_10_fn04:		; no hardware for light pen
	ret

;=========================================================================
; int_10_fn05 - Select active display page
; Input:
;	AH = 05h
;	AL - new page number (00h is the first page)
; Output:
;	none
;-------------------------------------------------------------------------
int_10_fn05:
	mov	byte ptr ds:[video_page],al	; update page number in BIOS data area
	mov	bl,al			; also copy it to BL
	mov	ah,0
	mul	word ptr ds:[video_page_size]	; calculate page offset
	mov	word ptr ds:[video_page_offt],ax ; save the offset

; Setup DMA ch3 start addres
	mov	cx,ax
	mov	dx,ds:[video_port]
	add	dx,VT57_cmd
	mov	al,80h		; Temporary stop DMA service
ifdef USE_CLI
	cli			; Disable interrupts
endif
	out	dx,al
	mov	ax,cx
	mov	dx,ds:[video_port]
	add	dx,VT57_ch3_adr	; Change DMA ch3 start address
	out	dx,al
	mov	al,ah
	out	dx,al
	mov	dx,ds:[video_port]
	add	dx,VT57_cmd	; Run DMA service
	mov	al,84h
	out	dx,al
ifdef USE_CLI
	sti			; Enable interrupts
endif
;--------------------------------	

fn05_set_curs:
	mov	bh,0
	shl	bx,1
	mov	dx,word ptr ds:[bx+video_cur_pos] ;DX-curs pos for new page
	mov	bh,byte ptr ds:[video_page] ;get page number
	mov	ah,02h
	int	10h
	ret
;=========================================================================
; int_10_fn06 - scroll up window
; int_10_fn07 - scroll down window
; Input:
;	AH = 06h (scroll up) or AH = 07 (scroll down)
;	AL = number of rows by which to scroll up (00h = clear entire window)
;	BH = attribute used to write blank rows at bottom of window
;	CH,CL = row,column of window's upper left corner
;	DH,DL = row,column of window's lower right corner
; Output:
;	none
;-------------------------------------------------------------------------
int_10_fn06:
int_10_fn07:

	mov	ax,word ptr [bp+int_10_dx]; AX = window's lower right corner
	push	ax
	cmp	byte ptr [bp+int_10_ah],07h; check for scroll down function
	jz	scrl_down		; jump if scroll down
	mov	ax,word ptr [bp+int_10_cx]; AX = window's upper left corner

scrl_down:
	call	vid_position_to_offset
	add	ax,word ptr ds:[video_page_offt]
	mov	di,ax			; DI = scroll copy destination address

; calculate scroll window size (DX)

	pop	dx			; DX = window's lower right corner
	sub	dx,word ptr [bp+int_10_cx]; substract windows's upper left corner
	add	dx,0101h 		; add 1x1

; calculate offset between the source and the destination (AX)

	mov	bx,word ptr ds:[video_columns]	; BX = columns (note BX <= 80)
	shl	bx,1			; each character takes two bytes
	mov	al,byte ptr [bp+int_10_al]; AL = number of rows to scroll
	push    dx
        mov     ah,0
        mul     bx
        pop     dx

	sub	bl,dl			; BX = distance between end of one
	sub	bl,dl			;   row and beggining of another
	push	ds
	mov	cx,es
	mov	ds,cx			; load video segment to DS
	cmp	byte ptr [bp+int_10_ah],06h; check for scroll up function
	jz	scrl_up			; jump if scroll up
	neg	ax			; negate offset
	neg	bx			; negate distance
	std				; copy backwards

scrl_up:
	mov	cl,byte ptr [bp+int_10_al]; CL = number of rows to scroll
	or	cl,cl
	jz	text_fill_only		; jump if clear window only requested
	mov	si,ax			; SI = offset
	add	si,di			; SI = scroll copy source address
	sub	dh,cl			; DH = number of rows to copy

	or	bx,bx
	jz	text_full_row_scroll

text_scroll_loop:
	mov	ch,0
	mov	cl,dl			; CX = characters in row to copy
	repz	movsw			; copy one row

;.text_scroll_next_row:
	add	si,bx			; SI = next row to copy source address
	add	di,bx			; DI = next row to copy destination
	dec	dh			; decrement row counter
	jnz	text_scroll_loop	; jump if there is more rows to copy

text_fill:
	mov	dh,byte ptr [bp+int_10_al]; DH = number of rows to fill

text_fill_only:
	mov	ch,0
	mov	ah,byte ptr [bp+int_10_bh]	; AH = blank attribute
	mov	al,' '			; AL = blank character

text_fill_loop:
	mov	cl,dl			; CX = characters in row to fill
	repz	stosw			; fill one row
	add	di,bx			; DI = next row to fill destination
	dec	dh			; decrement row counter
	jnz	text_fill_loop		; jump if there is more rows to fill

	pop	ds
	ret

text_full_row_scroll:
	mov	al,dl
	mul	dh
	mov	cx,ax
rep	movsw
	jmp	text_fill


;=========================================================================
; int_10_fn08 - Read character and attribute
; Input:
;	AH = 08h
; Output:
;	AL - character read
;	BH - video attribute (text modes only)
; int_10_fn09 - Write character and attribute
; Input:
;	AH = 09h
;	AL - character to write
;	BH - page number
;	BL - attribute (text modes) or color (graphics modes)
;	CX - number of times to write character
; Output:
;	none
; int_10_fn0A - Write character only
; Input:
;	AH = 0Ah
;	AL - character to write
;	BH - page number
;	CX - repeat count
; Output:
;	none
;-------------------------------------------------------------------------
int_10_fn08:
int_10_fn09:
int_10_fn0A:
	mov	bl,byte ptr [bp+int_10_bh]	; BL = page number
	mov	bh,0
	push	bx
	call	vid_current_offset
	mov	di,ax			; DI = character offset in the page
	pop	ax			; AX = page number
	mul	word ptr ds:[video_page_size]; AX = page number * page size
	add	di,ax			; DI = character offset
	mov	si,di			; SI = character offset
	push	ds
	mov	bx,es
	mov	ds,bx			; load video segment to DS
	mov	al,byte ptr [bp+int_10_ah]	; AL = function
	cmp	al,08h			; check for read character function
	jnz	text_write		; jump if not read char (write char)

	lodsw				; read character and attribute
	pop	ds
	mov	word ptr [bp+int_10_ax],ax; return char and attribute in AX
	ret

text_write:
	mov	bl,byte ptr [bp+int_10_al]	; BL = character to write
	mov	bh,byte ptr [bp+int_10_bl]	; BH = attribute to write
	mov	cx,word ptr [bp+int_10_cx] ;CX = number of times to write char
	cmp	al,0Ah			; check for write char only function
	jz	text_write_char_only	; jump if write char only

do_write_char_attr:
	mov	ax,bx			; AX = character / attribute
rep	stosw				; write it to video memory cx=times
	pop	ds
	ret

text_write_char_only:
	mov	al,bl			; AL = character to write
	stosb				; write it to video memory
	inc	di			; skip attribute
	loop	text_write_char_only	; repeat CX times
	pop	ds
	ret

;=========================================================================
; int_10_fn0B - Set background color or palette
; Input:
; 	AH - 0Bh
;	BH = 00h - set background / border color
;		BL - background (graphics modes) or border (text modes)
;	BH = 01h - set palette (320x200 graphics mode)
;		BL - palette ID:
;			00h - background, green, red, and yellow (brown)
;			01h - background, cyan, magenta, and white
; Output:
;	none
;-------------------------------------------------------------------------
int_10_fn0B:	;no overscan area hardware
	ret

;=========================================================================
; int_10_fn0C - Write graphics pixel
; Input:
;	AH = 0Ch
;	AL = pixel color, if bit 7 set, pixel is XOR'ed onto screen
;	CX = column
;	DX = row
; Output:
;	none
;-------------------------------------------------------------------------
int_10_fn0C:	; graphics mode not available
	ret

;=========================================================================
; int_10_fn0D - Read graphics pixel
; Input:
;	AH = 0Dh
;	CX = column
;	DX = row
; Output:
;	AL = pixel color 
;-------------------------------------------------------------------------
int_10_fn0D:	; graphics mode not available
	ret

;=========================================================================
; int_10_fn0E - Teletype output
; Input:
;	AH = 0Eh
;	AL = character to write
;	BL = foreground color (graphics modes only)
; Output:
;	none
; Notes:
;	- writes character to the active video page
;	- support following control characters: BEL, BS, LF, CR
;-------------------------------------------------------------------------
int_10_fn0E:
	mov	bl,byte ptr ds:[video_page]	; BL = active video page
	mov	bh,0
	shl	bl,1			; word index
	mov	dx,word ptr ds:[bx+video_cur_pos] ; DX = cursor position

	mov	al,byte ptr [bp+int_10_al]	; AL = character to write
	cmp	al,bs
	jz	bspace			; jump if backspace (BS)
	cmp	al,lf
	jz	lfeed			; jump if line feed (LF)
	cmp	al,bel
	jz	bels			; jump if beep (BEL)
	cmp	al,cr
	jz	cret			; jump if carriage return (CR)
	mov	bl,byte ptr [bp+int_10_bl]; BL = attribute for graphics mode
	mov	bh,byte ptr ds:[video_page] ;BH=current page number
	mov	ah,0Ah			; INT 10h, function 0Ah - write char
	mov	cx,1			; one character
	int	10h			; write character
	inc	dl			; move cursor to the next column
	cmp	dl,byte ptr ds:[video_columns]; compare pos to number of col
	jnz	set_cursor_pos		; jump if not past the last column
	mov	dl,0			; move to the first position

lfeed:
	cmp	dh,byte ptr ds:[video_rows]	; on the last row?
	jz	scroll			; jump if on the last row - scroll
	inc	dh			; move cursor to the next row
	jnz	set_cursor_pos		; set new cursor position

bspace:
	cmp	dl,0			; on the first column?
	jz	set_cursor_pos		; jump if yes - nothing to do
	dec	dl			; move cursor to the previous position
	jmp	set_cursor_pos		; set new cursor position

cret:
	mov	dl,0			; set cursor to the first column

set_cursor_pos:
	mov	bl,byte ptr ds:[video_page]	; BL = active video page
	mov	cx,dx
	jmp	set_cur_pos		; set new cursor position

bels:
	mov	bl,2			; 0.2 second beep
	call	beep
	ret

scroll:
	mov	ah,02h
	mov	bh,byte ptr ds:[video_page]
	int	10h			; set new cursor position
	
	mov	bh,07h
	mov	ah,06h			; INT 10h, function 06h - Scroll up
	mov	al,1			; scroll one line
	xor	cx,cx			; top right corner is 0,0
	mov	dh,byte ptr ds:[video_rows]	; bottom row
	mov	dl,byte ptr ds:[video_columns] ;right column is the last
	dec	dl
	int	10h			; scroll page up
	ret

;=========================================================================
; int_10_fn0F - Get current video mode
; Input:
;	AH = 0Fh
; Output:
;	AL = video mode
;	AH = characters per column
;	BH = active video page
;-------------------------------------------------------------------------
int_10_fn0F:
	mov	al,byte ptr ds:[video_columns]
	mov	[bp+int_10_ah],al
	mov	al,byte ptr ds:[video_mode]
	mov	[bp+int_10_al],al
	mov	al,byte ptr ds:[video_page]
	mov	[bp+int_10_bh],al
	ret

;=========================================================================
; int_10_fn10 Set/Get Palette registers
;-------------------------------------------------------------------------
int_10_fn10:	;Unsupported in this hardware
	
	ret
;=========================================================================
; int_10_fn11 Character generator control
;	AL = 00h - user charset load
;	AL = 01h - 8x14 ROM BIOS set load
;	AL = 02h - 8x8 ROM BIOS set load
;	AL = 03h - set displayed definition table
;	AL = 04h - 8x16 ROM BIOS set load
;	AL = 10h - user charset + display reset
;	AL = 11h - ROM BIOS 8x14 + display reset
;	AL = 12h - ROM BIOS 8x8 + dosplay reset
;	AL = 14h - ROM BIOS 8x16 + disp reset
;	AL = 20h - pointer to graphics character table for INT 1FH
;	AL = 21h - user graphics character pointer for INT 43
;	AL = 22h - ROM 8x14 for INT 43h
;	AL = 23h - ROM 8x8 for INT 43h
;	AL = 24h - ROM 8x16 for INT 43H
;	AL = 30h - get current character generator info
;-------------------------------------------------------------------------
int_10_fn11:

		cmp	al,30h
		je	fn11_get_info
		cmp	al,14h
		mov	si,offset mode_80x25
		je	fn11_set_mode
		cmp	al,12h
		mov	si,offset mode_80x50
		je	fn11_set_mode
		cmp	al,11h
		mov	si,offset mode_80x25
		je	fn11_set_mode
		ret
		

fn11_set_mode:	
		mov	ax,ds
		mov	es,ax
		mov	ax,0c000h
		mov	ds,ax
		jmp	set_vmode

fn11_get_info:	
		mov	ax,word ptr ds:[video_char_scl]
		mov	word ptr [bp+int_10_cx],ax
		mov	al,byte ptr ds:[video_rows]
		mov	byte ptr [bp+int_10_dl],al
fn11_exit:		ret

;=========================================================================
; int_10_fn12 - Video Subsystem configuration
;			BL = 10h - return video config info
;			BL = 20h - set alternate print screen routine
;			BL = 30h - selet scan lines for alphanumeric modes
;			BL = 31h - select default palette loading
;			BL = 32h - CPU access to VRAM
;			BL = 33h - Grayscale summing
;			BL = 34h - Cursor emulation
;			BL = 35h - video display switching
;			BL = 36h - video refresh control

;-------------------------------------------------------------------------
int_10_fn12:
		mov	al,byte ptr[bp+int_10_bl]
		cmp	al,10h
		jnz	fn12_exit
		mov	ax,0003h	; color 256k video system
		mov	word ptr[bp+int_10_bx],ax
		mov	ax,0009h	; some dip switches
		mov	word ptr[bp+int_10_cx],ax
fn12_exit:	ret
;=========================================================================
; int_10_fn13
;-------------------------------------------------------------------------
int_10_fn13:
	
	ret
;=========================================================================
; int_10_fn1a - Get display combination code
; Input:
;	AL = 00h
; Output:
;	AL = 1Ah (function supported)
;	BL = active display code
;	BH = alternate display code
;-------------------------------------------------------------------------
int_10_fn1a:
	mov	al,byte ptr[bp+int_10_al]
	test	al,al				; al = 00 ?
	jnz	fn1a_exit

;	mov 	al, byte ptr ds:[video_vga_fl1]
;	test	al,00100000b			; test 5 bit (first run)
;	jnz	fn1a_normal_run			; if 5 bit set = not first run
;	or	al, 00100000b			; first run, set 5 bit = 1
;	mov 	byte ptr ds:[video_vga_fl1],al
;	jmp	fn1a_exit
;fn1a_normal_run:
	mov	al,1ah
	mov	byte ptr [bp+int_10_al],al	; return position in DX
	mov 	ax,8	; VGA w/ color display
	mov	word ptr [bp+int_10_bx],ax	; return cursor shape in CX
fn1a_exit:
	ret
;=========================================================================

; int10h exit for non supported functions
;-------------------------------------------------------------------------
int_10_exit:
	ret
;=========================================================================
;Subroutine section
;=========================================================================
; vid_current_offset - convert current cursor position to offset
;		       relative to page starting address
; Input:
;	BL = page
; Output:
;	AX = offset
;-------------------------------------------------------------------------
vid_current_offset:
	mov	bh,0
	shl	bx,1				; word index
	mov	ax,word ptr ds:[bx+video_cur_pos];AX = current cursor position

; fall through to vid_position_to_offset

;=========================================================================
; vid_position_to_offset - convert position (row and column) to offset
;			   relative to page starting address
; Input:
;	AH = row
;	AL = column
; Output:
;	AX = offset
;-------------------------------------------------------------------------
vid_position_to_offset:
	push	bx
	mov	bl,al			; BL = column
	mov	al,ah			; AL = row
	mul	byte ptr ds:[video_columns] ; AX = row * video_columns
	mov	bh,0			;
	add	ax,bx			; AX = row * video_columns + column
	shl	ax,1			; multiply by two (char + attribute)
	pop	bx
	ret
;====================================================================
;DMA run subroutine. Cold start i8257 DMAC
;IN:ES=Bios DTA SEG, DS:SI = counter value; OUT:None
;--------------------------------------------------------------------
run_DMA		proc	near
		mov	dx,es:[video_port]
		add	dx,vt57_cmd
		mov	al,80h		;Set autoload flag to programming
		cli			;Disable interrupts
		out	dx,al		;chanels 2,3 at the same time
	jmp $+2

		mov	dx,es:[video_port]
		add	dx,vt57_ch2_adr
		mov	al,0
		out	dx,al		;set starting adress
	jmp $+2
		out	dx,al
	jmp $+2
		inc	dx
		lodsb
		out	dx,al
	jmp $+2
		lodsb
		out	dx,al
	jmp $+2
		mov	dx,es:[video_port]
		add	dx,vt57_cmd	;enable ch2 service
		mov	al,84h
		out	dx,al
	jmp $+2
		sti			;Enable interrupts
		ret
run_DMA	endp

;====================================================================
;Wait time using display frame frequency
;IN: CX=number of frames to waiting 1frame=1/70sec
;OUT: none
;_-------------------------------------------------------------------
wait_time	proc	near
		push	ax
		push	dx
		mov	dx,ds:[video_port]
		add	dx,vg75_cmd	; status registr
wait_time1:	in	al,dx
		test	al,00100000b	; Checkin end of current frame
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		jz	wait_time1
	loop	wait_time1	;Checking until CX number frame ends
		pop	dx
		pop	ax
		ret
wait_time	endp

;=========================================================================
; Generate short (about 0.2s) sound signal. IN:no,OUT:no
;-------------------------------------------------------------------------
beep	proc	near
		push	ax
		push	cx
		mov	al,0b6h
		out	timer_cmd,al	; Set timer ch2 to mode 3
		mov	ax,1900		; ~800Hz
		out	timer_ch2,al	; Set ch2 frequency divider
		mov	al,ah
		out	timer_ch2,al
		in	al,port_b_reg	; read system portB value
		or	al,03h		; turn on speaker
		out	port_b_reg,al
		mov	cx,14
		call	wait_time	; 0.2 sec delay
		xor	al,03h
		out	port_b_reg,al	; turn off speaker
		pop	cx
		pop	ax
		ret
beep	endp
;-------------------------------------------------------------------------
; Video Bios Data Area
;-------------------------------------------------------------------------
; Mode setting tables
; 1,2,3,4 - Reset CRTC command bytes VG75
; DMA_Hi, DMA_Lo, Start display VG75, DMA_Hi, DMA_Lo
; Charset, rows
; Charset_size, Video_page_Size, Cursor_Shape

mode_80x25:
		db	79,10011000b,0fh,00001001b
		db	09fh,08fh,00100101b,09fh,08fh
		db	0,24
		dw	16,1000h,0e0fh
mode_80x50:
		db	79,11110001b,07h,00001001b
		db	03fh,09fh,00100011b,03fh,09fh
		db	2,49
		dw	08,2040h,0607h
mode_80x30:
		db	79,10011101b,0fh,00001001b
		db	0bfh,092h,00100101b,0bfh,092h
		db	1,29
		dw	16,2000h,0e0fh
mode_80x60:
		db	79,11111011b,07h,00001001b
		db	07fh,0a5h,00100011b,07fh,0a5h
		db	2,59
		dw	08,2800h,0607h
mode_80x43:
		db	79,11101010b,0ah,00001001b
		db	0dfh,09ah,00100111b,0dfh,09ah
		db	2,42
		dw	10,2000h,090ah

;-------------------------------------------------------------------
; VBIOS Mesages
;-------------------------------------------------------------------
welcome_msg	db	'VGA Bios v0.3.1'

		db	cr,lf,'(c) Freddy 2021',cr,lf,'Tronix mod 2022',0

;========================================================================
	DB	'27/02/22',0		; RELEASE MARKER

bios_lenth = $-start
bios_body:	db	(bios_size*512)-bios_lenth-1 dup (0FFh)
end start