;Chip type                : ATmega8
;Program type             : Application
;Clock frequency          : 17.730000 MHz

.include "m8def.inc"


.def	temp 	=r16
.def	delay	=r17
.def	burst	=r18
.def	zero	=r19
.def	Ph1		=r21
.def	Ph2		=r22
.def	Ph3		=r23
.def	Ph4		=r24
.def	BlLv	=r25


;.ORG 0x00		
rjmp	reset
rjmp	SyncInt		
reti
reti
rjmp	start
reti
reti
reti
reti
reti
reti
reti
reti
reti
reti
reti
reti
reti
reti		
rjmp	cycle
;rjmp	cycle
;rjmp	cycle
;rjmp	cycle
;rjmp	cycle
;rjmp	cycle
;rjmp	cycle
;rjmp	cycle
;rjmp	cycle
;rjmp	cycle
;rjmp	cycle
;rjmp	cycle
;rjmp	cycle
;rjmp	cycle
;rjmp	cycle
;rjmp	cycle
;rjmp	cycle
;rjmp	cycle		
		

reset:	ldi	temp,	LOW(RAMEND)	;Init Stack Pointer
		out	SPL,	temp	
		ldi temp,	HIGH(RAMEND)
		out SPH,	temp
		ldi temp,	0b11111111        ;set port C bits to outputs
		out DDRC,	temp
		ldi temp,	0b11100000	;set port D bits 7-5out, 4-0 In
		out	DDRD,	temp
		ldi temp,	0x04	;PD2 Pullup
		out PORTD,	temp

		;External Interrupt initialization
		;INT0: On
		;INT0 Mode: Rising Edge - 0x03 (falling - 0x02)
		;INT1: Off
		;GICR|=0x40;
		IN   temp,	GICR
		ORI  temp,	0x40
		OUT  GICR,	temp
		;MCUCR=0x03;
		LDI  temp,	0x02
		OUT  MCUCR,	temp
		;GIFR=0x40;
		LDI  temp,	0x40
		OUT  GIFR,	temp
	
		;Timer/Counter 2 initialization
		;Clock source: System Clock
		;Clock value: 17734,475 kHz
		;Mode: CTC top=OCR2
		;OC2 output: Disconnected
		;ASSR=0x00;
		LDI  temp,	0x00
		OUT  ASSR,	temp
		;TCCR2=0x09;
		LDI  temp,	0x09
		OUT  TCCR2,	temp
		;TCNT2=0x00;
		LDI  temp,	0x00
		OUT  TCNT2,	temp
		;OCR2=0x03;
		LDI  temp,	0x03
		OUT  OCR2,	temp
	
		;Timer(s)/Counter(s) Interrupt(s) initialization
		;TIMSK=0x40 (OFF - 0x00);
		LDI  temp,	0x00
		OUT  TIMSK,	temp
					
		clr	zero		
		ldi BlLv,	0b10000100
		
		sei
		
		rjmp cycle

SyncInt:
;clr temp
;out gicr, temp
;ldi temp, 0xff
;out gifr, temp

		ldi delay,	16		;delay after start synchro
again1:	dec		delay
		nop
		brne	again1

		in		temp,	TCNT2	;synchronization at timer
		sbrc	burst,	0	;+90 even line
		inc		temp
		andi	temp,	0b00000011	;select phase  
		cpi 	temp,	0b00000000
		breq	PH_0
		cpi 	temp,	0b00000001
		breq	PH_90
		cpi 	temp,	0b00000010
		breq	PH_180
		cpi 	temp,	0b00000011
		breq	PH_270
		
PH_0:	ldi	Ph1, 0b11000100
		ldi Ph2, 0b10000100	
		ldi Ph3, 0b00000100	
		ldi Ph4, 0b10000100	
		nop
		nop
		nop
		nop
		rjmp	start		

PH_90:	ldi Ph1, 0b10000100	;6
		ldi Ph2, 0b00000100
		ldi Ph3, 0b10000100
		ldi Ph4, 0b11000100
		nop
		nop
		rjmp	start		

PH_180:	ldi Ph1, 0b00000100	;8
		ldi Ph2, 0b10000100
		ldi Ph3, 0b11000100
		ldi Ph4, 0b10000100
		rjmp	start	

PH_270:	ldi Ph1, 0b10000100	;10
		ldi Ph2, 0b11000100
		ldi Ph3, 0b10000100
		ldi Ph4, 0b00000100	

		
start:	out	PORTd,	Ph1	;start burst
		out	PORTd,	Ph2
		out	PORTd,	Ph3
		out	PORTd,	Ph4

		out	PORTd,	Ph1
		out	PORTd,	Ph2
		out	PORTd,	Ph3
		out	PORTd,	Ph4

		out	PORTd,	Ph1
		out	PORTd,	Ph2
		out	PORTd,	Ph3
		out	PORTd,	Ph4

		out	PORTd,	Ph1
		out	PORTd,	Ph2
		out	PORTd,	Ph3
		out	PORTd,	Ph4

		out	PORTd,	Ph1
		out	PORTd,	Ph2
		out	PORTd,	Ph3
		out	PORTd,	Ph4

		out	PORTd,	Ph1
		out	PORTd,	Ph2
		out	PORTd,	Ph3
		out	PORTd,	Ph4

		out	PORTd,	Ph1
		out	PORTd,	Ph2
		out	PORTd,	Ph3
		out	PORTd,	Ph4

		out	PORTd,	Ph1
		out	PORTd,	Ph2
		out	PORTd,	Ph3
		out	PORTd,	Ph4

		out	PORTd,	Ph1
		out	PORTd,	Ph2
		out	PORTd,	Ph3
		out	PORTd,	Ph4

		out	PORTd,	Ph1
		out	PORTd,	Ph2
		out	PORTd,	Ph3
		out	PORTd,	Ph4

		out PORTD,	BlLv ;black level
		nop

		;dec		temp
		andi	temp,	0b00000011	;compensate phase error
		cpi		temp,	0x03
		breq	selph1
		cpi		temp,	0x02
		breq	selph2
		cpi		temp,	0x01
		breq	selph3
		rjmp	selph3
selph1:	nop
selph2:	nop			
selph3:	sbrc burst,	0	;even line
		ldi Ph1,	0b00101010
		sbrc burst,	0
		ldi	Ph2,	0b00100110
		sbrc burst,	0
		ldi Ph3,	0b00000111
		sbrc burst,	0
		ldi Ph4,	0b00110100

		sbrs burst,	0	;odd line
		ldi Ph1,	0b00101010 
		sbrs burst,	0
		ldi Ph2,	0b00110100
		sbrs burst,	0
		ldi	Ph3,	0b00000111
		sbrs burst,	0
		ldi Ph4,	0b00100110


		inc burst

		;delay xx cycles 				
		ldi		delay,13
again:	dec		delay
		nop
		brne	again

		out PORTC,	Ph1	;start color carrier
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4		;10
		
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4		;20

		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4		;30

		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4		;40
;nop
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4		;50


		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4		;60

		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4		;70

		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4		;80
;nop
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4		;90

		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4		;100

		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4		;110

		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4		;120
;nop
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4		;130

		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4		;140

		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4		;150

		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4		;160

		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4		;170

		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4		;180

		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4		;190

		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4		;200

		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4		;210

		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4		;220
/*
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4
		out PORTC,	Ph1
		out	PORTC,	Ph2
		out PORTC,	Ph3
		out	PORTC,	Ph4		;230
*/

		out PORTC, Zero

;in temp, gicr
;ORI  temp,0x40
;out gicr, temp
		
		reti




cycle:	nop		;waiting int
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop

		rjmp cycle




		
		

		
		

			
