;
;  LCD 1602/16166  
; 設 8 
;  -06
;
;                                         04.2022
;--------------------------------------------------
; 祭 LCD
; ᮮ⢥⢨ ⮢ ࠧ   ᨣ ᯫ:
; 0 - RS
; C1 - R/-W
; C2 - E
;
; A0...A7 - 室  0...7 
; B0...B7 - 室  0...7 
;--------------------------------------------------
;
RS0	.equ	$00
RS1	.equ	$01
WrLcd	.equ	$02
RdLcd	.equ	$03
E0	.equ	$04
E1	.equ	$05
;
RUSPU	.equ	$04	;    ࠢ ஡
RDPU	.equ	$06	;    室
WRPU	.equ	$07	;    室
;
Set_SP	.EQU	0DFFFH		; 誠 ⥪
;
BufSkanKey	.EQU	0DEF0H	;   ᪠  - 8  + ਧ 
PressKey	.EQU	0DEF8H	; ਧ   (᪠)
KOD_KEY		.EQU	0DEF9H	;  ⮩ 
KEY_Sys		.EQU	0DEFAH	; ᪠ ﭨ  ,,
;
; 稪 室 ஫ 祪 ணࠬ - ⮡ࠦ  ࠭
ErrKey1		.EQU	0DEFBH	; 稪 訡   -    
ErrKey2		.EQU	0DEFCH	; ⠩  稪 ᥪ㭤
IntCount	.EQU	0DEFFH	; 稪 뢠
;-------------------------------------------------------------------------------
;
;
;=============================================================================
; 砫 ணࠬ
;
	.ORG	0100h
;
;   ᪥
StBoot:	DI
	XRA	A
	OUT	10H		; ⪫. 
;
	MVI	A,$8A	; A - 室, B - 室, 0-3 - 室, 4-7 - 室
	OUT	$04

	MVI	A,07H		;  "/LAT"
	OUT	00
;
	MVI	A,0C3H
	STA	0000H		;  १᪠
	STA	0038H		;  뢠
	LXI	H,StBoot	;  १᪠
	SHLD	0001H
	LXI	H,StInt		;  뢠
	SHLD	0039H
;
;--------------------------------
; ⪠  ࠭ C000...DFFF  B=F800
;
	LXI	SP,0E000H	; ⠭  ⥪ -  ࠭ 
	XRA	A
	LXI     B,0F800H	; 稪 ⢠ "࠭ HL  ⥪"
	LXI	H,0000H
CLR_S1:	PUSH	H		; ⪠ 
	PUSH	H		; ⪠ 
	INX	B		;   ᫨  墠⠥ ᮢ
	CMP	B	 	;  ,  ᪮ ⪨
	JNZ	CLR_S1
;
;===================================================
;--------------------------------
	LXI	SP,Set_SP	; ⠭  ⥪
;--------------------------------
;
	EI		; ࠧ 뢠
	HLT		;  뢠
	CALL	SColor	; ணࠬ஢ 
	DI		;  뢠
;
;  稪  䫠
	XRA	A
	STA	COUNTR	;  稪 뢠
	STA	KOD_KEY	;   ⮩ 
;
;------------------------------------------------------------------------------
; 稭   LCD
;
StartLCD:
	call	LCD_Init	;  LCD ᯫ
;
	call	TextLCD		; 뢮 ⮢ ⥪
;
	JMP	White_Key_Tim	; 室  ᭮ 横 
;
;********** ᭮  LCD **************
;
TextLCD:
	mvi	a,$00	; ३  砫 1 ப
	call	LCD_GotoXY

	mvi	a,'T'
	call   LCD_WD    ;    ᯫ
	mvi	a,'e'
	call   LCD_WD    ;    ᯫ
	mvi	a,'s'
	call   LCD_WD    ;    ᯫ
	mvi	a,'t'
	call   LCD_WD    ;    ᯫ
	mvi	a,' '
	call   LCD_WD    ;    ᯫ
	mvi	a,'V'
	call   LCD_WD    ;    ᯫ
	mvi	a,'e'
	call   LCD_WD    ;    ᯫ
	mvi	a,'c'
	call   LCD_WD    ;    ᯫ

	mvi	a,$01	; ३  2 ப
	call	LCD_GotoXY

	mvi	a,'t'
	call   LCD_WD    ;    ᯫ
	mvi	a,'o'
	call   LCD_WD    ;    ᯫ
	mvi	a,'r'
	call   LCD_WD    ;    ᯫ
	mvi	a,'-'
	call   LCD_WD    ;    ᯫ
	mvi	a,'0'
	call   LCD_WD    ;    ᯫ
	mvi	a,'6'
	call   LCD_WD    ;    ᯫ
	mvi	a,'C'
	call   LCD_WD    ;    ᯫ
	mvi	a,'.'
	call   LCD_WD    ;    ᯫ
;
	ret
;
;==========================================================
; ᭮ 横     㫥 ⠩
;
White_Key_Tim:
	EI
	HLT
	DI
	CALL	GET_KEY	 ;    ᫨  
	CPI	0Bh	; F1
	CZ	PRESS_F1	; ⨥ F1
	CPI	0Ch	; F2
	CZ	PRESS_F2	; ⨥ F2
	CPI	0Dh	; F3
	CZ	PRESS_F3	; ⨥ F3
;
	LDA	COUNTR	; 稪 뢠  0  50
;=======================
	STA	ErrKey2
;=======================
	CPI	50
	JC	White_Key_Tim	;   ⠫ ᥪ㭤
	XRA	A
	STA	COUNTR	 ;  稪 뢠
;
	JMP	White_Key_Tim
;
;=======================================================================
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;*=============
PRESS_F1:
	PUSH	PSW	; ࠭  ⮩ 
	call	TextLCD
	POP	PSW	;   ⮩ 
	RET		;  - 室    ⥪
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;==============
PRESS_F2:
	call	LCD_Clr     ; ⪠ ࠭
	RET		;  - 室    ⥪
;
;=== F3 - =====================
PRESS_F3:
	PUSH	PSW	; ࠭  ⮩ 

	mvi	a,$20	; ३  XY
	call	LCD_GotoXY
	mvi	a,'2'
	call   LCD_WD    ;    ᯫ
	mvi	a,'0'
	call   LCD_WD    ;    ᯫ

	mvi	a,$31	; ३  XY
	call	LCD_GotoXY
	mvi	a,'3'
	call   LCD_WD    ;    ᯫ
	mvi	a,'1'
	call   LCD_WD    ;    ᯫ

	POP	PSW	;   ⮩ 
	ret
;
;-----------------------------------------------------------
;== 稫 ࠡ⪠ ⨩  ======================================
;
;	
;=============================================
;*-- ணࠬ  ----------------------
;
PAUSE5:	PUSH	B
	PUSH	PSW
	MVI	B,003H	;   5
	JMP	PAUSEB
PAUSE1:	PUSH	B
	PUSH	PSW
	MVI	B,080H
PAUSEB:	MVI	C,0FFH
PAUSEC:	DCR	C
	JNZ	PAUSEC
	DCR	B
	JNZ	PAUSEB
	POP	PSW
	POP	B
	RET
;
;*=== ஢ઠ   ==================================
;  室    (0...63)   FFh
; 室 -   KOD_KEY  (0...63) ⮩ , ᫨ 뫠 
;
GET_KEY:
	LDA	PressKey	;  ਧ 
	CPI	0FFH	 ; ஢ ਧ   FF -  ⨩
	JZ	GET_K_ERR	; 室 -     
;-----------------------
	LXI	H,BufSkanKey	;   ᪠- 
;-----------------------
	LXI	B,0800H	 ; 稪 ஢塞 冷   鸞
GET_K1:	MOV	A,M	;    ﭨ 鸞 
	INX	H
	CPI	0FFH	; ஢ਬ  ⢨    ⮬ 
	JNZ	GET_K2	 ;  ⨥   
	INR	C	; 室  ᫥饬 
	DCR	B	 ; 稪 冷 
	JNZ	GET_K1	;   冷 
;===========
	LDA	ErrKey1	; ⪠  䫠 ﭨ ணࠬ
	INR	A
	STA	ErrKey1	; ⪠  䫠 ﭨ ணࠬ
;===========
	JMP	GET_K_ERR	;    
;
GET_K2:	MOV	D,A	; ࠭ ﭨ 鸞 
	MOV	A,C	 ;  鸞  ⮩ 襩
	RLC		;\ 
	RLC		;  ८ࠧ  鸞
	RLC		;/
	MOV	C,A	; ࠭  鸞
	MVI	B,01H	 ; ᪠  ᪠ ⮩ 
GET_K3:	MOV	A,D	; ﭨ 鸞 
	ANA	B	 ; 뤥 ᪮
	JZ	GET_K4	;   
	INR	C	 ; 塞  ⮩ 
	MOV	A,B	; ᪠
	RLC		; ४ ᪨
	MOV	B,A	; ࠭  
	JNC	GET_K3	;     ஢७
GET_K_ERR:
	MVI	A,0FFH
	RET	;    
;
GET_K4:
	CALL	PAUSE1	 ; 㧠
;
	MOV	A,C	;    0...63
	STA	KOD_KEY	; ࠭  ⮩ 
;
	RET	; 室 - 祭  ⮩ 
;	
;==============================================================================
;  梥⮢
MColor:	.DB	2DH,2DH,80H,80H,2DH,2DH,80H,80H,2DH,2DH,80H,80H,2DH,2DH,80H,80H
; 孮᪠    ⥭
;MColor:	.DB	40H,40H,40H,40H,80H,80H,2dH,2dH,40H,40H,40H,40H,80H,80H,2dH,2dH
;
COUNTR:		.DB	0	; 稪 뢠
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;=====================================
;*----------- 뢠 --------------
;  稪 ⢠ 뢠  ࠡ 
;  訢 
;
StInt:	PUSH	PSW
	PUSH	B
	PUSH	H
	LDA	COUNTR	 ;
	INR	A	 ; 稪 뢠
	STA	COUNTR	 ;
;===========
	LDA	IntCount	; ⪠  䫠 ﭨ ணࠬ
	INR	A
	STA	IntCount	; ⪠  䫠 ﭨ ணࠬ
;===========
	CALL	READ_KEY	;  
	POP	H
	POP	B
	POP	PSW
	EI
	RET
;
;*==== ⥭  ======
; :     BufSkanKey 뢠 ﭨ 冷 
;        ᫥ 9-   ANA ᪠  冷 - ਧ   
;
READ_KEY:
	MVI	A,8AH	; -室, -室, 0_3-室, 4_7-室
	OUT	00H
;-----------------------
	LXI	H,BufSkanKey	;   ᪠- 
;-----------------------
	LXI	B,0FEFFH	; ᪠   
	MOV	A,B
READ_K0:
	OUT	03H	; 뢮 ᪨ 
	IN	02H	 ; ⥭  
	MOV	M,A	; ࠭ ﭨ  
	ANA	C	 ;   冷  । 
	MOV	C,A	 ; ࠭ ਧ  
	INX	H	; ᫥.   
	MOV	A,B	 ; ᪠ 
	RLC		; ४  
	MOV	B,A	 ; ࠭  
	CPI	0FEH	; ࠧ ᪨ ᫥   冷
	JNZ	READ_K0	;  襭   
;
	IN	01H
	ANI	0E0H
	STA	KEY_Sys	; ࠭ ﭨ  , , /LAT
;
	MVI	A,88H	; -室, -室, 0_3-室, 4_7-室
	OUT	00H
	XRA	A
	OUT	02H
	DCR	A
	OUT	03H
;
	MOV	A,C	; ⠭ ਧ  
	MOV	M,A	; ࠭ ਧ  
	RET
;
;---------------------------------------------------
;*--- ணࠬ஢  ---
SColor:	PUSH	PSW
	PUSH	B
	PUSH	H
	LXI	H,MColor	;   梥⮢
	MVI	B,0FH
SCol1:	MOV	A,B
	OUT	02
	MOV	A,M
	OUT	0CH		;
	INR	C
	OUT	0CH		;
	INX	H
	OUT	0CH		;
	DCR	C
	DCR	B
	OUT	0CH		;
	JP	SCol1
	MVI	A,88H
	OUT	00
	XRA	A
	OUT	02
	DCR	A
	OUT	03
	POP	H
	POP	B
	POP	PSW
	RET
;
;-------------------------------------------------------------------------------
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;============== ணࠬ  LCD ================
;
; 樠 ᯫ
LCD_Init:
	mvi	a,RS0    ;  㬮砭 - 
	out	RUSPU
	mvi	a,WrLcd    ;  㬮砭 -  
	out	RUSPU
	mvi	a,E0    ;  㬮砭 - ஡ = 0
	out	RUSPU
;
	mvi	a,$30	; 設 8-, 1 ப,  5*8
	out	WRPU
	mvi	a,E1    ; ஡ ᯫ
	out	RUSPU
	mvi	a,E0    ; ஡ ᯫ
	out	RUSPU
;
	call	PAUSE5	; 㧠 ~ 5
;
	mvi	a,$30	; 設 8-, 1 ப,  5*8
	out	WRPU
	mvi	a,E1    ; ஡ ᯫ
	out	RUSPU
	mvi	a,E0    ; ஡ ᯫ
	out	RUSPU
;
	mvi	a,$38	; 設 8-, 2 ப,  5*8
	call	LCD_WK     ;   ᯫ 
;
	call	PAUSE5	; 㧠 ~ 5
; ன ᯫ
	mvi	a,$38	; 設 8-, 2 ப,  5*8
	call	LCD_WK     ;   ᯫ 
	mvi	a,$0c	; ᯫ .,  몫.
	call	LCD_WK     ;   ᯫ 
	mvi	a,$06	; ࠭  ᤢ, 稪 樨 㢥稢
	call	LCD_WK     ;   ᯫ 
	mvi	a,$01	; ⪠ ࠭
	call	LCD_WK     ;   ᯫ 
	ret		; 室  樠樨 ᯫ
;
;---------------------------------------
; ⥭ 䫠 ⮢.	
; ᫨ ᯫ  ⢥砥 - 横  
LCD_Busy:
	push	psw	; ࠭ 
	mvi	a,$FF	; ⪫ 設
	out	WRPU
	mvi	a,RdLcd	;  ⥭ ॣ ᯫ
	out	RUSPU
LCD_Busy81:
	mvi	a,E1    ; ஡ ᯫ
	out	RUSPU
	in	RDPU	;  
	rlc		 ; 뤥 䫠  ᯫ
	mvi	a,E0    ; ஡ ᯫ
	out	RUSPU
	jc	LCD_Busy81	; ᫨ ᯫ 
	mvi	a,WrLcd	;    ᯫ
	out	RUSPU
	pop	psw	; ⠭ 
	ret
;
;-------------------------------------------
; ⪠ ࠭ ᯫ
LCD_Clr:
	push	psw	; ࠭ 
	mvi	a,$01	; ⪠ ࠭
	call	LCD_WK     ;   ᯫ 
	pop	psw	;
	ret		; 室  樠樨 ᯫ
;
;-------------------------------------------
; ⪠ ࠭ ᯫ. 室  -  ଠ XYh
LCD_GotoXY:
	push	b	; ࠭ 
	mov	b,a
	rlc
	rlc
	rlc
	rlc
	ani	$0f	; 뤥 X
	mov	c,a	; ࠭ X
	mov	a,b	; XY
	ani	$0f	; 뤥 Y
	mov	a,c	; ᯮ X
	jnz	LCD_GotoY2	; ᫨  ப +0
	adi	$C0	; ᫨   ᯫ A+C0+C0=A+80
LCD_GotoY2:
	adi	$C0	; ᫨   ᯫ
	call	LCD_WK     ;   ᯫ 
	pop	b	; ⠭ 
	ret		; 室  樠樨 ᯫ
;
;=========================================================
;    ᯫ 
LCD_WK:	call	LCD_Busy	;  ⮢ ᯫ
;
	out	WRPU	; 뢮   
	mvi	a,RS0    ;   
	out	RUSPU
	mvi	a,E1    ; ஡ ᯫ
	out	RUSPU
	mvi	a,E0    ; ஡ ᯫ
	out	RUSPU
;
	mvi	a,$ff	; ⪫祭 設
	out	WRPU
	ret
;
;    ᯫ
LCD_WD:	call	LCD_Busy	;  ⮢ ᯫ
;
	out	WRPU	; 뢮   
	mvi	a,RS1    ;   
	out	RUSPU
	mvi	a,E1    ; ஡ ᯫ
	out	RUSPU
	mvi	a,E0    ; ஡ ᯫ
	out	RUSPU
;
	mvi	a,$ff	; ⪫祭 設
	out	WRPU
	mvi	a,RS0    ;   
	out	RUSPU
	ret
;
;-------------------------------------------------------------------------------
	.END
