crctab	.equ 0DE00h		;512 bytes (256-bytes aligned)

		.org 100h

start:
		di
		xra	a
		out	10h
		mvi	a, 0C3h		;jmp
		sta	0
		lxi	h, start
		shld	1
		mvi	a, 0C9h		;ret
		sta	38h

		lxi	sp, 100h

		ei
		hlt
		lxi	h, colors+15
		call	colorset

		call	cls

		call gentabcrc16
		lxi b,9		;length of data
		lxi h,data	;start adress of data
		call crc16
		xchg
		lxi d,0E0F8h
		mov a,h
		call print
		mov a,l
		call print
		jmp $

;Input:
;HL - start adress of data
;BC - data size
;Output:
;DE - CRC16
crc16:
		mvi e,0FFh
		mov a,e
		dcx b
		inr c
		inr b
crc16loop:
		xra m
		push h
		mov l,a
		mvi h,(crctab>>8)
		mov a,m
		xra e
		inr h
		mov e,m
		pop h
		inx h
		dcr c
		jnz crc16loop
		dcr b
		jnz crc16loop
		mov d,a
		ret
	

gentabcrc16:
		lxi d,crctab
gentabcrc16_1:
		mvi l,0
		mov h,e
		mvi b,8
gentabcrc16_2:
		dad h
		jnc gentabcrc16_3
		mvi a,21h
		xra l
		mov l,a
		mvi a,10h
		xra h
		mov h,a
gentabcrc16_3:
		dcr b
		jnz gentabcrc16_2
		xchg
		mov m,d
		inr h
		mov m,e
		xchg
		dcr d
		inr e
		jnz gentabcrc16_1
		ret

print:
		push psw
		rrc
		rrc
		rrc
		rrc
		call	printnum
		pop psw
		inr d
		call	printnum
		inr d
		ret

printnum:
		push d
		push h
		ani	00001111b
		add	a
		add	a
		add	a
		lxi	h, FONT
		add	l
		mov	l,a
		mvi	a,0
		adc	h
		mov	h,a
		mvi	b,8
prnumloop:
		mov	a,m
		stax	d
		inx	h
		inx	d
		dcr	b
		jnz	prnumloop
		pop	h
		pop d
		ret


cls:
		xra	a
		lxi	h, 0E000h
cls1:		mov	m,a
		inx	h
		cmp	h
		jnz	cls1
		ret

colorset:
		mvi	a, 88h
		out	0
		mvi	c, 15
colorset1:	mov	a, c
		out	2
		mov	a, m
		out	0Ch
		dcx	h
		out	0Ch
		out	0Ch
		dcr	c
		out	0Ch
		out	0Ch
		jp	colorset1
		mvi	a,255
		out	3
		ret

#define col 173

colors:
		.db 0,col,0,col,0,col,0,col,0,col,0,col,0,col,0,col
data:
		.db "123456789"

FONT:
	.DB 00,3Ch,66h,66h,66h,66h,3Ch,00
	.DB 00,3Ch,18h,18h,18h,78h,38h,00
	.DB 00,7Eh,30h,18h,0Ch,6Ch,38h,00
	.DB 00,3Ch,66h,06h,1Ch,06h,7Eh,00
	.DB 00,06h,06h,06h,7Eh,36h,1Eh,00
	.DB 00,3Ch,66h,06h,7Ch,60h,7Eh,00
	.DB 00,3Ch,66h,66h,7Ch,60h,3Ch,00
	.DB 00,30h,30h,30h,18h,0Ch,3Eh,00
	.DB 00,3Ch,66h,66h,3Ch,66h,3Ch,00
	.DB 00,3Ch,06h,06h,3Eh,66h,3Ch,00
	.DB 00,66h,66h,7Eh,66h,66h,3Eh,00
	.DB 00,7Ch,66h,66h,7Ch,66h,7Ch,00
	.DB 00,3Ch,66h,60h,60h,66h,3Ch,00
	.DB 00,7Ch,66h,66h,66h,66h,7Ch,00
	.DB 00,7Eh,60h,60h,78h,60h,7Eh,00
	.DB 00,60h,60h,60h,78h,60h,7Eh,00
	.DB 00,3Ch,66h,66h,66h,66h,3Ch,00
	.DB 00,3Ch,18h,18h,18h,78h,38h,00
	.DB 00,7Eh,30h,18h,0Ch,6Ch,38h,00
	.DB 00,3Ch,66h,06h,1Ch,06h,7Eh,00
	.DB 00,06h,06h,06h,7Eh,36h,1Eh,00
	.DB 00,3Ch,66h,06h,7Ch,60h,7Eh,00
	.DB 00,3Ch,66h,66h,7Ch,60h,3Ch,00
	.DB 00,30h,30h,30h,18h,0Ch,3Eh,00
	.DB 00,3Ch,66h,66h,3Ch,66h,3Ch,00
	.DB 00,3Ch,06h,06h,3Eh,66h,3Ch,00
	.DB 00,66h,66h,7Eh,66h,66h,3Eh,00
	.DB 00,7Ch,66h,66h,7Ch,66h,7Ch,00
	.DB 00,3Ch,66h,60h,60h,66h,3Ch,00
	.DB 00,7Ch,66h,66h,66h,66h,7Ch,00
	.DB 00,7Eh,60h,60h,78h,60h,7Eh,00
	.DB 00,60h,60h,60h,78h,60h,7Eh,00

		.end
