; -06
;  -    HDD
;  ,   LCD-
;    
;
;  -     HEX-,
;        HDD
;   0080h  0081h .
;                                             05.2022
;--------------------------------------------------
;  LCD
;     :
; 7C -    ,     
; 7D -    , 
;--------------------------------------------------
PCommand	.equ	$7C	;   -
PData		.equ	$7D	;   -
;--------------------------------------------------

        .ORG    00100h

L_0100:	DI
	XRA	A
	OUT	10H		; . 
;
	LXI  SP,00100h

;    
;	mvi	a,$01
;	lxi	b,$c040
;	call	Vyv_Hex ;    
;	mvi	a,$23
;	lxi	b,$c340
;	call	Vyv_Hex ;    
;	mvi	a,$45
;	lxi	b,$c640
;	call	Vyv_Hex ;    
;	mvi	a,$67
;	lxi	b,$c940
;	call	Vyv_Hex ;    
;	mvi	a,$89
;	lxi	b,$cc40
;	call	Vyv_Hex ;    
;	mvi	a,$ab
;	lxi	b,$cf40
;	call	Vyv_Hex ;    
;	mvi	a,$cd
;	lxi	b,$d240
;	call	Vyv_Hex ;    
;	mvi	a,$ef
;	lxi	b,$d540
;	call	Vyv_Hex ;    
;
	call	LCD_Init	;  LCD-
	mvi	a,$01	;    
	call	LCD_GotoXY	;     
	mvi	a,'O'	; 
	call	LCD_WD	;    
;	mvi	a,'k'	; 
;	call	LCD_WD	;    
;
	mvi	a,$00	;    
	call	LCD_GotoXY	;     
;
L_018A: MVI  B, 001h
L_018C: MVI  A, 001h
        OUT     052h
        MOV  A, B
        OUT     053h
        XRA  A
        OUT     054h
        OUT     055h
        OUT     056h
        MVI  A, 040h

        CALL    L_04D5	; +  

        ANI     0DDh
        CPI     050h

        JNZ     L_01C0	; 001BBh -  " "   L_01C0

        INR  B
        JNZ     L_018C	; +

; "  "
L_01C0: MOV  a, B
	dcr	a
	lxi	b,$c175
	call	Vyv_Hex	;    
	call	LCD_Hex	;   LCD- 
;
L_01E1: MVI  B, 000h
L_01E3: MVI  A, 001h
        OUT     052h
        OUT     053h
        XRA  A
        OUT     054h
        OUT     055h
        MOV  A, B
        OUT     056h
        MVI  A, 040h

        CALL    L_04D5	; +  

        ANI     0DDh
        CPI     050h

        JNZ     L_0204	; +  

        INR  B
        MOV  A, B
        CPI     010h
        JNZ     L_01E3	; +

;  ""
L_0204:	MOV	a, B
	lxi	b,$c575
	call	Vyv_Hex ;    
	call	LCD_Hex	;   LCD- 
;
; Stop
L_End:	mvi	a,$51	;    
	call	LCD_GotoXY	;     
	mvi	a,'S'	; 
	call	LCD_WD	;    
;
L_Stop: jmp	L_Stop
;
;=================================================
L_04D5: PUSH PSW
        CALL    L_0583	;  
        JNZ     L_04F2

; " "
	mvi	a,$51	;    
	call	LCD_GotoXY	;     
	mvi	a,'Z'	;  
	jmp	L_04D5E ;   
;
L_04F2: POP  PSW
        OUT     057h

        CALL    L_0583	;  

        RNZ	;   

; "     "
	mvi	a,$51	;    
	call	LCD_GotoXY	;     
	mvi	a,'W'	;  
L_04D5E:
	call	LCD_WD	;    

	xra	a
	lxi	b,$c875
	call	Vyv_Hex	;    
;
	jmp	L_Stop
;
;================================================


;========================================
;   HDD
L_0583: PUSH D
        PUSH B
        MVI  D, 020h
L_0587: IN      057h
        ANI     0C0h
        CPI     040h
        JZ      L_059A
        DCX  B
        MOV  A, B
        ORA  C
        JNZ     L_0587
        DCR  D
        JNZ     L_0587
L_059A: ANA  A
        POP  B
        POP  D
        IN      057h
        RET
;========================================
        


;========================================
;*--   ----------------------
;
PAUSE2:	PUSH	B
	PUSH	PSW
	MVI	B,001H	;   ~1.85
	JMP	PAUSEB
PAUSE5:	PUSH	B
	PUSH	PSW
	MVI	B,003H	;   5
	JMP	PAUSEB
PAUSE213:
	PUSH	B
	PUSH	PSW
	MVI	B,080H	;  213
PAUSEB:	MVI	C,0FFH
PAUSEC:	DCR	C
	JNZ	PAUSEC
	DCR	B
	JNZ	PAUSEB
	POP	PSW
	POP	B
	RET
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;==============   LCD ================
;
;  
LCD_Init:
	mvi	a,$30	;  8-, 1 ,  5*8
	out	PCommand
;
	call	PAUSE5	;  ~ 5
;
	mvi	a,$30	;  8-, 1 ,  5*8
	out	PCommand
;
	call	PAUSE5	;  ~ 5
;
	mvi	a,$38	;  8-, 2 ,  5*8
	call	LCD_WK     ;    
;
	call	PAUSE5	;  ~ 5
;  
	mvi	a,$38	;  8-, 2 ,  5*8
	call	LCD_WK     ;    
	mvi	a,$0c	;  .,  .
	call	LCD_WK     ;    
	mvi	a,$06	;   ,   
	call	LCD_WK     ;    
	call	LCD_Clr	;  
	ret		;    
;
;---------------------------------------
;   .	
;     -   
LCD_Busy:
	push	b
	push	psw	;  
	mvi	b,10
LCD_Busy81:
	in	PCommand	;  
	rlc		 ;    
	jnc	LCD_BusyEnd	;    
	dcr	b
	jnz	LCD_Busy81
LCD_BusyEnd:
	pop	psw	;  
	pop	b
	ret
;
;-------------------------------------------
;   
LCD_Clr:
	push	psw	;  
	mvi	a,$01	;  
	call	LCD_WK     ;    
	call	PAUSE2	;  ~ 1.85
	pop	psw	;
	ret		;    
;
;-------------------------------------------
;      .   -   XYh
LCD_GotoXY:
	push	b	;  
	mov	b,a	;  XY
	rlc
	rlc
	rlc
	rlc
	ani	$0f	;  X
	mov	c,a	;  X
	mov	a,b	;  XY
	ani	$0f	;  Y
	mov	a,c	;  X
	jnz	LCD_GotoY2	;   ,  +0
	adi	$C0	;     A+C0+C0=A+80
LCD_GotoY2:
	adi	$C0	;    
	call	LCD_WK     ;    
	pop	b	;  
	ret		;    
;
;-------------------------------------------
;    HEX-
LCD_Hex:
	push	b
	mvi	c,$02	;     
	mov	b,a	;  
	rlc
	rlc
	rlc
	rlc
LCD_HexC:
	ani	$0f	;   
	cpi	$0a
	jc	LCD_Hex9
	adi	$07	;     0A-0F
LCD_Hex9:
	adi	$30	;   
	call	LCD_WD	;    
	mov	a,b
	dcr	c	;
	jnz	LCD_HexC	;     
	pop	b
	ret
;
;=========================================================
;     
LCD_WK:	call	LCD_Busy	;   
	out	PCommand	;    
	ret
;
;    
LCD_WD:	call	LCD_Busy	;   
	out	PData	;    
	ret
;
;=========================================================
;    HEX- A-, BC-  
Vyv_Hex:
	push	psw
	push	h
	push	d
	push	b
	push	psw
	ani	$f0
	rrc
	rrc
	rrc
	call	Vyv_Hs	;  H 
	pop	psw
	pop	b
	inr	b
	ani	$0f
	rlc
	call	Vyv_Hs	;  L 
	pop	d
	pop	h
	pop	psw
	ret
;
Vyv_Hs:	mov	e,a
	mvi	d,$00
	lxi	h,tabs
	dad	d
	dad	d
	dad	d
	mvi	d,6
Vyv_Hd:
	mov	a,m
	stax	b
	dcx	b
	stax	b
	inx	h
	dcx	b
	dcr	d
	jnz	Vyv_Hd
	ret
;
;-------------------------------------------------------------------------------
tabs:	.db	$3c,$42,$42,$42,$42,$3c	;0
	.db	$0c,$0c,$3c,$0c,$0c,$0c	;1
	.db	$3c,$42,$0c,$30,$20,$7e	;2
	.db	$3c,$42,$0c,$02,$42,$3c	;3
	.db	$42,$42,$7e,$02,$02,$02	;4
	.db	$7e,$40,$7c,$02,$42,$3c	;5
	.db	$3c,$40,$7c,$42,$42,$3c	;6
	.db	$7e,$02,$0c,$0c,$0c,$0c	;7
	.db	$3c,$42,$3c,$42,$42,$3c	;8
	.db	$3c,$42,$3e,$02,$42,$3c	;9
	.db	$02,$0e,$32,$42,$7e,$42	;a
	.db	$7c,$42,$7c,$42,$42,$7c	;b
	.db	$3c,$42,$40,$40,$42,$3c	;c
	.db	$7c,$42,$42,$42,$42,$7c	;d
	.db	$7e,$40,$7c,$40,$40,$7e	;e
	.db	$7e,$40,$7c,$40,$40,$40	;f
;
;-------------------------------------------------------------------------------
	.END
