
;#DEFINE nblx

rastint .equ 38h ;    
FONTPAGE .equ $e000

    .org 100h
    ;    .rom  
    di              ;  
    xra a               
    out 10h         ;   
    lxi sp, $100    ;   
    

    mvi a, 0c9h     ;   RET
    sta rastint     ;   RST7

    mvi a, 0c3h
    sta 0
    lxi h, $100
    shld 1

        jmp realstart
        
        ;     ,       256
blx_jumptbl:
        jmp blit_x_0\ nop
        jmp blit_x_1\ nop
        jmp blit_x_2\ nop
        jmp blit_x_3\ nop
        jmp blit_x_4\ nop
        jmp blit_x_5\ nop
        jmp blit_x_6\ nop
        jmp blit_x_7\ nop

        ;  
nblx_jumptbl:
        jmp nblit_x_0\ nop
        jmp nblit_x_1\ nop
        jmp nblit_x_2\ nop
        jmp nblit_x_3\ nop
        jmp nblit_x_4\ nop
        jmp nblit_x_5\ nop
        jmp nblit_x_6\ nop
        jmp nblit_x_7\ nop


        
realstart:


    call clrscr     ;  
    
    lxi h, colors_1+15
    call colorset

        call prepare_font

#IFDEF nblx
        lxi b, FONTPAGE+(87)
        lxi d, $a0f0
        call nblit_x_0
        
        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (8 * 1)
        call nblit_x_1

        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (8 * 2)
        call nblit_x_2

        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (8 * 3)
        call nblit_x_3

        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (8 * 4)
        call nblit_x_4
        
        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (8 * 5)
        call nblit_x_5

        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (8 * 6)
        call nblit_x_6

        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (8 * 7)
        call nblit_x_7
#ELSE
        lxi b, FONTPAGE+(87)
        lxi d, $a0f0
        call blit_x_0
        
        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (8 * 1)
        call blit_x_1

        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (8 * 2)
        call blit_x_2

        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (8 * 3)
        call blit_x_3

        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (8 * 4)
        call blit_x_4
        
        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (8 * 5)
        call blit_x_5

        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (8 * 6)
        call blit_x_6

        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (8 * 7)
        call blit_x_7
#ENDIF

        ei
        hlt

        ;  :   
        mvi a, 0c3h
        sta rastint
        lxi h, stop_benchmark
        shld rastint+1
        ei
        
benchmark:
        lxi h, $0101
        mvi c, '!'
next_test_line:
        mvi b, 79
test_line:
        push b
        push h
        call blit_dispatch
        pop h
        pop b
        inr h
        inr c ; char to print
		mvi a,128
        cmp c
        jnz $+5
        mvi c, ' '
        dcr b
        jnz test_line
        
        inr l
		mvi a,32
        cmp l
        jnz $+5
        mvi l, 0
        mvi h, 0
        jmp next_test_line
        
        
stop_benchmark:        
        
        di \ hlt

        ; H = , L = , c = char
blit_dispatch:
        ;     
        mov a, l
		add a\ add a\ add a
        mov e, a
        
        ;   de =   * 3 / 8
        mov a, h
        add a
        add h
		mov h,a
;        rar \ rar \ rar
;        ani $1f
;        adi 0A0h ;    
        rar \ ora a\ rar \ rar
		ori 0A0h	; 
        mov d, a
        
        ; dispatch to blitnik h * 3 % 8
        ;  =     8
		mvi a,7
		ana h
		add a
		add a		;*4

        ;         +  * 3
        ;; !!     $100 --
#IFDEF nblx
        adi (nblx_jumptbl & 255)
		mov l,a
		mvi h,nblx_jumptbl>>8
#ELSE
        adi (blx_jumptbl & 255)
		mov l,a
		mvi h,blx_jumptbl>>8
#ENDIF

        ; load glyph
		mvi b,FONTPAGE>>8

		pchl


        ;         $e000
prepare_font:

        lxi h, FONTPAGE
        lxi b, 256*16/4
        mvi d, 0
pf_loop_1:        
        mov m, d \ inx h
        mov m, d \ inx h
        mov m, d \ inx h
        mov m, d \ inx h
        dcr c
        jnz pf_loop_1
        dcr b
        jnz pf_loop_1
        
		mvi a, 0
        lxi d, FONTPAGE
        lxi b, fontsrc
prepare_font_loop
        push psw
        call rotchar
        pop psw
        dcr a
        jnz prepare_font_loop
        ret
        
        
blit_x_0:
		mvi h,00011111b
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b

		mvi a,32\ add d\ mov d,a

        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d
        ret

blit_x_1:
		mvi h,10001111b
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b

		mvi a,32\ add d\ mov d,a

        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d
        ret

blit_x_2:
		mvi h,11000111b
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b

		mvi a,32\ add d\ mov d,a

        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d
        ret

blit_x_3:
		mvi h,11100011b
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b

		mvi a,32\ add d\ mov d,a

        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d
        ret

blit_x_4:
		mvi h,11110001b
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b

		mvi a,32\ add d\ mov d,a

        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d
        ret

blit_x_5:
		mov h,b
		mov l,c
        mvi b, 11111000b
        ldax d\ ana b\ ora m\ stax d\ inr h \ inr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ inr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ inr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ inr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ inr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ inr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ inr e
        ldax d\ ana b\ ora m\ stax d\ inr h

		mvi a,32\ add d\ mov d,a

        ldax d\ ana b\ ora m\ stax d\ inr h \ dcr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ dcr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ dcr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ dcr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ dcr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ dcr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ dcr e
        ldax d\ ana b\ ora m\ stax d\ inr h
        ret

blit_x_6:
        mvi h, 11111100b

		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr d
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ inr b\ inr e
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ dcr d
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr b\ inr e
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr d
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ inr b\ inr e
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ dcr d
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr b\ inr e
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr d
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ inr b\ inr e
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ dcr d
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr b\ inr e
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr d
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ inr b\ inr e
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ dcr d
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr b
       
		mvi a,32\ add d\ mov d,a

		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr d
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ inr b\ dcr e
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ dcr d
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr b\ dcr e
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr d
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ inr b\ dcr e
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ dcr d
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr b\ dcr e
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr d
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ inr b\ dcr e
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ dcr d
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr b\ dcr e
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr d
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ inr b\ dcr e
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ dcr d
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d
        ret

blit_x_7:
		mvi h,00111111b
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ inr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ inr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ inr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ inr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ inr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ inr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ inr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b
        
		mvi a,31\ add d\ mov d,a

		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ dcr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ dcr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ dcr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ dcr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ dcr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ dcr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ dcr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d
        ret

        ; blit at shift 0 (glyph << 5)
        ; de = screen addr
        ; hl = glyph addr
        ;   0   - ,   ,  
nblit_x_0:
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b

		mvi a,32\ add d\ mov d,a

        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ stax d
        ret

nblit_x_1:
        xchg
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b

		mvi a,32\ add h\ mov h,a
        
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a
        ret

nblit_x_2:
        xchg
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b

		mvi a,32\ add h\ mov h,a
        
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a
        ret

nblit_x_3:
        xchg
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b

		mvi a,32\ add h\ mov h,a

        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a
        ret

nblit_x_4:
        xchg
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b

		mvi a,32\ add h\ mov h,a
        
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ ora m \ mov m, a
        ret

nblit_x_5:
        ;mvi b, 0b1111_1000
        xchg
        ldax b \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ ora m \ mov m, a \ inr b

		mvi a,32\ add h\ mov h,a
        ldax b \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ ora m \ mov m, a
        ret

        ;   ,     -,  
nblit_x_6:
        xchg
        mvi d, 10000000b

        ora a 
        ldax b \ rar \ ora m \ mov m, a \ inr h
        ldax b \ rrc \ ana d \ mov m, a \ inr b \ inr l
        ldax b \ rrc \ ana d \ mov m, a \ dcr h
        ldax b \ rar \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rar \ ora m \ mov m, a \ inr h
        ldax b \ rrc \ ana d \ mov m, a \ inr b \ inr l
        ldax b \ rrc \ ana d \ mov m, a \ dcr h
        ldax b \ rar \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rar \ ora m \ mov m, a \ inr h
        ldax b \ rrc \ ana d \ mov m, a \ inr b \ inr l
        ldax b \ rrc \ ana d \ mov m, a \ dcr h
        ldax b \ rar \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rar \ ora m \ mov m, a \ inr h
        ldax b \ rrc \ ana d \ mov m, a \ inr b \ inr l
        ldax b \ rrc \ ana d \ mov m, a \ dcr h
        ldax b \ rar \ ora m \ mov m, a \ inr b
       
		mvi a,32\ add h\ mov h,a

        ldax b \ rar \ ora m \ mov m, a \ inr h
        ldax b \ rrc \ ana d \ mov m, a \ inr b \ dcr l
        ldax b \ rrc \ ana d \ mov m, a \ dcr h
        ldax b \ rar \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rar \ ora m \ mov m, a \ inr h
        ldax b \ rrc \ ana d \ mov m, a \ inr b \ dcr l
        ldax b \ rrc \ ana d \ mov m, a \ dcr h
        ldax b \ rar \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rar \ ora m \ mov m, a \ inr h
        ldax b \ rrc \ ana d \ mov m, a \ inr b \ dcr l
        ldax b \ rrc \ ana d \ mov m, a \ dcr h
        ldax b \ rar \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rar \ ora m \ mov m, a \ inr h
        ldax b \ rrc \ ana d \ mov m, a \ inr b \ dcr l
        ldax b \ rrc \ ana d \ mov m, a \ dcr h
        ldax b \ rar \ ora m \ mov m, a
        ret
        
        ;   ,     -,  
nblit_x_7:
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ inr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ inr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ inr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ inr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ inr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ inr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ inr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b
        
		mvi a,33\ add d\ mov d,a

		ldax b\ rrc\ rrc\ rrc\ add a\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ dcr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ dcr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ dcr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ dcr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ dcr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ dcr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ dcr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d
        ret


    ;    SP
__savedsp: .dw 0

    ;    
clrscr
    di
    lxi h,0
    dad sp
    shld __savedsp

    lxi sp, 0
    lxi b, 0;$ffff
    lxi d, $1000
_clrscr_1:
    push b
    push b
    push b
    push b
    dcx d
    mov a, d
    ora e
    jnz _clrscr_1

    lhld __savedsp
    sphl
    ret

; 0000  C0     
; 0001  C1     
; 0010  C2
; 0011  C3

; 0100  C0     
; 0101  C1
; 0110  C2
; 0111  C3
; 1000  C0
; 1001  C1
; 1010  C2
; 1011  C3
; 1100  C0
; 1101  C1
; 1110  C2
; 1111  C3


; index & 03
; x x 0 0    0
; x x 0 1    1
; x x 1 0    2
; x x 1 1    3
; index & 0c
; 0 0 x x    0
; 0 1 x x    1
; 1 0 x x    2
; 1 1 x x    3
C0 .equ 255
C1 .equ 007q
C2 .equ 070q
C3 .equ 300q
WHITE .equ 377q

colors_1:        .db WHITE, WHITE, 0, 0
                .db 0, C2, C2, C2
                .db WHITE, C2, C2, C2 ;; 10  
                .db 0, 0, 0, WHITE

                ; h points to palette + 15
colorset:
		mvi	a, 88h
		out	0
		mvi	c, 15
colorset1:	mov	a, c
		out	2
		mov	a, m
		out	0Ch
		dcx	h
		out	0Ch
		out	0Ch
		dcr	c
		out	0Ch
		out	0Ch
		out	0Ch
		jp	colorset1
                ;ret

                mvi a, $10
                out 2
                ret


        ;  6  / 8      8  6 
        ; 3   / 3  
rotchar:
		push d
		mvi a,3

rotchar_nextcol:
		sta rotchar_counter
		push d

		lxi h,8*256
		dad d
		xchg
		call rotchar_1
		pop d
		push d
		
		call rotchar_1

rotchar_counter	.equ $+1
		mvi a,0
		dcr a
		pop d
		jnz rotchar_nextcol
;rotchar_upsd:
		lxi h,8*256
		dad d
		xchg
		lxi h,7*256
		dad d
		push b
		mvi c,4
rotchar_upsd1:
		mov b,m
		ldax d
		mov m,a
		mov a,b
		stax d
		dcr h
		inr d
		dcr c
		jnz rotchar_upsd1
		pop b
		pop d
		inr e
		ret

rotchar_1:
		ldax b
		inx b
		mov h,a
		mvi l,1
rotchar_loop:
		ldax d
		dad h\ ral
		stax d
		inr d
		xra a
		ora l
        jnz rotchar_loop
		ret

fontsrc:

	.db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	.db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	.db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	.db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	.db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	.db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	.db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	.db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	.db $00, $2F, $00, $00, $00, $00, $03, $00, $03, $00, $00, $14, $3E, $14, $3E, $14, $00, $04, $2A, $7F, $2A, $10, $00, $26, $10
	.db $08, $04, $32, $00, $1A, $25, $29, $10, $28, $00, $00, $00, $03, $00, $00, $00, $00, $3E, $41, $41, $00, $00, $00, $41, $41	
	.db $3E, $00, $00, $28, $18, $0E, $18, $28, $00, $08, $08, $3E, $08, $08, $00, $00, $20, $10, $00, $00, $00, $08, $08, $08, $08
	.db $08, $00, $00, $00, $10, $00, $00, $00, $20, $10, $08, $04, $02, $00, $00, $1E, $21, $21, $1E, $00, $00, $00, $22, $3F, $20
	.db $00, $00, $22, $31, $29, $26, $00, $00, $12, $21, $25, $1A, $00, $00, $0C, $0A, $3F, $08, $00, $00, $17, $25, $25, $19, $00
	.db $00, $1C, $26, $25, $18, $00, $00, $01, $39, $05, $03, $00, $00, $1A, $25, $25, $1A, $00, $00, $06, $09, $29, $1E, $00, $00
	.db $00, $14, $00, $00, $00, $00, $20, $14, $00, $00, $00, $00, $08, $14, $22, $00, $00, $00, $14, $14, $14, $00, $00, $00, $22
	.db $14, $08, $00, $00, $02, $01, $29, $06, $00, $00, $1E, $21, $2D, $2E, $00, $00, $30, $0C, $0B, $0C, $30, $00, $00, $3F, $25
	.db $25, $1A, $00, $00, $1E, $21, $21, $12, $00, $00, $3F, $21, $21, $1E, $00, $00, $3F, $25, $25, $25, $00, $00, $3F, $05, $05
	.db $05, $00, $00, $1E, $21, $29, $1A, $00, $00, $3F, $04, $04, $3F, $00, $00, $21, $3F, $21, $00, $00, $18, $20, $21, $1F, $00
	.db $00, $00, $3F, $0C, $12, $21, $00, $00, $3F, $20, $20, $20, $00, $3F, $06, $08, $06, $3F, $00, $00, $3F, $06, $18, $3F, $00
	.db $00, $1E, $21, $21, $1E, $00, $00, $3F, $09, $09, $06, $00, $1E, $21, $21, $5E, $00, $00, $00, $3F, $09, $19, $26, $00, $00
	.db $12, $25, $29, $12, $00, $01, $01, $3F, $01, $01, $00, $1F, $20, $20, $20, $1F, $00, $0F, $10, $20, $10, $0F, $00, $1F, $20
	.db $1C, $20, $1F, $00, $21, $12, $0C, $12, $21, $00, $03, $04, $38, $04, $03, $00, $00, $31, $29, $25, $23, $00, $00, $3F, $21
	.db $21, $00, $00, $02, $04, $08, $10, $20, $00, $00, $21, $21, $3F, $00, $00, $04, $02, $01, $02, $04, $00, $40, $40, $40, $40
	.db $40, $00, $00, $00, $01, $02, $00, $00, $18, $24, $24, $18, $20, $00, $00, $3F, $24, $24, $18, $00, $00, $18, $24, $24, $00
	.db $00, $00, $18, $24, $24, $3F, $00, $00, $1C, $2A, $2A, $0C, $00, $04, $04, $3E, $05, $05, $00, $00, $0C, $52, $52, $3E, $00
	.db $00, $3F, $04, $04, $38, $00, $00, $24, $3D, $20, $00, $00, $20, $40, $44, $3D, $00, $00, $00, $3F, $08, $14, $22, $00, $00
	.db $1F, $20, $20, $10, $00, $3E, $04, $18, $04, $3E, $00, $00, $3C, $02, $02, $3C, $00, $00, $1C, $22, $22, $1C, $00, $00, $7E
	.db $12, $12, $0C, $00, $00, $0C, $12, $12, $7E, $00, $00, $04, $38, $04, $04, $00, $00, $04, $2A, $2A, $10, $00, $00, $04, $1E
	.db $24, $10, $00, $1C, $20, $20, $20, $1C, $00, $0C, $10, $20, $10, $0C, $00, $1C, $20, $18, $20, $1C, $00, $22, $14, $08, $14
	.db $22, $00, $04, $48, $30, $08, $04, $00, $00, $24, $34, $2C, $24, $00, $08, $08, $36, $41, $41, $00, $00, $00, $7F, $00, $00
	.db $00, $41, $41, $36, $08, $08, $00, $08, $04, $08, $10, $08, $00, $00, $00, $00, $00, $00
fontdst:

        .db $1a
        .end
