
;#DEFINE nblx

rastint .equ 38h ;    
FONTPAGE .equ $e000

    .org 100h
    ;    .rom  
    di              ;  
    xra a               
    out 10h         ;   
    lxi sp, $100    ;   
    

    mvi a, 0c9h     ;   RET
    sta rastint     ;   RST7

    mvi a, 0c3h
    sta 0
    lxi h, $100
    shld 1

        jmp realstart
        
        ;     ,       256
blx_jumptbl:
        jmp blit_x_0\ nop
        jmp blit_x_1\ nop
        jmp blit_x_2\ nop
        jmp blit_x_3\ nop
        jmp blit_x_4\ nop
        jmp blit_x_5\ nop
        jmp blit_x_6\ nop
        jmp blit_x_7\ nop

        ;  
nblx_jumptbl:
        jmp nblit_x_0\ nop
        jmp nblit_x_1\ nop
        jmp nblit_x_2\ nop
        jmp nblit_x_3\ nop
        jmp nblit_x_4\ nop
        jmp nblit_x_5\ nop
        jmp nblit_x_6\ nop
        jmp nblit_x_7\ nop


        
realstart:


    call clrscr     ;  
    
    lxi h, colors_1+15
    call colorset

        call prepare_font

#IFDEF nblx
        lxi b, FONTPAGE+(87)
        lxi d, $a0f0
        call nblit_x_0
        
        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (10 * 1)
        call nblit_x_1

        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (10 * 2)
        call nblit_x_2

        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (10 * 3)
        call nblit_x_3

        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (10 * 4)
        call nblit_x_4
        
        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (10 * 5)
        call nblit_x_5

        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (10 * 6)
        call nblit_x_6

        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (10 * 7)
        call nblit_x_7
#ELSE
        lxi b, FONTPAGE+(87)
        lxi d, $a0f0
        call blit_x_0
        
        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (10 * 1)
        call blit_x_1

        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (10 * 2)
        call blit_x_2

        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (10 * 3)
        call blit_x_3

        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (10 * 4)
        call blit_x_4
        
        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (10 * 5)
        call blit_x_5

        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (10 * 6)
        call blit_x_6

        lxi b, FONTPAGE+(87)
        lxi d, $a0f0 - (10 * 7)
        call blit_x_7
#ENDIF

        ei
        hlt

        ;  :   
;        mvi a, 0c3h
;        sta rastint
;        lxi h, stop_benchmark
;        shld rastint+1
;        ei
        
benchmark:
        lxi h, $0111
        mvi c, 0
next_test_line:
        mvi b, 16
test_line:
        push b
        push h
        call blit_dispatch
        pop h
        pop b
        inr h
        inr c ; char to print
        dcr b
        jnz test_line
        dcr l
		mvi a,11h-16
		cmp l
        mvi h, 1
        jnz next_test_line
        
        
stop_benchmark:        
        
        di \ hlt

        ; H = , L = , c = char
blit_dispatch:
        ;     
        mov a, l
		add a\ add a\ add l\ add a
        mov e, a
        
        ;   de =   * 3 / 8
        mov a, h
        add a
        add h
		mov h,a
;        rar \ rar \ rar
;        ani $1f
;        adi 0A0h ;    
        rar \ ora a\ rar \ rar
		ori 0A0h	; 
        mov d, a
        
        ; dispatch to blitnik h * 3 % 8
        ;  =     8
		mvi a,7
		ana h
		add a
		add a		;*4

        ;         +  * 3
        ;; !!     $100 --
#IFDEF nblx
        adi (nblx_jumptbl & 255)
		mov l,a
		mvi h,nblx_jumptbl>>8
#ELSE
        adi (blx_jumptbl & 255)
		mov l,a
		mvi h,blx_jumptbl>>8
#ENDIF

        ; load glyph
		mvi b,FONTPAGE>>8

		pchl


        ;    $e000
prepare_font:
		lxi h,fontsrc
        lxi b, FONTPAGE
        lxi d, FONTPAGE+(256*19)
		mvi a,0
pf_loop_1:
		push psw
		push b
		push d

		mov a,m
		rlc\ rlc\ rlc
		ani 7
		stax d
		mov a,m
		rrc\ rrc
		ani 7
		stax b
		inr b
		dcr d
		inx h

		mov a,m
		rlc\ rlc\ rlc
		ani 7
		stax d
		mov a,m
		rrc\ rrc
		ani 7
		stax b
		inr b
		dcr d
		inx h
				mov a,m
		rlc\ rlc\ rlc
		ani 7
		stax d
		mov a,m
		rrc\ rrc
		ani 7
		stax b
		inr b
		dcr d
		inx h
				mov a,m
		rlc\ rlc\ rlc
		ani 7
		stax d
		mov a,m
		rrc\ rrc
		ani 7
		stax b
		inr b
		dcr d
		inx h
				mov a,m
		rlc\ rlc\ rlc
		ani 7
		stax d
		mov a,m
		rrc\ rrc
		ani 7
		stax b
		inr b
		dcr d
		inx h
				mov a,m
		rlc\ rlc\ rlc
		ani 7
		stax d
		mov a,m
		rrc\ rrc
		ani 7
		stax b
		inr b
		dcr d
		inx h
				mov a,m
		rlc\ rlc\ rlc
		ani 7
		stax d
		mov a,m
		rrc\ rrc
		ani 7
		stax b
		inr b
		dcr d
		inx h
				mov a,m
		rlc\ rlc\ rlc
		ani 7
		stax d
		mov a,m
		rrc\ rrc
		ani 7
		stax b
		inr b
		dcr d
		inx h
				mov a,m
		rlc\ rlc\ rlc
		ani 7
		stax d
		mov a,m
		rrc\ rrc
		ani 7
		stax b
		inr b
		dcr d
		inx h
				mov a,m
		rlc\ rlc\ rlc
		ani 7
		stax d
		mov a,m
		rrc\ rrc
		ani 7
		stax b
		inx h

		pop d
		pop b
		pop psw
		inr e
		inr c
		dcr a
		jnz pf_loop_1
        ret
        
        
blit_x_0:
		mvi h,00011111b
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b

		mvi a,32\ add d\ mov d,a

        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d
        ret

blit_x_1:
		mvi h,10001111b
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b

		mvi a,32\ add d\ mov d,a

        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ rrc \ mov l,a\ ldax d\ ana h\ ora l\ stax d
        ret

blit_x_2:
		mvi h,11000111b
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ inr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b

		mvi a,32\ add d\ mov d,a

        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d \ inr b \ dcr e
        ldax b \ rlc \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d
        ret

blit_x_3:
		mvi h,11100011b
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b

		mvi a,32\ add d\ mov d,a

        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d
        ret

blit_x_4:
		mvi h,11110001b
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ inr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b

		mvi a,32\ add d\ mov d,a

        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d\ inr b \ dcr e
        ldax b \ rlc \ mov l,a\ ldax d\ ana h\ ora l\ stax d
        ret

blit_x_5:
		mov h,b
		mov l,c
        mvi b, 11111000b
        ldax d\ ana b\ ora m\ stax d\ inr h \ inr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ inr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ inr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ inr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ inr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ inr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ inr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ inr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ inr e
        ldax d\ ana b\ ora m\ stax d\ inr h

		mvi a,32\ add d\ mov d,a

        ldax d\ ana b\ ora m\ stax d\ inr h \ dcr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ dcr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ dcr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ dcr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ dcr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ dcr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ dcr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ dcr e
        ldax d\ ana b\ ora m\ stax d\ inr h \ dcr e
        ldax d\ ana b\ ora m\ stax d\ inr h
        ret

blit_x_6:
        mvi h, 11111100b

		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr d
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ inr b\ inr e
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ dcr d
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr b\ inr e
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr d
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ inr b\ inr e
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ dcr d
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr b\ inr e
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr d
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ inr b\ inr e
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ dcr d
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr b\ inr e
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr d
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ inr b\ inr e
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ dcr d
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr b\ inr e
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr d
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ inr b\ inr e
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ dcr d
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr b
       
		mvi a,32\ add d\ mov d,a

		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr d
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ inr b\ dcr e
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ dcr d
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr b\ dcr e
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr d
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ inr b\ dcr e
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ dcr d
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr b\ dcr e
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr d
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ inr b\ dcr e
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ dcr d
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr b\ dcr e
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr d
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ inr b\ dcr e
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ dcr d
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr b\ dcr e
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d\ inr d
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ inr b\ dcr e
		ldax b\ rrc\ ldax d\ ral\ rrc\ stax d\ dcr d
		ldax d\ ana h\ mov l,a\ ldax b\ rar\ ora l\ stax d
        ret

blit_x_7:
		mvi h,00111111b
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ inr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ inr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ inr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ inr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ inr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ inr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ inr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ inr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ inr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b
        
		mvi a,31\ add d\ mov d,a

		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ dcr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ dcr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ dcr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ dcr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ dcr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ dcr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ dcr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ dcr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d\ inr b\ dcr e\ dcr d
		ldax b\ rrc\ rrc\ rrc\ add a\ mov l,a\ ldax d\ rar\ rlc\ stax d\ inr d
		ldax d\ ana h\ ora l\ stax d
        ret

        ; blit at shift 0 (glyph << 5)
        ; de = screen addr
        ; hl = glyph addr
        ;   0   - ,   ,  
nblit_x_0:
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ inr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b

		mvi a,32\ add d\ mov d,a

        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ stax d \ inr b \ dcr e
        ldax b \ rrc \ rrc \ rrc \ stax d
        ret

nblit_x_1:
        xchg
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b

		mvi a,32\ add h\ mov h,a
        
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rrc \ rrc \ rrc \ rrc \ ora m \ mov m, a
        ret

nblit_x_2:
        xchg
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b

		mvi a,32\ add h\ mov h,a
        
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ rlc \ ora m \ mov m, a
        ret

nblit_x_3:
        xchg
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b

		mvi a,32\ add h\ mov h,a

        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ rlc \ ora m \ mov m, a
        ret

nblit_x_4:
        xchg
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b

		mvi a,32\ add h\ mov h,a
        
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rlc \ ora m \ mov m, a
        ret

nblit_x_5:
        ;mvi b, 0b1111_1000
        xchg
        ldax b \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ ora m \ mov m, a \ inr b

		mvi a,32\ add h\ mov h,a
        ldax b \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ ora m \ mov m, a
        ret

        ;   ,     -,  
nblit_x_6:
        xchg
        mvi d, 10000000b

        ora a 
        ldax b \ rar \ ora m \ mov m, a \ inr h
        ldax b \ rrc \ ana d \ mov m, a \ inr b \ inr l
        ldax b \ rrc \ ana d \ mov m, a \ dcr h
        ldax b \ rar \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rar \ ora m \ mov m, a \ inr h
        ldax b \ rrc \ ana d \ mov m, a \ inr b \ inr l
        ldax b \ rrc \ ana d \ mov m, a \ dcr h
        ldax b \ rar \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rar \ ora m \ mov m, a \ inr h
        ldax b \ rrc \ ana d \ mov m, a \ inr b \ inr l
        ldax b \ rrc \ ana d \ mov m, a \ dcr h
        ldax b \ rar \ ora m \ mov m, a \ inr b \ inr l
        ldax b \ rar \ ora m \ mov m, a \ inr h
        ldax b \ rrc \ ana d \ mov m, a \ inr b \ inr l
        ldax b \ rrc \ ana d \ mov m, a \ dcr h
        ldax b \ rar \ ora m \ mov m, a \ inr b
       
		mvi a,32\ add h\ mov h,a

        ldax b \ rar \ ora m \ mov m, a \ inr h
        ldax b \ rrc \ ana d \ mov m, a \ inr b \ dcr l
        ldax b \ rrc \ ana d \ mov m, a \ dcr h
        ldax b \ rar \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rar \ ora m \ mov m, a \ inr h
        ldax b \ rrc \ ana d \ mov m, a \ inr b \ dcr l
        ldax b \ rrc \ ana d \ mov m, a \ dcr h
        ldax b \ rar \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rar \ ora m \ mov m, a \ inr h
        ldax b \ rrc \ ana d \ mov m, a \ inr b \ dcr l
        ldax b \ rrc \ ana d \ mov m, a \ dcr h
        ldax b \ rar \ ora m \ mov m, a \ inr b \ dcr l
        ldax b \ rar \ ora m \ mov m, a \ inr h
        ldax b \ rrc \ ana d \ mov m, a \ inr b \ dcr l
        ldax b \ rrc \ ana d \ mov m, a \ dcr h
        ldax b \ rar \ ora m \ mov m, a
        ret
        
        ;   ,     -,  
nblit_x_7:
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ inr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ inr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ inr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ inr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ inr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ inr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ inr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b
        
		mvi a,33\ add d\ mov d,a

		ldax b\ rrc\ rrc\ rrc\ add a\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ dcr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ dcr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ dcr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ dcr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ dcr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ dcr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d\ inr b\ dcr e
		ldax b\ rrc\ rrc\ rrc\ add a\ inr d\ stax d\ dcr d\ ldax d\ rar\ rlc\ stax d
        ret


    ;    SP
__savedsp: .dw 0

    ;    
clrscr
    di
    lxi h,0
    dad sp
    shld __savedsp

    lxi sp, 0
    lxi b, 0;$ffff
    lxi d, $1000
_clrscr_1:
    push b
    push b
    push b
    push b
    dcx d
    mov a, d
    ora e
    jnz _clrscr_1

    lhld __savedsp
    sphl
    ret

; 0000  C0     
; 0001  C1     
; 0010  C2
; 0011  C3

; 0100  C0     
; 0101  C1
; 0110  C2
; 0111  C3
; 1000  C0
; 1001  C1
; 1010  C2
; 1011  C3
; 1100  C0
; 1101  C1
; 1110  C2
; 1111  C3


; index & 03
; x x 0 0    0
; x x 0 1    1
; x x 1 0    2
; x x 1 1    3
; index & 0c
; 0 0 x x    0
; 0 1 x x    1
; 1 0 x x    2
; 1 1 x x    3
C0 .equ 255
C1 .equ 007q
C2 .equ 070q
C3 .equ 300q
WHITE .equ 377q

colors_1:        .db WHITE, WHITE, 0, 0
                .db 0, C2, C2, C2
                .db WHITE, C2, C2, C2 ;; 10  
                .db 0, 0, 0, WHITE

                ; h points to palette + 15
colorset:
		mvi	a, 88h
		out	0
		ei\ hlt
		mvi	c, 15
colorset1:	mov	a, c
		out	2
		mov	a, m
		out	0Ch
		dcx	h
		out	0Ch
		out	0Ch
		dcr	c
		out	0Ch
		out	0Ch
		out	0Ch
		jp	colorset1
                ;ret

                mvi a, $10
                out 2
                ret



fontsrc:

        .end
