; ea demosong from Arkos Tracker 2 demo songs
; compressed into 14 parallel streams from YM6 file saved by register
;
; decompressing and playing 14 parallel streams
; compressed data size 2055 bytes (uncompressed 61573)
;

; -----------------------------------------------------------------------------
; ZX0 8080 decoder by Ivan Gorodetsky - OLD FILE FORMAT v1 
; Based on ZX0 z80 decoder by Einar Saukas
; v1 (2021-02-15) - 103 bytes forward / 100 bytes backward
; v2 (2021-02-17) - 101 bytes forward / 100 bytes backward
; v3 (2021-02-22) - 99 bytes forward / 98 bytes backward
; v4 (2021-02-23) - 98 bytes forward / 97 bytes backward
; v5 (2021-08-16) - 94 bytes forward and backward (slightly faster)
; v6 (2021-08-17) - 92 bytes forward / 94 bytes backward (forward version slightly faster)
; v7 (2022-04-30) - 92 bytes forward / 94 bytes backward (source address now in DE, slightly faster)
; -----------------------------------------------------------------------------
; Parameters (forward):
;   DE: source address (compressed data)
;   BC: destination address (decompressing)
;
; Parameters (backward):
;   DE: last source address (compressed data)
;   BC: last destination address (decompressing)
; -----------------------------------------------------------------------------
; compress forward with <-c> option (<-classic> for salvador)
;
; compress backward with <-b -c> options (<-b -classic> for salvador)
;
; -----------------------------------------------------------------------------

.include "tasm.inc"
                
                .org $100



; total number of scheduler tasks                
n_tasks         equ 14

; task stack size 
task_stack_size equ 22

                xra a
                out $10
                
                mvi a, $c9
                sta $38

brutal_restart:                
                lxi sp, $100
                
create_tasks:                
                lxi d, em_byreg00
                lxi b, buffer00
                lxi h, stack_00 + task_stack_size
                xra a
                call dzx0_create

                lxi d, em_byreg01
                call dzx0_create

                lxi d, em_byreg02
                call dzx0_create

                lxi d, em_byreg03
                call dzx0_create

                lxi d, em_byreg04
                call dzx0_create

                lxi d, em_byreg05
                call dzx0_create

                lxi d, em_byreg06
                call dzx0_create

                lxi d, em_byreg07
                call dzx0_create

                lxi d, em_byreg08
                call dzx0_create

                lxi d, em_byreg09
                call dzx0_create

                lxi d, em_byreg10
                call dzx0_create

                lxi d, em_byreg11
                call dzx0_create

                lxi d, em_byreg12
                call dzx0_create

                lxi d, em_byreg13
                call dzx0_create

frame:
                ei
                hlt
                
                call scheduler_tick
                call ay_send
                
                jmp frame

ay_line         db 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

ayctrl          equ $15
aydata          equ $14
                ; bc = reg dump
ay_send         
                mvi e, 13
                lxi b, ay_line+13
ay_send_L1                
                mov a, e
                out ayctrl
                ldax b
                out aydata
                dcr c
                dcr e
                jp ay_send_L1
                ret

                ;
                ; call all tasks in order
                ;
scheduler_tick: 
                lxi h, 0
                dad sp
                shld sched_sp
                
                ; data harvest pointer
                lxi h, ay_line
                shld ay_line_ptr
                
                lxi h, context
sched_next_task:
                shld context_ptr
                mov e, m \ inx h \ mov d, m ; de = &context[n]
                xchg
                sphl
                
                ; restore task context and return into it
                pop h
                pop d
                pop b
                pop psw
                ret


                ; dzx0 task calls this to yield after producing each octet
dzx0_yield:     push psw
                push b
                push d
                push h
;                jmp sched_yield
;sched_yield:    ; a = decoded byte in-order

ay_line_ptr     equ $+1
                lxi h, 0
                mov m, a
                inx h
                shld ay_line_ptr
                
                lxi h, 0 
                dad sp
                xchg                    ; de = task context
                lhld context_ptr        ; hl = context[n]
                mov m, e \ inx h \ mov m, d \ inx h
                mvi a, context_end >> 8
                cmp h
                jnz sched_next_task
                mvi a, context_end & 255
                cmp l
                jnz sched_next_task
sched_sp        equ $+1
                lxi sp, 0
                ret
				
                ;
                ; create a dzx0 task
                ;
                ; a = task number (0..n_tasks-1)
                ; hl = task stack end
                ; bc = dst buffer
                ; de = stream source
dzx0_create:
                shld crea_loadsp
                lxi h, 0
                dad sp
                shld dzx0_create_sp
crea_loadsp     equ $+1
                lxi sp, 0

                ; create task entry point within its context
                lxi h, dzx0
                push h
                push psw
                push b
                push d
                push h
                
                lxi d, context  ; context[0]
                mov l, a
                mvi h, 0
                dad h
                dad d           ; hl = &context[a]
                shld crea_ctx+1 ; will save task sp here
				
				pop h
				pop d
				push d
				push h

                lxi h, 0
                dad sp
crea_ctx:       shld 0                  ; save sp in task context
dzx0_create_sp  equ $+1
                lxi sp, 0
				
				inr a					;task number++
				inr b					;dst buffer+=256
				push b
				lxi b,task_stack_size+10
				dad b
				pop b
                ret                     ; this is a normal return

dzx0:
		lxi h,0FFFFh            ; tos=-1 offset?
		push h
		inx h
		mvi a,080h
dzx0_literals:  ; Literal (copy next N bytes from compressed file)
		call dzx0_elias         ; hl = read_interlaced_elias_gamma(FALSE)
;		call dzx0_ldir          ; for (i = 0; i < length; i++) write_byte(read_byte()
		push psw
dzx0_ldir1:
		ldax d
		stax b
		inx d
		call dzx0_yield
		inr c           ; stay within circular buffer
		dcx h
		mov a,h
		ora l
		jnz dzx0_ldir1
		pop psw
		add a

		jc dzx0_new_offset      ; if (read_bit()) goto COPY_FROM_NEW_OFFSET
	
		; COPY_FROM_LAST_OFFSET
		call dzx0_elias         ; hl = read_interlaced_elias_gamma(FALSE) 
dzx0_copy:
		xchg                    ; hl = src, de = length
		xthl                    ; ex (sp), hl:
		                        ; tos = src
		                        ; hl = -1
		push h                  ; push -1
		dad b                   ; h = -1 + dst
		mov h, b                ; stay in the buffer!
		xchg                    ; de = dst + offset, hl = length
;		call dzx0_ldir          ; for (i = 0; i < length; i++) write_byte(dst[-offset+i]) 
		push psw
dzx0_ldir_from_buf:
		ldax d
		stax b
		inr e
		call dzx0_yield 
		inr c           ; stay within circular buffer
		dcx h
		mov a,h
		ora l
		jnz dzx0_ldir_from_buf
		mvi h,0
		pop psw
		add a
		                        ; de = de + length
		                        ; hl = 0

		                        ; a, carry = a + a 
		xchg                    ; de = 0, hl = de + length .. discard dst
		pop h                   ; hl = old offset
		xthl                    ; offset = hl, hl = src
		xchg                    ; de = src, hl = 0?
		jnc dzx0_literals       ; if (!read_bit()) goto COPY_LITERALS
		
		; COPY_FROM_NEW_OFFSET
		; Copy from new offset (repeat N bytes from new offset)
dzx0_new_offset:
		call dzx0_elias         ; hl = read_interlaced_elias_gamma()
		mov h,a                 ; h = a
		pop psw                 ; drop offset from stack
		xra a                   ; a = 0
		sub l                   ; l == 0?
		;rz                      ; return
		jz dzx0_ded
		push h                  ; offset = new offset
		; last_offset = last_offset*128-(read_byte()>>1);
		rar\ mov h,a            ; h = hi(last_offset*128)
		ldax d                  ; read_byte()
		rar\ mov l,a            ; l = read_byte()>>1
		inx d                   ; src++
		xthl                    ; offset = hl, hl = old offset
		
		mov a,h                 ; 
		lxi h,1                 ; 
		cnc dzx0_elias_backtrack; 
		inx h
		jmp dzx0_copy
dzx0_elias:
		inr l
dzx0_elias_loop:	
		add a
		jnz dzx0_elias_skip
		ldax d
		inx d
		ral
dzx0_elias_skip:
		rc
dzx0_elias_backtrack:
		dad h
		add a
		jnc dzx0_elias_loop
		jmp dzx0_elias


                ; reached the end, just restart the scheduler
dzx0_ded        jmp brutal_restart
                ;call dzx0_yield
                ;jmp dzx0_ded


;
;
; SONG DATA
;
; see ym6break.py
;
; recipe: 
;   1. extract each register as separate stream
;   2. salvador -classic -w 256 register_stream
;   3. make db strings etc


em_byreg00: db $79,$7c,$f9,$d1,$fa,$54,$26,$9d,$39,$f9,$15,$19,$85,$8c,$17,$dd,$47,$2e,$02,$fa,$55,$09,$85,$9d,$39,$f9,$46,$61,$8c,$17,$dd,$51,$9b,$fc,$79,$51,$21,$50,$79,$d0,$04
			db $79,$fb,$a6,$1d,$b9,$79,$39,$f9,$9d,$01,$e0,$d0,$47,$9a,$fb,$0c,$97,$5d,$60,$17,$dd,$8c,$1e,$d0,$05,$73,$20,$02,$a8,$f9,$7c,$43,$81,$a0,$47,$9a,$fb,$1d,$b9,$79,$60
			db $39,$f9,$9d,$1e,$d7,$b8,$79,$d0,$5e,$a0,$51,$e6,$fb,$0c,$97,$5d,$98,$17,$dd,$8c,$07,$ae,$d7,$5d,$d0,$17,$95,$a0,$72,$20,$68,$fc,$5a,$fc,$07,$85,$d0,$e0,$a0,$51,$e6
			db $fb,$1d,$b9,$79,$89,$39,$f9,$a5,$9d,$fc,$e9,$f4,$ae,$79,$d0,$17,$94,$a0,$79,$fb,$a2,$0c,$97,$5d,$17,$dd,$69,$8c,$7f,$e9,$f4,$2b,$5d,$85,$d0,$e5,$a0,$5c,$95,$20,$78
			db $a0,$14,$79,$fb,$a2,$1d,$b9,$79,$39,$f9,$69,$9d,$7f,$e9,$f4,$2b,$79,$85,$d0,$e5,$a0,$1e,$fb,$68,$0c,$97,$5d,$9a,$17,$dd,$8c,$5f,$e9,$ca,$f4,$5d,$e1,$d0,$79,$a0,$57
			db $25,$20,$5e,$a0,$05,$1e,$fb,$68,$1d,$b9,$79,$9a,$39,$f9,$9d,$5f,$e9,$ca,$f4,$79,$e1,$d0,$79,$a0,$47,$9a,$fb,$0c,$97,$5d,$26,$17,$dd,$97,$8c,$f2,$e9,$f4,$b8,$5d,$d0
			db $5e,$a0,$55,$c9,$20,$57,$81,$a0,$47,$9a,$fb,$1d,$b9,$79,$26,$39,$f9,$97,$9d,$f2,$e9,$f4,$b8,$79,$d0,$5e,$a0,$51,$e6,$fb,$0c,$97,$5d,$89,$17,$dd,$a5,$8c,$fc,$e9,$f4
			db $ae,$5d,$d0,$17,$95,$a0,$72,$20,$55,$e0,$a0,$51,$e6,$fb,$1d,$b9,$79,$89,$39,$f9,$a5,$9d,$fc,$e9,$f4,$ae,$79,$d0,$17,$94,$a0,$79,$fb,$a2,$0c,$97,$5d,$17,$dd,$69,$8c
			db $7f,$e9,$f4,$2b,$5d,$85,$d0,$e5,$a0,$5c,$95,$20,$78,$a0,$14,$79,$fb,$a2,$1d,$b9,$79,$39,$f9,$69,$9d,$7f,$e9,$f4,$2b,$79,$85,$d0,$e5,$a0,$1e,$fb,$68,$0c,$97,$5d,$9a
			db $17,$dd,$8c,$5f,$e9,$ca,$f4,$5d,$e1,$d0,$79,$a0,$57,$00,$00,$80
em_byreg01: db $90,$00,$00,$b9,$01,$fa,$55,$28,$00,$55,$5a,$01,$15,$52,$0c,$01,$03,$04,$04,$84,$52,$e4,$d0,$40,$a2,$02,$c8,$05,$50,$4e,$d0,$41,$5c,$c0,$50,$eb,$9b,$02,$84,$d2,$e0
			db $a0,$55,$cc,$50,$1b,$02,$e1,$a1,$d0,$38,$a0,$15,$73,$20,$28,$0f,$5a,$0f,$07,$84,$d0,$e0,$a0,$55,$c9,$20,$57,$81,$a0,$57,$25,$20,$5e,$a0,$05,$5c,$95,$20,$78,$a0,$15
			db $72,$20,$55,$e0,$a0,$55,$c9,$20,$57,$81,$a0,$57,$25,$20,$5e,$a0,$05,$5c,$95,$20,$78,$a0,$15,$72,$20,$55,$e0,$a0,$55,$c9,$20,$57,$81,$a0,$57,$25,$20,$5e,$a0,$05,$5c
			db $95,$20,$78,$a0,$40,$30,$00,$08
em_byreg02: db $85,$00,$55,$6b,$d1,$a2,$fc,$ce,$cb,$9b,$d1,$d4,$d7,$9b,$f0,$f9,$e2,$ff,$fd,$f6,$f3,$9b,$f9,$fc,$ff,$9e,$f0,$b8,$54,$f0,$7c,$e5,$40,$57,$81,$64,$be,$39,$ff,$fd,$29
			db $36,$33,$b9,$39,$3c,$3f,$f0,$e5,$b8,$4f,$7c,$0b,$dd,$e2,$ff,$fd,$da,$d7,$9b,$dd,$e0,$e3,$9b,$f0,$17,$e2,$ff,$fd,$14,$11,$9b,$17,$1a,$1d,$9e,$f0,$b8,$54,$f0,$7c,$c8
			db $08,$17,$95,$b8,$3c,$7c,$39,$40,$55,$e0,$64,$6f,$39,$ff,$8a,$fd,$36,$33,$6e,$39,$3c,$3f,$f0,$79,$b8,$53,$c2,$7c,$f8,$dd,$ff,$fd,$a6,$da,$d7,$dd,$e0,$e3,$e6,$f0,$f8
			db $17,$ff,$fd,$a6,$14,$11,$17,$1a,$1d,$e7,$f0,$95,$b8,$3c,$7c,$32,$08,$05,$e5,$b8,$4f,$7c,$0e,$40,$55,$78,$64,$1b,$39,$e2,$ff,$fd,$36,$33,$9b,$39,$3c,$3f,$9e,$f0,$b8
			db $54,$f0,$7c,$be,$dd,$ff,$fd,$29,$da,$d7,$b9,$dd,$e0,$e3,$f0,$be,$17,$ff,$fd,$29,$14,$11,$b9,$17,$1a,$1d,$f0,$e5,$b8,$4f,$7c,$0c,$96,$08,$fb,$a6,$fe,$a3,$25,$ec,$e7
			db $dc,$95,$b8,$79,$7c,$79,$40,$55,$e0,$28,$6f,$39,$ff,$8a,$fd,$36,$33,$6e,$39,$3c,$3f,$94,$79,$b8,$57,$96,$7c,$f8,$dd,$fe,$08,$da,$d7,$da,$dd,$e0,$e3,$e0,$ba,$22,$b7
			db $17,$e8,$fc,$a6,$14,$11,$17,$1a,$1d,$e7,$dc,$95,$b8,$79,$7c,$79,$f0,$6e,$f9,$fe,$25,$86,$f7,$f5,$f7,$f9,$fb,$fd,$a6,$86,$ba,$86,$d1,$11,$fc,$cf,$cd,$cf,$d1,$d3,$d5
			db $cd,$c5,$be,$b6,$b2,$af,$ab,$aa,$a8,$a6,$a4,$a2,$a4,$a6,$a8,$f1,$b8,$97,$b8,$b6,$b8,$ba,$bc,$be,$bc,$fc,$f0,$a0,$38,$70,$f7,$a8,$93,$f0,$97,$94,$99,$40,$7d,$c9,$c1
			db $be,$ba,$b6,$b3,$ab,$a8,$f0,$f0,$4c,$81,$80,$65,$7b,$cb,$c2,$b9,$b0,$ab,$a6,$a1,$a1,$9f,$9d,$9b,$99,$9b,$9d,$9f,$f0,$20,$bc,$79,$a0,$73,$44,$5f,$f0,$72,$38,$07,$c7
			db $ac,$d6,$9c,$01,$6c,$bf,$c4,$cd,$d6,$df,$e8,$ed,$f2,$f7,$fc,$05,$0e,$17,$20,$25,$2a,$2f,$34,$3d,$46,$4f,$58,$5d,$62,$67,$6c,$75,$7e,$87,$90,$95,$9a,$9f,$a4,$ad,$81
			db $80,$65,$c8,$cd,$c5,$be,$b6,$b2,$af,$ab,$10,$78,$10,$1f,$a0,$0c,$d7,$44,$de,$f0,$94,$5e,$40,$65,$f7,$c9,$c1,$be,$ba,$b6,$b3,$ab,$a8,$c1,$f0,$32,$80,$05,$95,$ec,$cb
			db $c2,$b9,$b0,$ab,$a6,$a1,$a1,$9f,$9d,$9b,$99,$9b,$9d,$9f,$f0,$81,$bc,$e5,$a0,$cd,$44,$7d,$f0,$c8,$38,$1f,$ac,$1f,$9c,$59,$43,$bf,$c4,$cd,$d6,$df,$e8,$ed,$f2,$f7,$fc
			db $05,$0e,$17,$20,$25,$2a,$2f,$34,$3d,$46,$4f,$58,$5d,$62,$f9,$7c,$53,$f9,$e0,$f9,$f4,$67,$a6,$53,$37,$2a,$83,$53,$22,$5d,$3e,$a2,$5d,$69,$46,$f9,$f9,$ac,$92,$dd,$6f
			db $4a,$dd,$dd,$6f,$43,$81,$d0,$e5,$a0,$e5,$40,$56,$0f,$39,$9d,$69,$39,$f8,$18,$25,$a2,$d1,$8c,$a2,$39,$b8,$e7,$ac,$f9,$94,$f8,$17,$fc,$10,$f8,$78,$7c,$1c,$98,$74,$ff
			db $17,$8c,$fb,$f9,$a0,$e4,$f8,$5e,$7c,$78,$f4,$18,$3e,$a6,$53,$37,$a6,$f9,$4c,$72,$20,$5e,$40,$7c,$94,$7d,$d0,$79,$a0,$79,$40,$55,$83,$39,$9d,$69,$39,$c6,$f8,$09,$a2
			db $d1,$8c,$a2,$4e,$b8,$79,$ac,$fe,$94,$f8,$45,$ff,$10,$f8,$1e,$7c,$07,$26,$74,$3f,$17,$8c,$fb,$f9,$f9,$a0,$f8,$17,$22,$08,$46,$66,$40,$ce,$d1,$6c,$4c,$d4,$a6,$53,$37
			db $a6,$a6,$50,$19,$79,$79,$4d,$f6,$f9,$7f,$59,$fc,$dc,$e5,$b8,$5e,$7c,$5e,$40,$55,$78,$28,$19,$0e,$39,$9d,$69,$39,$39,$9a,$63,$36,$39,$a0,$6f,$3c,$04,$79,$b8,$57,$96
			db $7c,$54,$e7,$dd,$6f,$4a,$dd,$dd,$6c,$44,$da,$dd,$72,$50,$e0,$ba,$5d,$3e,$ba,$ba,$5a,$17,$8c,$5d,$17,$17,$89,$57,$14,$17,$8f,$63,$1a,$dc,$95,$b8,$79,$7c,$70,$00,$08
em_byreg03: db $81,$00,$10,$1a,$01,$01,$e4,$b8,$5f,$7c,$5f,$40,$00,$3c,$fe,$15,$33,$08,$57,$d5,$b8,$f5,$7c,$f0,$40,$03,$c1,$fe,$53,$35,$08,$7d,$b8,$5f,$7c,$5f,$40,$00,$3c,$fe,$40
			db $33,$44,$5f,$b8,$57,$d1,$c4,$e5,$40,$57,$c3,$64,$94,$fe,$10,$a4,$01,$1a,$00,$14,$11,$a4,$01,$73,$64,$00,$0e,$fa,$f0,$f8,$e4,$dc,$7d,$d0,$cc,$ec,$00,$f4,$fe,$55,$cf
			db $14,$c3,$f8,$91,$dc,$f7,$d0,$30,$ec,$03,$80,$fe,$01,$bb,$01,$fa,$df,$f8,$b8,$01,$f5,$c4,$e5,$40,$57,$00,$00,$80
em_byreg04: db $79,$f9,$d1,$a6,$fa,$54,$26,$39,$f9,$d1,$15,$19,$85,$17,$dd,$ba,$47,$2e,$02,$fa,$55,$09,$85,$39,$f9,$d1,$46,$61,$17,$dd,$ba,$51,$cb,$02,$95,$fa,$42,$61,$39,$f9,$d1
			db $51,$98,$17,$dd,$ba,$54,$72,$02,$e5,$fa,$50,$98,$39,$f9,$d1,$54,$66,$17,$dd,$ba,$15,$1c,$97,$68,$97,$fe,$90,$d0,$56,$f8,$39,$e1,$fa,$39,$fe,$78,$d0,$15,$9e,$17,$dd
			db $ba,$fa,$0e,$fe,$5e,$d0,$05,$72,$20,$57,$90,$d0,$56,$f8,$39,$e1,$fa,$39,$fe,$78,$d0,$15,$9e,$17,$dd,$ba,$fa,$0e,$fe,$5e,$d0,$05,$72,$20,$57,$90,$d0,$56,$f8,$39,$e1
			db $fa,$39,$fe,$78,$d0,$15,$9e,$17,$dd,$ba,$fa,$0e,$fe,$5e,$d0,$05,$72,$20,$57,$90,$d0,$56,$f8,$39,$e1,$fa,$39,$fe,$78,$d0,$15,$9e,$17,$dd,$ba,$fa,$0e,$fe,$5e,$d0,$05
			db $72,$20,$57,$90,$d0,$56,$f8,$39,$e1,$fa,$39,$fe,$78,$d0,$15,$9e,$17,$dd,$ba,$fa,$0e,$fe,$5e,$d0,$05,$72,$20,$57,$90,$d0,$56,$f8,$39,$e1,$fa,$39,$fe,$78,$d0,$15,$9e
			db $17,$dd,$ba,$fa,$0e,$fe,$5e,$d0,$05,$70,$00,$08
em_byreg05: db $85,$00,$55,$b9,$01,$fa,$55,$28,$00,$55,$5a,$01,$40,$02,$72,$02,$03,$04,$50,$07,$91,$d0,$06,$8b,$02,$05,$20,$50,$79,$d0,$05,$72,$20,$57,$90,$d0,$57,$25,$20,$79,$d0
			db $05,$72,$20,$57,$90,$d0,$57,$25,$50,$e4,$d0,$55,$cd,$20,$79,$d0,$15,$73,$20,$5e,$d0,$45,$5c,$d7,$20,$91,$d0,$57,$35,$20,$e4,$d0,$55,$cd,$20,$79,$d0,$15,$73,$20,$5e
			db $d0,$45,$5c,$d7,$20,$91,$d0,$57,$35,$20,$e4,$d0,$55,$cd,$20,$79,$d0,$15,$73,$20,$5e,$d0,$51,$1c,$00,$02
em_byreg06: db $85,$00,$55,$5b,$01,$c0,$d0,$44,$88,$01,$01,$48,$21,$10,$08,$06,$04,$39,$a0,$15,$5a,$01,$16,$81,$01,$f4,$d0,$e0,$a0,$51,$10,$c0,$00,$20
em_byreg07: db $85,$3a,$55,$68,$38,$55,$56,$f0,$30,$d0,$11,$22,$30,$30,$17,$b8,$fe,$d0,$79,$a0,$15,$5f,$df,$ea,$fe,$34,$9f,$3c,$f7,$ff,$f4,$a0,$85,$d0,$e0,$a0,$50,$55,$c0,$00,$20
em_byreg08: db $49,$0e,$0d,$0c,$0b,$0a,$09,$38,$e8,$1f,$c4,$41,$f7,$d0,$90,$40,$55,$6e,$0f,$e6,$bc,$0a,$fe,$fa,$e8,$0b,$17,$81,$dc,$b9,$0b,$d0,$7c,$a0,$39,$70,$5e,$40,$11,$16,$3b
			db $0d,$0d,$ec,$84,$40,$f9,$d1,$40,$3d,$d0,$79,$70,$5e,$40,$11,$42,$85,$0d,$b8,$0d,$d0,$15,$14,$30,$00,$08
em_byreg09: db $85,$00,$55,$61,$91,$0f,$0e,$0d,$0c,$0b,$f5,$dc,$1f,$e8,$5e,$40,$01,$14,$21,$f1,$0a,$09,$08,$07,$07,$dc,$1e,$40,$14,$17,$d6,$f8,$fb,$0f,$cf,$cc,$97,$e8,$df,$f4,$d0
			db $7c,$94,$1f,$70,$47,$81,$28,$6f,$0b,$fe,$50,$cd,$80,$55,$f5,$34,$6e,$09,$fe,$04,$cd,$80,$51,$fd,$41,$fc,$57,$35,$80,$17,$d5,$34,$b9,$09,$fe,$4b,$0f,$ee,$98,$0a,$fd
			db $0e,$09,$08,$07,$06,$e8,$07,$9e,$f4,$b8,$5e,$e8,$55,$f0,$40,$47,$97,$fe,$85,$dc,$f5,$a0,$e4,$fe,$1e,$40,$55,$33,$08,$47,$9f,$c4,$b8,$0e,$e8,$55,$f0,$40,$43,$20,$5c
			db $73,$38,$53,$90,$fe,$7c,$40,$10,$f7,$fe,$ee,$7c,$07,$dc,$00,$79,$e8,$78,$40,$15,$5c,$00,$02
em_byreg10: db $49,$0e,$0d,$0c,$0b,$0a,$09,$38,$e8,$1f,$c4,$41,$f7,$d0,$90,$40,$55,$6e,$0f,$e6,$bc,$0a,$fe,$fa,$e8,$0b,$17,$81,$dc,$b9,$0b,$d0,$7c,$a0,$39,$70,$5e,$40,$44,$50,$e4
			db $fe,$e4,$70,$e1,$d0,$0e,$70,$57,$81,$40,$05,$57,$00,$00,$80
em_byreg11: db $94,$00,$55,$55,$c0,$00,$20
em_byreg12: db $94,$00,$55,$55,$c0,$00,$20
em_byreg13: db $25,$00,$ff,$15,$55,$30,$00,$08
em_byreg14: db $94,$00,$55,$55,$c0,$00,$20
em_byreg15: db $94,$00,$55,$55,$c0,$00,$20

;
; runtime data (careful with relative equ directives)
;

; task stacks

stacks          
stack_00        equ stacks
stack_01        equ stack_00 + task_stack_size
stack_02        equ stack_01 + task_stack_size
stack_03        equ stack_02 + task_stack_size
stack_04        equ stack_03 + task_stack_size
stack_05        equ stack_04 + task_stack_size
stack_06        equ stack_05 + task_stack_size
stack_07        equ stack_06 + task_stack_size
stack_08        equ stack_07 + task_stack_size
stack_09        equ stack_08 + task_stack_size
stack_10        equ stack_09 + task_stack_size
stack_11        equ stack_10 + task_stack_size
stack_12        equ stack_11 + task_stack_size
stack_13        equ stack_12 + task_stack_size
stack_14        equ stack_13 + task_stack_size
stack_15        equ stack_14 + task_stack_size
stacks_end      equ stack_15 + task_stack_size

; array of task sp: context[i] = task's stack pointer
context         equ stacks_end
context_end     equ context + (2 * n_tasks)

context_ptr:    equ context_end
bss_end         equ context_ptr + 2


; buffers for unpacking the streams, must be aligned to 256 byte boundary

buffer00        equ     $ff00 & bss_end + 256        
;buffer01        equ     $ff00 & bss_end + (256 * 2)
;buffer02        equ     $ff00 & bss_end + (256 * 3)
;buffer03        equ     $ff00 & bss_end + (256 * 4)        
;buffer04        equ     $ff00 & bss_end + (256 * 5)
;buffer05        equ     $ff00 & bss_end + (256 * 6)        
;buffer06        equ     $ff00 & bss_end + (256 * 7)
;buffer07        equ     $ff00 & bss_end + (256 * 8)        
;buffer08        equ     $ff00 & bss_end + (256 * 9)
;buffer09        equ     $ff00 & bss_end + (256 * 10)        
;buffer10        equ     $ff00 & bss_end + (256 * 11)
;buffer11        equ     $ff00 & bss_end + (256 * 12)       
;buffer12        equ     $ff00 & bss_end + (256 * 13)
;buffer13        equ     $ff00 & bss_end + (256 * 14)   

				.end