; -----------------------------------------------------------------------------
; ZX0 8080 stream chunk256 decoder by Ivan Gorodetsky - OLD FILE FORMAT v1 
; Based on ZX0 z80 decoder by Einar Saukas
; v1 (2022-09-14) - 179 bytes forward / 181 bytes backward
; v2 (2022-09-18) - 179 bytes forward / 181 bytes backward (slightly faster, preserve BC between chunks) 
; -----------------------------------------------------------------------------
; Parameters (forward):
;   DE: source address (compressed data)
;   BC: destination buffer (decompressing)
;
; Parameters (backward):
;   DE: last source address (compressed data)
;   BC: destination buffer (decompressing)
; -----------------------------------------------------------------------------
; On exit:
;   CY=1 - decompression not finished
; -----------------------------------------------------------------------------
; compress forward with <-classic -w256> options (salvador)
;
; compress backward with <-b -classic -w256> options (salvador)
;
; Compile with The Telemark Assembler (TASM) 3.2
; ----------------------------------------------------------------------------- 


;#define BACKWARD

#ifdef BACKWARD
#define NEXT_HL dcx h
#define NEXT_DE dcx d
#define NEXT_DElo dcr e
#define NEXT_BC dcr c
#else
#define NEXT_HL inx h
#define NEXT_DE inx d
#define NEXT_DElo inr e
#define NEXT_BC inr c
#endif

;You can change dzx0_Buffer
dzx0_Buffer	.equ 0FF00h

dzx0:
		jmp dzx0_Init
dzx0_Init:
		mov a,b
		sta dzx0_SetBC+2
		lxi h,dzx0_GetChunk
		shld dzx0+1
#ifdef BACKWARD
		mvi a,1
		sta dzx0_offset+1
		lxi h,0
#else
		mvi a,0FFh
		sta dzx0_offset+1
		lxi h,0
#endif
		mvi a,080h
dzx0_literals:
		call dzx0_elias
		sta dzx0_ldir1_2+1
dzx0_ldir1_1:
		ldax d
		stax b
		NEXT_DE
		NEXT_BC
		jnz dzx0_ldir1_3
		shld dzx0_SetHL+1
		xchg
		shld dzx0_SetDE+1
		lxi h,dzx0_ldir1_3
		shld dzx0_SetJmp2+1
		stc
		ret
dzx0_ldir1_3:
		dcx h
		mov a,h
		ora l
		jnz dzx0_ldir1_1
dzx0_ldir1_2:
		mvi a,0
		add a
		
		jc dzx0_new_offset
		call dzx0_elias
dzx0_copy:
		xchg
		shld dzx0_copy2+1
		xchg
		sta dzx0_ldir2_2+1
dzx0_offset:
		mvi a,0
		add c
		mov e,a
		mov d,b
dzx0_ldir2_1:
		ldax d
		stax b
		NEXT_DElo
		NEXT_BC
		jnz dzx0_ldir2_3
		shld dzx0_SetHL+1
		xchg
		shld dzx0_SetDE+1
		lxi h,dzx0_ldir2_3
		shld dzx0_SetJmp2+1
		stc
		ret
dzx0_ldir2_3:
		dcx h
		mov a,h
		ora l
		jnz dzx0_ldir2_1
dzx0_ldir2_2:
		mvi a,0
		add a
dzx0_copy2:
		lxi d,0
		jnc dzx0_literals
dzx0_new_offset:
		call dzx0_elias
#ifdef BACKWARD
		dcr h
		jz dzx0_exit
		dcr l
		push psw
		mov a,l
#else
		mov h,a
		xra a
		sub l
		jz dzx0_exit
#endif
		rar
		ldax d
		rar
		NEXT_DE
#ifdef BACKWARD
		inr a
#endif
		sta dzx0_offset+1
		mov a,h
		lxi h,1
#ifdef BACKWARD
		cc dzx0_elias_backtrack
#else
		cnc dzx0_elias_backtrack
#endif
		inx h
		jmp dzx0_copy
dzx0_elias:
		inr l
dzx0_elias_loop:	
		add a
		jnz dzx0_elias_skip
		ldax d
		NEXT_DE
		ral
dzx0_elias_skip:
#ifdef BACKWARD
		rnc
#else
		rc
#endif
dzx0_elias_backtrack:
		dad h
		add a
		jnc dzx0_elias_loop
		jmp dzx0_elias

dzx0_exit:
		lxi h,dzx0_Init
		shld dzx0+1
		ret
		
dzx0_GetChunk:
dzx0_SetHL:
		lxi h,0
dzx0_SetDE:
		lxi d,0
dzx0_SetBC:
		lxi b,0
dzx0_SetJmp2:
		jmp 0

		.end