﻿using System.Drawing;
using System.Drawing.Imaging;
using System.IO;
using System;

namespace IrishaPicConvert
{
    internal class Program
    {
        static void Main(string[] args)
        {
            if (args.Length <= 0)
            {
                Console.WriteLine();
                Console.WriteLine("Usage: IrishaPicConver FileName");
                System.Environment.Exit(1);
            }

            string pathSource = args[0];

            Console.WriteLine();
            Console.WriteLine("Converting File " + pathSource);

            unsafe
            {
                using (FileStream fsSource = new FileStream(pathSource, FileMode.Open, FileAccess.Read))
                {
                    byte[] imageBuffer = new byte[fsSource.Length];
                    int SizeX = (fsSource.Length > 8064) ? 640 : 320;

                    fsSource.Read(imageBuffer, 0, imageBuffer.Length);
                    fsSource.Close();
                    fsSource.Dispose();

                    fixed (byte* ptr = imageBuffer)
                    {
                        using (Bitmap image = new Bitmap(SizeX, 200, SizeX / 8, PixelFormat.Format1bppIndexed, new System.IntPtr(ptr)))
                        {
                            String NewPath = Path.GetDirectoryName(pathSource);
                            String NewFileName = Path.GetFileNameWithoutExtension(pathSource);
                            String NewFullName = Path.Combine(NewPath, NewFileName + ".gif");
                            image.Save(NewFullName, ImageFormat.Gif);
                        }
                    }
                }
            }
        }
    }
}