﻿using System.Drawing;
using System.Drawing.Imaging;
using System.IO;
using System;

namespace IrishaPicConvert
{
    internal class Program
    {
        static void Main(string[] args)
        {
            if (args.Length <= 0)
            {
                Console.WriteLine();
                Console.WriteLine("Usage: IrishaPicConver FileName");
                System.Environment.Exit(1);
            }

            string pathSource = args[0];

            Console.WriteLine();
            Console.WriteLine("Converting File " + pathSource);

            unsafe
            {
                using (FileStream fsSource = new FileStream(pathSource, FileMode.Open, FileAccess.Read))
                {
                    int SizeX = (fsSource.Length > 8064) ? 640 : 320;
                    int SizeY = (fsSource.Length > 8064) ? 400 : 200;
                    long BufferSize = (fsSource.Length > 8064) ? fsSource.Length * 2 : fsSource.Length;

                    byte[] imageBuffer = new byte[BufferSize];

                    fsSource.Read(imageBuffer, 0, (int)fsSource.Length);
                    fsSource.Close();
                    fsSource.Dispose();

                    if (SizeX == 640)
                    {
                        for (int i = 399; i > 0; i-=2)
                        {
                            for (int j = 0; j < 640 / 8; j++)
                            {
                                imageBuffer[(i - 1) * 640 / 8 + j] = imageBuffer[i / 2 * 640 / 8 + j];
                                imageBuffer[(i - 0) * 640 / 8 + j] = imageBuffer[i / 2 * 640 / 8 + j];
                            }
                        }
                    }

                    fixed (byte* ptr = imageBuffer)
                    {
                        using (Bitmap image = new Bitmap(SizeX, SizeY, SizeX / 8, PixelFormat.Format1bppIndexed, new System.IntPtr(ptr)))
                        {
                            String NewPath = Path.GetDirectoryName(pathSource);
                            String NewFileName = Path.GetFileNameWithoutExtension(pathSource);
                            String NewFullName = Path.Combine(NewPath, NewFileName + ".gif");
                            image.Save(NewFullName, ImageFormat.Gif);
                        }
                    }
                }
            }
        }
    }
}