# cwk2txt.py v. 1.1
# Конвертер файлов в формате ChiWorker ПК «Корвет» в текстовые файлы
# (c) Виктор Пыхонин, 2022
#
# Использование: cw2txt.py <исходный файл.chi>')
# Результат будет записан в файл с тем же именем и расширением .txt')
# Запуск без параметров выдает подсказку по использованию

import sys
import os
import glob

print('cwk2txt v. 1.0, (c) Viktor Pykhonin, 2022')
print('Конвертер файлов в формате ChiWorker ПК "Корвет" в текстовые файлы\n')


if len(sys.argv) != 2:
    print('Использование: cwk2txt.py <маска исходных файлов.chi>')
    print('Результат будет записан в файлы с тем же именем и расширением .txt')
    exit()

fonts_r = ('BOLD__R', 'ITAL__R', 'NORM__R', 'NORM_SR', 'PLAKAT')
fonts_s = ('CHEM1', 'CHEMLETT', 'DRAWLIN', 'DRAWSYM', 'FOREIGN', 'GOTHIC', 'GOTHIC1', 'GREEK1', 'MATH', 'MATHI', 'MATHII', 'SETS')

rus_xlat = '!Э:;%.э()*+б-ю/0123456789ЖжБ=Ю?"ФИСВУАПРШОЛДЬТЩЗЙКЫЕГМЦЧНЯх\§,_ъфисвуапршолдьтщзйкыегмцчняХ|№Ъ'

font_map = {}

cur_font = ''

def to_rus(str):
    return ''.join([rus_xlat[ord(s) - ord('!')] if (s >= '!') and (s <= '~') else ' ' for s in str])


def process_str(str):
    if not str:
        return '', False;

    code = str[0]
    str = str[1:]

    if code == 'p':
        return '', True

    if code == 'U':
        code = str[0]
        str = str[1:]
        font_map[code] = str
        return '', True

    global cur_font

    if code in '0123456789!"#$%&\'()*':
        cur_font = font_map.get(code,'')
    elif code == ' ':
        str = ' ' + str

    if cur_font in fonts_r:
        return to_rus(str), False
    elif cur_font in fonts_s:
        return ''.join(['·' if x != ' ' else ' ' for x in str]), False
    return str, False


def process_file(dst_file):
    print('Обработка файла {0} ... '.format(dst_file), end='')

    with open(src_file, 'r', encoding = 'latin1') as f:
        doc = f.read().splitlines()

    if not doc or (doc[0][:6] != '\\1cw 3'):
        print('формат не поддерживается!')
        return
    doc = doc[1:]

    dst_file = os.path.splitext(src_file)[0] + '.txt'
    with open(dst_file, 'w', encoding = 'utf8') as f:
        for ln in doc:
#            if (ln == '\\-') or (ln == '\\,') or (ln == '\\+'):
#                continue
            br = False
            strs = ln.split('\\')
            for str in strs:
                str, br = process_str(str)
                if not br:
                    f.write(str)
                else:
                    break
            if not br:
                f.write('\n')
    print('выполнено.')

n = 0
for src_file in glob.glob(sys.argv[1]):
    process_file(src_file)
    n += 1

print('\nЗавершено, обработано {0} файлов\n'.format(n))
