.org 0

krs	.equ 0200h
scr1	.equ 0f900h
scr2	.equ 7900h

	call prep_scr

	lxi h, krs
	mov a, m
	cpi 'K'
	jnz inval
	inx h
	mov a, m
	cpi 'R'
	inx h
	mov a, m
	cpi '0'
	inx h
	mov a, m
	cpi '4'
	jnz inval
	inx h
	mov a, m
	ani 1
	cz init_bw
	cnz init_color
	mov a, m
	push psw
	ani 2
	inx h
	cnz set_pal
	cz clear_pal
	pop psw
	ani 1
	jnz col

	push h
	lhld krs + 8 ; width
	lxi d, 7
	dad d
	mov a, d
	rar
	mov a, l
	rrc
	rar
	rar
	ani 3fh
	jmp l2
	

col:	lda krs + 8 ; width
	adi 3
	rrc
	rrc
	ani 3fh

l2:	mov e, a
	lda krs + 10 ; height
	mov d, a

	push d
	lxi b,krs + 12
	lxi h, 0bc02h
	call show_field
	pop d

	lda krs + 4
	ani 4
	jz still

	lxi h, 08002h
	call show_field

gs:
	lxi d, scr1
	call sw_buf
	lxi d, scr2
	call sw_buf
	call 0f812h
	ora a
	jz gs

still:
	call 0f803h

	jmp exit

show_field:
	push d
	push h
l1:	ldax b
	mov m, a
	inx h
	inx b
	dcr e
	jnz l1

	pop h
	pop d
	dcr d
	push d
	mvi a, 40h
	add l
	mov l, a
	mvi a, 0
	adc h
	mov h, a
	push h

	mov a, d
	ora a
	jnz l1

	pop h
	pop d
	ret
	
inval:
	lxi h, err_msg
	call 0f818h

exit:
	call 0f82dh
	call clear_pal
	mvi c, 1fh
	call 0f809h
	jmp 0f800h	

err_msg:
	.db "KRS FILE FORMAT ERROR!",0


set_pal:
	push psw
	mov a, m
	out 00h
	inx h
	mov a, m
	out 01h
	inx h
	mov a, m
	out 02h
	pop psw
	ret

clear_pal:
	push psw
	mvi a, 0ch
	out 0
	mvi a, 30h
	out 1
	mvi a, 0c0h
	out 2
	pop psw
	ret

init_color:
        mvi a, 1
	jmp l4
init_bw:
        mvi a, 3
l4:	sta 0f604h
	call 0f82dh

	; clear screen
	push h
	push d
	lxi d, 0f400h
	lxi h, 08000h
l3:	mov m, e
	inx h
	mov a, h
	cmp d
	jnz l3
	pop d
	pop h
	ret

prep_scr:
	lxi h, scr2

	mvi m, 0f1h
	inx h
	mvi m, 0f1h
	inx h
	mvi m, 0f1h
	inx h
	mvi m, 0f1h
	inx h

	lxi d, attrs
	mvi c, 7

ps1:	mvi b, 0
	call fill_row
	mvi b, 40h
	call fill_row
	dcr c
	jnz ps1

	dcx h
	dcx h
	mvi m, 0f3h
	ret

fill_row:
	ldax d
	mov m, a
	inx h
	mov m, b
	inx h
	mov m, b
	inx h
	mvi a, 3eh
	add b
	mov m, a
	inx h
	inr a
	mov m, a
	inx h
fr1:	mov m, b
	inx h
	inr b
	mov a,b
	ani 3fh
	cpi 3fh
	jnz fr1
	mvi m, 0f1h
	inx h
	mvi m, 0f1h
	inx h
	inx d
	ret

sw_buf:
	in 0e1h
sw2_1:	in 0e1h
	ani 20h
	jz sw2_1
	mvi a, 80h
	out 0f8h
	mov a, e
	out 0f4h
	mov a, d
	out 0f4h
	mvi a, 0d7h
	out 0f5h
	mvi a, 83h
	out 0f5h
	mvi a, 084h
	out 0f8h
	ret

attrs:	.db 80h,40h,84h,40h,88h,40h,8ch,40h,81h,40h,85h,40h,89h,40h

.end