#!/bin/sh

if [ -z $1 ] || [ ! -f $1 ]
then
  echo
  echo "Missing input file!"
  exit 1
fi

rm viewer.bin > /dev/null
wine tasm -b -85 krsview.asm viewer.bin
if [ $? -ne 0 ]
then
  echo
  echo "Compilation error!"
  exit 2
fi

echo
python upto512.py
cat viewer.bin $1 > krsview.bin
wine bin2tape -t rk4 -a 0 krsview.bin

rm krsview.bin > /dev/null

#~/programs/Emu80qt/Emu80qt -4 krsview.rk4
exit 0
