module frequency_divider(
    input clock_in,
    output clock_out
);
    reg [27:0] counter = 28'd0;
    parameter DIVIDER = 4;
    always @(posedge clock_in)
        begin
            counter <= counter + 28'd1;
            if(counter >= (DIVIDER - 1))
                    counter <= 28'd0;
        end
    assign clock_out = (counter < DIVIDER / 2) ? 1'b0 : 1'b1;

endmodule